/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public enum QueryStatus {
    SUCCESS("success"),
    FAILED("failed");

    private String _status;
    private static Hashtable<String, QueryStatus> _statuses;

    private QueryStatus(String status) {
        this._status = status;
    }

    public String getStatus() {
        return this._status;
    }

    public static synchronized void initStatuses() {
        if (_statuses == null) {
            _statuses = new Hashtable();
            _statuses.put(SUCCESS.getStatus(), SUCCESS);
            _statuses.put(FAILED.getStatus(), FAILED);
        }
    }

    public static List<String> getQueries() {
        if (_statuses == null) {
            QueryStatus.initStatuses();
        }
        ArrayList<String> list = new ArrayList<String>(_statuses.keySet());
        return list;
    }

    public static QueryStatus fromStatus(String status) {
        if (_statuses == null) {
            QueryStatus.initStatuses();
        }
        if (_statuses.contains(status)) {
            return _statuses.get(status);
        }
        throw new IllegalArgumentException("Unrecognized status " + status);
    }

    static {
        _statuses = null;
    }
}

