/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.ClassUtil;
import org.apache.juddi.api.impl.UDDIInquiryImpl;
import org.apache.juddi.api.impl.UDDIPublicationImpl;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.config.PublisherFileFilter;
import org.apache.juddi.mapping.MappingApiToModel;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.ReplicationConfiguration;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.replication.ReplicationNotifier;
import org.apache.juddi.v3.client.cryptor.XmlUtils;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.KeyUnavailableException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidatePublish;
import org.apache.juddi.validation.ValidateReplication;
import org.apache.juddi.validation.ValidateUDDIKey;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModel;
import org.uddi.repl_v3.CommunicationGraph;
import org.uddi.repl_v3.Operator;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class Install {
    public static final String FILE_BUSINESSENTITY = "_BusinessEntity.xml";
    public static final String FILE_PUBLISHER = "_Publisher.xml";
    public static final String FILE_TMODELKEYGEN = "_tModelKeyGen.xml";
    public static final String FILE_TMODELS = "_tModels.xml";
    public static final String FILE_PERSISTENCE = "persistence.xml";
    public static final String JUDDI_INSTALL_DATA_DIR = "juddi_install_data/";
    public static final String JUDDI_CUSTOM_INSTALL_DATA_DIR = "juddi_custom_install_data/";
    public static final String FILE_REPLICATION_CONFIG = "_replicationConfiguration.xml";
    public static final Log log = LogFactory.getLog(Install.class);

    protected static void install(Configuration config) throws JAXBException, DispositionReportFaultMessage, IOException, ConfigurationException, XMLStreamException {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        UddiEntityPublisher rootPublisher = null;
        try {
            tx.begin();
            boolean seedAlways = config.getBoolean("juddi.seed.always", false);
            boolean alreadyInstalled = Install.alreadyInstalled(config);
            if (!seedAlways && alreadyInstalled) {
                throw new FatalErrorException(new ErrorMessage("errors.install.AlreadyInstalled"));
            }
            String rootPublisherStr = config.getString("juddi.root.publisher");
            String fileRootTModelKeygen = rootPublisherStr + FILE_TMODELKEYGEN;
            TModel rootTModelKeyGen = (TModel)Install.buildInstallEntity(fileRootTModelKeygen, "org.uddi.api_v3", config);
            String fileRootBusinessEntity = rootPublisherStr + FILE_BUSINESSENTITY;
            org.uddi.api_v3.BusinessEntity rootBusinessEntity = (org.uddi.api_v3.BusinessEntity)Install.buildInstallEntity(fileRootBusinessEntity, "org.uddi.api_v3", config);
            String rootPartition = Install.getRootPartition(rootTModelKeyGen);
            String nodeId = config.getString("juddi.nodeId", Install.getNodeId(rootBusinessEntity.getBusinessKey(), rootPartition));
            String rootbizkey = Install.getNodeId(rootBusinessEntity.getBusinessKey(), rootPartition);
            String fileRootPublisher = rootPublisherStr + FILE_PUBLISHER;
            String fileReplicationConfig = rootPublisherStr + FILE_REPLICATION_CONFIG;
            org.uddi.repl_v3.ReplicationConfiguration replicationCfg = (org.uddi.repl_v3.ReplicationConfiguration)Install.buildInstallEntityAlt(fileReplicationConfig, org.uddi.repl_v3.ReplicationConfiguration.class, config);
            if (!alreadyInstalled) {
                log.info((Object)("Loading the root Publisher from file " + fileRootPublisher));
                rootPublisher = Install.installPublisher(em, fileRootPublisher, config);
                Install.installRootPublisherKeyGen(em, rootTModelKeyGen, rootPartition, rootPublisher, nodeId);
                rootBusinessEntity.setBusinessKey(rootbizkey);
                Install.installBusinessEntity(true, em, rootBusinessEntity, rootPublisher, rootPartition, config, nodeId);
                Install.installReplicationConfiguration(em, replicationCfg, config, nodeId);
            } else {
                log.debug((Object)"juddi.seed.always reapplies all seed files except for the root data.");
            }
            List<String> juddiPublishers = Install.getPublishers(config);
            for (String publisherStr : juddiPublishers) {
                String filePublisher = publisherStr + FILE_PUBLISHER;
                String fileTModelKeygen = publisherStr + FILE_TMODELKEYGEN;
                TModel tModelKeyGen = (TModel)Install.buildInstallEntity(fileTModelKeygen, "org.uddi.api_v3", config);
                String fileBusinessEntity = publisherStr + FILE_BUSINESSENTITY;
                org.uddi.api_v3.BusinessEntity businessEntity = (org.uddi.api_v3.BusinessEntity)Install.buildInstallEntity(fileBusinessEntity, "org.uddi.api_v3", config);
                UddiEntityPublisher publisher = Install.installPublisher(em, filePublisher, config);
                if (publisher == null) {
                    throw new ConfigurationException("File " + filePublisher + " not found.");
                }
                if (tModelKeyGen != null) {
                    Install.installPublisherKeyGen(em, tModelKeyGen, publisher, nodeId);
                }
                if (businessEntity != null) {
                    Install.installBusinessEntity(false, em, businessEntity, publisher, null, config, nodeId);
                }
                String fileTModels = publisherStr + FILE_TMODELS;
                Install.installSaveTModel(em, fileTModels, publisher, nodeId, config);
            }
            tx.commit();
        }
        catch (DispositionReportFaultMessage dr) {
            log.error((Object)dr.getMessage(), (Throwable)dr);
            tx.rollback();
            throw dr;
        }
        catch (JAXBException je) {
            log.error((Object)je.getMessage(), (Throwable)je);
            tx.rollback();
            throw je;
        }
        catch (IOException ie) {
            log.error((Object)ie.getMessage(), (Throwable)ie);
            tx.rollback();
            throw ie;
        }
        catch (XMLStreamException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            tx.rollback();
            throw ex;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    protected static void uninstall() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean alreadyInstalled(Configuration config) throws ConfigurationException {
        String rootPublisherStr = config.getString("juddi.root.publisher");
        log.info((Object)("Checking if jUDDI is seeded by searching for root publisher " + rootPublisherStr));
        Publisher publisher = null;
        int numberOfTries = 0;
        while (numberOfTries++ < 100) {
            EntityManager em = PersistenceManager.getEntityManager();
            EntityTransaction tx = em.getTransaction();
            try {
                tx.begin();
                publisher = (Publisher)em.find(Publisher.class, (Object)rootPublisherStr);
                tx.commit();
            }
            finally {
                if (tx.isActive()) {
                    tx.rollback();
                }
                em.close();
            }
            if (publisher != null) {
                return true;
            }
            if (config.getBoolean("juddi.load.install.data", true)) {
                log.debug((Object)"Install data not yet installed.");
                return false;
            }
            try {
                log.info((Object)"Install data not yet installed.");
                log.info((Object)"Going to sleep and retry...");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        throw new ConfigurationException("Could not load the Root node data. Please check for errors.");
    }

    protected static String getRootPartition(TModel rootTModelKeyGen) throws JAXBException, IOException, DispositionReportFaultMessage {
        String result = rootTModelKeyGen.getTModelKey().substring(0, rootTModelKeyGen.getTModelKey().lastIndexOf(":"));
        if (result == null || result.length() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.MalformedKey", result));
        }
        if ((result = result.trim()).endsWith(":") || result.startsWith(":")) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.MalformedKey", result));
        }
        StringTokenizer tokenizer = new StringTokenizer(result.toLowerCase(), ":");
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (count == 0 ? !ValidateUDDIKey.isValidDomainKey(nextToken) : !ValidateUDDIKey.isValidKSS(nextToken)) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.MalformedKey", result));
            }
            ++count;
        }
        return result;
    }

    protected static String getNodeId(String userNodeId, String rootPartition) throws DispositionReportFaultMessage {
        String result = userNodeId;
        if (result == null || result.length() == 0) {
            result = rootPartition + ":" + UUID.randomUUID();
        } else {
            ValidateUDDIKey.validateUDDIv3Key(result);
            String keyPartition = result.substring(0, result.lastIndexOf(":"));
            if (!rootPartition.equalsIgnoreCase(keyPartition)) {
                throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", userNodeId));
            }
        }
        return result;
    }

    private static String installBusinessEntity(boolean isRoot, EntityManager em, org.uddi.api_v3.BusinessEntity rootBusinessEntity, UddiEntityPublisher rootPublisher, String rootPartition, Configuration config, String nodeId) throws JAXBException, DispositionReportFaultMessage, IOException {
        if (isRoot) {
            Install.validateRootBusinessEntity(rootBusinessEntity, rootPublisher, rootPartition, config);
        }
        BusinessEntity modelBusinessEntity = new BusinessEntity();
        MappingApiToModel.mapBusinessEntity(rootBusinessEntity, modelBusinessEntity);
        modelBusinessEntity.setAuthorizedName(rootPublisher.getAuthorizedName());
        modelBusinessEntity.setNodeId(nodeId);
        Date now = new Date();
        modelBusinessEntity.setCreated(now);
        modelBusinessEntity.setModified(now);
        modelBusinessEntity.setModifiedIncludingChildren(now);
        modelBusinessEntity.setNodeId(config.getString("juddi.nodeId", modelBusinessEntity.getEntityKey()));
        for (BusinessService service : modelBusinessEntity.getBusinessServices()) {
            service.setAuthorizedName(rootPublisher.getAuthorizedName());
            service.setNodeId(modelBusinessEntity.getNodeId());
            service.setCreated(now);
            service.setModified(now);
            service.setModifiedIncludingChildren(now);
            for (BindingTemplate binding : service.getBindingTemplates()) {
                binding.setAuthorizedName(rootPublisher.getAuthorizedName());
                binding.setNodeId(nodeId);
                binding.setCreated(now);
                binding.setModified(now);
                binding.setModifiedIncludingChildren(now);
            }
        }
        em.persist((Object)modelBusinessEntity);
        SaveBusiness sb = new SaveBusiness();
        sb.getBusinessEntity().add(rootBusinessEntity);
        ReplicationNotifier.enqueue(UDDIPublicationImpl.getChangeRecord(modelBusinessEntity, rootBusinessEntity, modelBusinessEntity.getNodeId()));
        return modelBusinessEntity.getEntityKey();
    }

    private static void validateRootBusinessEntity(org.uddi.api_v3.BusinessEntity businessEntity, UddiEntityPublisher rootPublisher, String rootPartition, Configuration config) throws DispositionReportFaultMessage {
        if (businessEntity == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.businessentity.NullInput"));
        }
        String entityKey = businessEntity.getBusinessKey();
        if (entityKey == null || entityKey.length() == 0) {
            entityKey = rootPartition + ":" + UUID.randomUUID();
            businessEntity.setBusinessKey(entityKey);
        } else {
            entityKey = entityKey.toLowerCase();
            businessEntity.setBusinessKey(entityKey);
            ValidateUDDIKey.validateUDDIv3Key(entityKey);
            String keyPartition = entityKey.substring(0, entityKey.lastIndexOf(":"));
            if (!rootPartition.equalsIgnoreCase(keyPartition)) {
                throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
            }
        }
        ValidatePublish validatePublish = new ValidatePublish(rootPublisher, config.getString("juddi.nodeId"));
        validatePublish.validateNames(businessEntity.getName());
        validatePublish.validateDiscoveryUrls(businessEntity.getDiscoveryURLs());
        validatePublish.validateContacts(businessEntity.getContacts(), config);
        validatePublish.validateCategoryBag(businessEntity.getCategoryBag(), config, true);
        validatePublish.validateIdentifierBag(businessEntity.getIdentifierBag(), config, true);
        BusinessServices businessServices = businessEntity.getBusinessServices();
        if (businessServices != null) {
            List businessServiceList = businessServices.getBusinessService();
            if (businessServiceList == null || businessServiceList.size() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.businessservices.NoInput"));
            }
            for (org.uddi.api_v3.BusinessService businessService : businessServiceList) {
                Install.validateRootBusinessService(businessService, businessEntity, rootPublisher, rootPartition, config);
            }
        }
    }

    private static void validateRootBusinessService(org.uddi.api_v3.BusinessService businessService, org.uddi.api_v3.BusinessEntity parent, UddiEntityPublisher rootPublisher, String rootPartition, Configuration config) throws DispositionReportFaultMessage {
        if (businessService == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.businessservice.NullInput"));
        }
        String parentKey = businessService.getBusinessKey();
        if (parentKey != null && parentKey.length() > 0 && !parentKey.equalsIgnoreCase(parent.getBusinessKey())) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentBusinessNotFound", parentKey + " " + businessService.getBusinessKey() + " " + businessService.getBusinessKey().length() + " " + parentKey.length()));
        }
        String entityKey = businessService.getServiceKey();
        if (entityKey == null || entityKey.length() == 0) {
            entityKey = rootPartition + ":" + UUID.randomUUID();
            businessService.setServiceKey(entityKey);
        } else {
            entityKey = entityKey.toLowerCase();
            businessService.setServiceKey(entityKey);
            ValidateUDDIKey.validateUDDIv3Key(entityKey);
            String keyPartition = entityKey.substring(0, entityKey.lastIndexOf(":"));
            if (!rootPartition.equalsIgnoreCase(keyPartition)) {
                throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
            }
        }
        ValidatePublish validatePublish = new ValidatePublish(rootPublisher, config.getString("juddi.nodeId"));
        validatePublish.validateNames(businessService.getName());
        validatePublish.validateCategoryBag(businessService.getCategoryBag(), config, true);
        BindingTemplates bindingTemplates = businessService.getBindingTemplates();
        if (bindingTemplates != null) {
            List bindingTemplateList = bindingTemplates.getBindingTemplate();
            if (bindingTemplateList == null || bindingTemplateList.size() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.bindingtemplates.NoInput"));
            }
            for (org.uddi.api_v3.BindingTemplate bindingTemplate : bindingTemplateList) {
                Install.validateRootBindingTemplate(bindingTemplate, businessService, rootPublisher, rootPartition, config);
            }
        }
    }

    private static void validateRootBindingTemplate(org.uddi.api_v3.BindingTemplate bindingTemplate, org.uddi.api_v3.BusinessService parent, UddiEntityPublisher rootPublisher, String rootPartition, Configuration config) throws DispositionReportFaultMessage {
        if (bindingTemplate == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.bindingtemplate.NullInput"));
        }
        String parentKey = bindingTemplate.getServiceKey();
        if (parentKey != null && parentKey.length() > 0 && !parentKey.equalsIgnoreCase(parent.getServiceKey())) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentServiceNotFound", parentKey));
        }
        String entityKey = bindingTemplate.getBindingKey();
        if (entityKey == null || entityKey.length() == 0) {
            entityKey = rootPartition + ":" + UUID.randomUUID();
            bindingTemplate.setBindingKey(entityKey);
        } else {
            entityKey = entityKey.toLowerCase();
            bindingTemplate.setBindingKey(entityKey);
            ValidateUDDIKey.validateUDDIv3Key(entityKey);
            String keyPartition = entityKey.substring(0, entityKey.lastIndexOf(":"));
            if (!rootPartition.equalsIgnoreCase(keyPartition)) {
                throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
            }
        }
        ValidatePublish validatePublish = new ValidatePublish(rootPublisher, config.getString("juddi.nodeId"));
        validatePublish.validateCategoryBag(bindingTemplate.getCategoryBag(), config, true);
        validatePublish.validateTModelInstanceDetails(bindingTemplate.getTModelInstanceDetails(), config, true);
    }

    private static void installTModels(EntityManager em, List<TModel> apiTModelList, UddiEntityPublisher publisher, String nodeId) throws DispositionReportFaultMessage {
        if (apiTModelList != null) {
            for (TModel apiTModel : apiTModelList) {
                String tModelKey = apiTModel.getTModelKey();
                if (tModelKey.toUpperCase().endsWith("keygenerator".toUpperCase())) {
                    Install.installPublisherKeyGen(em, apiTModel, publisher, nodeId);
                    continue;
                }
                Tmodel modelTModel = new Tmodel();
                apiTModel.setTModelKey(apiTModel.getTModelKey().toLowerCase());
                MappingApiToModel.mapTModel(apiTModel, modelTModel);
                modelTModel.setAuthorizedName(publisher.getAuthorizedName());
                Date now = new Date();
                modelTModel.setCreated(now);
                modelTModel.setModified(now);
                modelTModel.setModifiedIncludingChildren(now);
                modelTModel.setNodeId(nodeId);
                em.persist((Object)modelTModel);
                SaveTModel stm = new SaveTModel();
                stm.getTModel().add(apiTModel);
                ReplicationNotifier.enqueue(UDDIPublicationImpl.getChangeRecord(modelTModel, apiTModel, nodeId));
            }
        }
    }

    private static void installRootPublisherKeyGen(EntityManager em, TModel rootTModelKeyGen, String rootPartition, UddiEntityPublisher publisher, String nodeId) throws DispositionReportFaultMessage {
        rootTModelKeyGen.setTModelKey(rootPartition + ":" + "keygenerator");
        Install.installPublisherKeyGen(em, rootTModelKeyGen, publisher, nodeId);
    }

    private static void installPublisherKeyGen(EntityManager em, TModel apiTModel, UddiEntityPublisher publisher, String nodeId) throws DispositionReportFaultMessage {
        Tmodel modelTModel = new Tmodel();
        MappingApiToModel.mapTModel(apiTModel, modelTModel);
        modelTModel.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        modelTModel.setCreated(now);
        modelTModel.setModified(now);
        modelTModel.setModifiedIncludingChildren(now);
        modelTModel.setNodeId(nodeId);
        em.persist((Object)modelTModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getPublishers(Configuration config) throws ConfigurationException {
        ArrayList<String> publishers = new ArrayList<String>();
        String basePath = JUDDI_CUSTOM_INSTALL_DATA_DIR;
        URL url = ClassUtil.getResource(JUDDI_CUSTOM_INSTALL_DATA_DIR, Install.class);
        if (url == null) {
            url = ClassUtil.getResource(JUDDI_INSTALL_DATA_DIR, Install.class);
            basePath = JUDDI_INSTALL_DATA_DIR;
        }
        String path = null;
        try {
            path = url.toURI().getSchemeSpecificPart();
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException((Throwable)e);
        }
        File dir = new File(path);
        String rootPublisherStr = config.getString("juddi.root.publisher");
        if (dir.exists()) {
            log.debug((Object)("Discovering the Publisher XML data files in directory: " + path));
            File[] files = dir.listFiles(new PublisherFileFilter());
            if (files == null) return publishers;
            for (File f : files) {
                String publisher = f.getName().substring(0, f.getName().indexOf(FILE_PUBLISHER));
                if (rootPublisherStr.equalsIgnoreCase(publisher)) continue;
                publishers.add(publisher);
            }
            return publishers;
        } else {
            String[] paths = new String[]{};
            Enumeration<JarEntry> en = null;
            JarFile jf = null;
            try {
                if (path.indexOf("!") > 0) {
                    paths = path.split("!");
                    jf = new JarFile(new File(new URI(paths[0])));
                    en = jf.entries();
                } else if (path.indexOf(".jar") > 0) {
                    paths = path.split(".jar");
                    paths[0] = paths[0] + ".jar";
                    File temp = new File(paths[0]);
                    if (temp.exists()) {
                        jf = new JarFile(temp);
                        en = jf.entries();
                    }
                }
                if (paths.length > 0) {
                    log.debug((Object)("Discovering the Publisher XML data files in jar: " + paths[0]));
                    while (en != null && en.hasMoreElements()) {
                        String name = en.nextElement().getName();
                        if (!name.endsWith(FILE_PUBLISHER)) continue;
                        log.debug((Object)("Found publisher file=" + name));
                        String publisher = name.substring(basePath.length(), name.indexOf(FILE_PUBLISHER));
                        if (rootPublisherStr.equalsIgnoreCase(publisher)) continue;
                        publishers.add(publisher);
                    }
                } else {
                    log.info((Object)("No custom configuration files where found in " + path));
                }
                if (jf == null) return publishers;
                jf.close();
                return publishers;
            }
            catch (IOException e) {
                throw new ConfigurationException((Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
    }

    private static Object buildInstallEntityAlt(String fileName, Class outputtype, Configuration config) throws JAXBException, IOException, ConfigurationException {
        int n;
        InputStream resourceStream = null;
        URL url = ClassUtil.getResource(JUDDI_CUSTOM_INSTALL_DATA_DIR + fileName, Install.class);
        if (url != null) {
            resourceStream = url.openStream();
        }
        if (resourceStream == null) {
            url = ClassUtil.getResource(JUDDI_INSTALL_DATA_DIR + fileName, Install.class);
            if (url != null) {
                resourceStream = url.openStream();
            }
            if (url == null || resourceStream == null) {
                if (fileName.endsWith(FILE_PUBLISHER)) {
                    throw new ConfigurationException("Could not locate juddi_install_data/" + fileName);
                }
                log.debug((Object)("Could not locate: " + url));
                return null;
            }
        }
        log.info((Object)("Loading the content of file: " + url));
        StringBuilder xml = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = resourceStream.read(b)) != -1) {
            xml.append(new String(b, 0, n, "UTF-8"));
        }
        log.debug((Object)("inserting: " + xml.toString()));
        StringReader reader = new StringReader(xml.toString());
        Object obj = XmlUtils.unmarshal((Reader)reader, (Class[])new Class[]{outputtype});
        reader.close();
        return obj;
    }

    private static Object buildInstallEntity(String fileName, String packageName, Configuration config) throws JAXBException, IOException, ConfigurationException, XMLStreamException {
        int n;
        InputStream resourceStream = null;
        URL url = ClassUtil.getResource(JUDDI_CUSTOM_INSTALL_DATA_DIR + fileName, Install.class);
        if (url != null) {
            resourceStream = url.openStream();
        }
        if (resourceStream == null) {
            url = ClassUtil.getResource(JUDDI_INSTALL_DATA_DIR + fileName, Install.class);
            if (url != null) {
                resourceStream = url.openStream();
            }
            if (url == null || resourceStream == null) {
                if (fileName.endsWith(FILE_PUBLISHER)) {
                    throw new ConfigurationException("Could not locate juddi_install_data/" + fileName);
                }
                log.debug((Object)("Could not locate: " + url));
                return null;
            }
        }
        log.info((Object)("Loading the content of file: " + url));
        StringBuilder xml = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = resourceStream.read(b)) != -1) {
            xml.append(new String(b, 0, n, "UTF-8"));
        }
        log.debug((Object)("inserting: " + xml.toString()));
        StringReader reader = new StringReader(xml.toString());
        Object obj = XmlUtils.unmarshal((Reader)reader, (String)packageName);
        reader.close();
        return obj;
    }

    public static org.uddi.api_v3.BusinessEntity getNodeBusinessEntity(String businessKey) throws DispositionReportFaultMessage {
        List beList;
        UDDIInquiryImpl inquiry = new UDDIInquiryImpl();
        GetBusinessDetail gbd = new GetBusinessDetail();
        gbd.getBusinessKey().add(businessKey);
        BusinessDetail bd = inquiry.getBusinessDetail(gbd);
        if (bd != null && (beList = bd.getBusinessEntity()) != null && beList.size() > 0) {
            return (org.uddi.api_v3.BusinessEntity)beList.get(0);
        }
        return new org.uddi.api_v3.BusinessEntity();
    }

    public static void installSaveTModel(EntityManager em, String fileName, UddiEntityPublisher publisher, String nodeId, Configuration config) throws JAXBException, DispositionReportFaultMessage, IOException, ConfigurationException, XMLStreamException {
        SaveTModel apiSaveTModel = (SaveTModel)Install.buildInstallEntity(fileName, "org.uddi.api_v3", config);
        if (apiSaveTModel != null) {
            Install.installTModels(em, apiSaveTModel.getTModel(), publisher, nodeId);
        }
    }

    public static UddiEntityPublisher installPublisher(EntityManager em, String fileName, Configuration config) throws JAXBException, DispositionReportFaultMessage, IOException, ConfigurationException, XMLStreamException {
        org.apache.juddi.api_v3.Publisher apiPub = (org.apache.juddi.api_v3.Publisher)Install.buildInstallEntity(fileName, "org.apache.juddi.api_v3", config);
        if (apiPub == null) {
            return null;
        }
        Publisher modelPub = new Publisher();
        MappingApiToModel.mapPublisher(apiPub, modelPub);
        em.persist((Object)modelPub);
        return modelPub;
    }

    public static org.uddi.repl_v3.ReplicationConfiguration applyReplicationTokenChanges(org.uddi.repl_v3.ReplicationConfiguration replicationCfg, Configuration config, String thisnode) {
        log.info((Object)"replacing tokens on repl config");
        if (replicationCfg == null) {
            return null;
        }
        for (Operator op : replicationCfg.getOperator()) {
            op.setOperatorNodeID(op.getOperatorNodeID().replace("${juddi.nodeId}", thisnode));
            op.setSoapReplicationURL(op.getSoapReplicationURL().replace("${juddi.server.baseurlsecure}", config.getString("juddi.server.baseurlsecure")));
            op.setSoapReplicationURL(op.getSoapReplicationURL().replace("${juddi.server.baseurl}", config.getString("juddi.server.baseurl")));
        }
        if (replicationCfg.getCommunicationGraph() != null) {
            int i;
            for (i = 0; i < replicationCfg.getCommunicationGraph().getNode().size(); ++i) {
                replicationCfg.getCommunicationGraph().getNode().set(i, ((String)replicationCfg.getCommunicationGraph().getNode().get(i)).replace("${juddi.nodeId}", thisnode));
            }
            for (i = 0; i < replicationCfg.getCommunicationGraph().getEdge().size(); ++i) {
                ((CommunicationGraph.Edge)replicationCfg.getCommunicationGraph().getEdge().get(i)).setMessageSender(((CommunicationGraph.Edge)replicationCfg.getCommunicationGraph().getEdge().get(i)).getMessageSender().replace("${juddi.nodeId}", thisnode));
                ((CommunicationGraph.Edge)replicationCfg.getCommunicationGraph().getEdge().get(i)).setMessageReceiver(((CommunicationGraph.Edge)replicationCfg.getCommunicationGraph().getEdge().get(i)).getMessageReceiver().replace("${juddi.nodeId}", thisnode));
                for (int k = 0; k < ((CommunicationGraph.Edge)replicationCfg.getCommunicationGraph().getEdge().get(i)).getMessageReceiverAlternate().size(); ++k) {
                    ((CommunicationGraph.Edge)replicationCfg.getCommunicationGraph().getEdge().get(i)).getMessageReceiverAlternate().set(k, ((String)((CommunicationGraph.Edge)replicationCfg.getCommunicationGraph().getEdge().get(i)).getMessageReceiverAlternate().get(k)).replace("${juddi.nodeId}", thisnode));
                }
            }
        }
        for (Operator op : replicationCfg.getOperator()) {
            op.setOperatorNodeID(op.getOperatorNodeID().replace("${juddi.nodeId}", thisnode));
        }
        log.info((Object)"replacing tokens on repl config, done");
        return replicationCfg;
    }

    private static void installReplicationConfiguration(EntityManager em, org.uddi.repl_v3.ReplicationConfiguration replicationCfg, Configuration config, String thisnode) throws DispositionReportFaultMessage, ConfigurationException {
        replicationCfg = Install.applyReplicationTokenChanges(replicationCfg, config, thisnode);
        new ValidateReplication(null, thisnode).validateSetReplicationNodes(replicationCfg, em, thisnode, config);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddkkmmZ");
        replicationCfg.setTimeOfConfigurationUpdate(sdf.format(new Date()));
        ReplicationConfiguration model = new ReplicationConfiguration();
        MappingApiToModel.mapReplicationConfiguration(replicationCfg, model, em);
        model.setSerialNumber(System.currentTimeMillis());
        ReplicationConfiguration oldstuff = null;
        try {
            oldstuff = (ReplicationConfiguration)em.createQuery("select c FROM ReplicationConfiguration c order by c.serialNumber desc").getSingleResult();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oldstuff != null) {
            em.remove((Object)oldstuff);
        }
        em.persist((Object)model);
    }
}

