/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.cryptor;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.ClassUtil;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.v3.client.cryptor.Cryptor;

public abstract class CryptorFactory {
    private static final Log log = LogFactory.getLog(CryptorFactory.class);
    private static Cryptor cryptor = null;

    public static synchronized Cryptor getCryptor() {
        if (cryptor == null) {
            cryptor = CryptorFactory.createCryptor();
        }
        return cryptor;
    }

    public static synchronized Cryptor getCryptor(String className) throws Exception {
        return org.apache.juddi.v3.client.cryptor.CryptorFactory.getCryptor((String)className);
    }

    private static synchronized Cryptor createCryptor() {
        if (cryptor != null) {
            return cryptor;
        }
        String className = "org.apache.juddi.v3.client.cryptor.DefaultCryptor";
        try {
            className = AppConfig.getConfiguration().getString("juddi.cryptor", "org.apache.juddi.v3.client.cryptor.DefaultCryptor");
        }
        catch (ConfigurationException ce) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.cryptor", (Throwable)ce);
        }
        log.debug((Object)("Cryptor Implementation = " + className));
        Class<?> cryptorClass = null;
        try {
            cryptorClass = ClassUtil.forName(className, CryptorFactory.class);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("The specified Cryptor class '" + className + "' was not found in classpath."));
            log.error((Object)e);
        }
        if (cryptorClass != null) {
            try {
                cryptor = (Cryptor)cryptorClass.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("Exception while attempting to instantiate the implementation of Cryptor: " + cryptorClass.getName() + "\n" + e.getMessage()));
                log.error((Object)e);
            }
        }
        return cryptor;
    }
}

