/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.keygen;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.keygen.KeyGenerator;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class DefaultKeyGenerator
implements KeyGenerator {
    @Override
    public String generate(UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        String domain = DefaultKeyGenerator.getDomain(publisher);
        if (domain == null) {
            String rootPartition = "";
            try {
                rootPartition = AppConfig.getConfiguration().getString("juddi.root.partition");
            }
            catch (ConfigurationException ce) {
                throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.root.partition"));
            }
            domain = rootPartition;
        }
        return domain + ":" + UUID.randomUUID();
    }

    public static String getDomain(UddiEntityPublisher publisher) {
        String domain = null;
        if (publisher == null || "uddi".equalsIgnoreCase(publisher.getAuthorizedName())) {
            return domain;
        }
        List<String> domains = publisher.getKeyGeneratorKeys();
        if (domains != null && !domains.isEmpty()) {
            Iterator<String> iter = domains.iterator();
            int partsMax = 1000;
            while (iter.hasNext()) {
                String thisDomain = iter.next();
                String[] parts = thisDomain.split(":");
                if (domain != null && (2 > parts.length || parts.length >= partsMax) || thisDomain.length() + 37 >= 255) continue;
                partsMax = parts.length;
                domain = thisDomain;
            }
            domain = domain.substring(0, domain.lastIndexOf(":"));
        }
        return domain;
    }
}

