/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.mapping;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.jaxb.JAXBMarshaller;
import org.apache.juddi.model.Address;
import org.apache.juddi.model.BindingCategoryBag;
import org.apache.juddi.model.BindingDescr;
import org.apache.juddi.model.BusinessCategoryBag;
import org.apache.juddi.model.BusinessDescr;
import org.apache.juddi.model.BusinessIdentifier;
import org.apache.juddi.model.BusinessName;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.CanonicalizationMethod;
import org.apache.juddi.model.CategoryBag;
import org.apache.juddi.model.ChangeRecord;
import org.apache.juddi.model.Clerk;
import org.apache.juddi.model.ClientSubscriptionInfo;
import org.apache.juddi.model.Contact;
import org.apache.juddi.model.ContactDescr;
import org.apache.juddi.model.ControlMessage;
import org.apache.juddi.model.DiscoveryUrl;
import org.apache.juddi.model.Edge;
import org.apache.juddi.model.EdgeReceiverAlternate;
import org.apache.juddi.model.Email;
import org.apache.juddi.model.InstanceDetailsDescr;
import org.apache.juddi.model.KeyDataValue;
import org.apache.juddi.model.KeyInfo;
import org.apache.juddi.model.Node;
import org.apache.juddi.model.Operator;
import org.apache.juddi.model.OperatorStatusType;
import org.apache.juddi.model.OverviewDoc;
import org.apache.juddi.model.OverviewDocDescr;
import org.apache.juddi.model.PersonName;
import org.apache.juddi.model.Phone;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.PublisherAssertionId;
import org.apache.juddi.model.Reference;
import org.apache.juddi.model.ReplicationConfigurationNode;
import org.apache.juddi.model.ServiceCategoryBag;
import org.apache.juddi.model.ServiceDescr;
import org.apache.juddi.model.ServiceName;
import org.apache.juddi.model.ServiceProjection;
import org.apache.juddi.model.Signature;
import org.apache.juddi.model.SignatureMethod;
import org.apache.juddi.model.SignatureTransform;
import org.apache.juddi.model.SignatureTransformDataValue;
import org.apache.juddi.model.SignatureValue;
import org.apache.juddi.model.SignedInfo;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.TmodelCategoryBag;
import org.apache.juddi.model.TmodelDescr;
import org.apache.juddi.model.TmodelIdentifier;
import org.apache.juddi.model.TmodelInstanceInfo;
import org.apache.juddi.model.TmodelInstanceInfoDescr;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.uddi.api_v3.AddressLine;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OperationalInfo;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.repl_v3.ChangeRecord;
import org.uddi.repl_v3.CommunicationGraph;
import org.uddi.repl_v3.ReplicationConfiguration;
import org.uddi.sub_v3.ObjectFactory;
import org.uddi.sub_v3.Subscription;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.w3._2000._09.xmldsig_.DSAKeyValueType;
import org.w3._2000._09.xmldsig_.KeyInfoType;
import org.w3._2000._09.xmldsig_.KeyValueType;
import org.w3._2000._09.xmldsig_.PGPDataType;
import org.w3._2000._09.xmldsig_.RSAKeyValueType;
import org.w3._2000._09.xmldsig_.ReferenceType;
import org.w3._2000._09.xmldsig_.RetrievalMethodType;
import org.w3._2000._09.xmldsig_.SPKIDataType;
import org.w3._2000._09.xmldsig_.SignatureType;
import org.w3._2000._09.xmldsig_.SignatureValueType;
import org.w3._2000._09.xmldsig_.SignedInfoType;
import org.w3._2000._09.xmldsig_.TransformType;
import org.w3._2000._09.xmldsig_.TransformsType;
import org.w3._2000._09.xmldsig_.X509DataType;
import org.w3._2000._09.xmldsig_.X509IssuerSerialType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSSerializer;

public class MappingApiToModel {
    private static Log logger = LogFactory.getLog(MappingApiToModel.class);

    public static void mapPublisher(org.apache.juddi.api_v3.Publisher apiPublisher, Publisher modelPublisher) throws DispositionReportFaultMessage {
        modelPublisher.setAuthorizedName(apiPublisher.getAuthorizedName());
        modelPublisher.setPublisherName(apiPublisher.getPublisherName());
        modelPublisher.setEmailAddress(apiPublisher.getEmailAddress());
        modelPublisher.setIsAdmin(apiPublisher.isIsAdmin());
        modelPublisher.setIsEnabled(apiPublisher.isIsEnabled());
        modelPublisher.setMaxBindingsPerService(apiPublisher.getMaxBindingsPerService());
        modelPublisher.setMaxBusinesses(apiPublisher.getMaxBusinesses());
        modelPublisher.setMaxServicesPerBusiness(apiPublisher.getMaxServicePerBusiness());
        modelPublisher.setMaxTmodels(apiPublisher.getMaxTModels());
        MappingApiToModel.mapPublisherSignatures(apiPublisher.getSignature(), modelPublisher);
    }

    public static void mapBusinessEntity(BusinessEntity apiBusinessEntity, org.apache.juddi.model.BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelBusinessEntity.setEntityKey(apiBusinessEntity.getBusinessKey());
        MappingApiToModel.mapBusinessNames(apiBusinessEntity.getName(), modelBusinessEntity.getBusinessNames(), modelBusinessEntity);
        MappingApiToModel.mapBusinessDescriptions(apiBusinessEntity.getDescription(), modelBusinessEntity.getBusinessDescrs(), modelBusinessEntity);
        MappingApiToModel.mapDiscoveryUrls(apiBusinessEntity.getDiscoveryURLs(), modelBusinessEntity.getDiscoveryUrls(), modelBusinessEntity);
        MappingApiToModel.mapContacts(apiBusinessEntity.getContacts(), modelBusinessEntity.getContacts(), modelBusinessEntity);
        MappingApiToModel.mapBusinessIdentifiers(apiBusinessEntity.getIdentifierBag(), modelBusinessEntity.getBusinessIdentifiers(), modelBusinessEntity);
        if (apiBusinessEntity.getCategoryBag() != null) {
            modelBusinessEntity.setCategoryBag(new BusinessCategoryBag(modelBusinessEntity));
            MappingApiToModel.mapCategoryBag(apiBusinessEntity.getCategoryBag(), modelBusinessEntity.getCategoryBag());
        }
        MappingApiToModel.mapBusinessServices(apiBusinessEntity.getBusinessServices(), modelBusinessEntity.getBusinessServices(), modelBusinessEntity.getServiceProjections(), modelBusinessEntity);
        MappingApiToModel.mapBusinessSignature(apiBusinessEntity.getSignature(), modelBusinessEntity);
    }

    public static List<Signature> mapApiSignaturesToModelSignatures(List<SignatureType> apiSignatures) throws DispositionReportFaultMessage {
        ArrayList<Signature> modelSignatures = new ArrayList<Signature>();
        modelSignatures.clear();
        for (SignatureType signatureType : apiSignatures) {
            Signature modelSignature = new Signature();
            SignedInfoType apiSignedInfo = signatureType.getSignedInfo();
            SignedInfo modelSignedInfo = new SignedInfo();
            modelSignature.setSignedInfo(modelSignedInfo);
            String canonicalizationAlgMethod = apiSignedInfo.getCanonicalizationMethod().getAlgorithm();
            CanonicalizationMethod modelCanonMethod = new CanonicalizationMethod();
            modelSignedInfo.setCanonicalizationMethod(modelCanonMethod);
            modelCanonMethod.setAlgorithm(canonicalizationAlgMethod);
            SignatureMethod modelSigMethod = new SignatureMethod();
            modelSignedInfo.setSignatureMethod(modelSigMethod);
            String sigMethod = apiSignedInfo.getSignatureMethod().getAlgorithm();
            modelSigMethod.setAlgorithm(sigMethod);
            List apiReferenceList = apiSignedInfo.getReference();
            for (ReferenceType apiReference : apiReferenceList) {
                Reference ref = MappingApiToModel.mapReference(modelSignedInfo, apiReference);
                modelSignedInfo.getReference().add(ref);
            }
            modelSignedInfo.setCanonicalizationMethod(modelCanonMethod);
            SignatureValueType apiSignatureValue = signatureType.getSignatureValue();
            SignatureValue modelSignatureValue = new SignatureValue();
            byte[] signatureValueBytes = apiSignatureValue.getValue();
            String signatureValueXmlID = apiSignatureValue.getId();
            modelSignatureValue.setValue(signatureValueBytes);
            modelSignatureValue.setXmlID(signatureValueXmlID);
            modelSignature.setSignatureValue(modelSignatureValue);
            KeyInfoType apiKeyInfo = signatureType.getKeyInfo();
            String apiKeyInfoXmlID = apiKeyInfo.getId();
            KeyInfo modelKeyInfo = new KeyInfo();
            modelSignature.setKeyInfo(modelKeyInfo);
            modelKeyInfo.setXmlID(apiKeyInfoXmlID);
            List apiKeyInfoContentList = apiKeyInfo.getContent();
            List<KeyDataValue> keyInfoDataValues = modelKeyInfo.getKeyDataValue();
            for (Object apiKeyInfoContentObj : apiKeyInfoContentList) {
                KeyDataValue modelKeyValueKDV;
                if (!(apiKeyInfoContentObj instanceof JAXBElement)) continue;
                JAXBElement apiKeyInfoContentJAXB = (JAXBElement)apiKeyInfoContentObj;
                String apiKeyInfoContentTagName = apiKeyInfoContentJAXB.getName().getLocalPart();
                if (apiKeyInfoContentJAXB.getValue() instanceof X509DataType) {
                    KeyDataValue modelX509KeyData = MappingApiToModel.mapX509DataType(apiKeyInfoContentJAXB, modelKeyInfo);
                    keyInfoDataValues.add(modelX509KeyData);
                    continue;
                }
                if (apiKeyInfoContentTagName.equals("KeyName")) {
                    KeyDataValue modelKeyNameKDV = MappingApiToModel.mapKeyName(apiKeyInfoContentJAXB);
                    modelKeyNameKDV.setKeyInfo(modelKeyInfo);
                    keyInfoDataValues.add(modelKeyNameKDV);
                    continue;
                }
                if (apiKeyInfoContentTagName.equals("KeyValue")) {
                    modelKeyValueKDV = MappingApiToModel.mapKeyValue(apiKeyInfoContentJAXB, keyInfoDataValues);
                    modelKeyValueKDV.setKeyInfo(modelKeyInfo);
                    keyInfoDataValues.add(modelKeyValueKDV);
                    continue;
                }
                if (apiKeyInfoContentTagName.equals("MgmtData")) {
                    modelKeyValueKDV = new KeyDataValue();
                    modelKeyValueKDV.setKeyDataName(apiKeyInfoContentTagName);
                    modelKeyValueKDV.setKeyDataType("String");
                    modelKeyValueKDV.setKeyDataValueString((String)apiKeyInfoContentJAXB.getValue());
                    modelKeyValueKDV.setKeyInfo(modelKeyInfo);
                    keyInfoDataValues.add(modelKeyValueKDV);
                    continue;
                }
                if (apiKeyInfoContentTagName.equals("RetrievalMethod")) {
                    RetrievalMethodType retrievalMethodType = (RetrievalMethodType)apiKeyInfoContentJAXB.getValue();
                    KeyDataValue retrievalMethodTypeKDV = MappingApiToModel.mapRetrievalMethod(apiKeyInfoContentTagName, modelKeyInfo, retrievalMethodType);
                    keyInfoDataValues.add(retrievalMethodTypeKDV);
                    continue;
                }
                if (apiKeyInfoContentTagName.equals("PGPData")) {
                    PGPDataType pgpDataType = (PGPDataType)apiKeyInfoContentJAXB.getValue();
                    KeyDataValue pgpDataTypeKDV = MappingApiToModel.mapPGPDataType(apiKeyInfoContentTagName, modelKeyInfo, pgpDataType);
                    keyInfoDataValues.add(pgpDataTypeKDV);
                    continue;
                }
                if (apiKeyInfoContentTagName.equals("SPKIData")) {
                    SPKIDataType spkiDataType = (SPKIDataType)apiKeyInfoContentJAXB.getValue();
                    KeyDataValue spkiDataTypeKDV = MappingApiToModel.mapSPKIDataType(apiKeyInfoContentTagName, modelKeyInfo, spkiDataType);
                    keyInfoDataValues.add(spkiDataTypeKDV);
                    continue;
                }
                throw new RuntimeException("Unrecognized tag: " + apiKeyInfoContentTagName + " type: " + apiKeyInfoContentJAXB.getValue().getClass().getCanonicalName());
            }
            modelSignatures.add(modelSignature);
        }
        return modelSignatures;
    }

    public static void mapBusinessServiceSignature(List<SignatureType> apiSignatures, BusinessService modelBusinessService) throws DispositionReportFaultMessage {
        List<Signature> modelSignatures = MappingApiToModel.mapApiSignaturesToModelSignatures(apiSignatures);
        for (Signature modelSignature : modelSignatures) {
            modelSignature.setBusinessService(modelBusinessService);
        }
        modelBusinessService.setSignatures(modelSignatures);
    }

    public static void mapTmodelSignatures(List<SignatureType> apiSignatures, Tmodel modelTmodel) throws DispositionReportFaultMessage {
        List<Signature> modelSignatures = MappingApiToModel.mapApiSignaturesToModelSignatures(apiSignatures);
        for (Signature modelSignature : modelSignatures) {
            modelSignature.setTmodel(modelTmodel);
        }
        modelTmodel.setSignatures(modelSignatures);
    }

    public static void mapBindingTemplateSignatures(List<SignatureType> apiSignatures, org.apache.juddi.model.BindingTemplate modelBindingTemplate) throws DispositionReportFaultMessage {
        List<Signature> modelSignatures = MappingApiToModel.mapApiSignaturesToModelSignatures(apiSignatures);
        for (Signature modelSignature : modelSignatures) {
            modelSignature.setBindingTemplate(modelBindingTemplate);
        }
        modelBindingTemplate.setSignatures(modelSignatures);
    }

    public static void mapPublisherSignatures(List<SignatureType> apiSignatures, Publisher modelPublisher) throws DispositionReportFaultMessage {
        List<Signature> modelSignatures = MappingApiToModel.mapApiSignaturesToModelSignatures(apiSignatures);
        for (Signature modelSignature : modelSignatures) {
            modelSignature.setPublisher(modelPublisher);
        }
        modelPublisher.setSignatures(modelSignatures);
    }

    public static void mapBusinessSignature(List<SignatureType> apiSignatures, org.apache.juddi.model.BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        List<Signature> modelSignatures = MappingApiToModel.mapApiSignaturesToModelSignatures(apiSignatures);
        for (Signature modelSignature : modelSignatures) {
            modelSignature.setBusinessEntity(modelBusinessEntity);
        }
        modelBusinessEntity.setSignatures(modelSignatures);
    }

    public static void mapBusinessNames(List<Name> apiNameList, List<BusinessName> modelNameList, org.apache.juddi.model.BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelNameList.clear();
        for (Name apiName : apiNameList) {
            modelNameList.add(new BusinessName(modelBusinessEntity, apiName.getLang(), apiName.getValue()));
        }
    }

    public static void mapBusinessDescriptions(List<Description> apiDescList, List<BusinessDescr> modelDescList, org.apache.juddi.model.BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new BusinessDescr(modelBusinessEntity, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapDiscoveryUrls(DiscoveryURLs apiDiscUrls, List<DiscoveryUrl> modelDiscUrlList, org.apache.juddi.model.BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelDiscUrlList.clear();
        if (apiDiscUrls != null) {
            List apiDiscUrlList = apiDiscUrls.getDiscoveryURL();
            for (DiscoveryURL apiDiscUrl : apiDiscUrlList) {
                modelDiscUrlList.add(new DiscoveryUrl(modelBusinessEntity, apiDiscUrl.getUseType(), apiDiscUrl.getValue()));
            }
        }
    }

    public static void mapContacts(Contacts apiContacts, List<Contact> modelContactList, org.apache.juddi.model.BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelContactList.clear();
        if (apiContacts != null) {
            List apiContactList = apiContacts.getContact();
            for (org.uddi.api_v3.Contact apiContact : apiContactList) {
                Contact modelContact = new Contact(modelBusinessEntity);
                modelContact.setUseType(apiContact.getUseType());
                MappingApiToModel.mapPersonNames(apiContact.getPersonName(), modelContact.getPersonNames(), modelContact, modelBusinessEntity.getEntityKey());
                MappingApiToModel.mapContactDescriptions(apiContact.getDescription(), modelContact.getContactDescrs(), modelContact, modelBusinessEntity.getEntityKey());
                MappingApiToModel.mapContactEmails(apiContact.getEmail(), modelContact.getEmails(), modelContact, modelBusinessEntity.getEntityKey());
                MappingApiToModel.mapContactPhones(apiContact.getPhone(), modelContact.getPhones(), modelContact, modelBusinessEntity.getEntityKey());
                MappingApiToModel.mapContactAddresses(apiContact.getAddress(), modelContact.getAddresses(), modelContact);
                modelContactList.add(modelContact);
            }
        }
    }

    public static void mapContactDescriptions(List<Description> apiDescList, List<ContactDescr> modelDescList, Contact modelContact, String businessKey) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new ContactDescr(modelContact, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapPersonNames(List<org.uddi.api_v3.PersonName> apiPersonNameList, List<PersonName> modelPersonNameList, Contact modelContact, String businessKey) throws DispositionReportFaultMessage {
        modelPersonNameList.clear();
        for (org.uddi.api_v3.PersonName apiPersonName : apiPersonNameList) {
            modelPersonNameList.add(new PersonName(modelContact, apiPersonName.getLang(), apiPersonName.getValue()));
        }
    }

    public static void mapContactEmails(List<org.uddi.api_v3.Email> apiEmailList, List<Email> modelEmailList, Contact modelContact, String businessKey) throws DispositionReportFaultMessage {
        modelEmailList.clear();
        for (org.uddi.api_v3.Email apiEmail : apiEmailList) {
            modelEmailList.add(new Email(modelContact, apiEmail.getUseType(), apiEmail.getValue()));
        }
    }

    public static void mapContactPhones(List<org.uddi.api_v3.Phone> apiPhoneList, List<Phone> modelPhoneList, Contact modelContact, String businessKey) throws DispositionReportFaultMessage {
        modelPhoneList.clear();
        for (org.uddi.api_v3.Phone apiPhone : apiPhoneList) {
            modelPhoneList.add(new Phone(modelContact, apiPhone.getUseType(), apiPhone.getValue()));
        }
    }

    public static void mapContactAddresses(List<org.uddi.api_v3.Address> apiAddressList, List<Address> modelAddressList, Contact modelContact) throws DispositionReportFaultMessage {
        modelAddressList.clear();
        for (org.uddi.api_v3.Address apiAddress : apiAddressList) {
            Address modelAddress = new Address(modelContact);
            modelAddress.setSortCode(apiAddress.getSortCode());
            modelAddress.setTmodelKey(apiAddress.getTModelKey());
            modelAddress.setUseType(apiAddress.getUseType());
            MappingApiToModel.mapAddressLines(apiAddress.getAddressLine(), modelAddress.getAddressLines(), modelAddress, modelContact.getId());
            modelAddressList.add(modelAddress);
        }
    }

    public static void mapAddressLines(List<AddressLine> apiAddressLineList, List<org.apache.juddi.model.AddressLine> modelAddressLineList, Address modelAddress, Long contactId) throws DispositionReportFaultMessage {
        modelAddressLineList.clear();
        for (AddressLine apiAddressLine : apiAddressLineList) {
            modelAddressLineList.add(new org.apache.juddi.model.AddressLine(modelAddress, apiAddressLine.getValue(), apiAddressLine.getKeyName(), apiAddressLine.getKeyValue()));
        }
    }

    public static void mapBusinessIdentifiers(IdentifierBag apiIdentifierBag, List<BusinessIdentifier> modelIdentifierList, org.apache.juddi.model.BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelIdentifierList.clear();
        if (apiIdentifierBag != null) {
            List apiKeyedRefList = apiIdentifierBag.getKeyedReference();
            for (KeyedReference apiKeyedRef : apiKeyedRefList) {
                modelIdentifierList.add(new BusinessIdentifier(modelBusinessEntity, apiKeyedRef.getTModelKey(), apiKeyedRef.getKeyName(), apiKeyedRef.getKeyValue()));
            }
        }
    }

    public static void mapBusinessServices(BusinessServices apiBusinessServices, List<BusinessService> modelBusinessServiceList, List<ServiceProjection> modelServiceProjectionList, org.apache.juddi.model.BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelBusinessServiceList.clear();
        if (apiBusinessServices != null) {
            List apiBusinessServiceList = apiBusinessServices.getBusinessService();
            for (org.uddi.api_v3.BusinessService apiBusinessService : apiBusinessServiceList) {
                BusinessService modelBusinessService = new BusinessService();
                if (apiBusinessService.getBusinessKey() != null && apiBusinessService.getBusinessKey().length() > 0 && !modelBusinessEntity.getEntityKey().equalsIgnoreCase(apiBusinessService.getBusinessKey())) {
                    modelBusinessService.setEntityKey(apiBusinessService.getServiceKey());
                    ServiceProjection modelServiceProjection = new ServiceProjection(modelBusinessEntity, modelBusinessService);
                    modelServiceProjectionList.add(modelServiceProjection);
                    continue;
                }
                MappingApiToModel.mapBusinessService(apiBusinessService, modelBusinessService, modelBusinessEntity);
                modelBusinessServiceList.add(modelBusinessService);
            }
        }
    }

    public static void mapBusinessService(org.uddi.api_v3.BusinessService apiBusinessService, BusinessService modelBusinessService, org.apache.juddi.model.BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelBusinessService.setBusinessEntity(modelBusinessEntity);
        modelBusinessService.setEntityKey(apiBusinessService.getServiceKey());
        MappingApiToModel.mapServiceNames(apiBusinessService.getName(), modelBusinessService.getServiceNames(), modelBusinessService);
        MappingApiToModel.mapServiceDescriptions(apiBusinessService.getDescription(), modelBusinessService.getServiceDescrs(), modelBusinessService);
        if (apiBusinessService.getCategoryBag() != null) {
            modelBusinessService.setCategoryBag(new ServiceCategoryBag(modelBusinessService));
            MappingApiToModel.mapCategoryBag(apiBusinessService.getCategoryBag(), modelBusinessService.getCategoryBag());
        }
        MappingApiToModel.mapBindingTemplates(apiBusinessService.getBindingTemplates(), modelBusinessService.getBindingTemplates(), modelBusinessService);
        MappingApiToModel.mapBusinessServiceSignature(apiBusinessService.getSignature(), modelBusinessService);
    }

    public static void mapServiceNames(List<Name> apiNameList, List<ServiceName> modelNameList, BusinessService modelBusinessService) throws DispositionReportFaultMessage {
        modelNameList.clear();
        for (Name apiName : apiNameList) {
            modelNameList.add(new ServiceName(modelBusinessService, apiName.getLang(), apiName.getValue()));
        }
    }

    public static void mapServiceDescriptions(List<Description> apiDescList, List<ServiceDescr> modelDescList, BusinessService modelBusinessService) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new ServiceDescr(modelBusinessService, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapBindingTemplates(BindingTemplates apiBindingTemplates, List<org.apache.juddi.model.BindingTemplate> modelBindingTemplateList, BusinessService modelBusinessService) throws DispositionReportFaultMessage {
        modelBindingTemplateList.clear();
        if (apiBindingTemplates != null) {
            List apiBindingTemplateList = apiBindingTemplates.getBindingTemplate();
            for (BindingTemplate apiBindingTemplate : apiBindingTemplateList) {
                org.apache.juddi.model.BindingTemplate modelBindingTemplate = new org.apache.juddi.model.BindingTemplate();
                MappingApiToModel.mapBindingTemplate(apiBindingTemplate, modelBindingTemplate, modelBusinessService);
                modelBindingTemplateList.add(modelBindingTemplate);
            }
        }
    }

    public static void mapBindingTemplate(BindingTemplate apiBindingTemplate, org.apache.juddi.model.BindingTemplate modelBindingTemplate, BusinessService modelBusinessService) throws DispositionReportFaultMessage {
        modelBindingTemplate.setBusinessService(modelBusinessService);
        modelBindingTemplate.setEntityKey(apiBindingTemplate.getBindingKey());
        if (apiBindingTemplate.getAccessPoint() != null) {
            modelBindingTemplate.setAccessPointType(apiBindingTemplate.getAccessPoint().getUseType());
            modelBindingTemplate.setAccessPointUrl(apiBindingTemplate.getAccessPoint().getValue());
        }
        if (apiBindingTemplate.getHostingRedirector() != null) {
            modelBindingTemplate.setHostingRedirector(apiBindingTemplate.getHostingRedirector().getBindingKey());
        }
        MappingApiToModel.mapBindingDescriptions(apiBindingTemplate.getDescription(), modelBindingTemplate.getBindingDescrs(), modelBindingTemplate);
        if (apiBindingTemplate.getCategoryBag() != null) {
            modelBindingTemplate.setCategoryBag(new BindingCategoryBag(modelBindingTemplate));
            MappingApiToModel.mapCategoryBag(apiBindingTemplate.getCategoryBag(), modelBindingTemplate.getCategoryBag());
        }
        MappingApiToModel.mapTModelInstanceDetails(apiBindingTemplate.getTModelInstanceDetails(), modelBindingTemplate.getTmodelInstanceInfos(), modelBindingTemplate);
        MappingApiToModel.mapBindingTemplateSignatures(apiBindingTemplate.getSignature(), modelBindingTemplate);
    }

    public static void mapBindingDescriptions(List<Description> apiDescList, List<BindingDescr> modelDescList, org.apache.juddi.model.BindingTemplate modelBindingTemplate) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new BindingDescr(modelBindingTemplate, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapCategoryBag(org.uddi.api_v3.CategoryBag apiCategoryBag, CategoryBag modelCategoryBag) throws DispositionReportFaultMessage {
        if (apiCategoryBag != null) {
            List krList = apiCategoryBag.getKeyedReference();
            for (Object elem : krList) {
                if (!(elem instanceof KeyedReference)) continue;
                List<org.apache.juddi.model.KeyedReference> modelKeyedReferences = modelCategoryBag.getKeyedReferences();
                KeyedReference apiKeyedReference = (KeyedReference)elem;
                modelKeyedReferences.add(new org.apache.juddi.model.KeyedReference(modelCategoryBag, apiKeyedReference.getTModelKey(), apiKeyedReference.getKeyName(), apiKeyedReference.getKeyValue()));
            }
            List krgList = apiCategoryBag.getKeyedReferenceGroup();
            for (KeyedReferenceGroup elem : krgList) {
                if (!(elem instanceof KeyedReferenceGroup)) continue;
                KeyedReferenceGroup apiKeyedReferenceGroup = elem;
                org.apache.juddi.model.KeyedReferenceGroup modelKeyedReferenceGroup = new org.apache.juddi.model.KeyedReferenceGroup();
                List<org.apache.juddi.model.KeyedReferenceGroup> modelKeyedReferenceGroups = modelCategoryBag.getKeyedReferenceGroups();
                MappingApiToModel.mapKeyedReferenceGroup(apiKeyedReferenceGroup, modelKeyedReferenceGroup, modelCategoryBag);
                modelKeyedReferenceGroups.add(modelKeyedReferenceGroup);
            }
        }
    }

    public static void mapKeyedReferenceGroup(KeyedReferenceGroup apiKeyedReferenceGroup, org.apache.juddi.model.KeyedReferenceGroup modelKeyedReferenceGroup, CategoryBag modelCategoryBag) throws DispositionReportFaultMessage {
        if (apiKeyedReferenceGroup != null) {
            modelKeyedReferenceGroup.setCategoryBag(modelCategoryBag);
            modelKeyedReferenceGroup.setTmodelKey(apiKeyedReferenceGroup.getTModelKey());
            if (apiKeyedReferenceGroup.getKeyedReference() != null) {
                List<org.apache.juddi.model.KeyedReference> modelKeyedReferences = modelKeyedReferenceGroup.getKeyedReferences();
                for (KeyedReference apiKeyedReference : apiKeyedReferenceGroup.getKeyedReference()) {
                    modelKeyedReferences.add(new org.apache.juddi.model.KeyedReference(modelKeyedReferenceGroup, apiKeyedReference.getTModelKey(), apiKeyedReference.getKeyName(), apiKeyedReference.getKeyValue()));
                }
            }
        }
    }

    public static void mapTModelInstanceDetails(TModelInstanceDetails apiTModelInstDetails, List<TmodelInstanceInfo> modelTModelInstInfoList, org.apache.juddi.model.BindingTemplate modelBindingTemplate) throws DispositionReportFaultMessage {
        modelTModelInstInfoList.clear();
        if (apiTModelInstDetails != null) {
            List apiTModelInstInfoList = apiTModelInstDetails.getTModelInstanceInfo();
            for (TModelInstanceInfo apiTModelInstInfo : apiTModelInstInfoList) {
                TmodelInstanceInfo modelTModelInstInfo = new TmodelInstanceInfo(modelBindingTemplate, apiTModelInstInfo.getTModelKey());
                MappingApiToModel.mapTModelInstanceInfoDescriptions(apiTModelInstInfo.getDescription(), modelTModelInstInfo.getTmodelInstanceInfoDescrs(), modelTModelInstInfo);
                MappingApiToModel.mapInstanceDetails(apiTModelInstInfo.getInstanceDetails(), modelTModelInstInfo);
                modelTModelInstInfoList.add(modelTModelInstInfo);
            }
        }
    }

    public static void mapTModelInstanceInfoDescriptions(List<Description> apiDescList, List<TmodelInstanceInfoDescr> modelDescList, TmodelInstanceInfo modelTModelInstInfo) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new TmodelInstanceInfoDescr(modelTModelInstInfo, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapInstanceDetails(InstanceDetails apiInstanceDetails, TmodelInstanceInfo modelTmodelInstInfo) throws DispositionReportFaultMessage {
        modelTmodelInstInfo.getInstanceDetailsDescrs().clear();
        if (apiInstanceDetails != null) {
            List descriptions = apiInstanceDetails.getDescription();
            List overviewdocs = apiInstanceDetails.getOverviewDoc();
            for (Description apiDesc : descriptions) {
                InstanceDetailsDescr modelInstanceDetailsDescr = new InstanceDetailsDescr(modelTmodelInstInfo, apiDesc.getLang(), apiDesc.getValue());
                modelTmodelInstInfo.getInstanceDetailsDescrs().add(modelInstanceDetailsDescr);
            }
            for (org.uddi.api_v3.OverviewDoc apiOverviewDoc : overviewdocs) {
                OverviewDoc modelOverviewDoc = new OverviewDoc(modelTmodelInstInfo);
                MappingApiToModel.mapOverviewDoc(apiOverviewDoc, modelOverviewDoc);
                modelTmodelInstInfo.getOverviewDocs().add(modelOverviewDoc);
            }
            modelTmodelInstInfo.setInstanceParms(apiInstanceDetails.getInstanceParms());
        }
    }

    public static void mapOverviewDoc(org.uddi.api_v3.OverviewDoc apiOverviewDoc, OverviewDoc modelOverviewDoc) throws DispositionReportFaultMessage {
        if (apiOverviewDoc != null) {
            List descContent = apiOverviewDoc.getDescription();
            for (Object elem : descContent) {
                Description description = (Description)elem;
                if (description == null) continue;
                OverviewDocDescr modelOverviewDocDescr = new OverviewDocDescr(modelOverviewDoc, description.getLang(), description.getValue());
                modelOverviewDoc.getOverviewDocDescrs().add(modelOverviewDocDescr);
            }
            OverviewURL elem = apiOverviewDoc.getOverviewURL();
            if (elem instanceof OverviewURL) {
                OverviewURL overviewURL = elem;
                modelOverviewDoc.setOverviewUrl(overviewURL.getValue());
                modelOverviewDoc.setOverviewUrlUseType(overviewURL.getUseType());
            }
        }
    }

    public static void mapTModel(TModel apiTModel, Tmodel modelTModel) throws DispositionReportFaultMessage {
        modelTModel.setEntityKey(apiTModel.getTModelKey());
        modelTModel.setName(apiTModel.getName().getValue());
        modelTModel.setLangCode(apiTModel.getName().getLang());
        modelTModel.setDeleted(apiTModel.isDeleted());
        MappingApiToModel.mapTModelDescriptions(apiTModel.getDescription(), modelTModel.getTmodelDescrs(), modelTModel);
        MappingApiToModel.mapTModelIdentifiers(apiTModel.getIdentifierBag(), modelTModel.getTmodelIdentifiers(), modelTModel);
        if (apiTModel.getCategoryBag() != null) {
            modelTModel.setCategoryBag(new TmodelCategoryBag(modelTModel));
            MappingApiToModel.mapCategoryBag(apiTModel.getCategoryBag(), modelTModel.getCategoryBag());
        }
        MappingApiToModel.mapTModelOverviewDocs(apiTModel.getOverviewDoc(), modelTModel.getOverviewDocs(), modelTModel);
        MappingApiToModel.mapTmodelSignatures(apiTModel.getSignature(), modelTModel);
    }

    public static void mapTModelDescriptions(List<Description> apiDescList, List<TmodelDescr> modelDescList, Tmodel modelTModel) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new TmodelDescr(modelTModel, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapTModelIdentifiers(IdentifierBag apiIdentifierBag, List<TmodelIdentifier> modelIdentifierList, Tmodel modelTModel) throws DispositionReportFaultMessage {
        modelIdentifierList.clear();
        if (apiIdentifierBag != null) {
            List apiKeyedRefList = apiIdentifierBag.getKeyedReference();
            for (KeyedReference apiKeyedRef : apiKeyedRefList) {
                modelIdentifierList.add(new TmodelIdentifier(modelTModel, apiKeyedRef.getTModelKey(), apiKeyedRef.getKeyName(), apiKeyedRef.getKeyValue()));
            }
        }
    }

    public static void mapTModelOverviewDocs(List<org.uddi.api_v3.OverviewDoc> apiOverviewDocList, List<OverviewDoc> modelOverviewDocList, Tmodel modelTmodel) throws DispositionReportFaultMessage {
        modelOverviewDocList.clear();
        for (org.uddi.api_v3.OverviewDoc apiOverviewDoc : apiOverviewDocList) {
            OverviewDoc modelOverviewDoc = new OverviewDoc(modelTmodel);
            MappingApiToModel.mapOverviewDoc(apiOverviewDoc, modelOverviewDoc);
            modelTmodel.getOverviewDocs().add(modelOverviewDoc);
        }
    }

    public static void mapPublisherAssertion(PublisherAssertion apiPubAssertion, org.apache.juddi.model.PublisherAssertion modelPubAssertion) throws DispositionReportFaultMessage {
        modelPubAssertion.setId(new PublisherAssertionId(apiPubAssertion.getFromKey(), apiPubAssertion.getToKey()));
        org.apache.juddi.model.BusinessEntity beFrom = new org.apache.juddi.model.BusinessEntity();
        beFrom.setEntityKey(apiPubAssertion.getFromKey());
        modelPubAssertion.setBusinessEntityByFromKey(beFrom);
        org.apache.juddi.model.BusinessEntity beTo = new org.apache.juddi.model.BusinessEntity();
        beFrom.setEntityKey(apiPubAssertion.getToKey());
        modelPubAssertion.setBusinessEntityByToKey(beTo);
        KeyedReference apiKeyedRef = apiPubAssertion.getKeyedReference();
        if (apiKeyedRef != null) {
            modelPubAssertion.setTmodelKey(apiKeyedRef.getTModelKey());
            modelPubAssertion.setKeyName(apiKeyedRef.getKeyName());
            modelPubAssertion.setKeyValue(apiKeyedRef.getKeyValue());
        }
        if (!apiPubAssertion.getSignature().isEmpty()) {
            modelPubAssertion.setSignatures(MappingApiToModel.mapApiSignaturesToModelSignatures(apiPubAssertion.getSignature()));
            for (Signature s : modelPubAssertion.getSignatures()) {
                s.setPublisherAssertionFromKey(modelPubAssertion.getBusinessEntityByFromKey().getEntityKey());
                s.setPublisherAssertionToKey(modelPubAssertion.getBusinessEntityByToKey().getEntityKey());
            }
        }
    }

    public static void mapSubscription(Subscription apiSubscription, org.apache.juddi.model.Subscription modelSubscription) throws DispositionReportFaultMessage {
        modelSubscription.setSubscriptionKey(apiSubscription.getSubscriptionKey());
        modelSubscription.setBindingKey(apiSubscription.getBindingKey());
        if (apiSubscription.getNotificationInterval() != null) {
            modelSubscription.setNotificationInterval(apiSubscription.getNotificationInterval().toString());
        }
        modelSubscription.setMaxEntities(apiSubscription.getMaxEntities());
        if (apiSubscription.getExpiresAfter() != null) {
            GregorianCalendar gc = apiSubscription.getExpiresAfter().toGregorianCalendar();
            modelSubscription.setExpiresAfter(new Date(gc.getTimeInMillis()));
        }
        if (apiSubscription.isBrief() != null) {
            modelSubscription.setBrief(apiSubscription.isBrief());
        } else {
            modelSubscription.setBrief(Boolean.FALSE);
        }
        String rawFilter = JAXBMarshaller.marshallToString((Object)new ObjectFactory().createSubscriptionFilter(apiSubscription.getSubscriptionFilter()), (String)"org.uddi.sub_v3");
        logger.debug((Object)("marshalled subscription filter:  " + rawFilter));
        modelSubscription.setSubscriptionFilter(rawFilter);
    }

    public static void mapClientSubscriptionInfo(org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo, ClientSubscriptionInfo modelClientSubscriptionInfo) throws DispositionReportFaultMessage {
        modelClientSubscriptionInfo.setLastNotified(new Date());
        modelClientSubscriptionInfo.setSubscriptionKey(apiClientSubscriptionInfo.getSubscriptionKey());
        if (apiClientSubscriptionInfo.getFromClerk() != null) {
            Clerk modelClerk = new Clerk();
            MappingApiToModel.mapClerk(apiClientSubscriptionInfo.getFromClerk(), modelClerk);
            modelClientSubscriptionInfo.setFromClerk(modelClerk);
        }
        if (apiClientSubscriptionInfo.getToClerk() != null) {
            Clerk modelToClerk = new Clerk();
            MappingApiToModel.mapClerk(apiClientSubscriptionInfo.getToClerk(), modelToClerk);
            modelClientSubscriptionInfo.setToClerk(modelToClerk);
        }
    }

    public static void mapClerk(org.apache.juddi.api_v3.Clerk apiClerk, Clerk modelClerk) {
        if (apiClerk != null) {
            modelClerk.setClerkName(apiClerk.getName());
            modelClerk.setCred(apiClerk.getPassword());
            modelClerk.setPublisherId(apiClerk.getPublisher());
            if (apiClerk.getNode() != null) {
                Node modelNode = new Node();
                MappingApiToModel.mapNode(apiClerk.getNode(), modelNode);
                modelClerk.setNode(modelNode.getName());
            }
        }
    }

    public static void mapNode(org.apache.juddi.api_v3.Node apiNode, Node modelNode) {
        if (apiNode != null) {
            modelNode.setCustodyTransferUrl(apiNode.getCustodyTransferUrl());
            modelNode.setInquiryUrl(apiNode.getInquiryUrl());
            modelNode.setJuddiApiUrl(apiNode.getJuddiApiUrl());
            modelNode.setName(apiNode.getName());
            modelNode.setClientName(apiNode.getClientName());
            modelNode.setProxyTransport(apiNode.getProxyTransport());
            modelNode.setPublishUrl(apiNode.getPublishUrl());
            modelNode.setSecurityUrl(apiNode.getSecurityUrl());
            modelNode.setSubscriptionUrl(apiNode.getSubscriptionUrl());
            modelNode.setSubscriptionListenerUrl(apiNode.getSubscriptionListenerUrl());
            modelNode.setReplicationUrl(apiNode.getReplicationUrl());
            modelNode.setFactoryInitial(apiNode.getFactoryInitial());
            modelNode.setFactoryNamingProvider(apiNode.getFactoryNamingProvider());
            modelNode.setFactoryURLPkgs(apiNode.getFactoryURLPkgs());
        }
    }

    private static Reference mapReference(SignedInfo modelSignedInfo, ReferenceType apiReference) {
        Reference ref = new Reference();
        ref.setSignedInfo(modelSignedInfo);
        String refUri = apiReference.getURI();
        if (refUri == null) {
            refUri = "";
        }
        ref.setUri(refUri);
        List apiTransformList = apiReference.getTransforms().getTransform();
        for (TransformType apiTransform : apiTransformList) {
            SignatureTransform modelTransform = new SignatureTransform();
            modelTransform.setReference(ref);
            modelTransform.setTransform(apiTransform.getAlgorithm());
            for (Object xform : apiTransform.getContent()) {
                SignatureTransformDataValue sdv = MappingApiToModel.mapSignatureTransformDataValue(xform);
                sdv.setSignatureTransform(modelTransform);
                modelTransform.getSignatureTransformDataValue().add(sdv);
            }
            ref.getTransforms().add(modelTransform);
        }
        String digestMethodStr = apiReference.getDigestMethod().getAlgorithm();
        byte[] digestValueBytes = apiReference.getDigestValue();
        ref.setDigestMethod(digestMethodStr);
        ref.setDigestValue(digestValueBytes);
        return ref;
    }

    private static KeyDataValue mapX509DataType(JAXBElement apiKeyInfoContentJAXB, KeyInfo modelKeyInfo) throws RuntimeException {
        X509DataType apiKeyInfoContent = (X509DataType)apiKeyInfoContentJAXB.getValue();
        KeyDataValue modelX509KeyData = new KeyDataValue();
        modelX509KeyData.setKeyDataType(X509DataType.class.getSimpleName());
        modelX509KeyData.setKeyDataName(apiKeyInfoContentJAXB.getName().getLocalPart());
        modelX509KeyData.setKeyInfo(modelKeyInfo);
        List x509IssuerSerialOrX509SKIOrX509SubjectNameList = apiKeyInfoContent.getX509IssuerSerialOrX509SKIOrX509SubjectName();
        for (Object x509IssuerSerialOrX509SKIOrX509SubjectNameObj : x509IssuerSerialOrX509SKIOrX509SubjectNameList) {
            JAXBElement x509IssuerSerialOrX509SKIOrX509SubjectNameJAXB = (JAXBElement)x509IssuerSerialOrX509SKIOrX509SubjectNameObj;
            String tagName = x509IssuerSerialOrX509SKIOrX509SubjectNameJAXB.getName().getLocalPart();
            Object x509IssuerSerialOrX509SKIOrX509SubjectName = x509IssuerSerialOrX509SKIOrX509SubjectNameJAXB.getValue();
            KeyDataValue modelKeyInfoValue = new KeyDataValue();
            modelKeyInfoValue.setKeyDataName(tagName);
            if (x509IssuerSerialOrX509SKIOrX509SubjectName instanceof byte[]) {
                modelKeyInfoValue.setKeyDataValueBytes((byte[])x509IssuerSerialOrX509SKIOrX509SubjectName);
            } else if (x509IssuerSerialOrX509SKIOrX509SubjectName instanceof String) {
                modelKeyInfoValue.setKeyDataValueString((String)x509IssuerSerialOrX509SKIOrX509SubjectName);
            } else if (x509IssuerSerialOrX509SKIOrX509SubjectName instanceof X509IssuerSerialType) {
                modelKeyInfoValue.setKeyDataType(X509IssuerSerialType.class.getSimpleName());
                X509IssuerSerialType x509IssuerSerialType = (X509IssuerSerialType)x509IssuerSerialOrX509SKIOrX509SubjectName;
                modelKeyInfoValue.setKeyDataValueString(x509IssuerSerialType.getX509IssuerName());
                modelKeyInfoValue.setKeyDataValueBytes(x509IssuerSerialType.getX509SerialNumber().toByteArray());
            } else if (x509IssuerSerialOrX509SKIOrX509SubjectName != null) {
                throw new RuntimeException("Unrecognized Value for Element: " + tagName + ": " + x509IssuerSerialOrX509SKIOrX509SubjectName.getClass().getCanonicalName());
            }
            modelKeyInfoValue.setKeyDataValue(modelX509KeyData);
            modelX509KeyData.getKeyDataValueList().add(modelKeyInfoValue);
        }
        return modelX509KeyData;
    }

    private static KeyDataValue mapKeyName(JAXBElement apiKeyInfoContentJAXB) {
        KeyDataValue modelKeyNameKDV = new KeyDataValue();
        modelKeyNameKDV.setKeyDataType(String.class.getSimpleName());
        modelKeyNameKDV.setKeyDataName(apiKeyInfoContentJAXB.getName().getLocalPart());
        modelKeyNameKDV.setKeyDataValueString((String)apiKeyInfoContentJAXB.getValue());
        return modelKeyNameKDV;
    }

    private static KeyDataValue mapKeyValue(JAXBElement apiKeyInfoContentJAXB, List<KeyDataValue> keyInfoDataValues) {
        KeyValueType kvt = (KeyValueType)apiKeyInfoContentJAXB.getValue();
        KeyDataValue modelKeyValueKDV = new KeyDataValue();
        modelKeyValueKDV.setKeyDataType(KeyValueType.class.getSimpleName());
        modelKeyValueKDV.setKeyDataName(apiKeyInfoContentJAXB.getName().getLocalPart());
        keyInfoDataValues.add(modelKeyValueKDV);
        List kvObjList = kvt.getContent();
        for (Object kvObj : kvObjList) {
            if (!(kvObj instanceof JAXBElement)) continue;
            JAXBElement kvJAXB = (JAXBElement)kvObj;
            Object childVal = kvJAXB.getValue();
            KeyDataValue childKDV = new KeyDataValue();
            childKDV.setKeyDataValue(modelKeyValueKDV);
            childKDV.setKeyDataName(kvJAXB.getName().getLocalPart());
            childKDV.setKeyDataType(childVal.getClass().getSimpleName());
            modelKeyValueKDV.getKeyDataValueList().add(childKDV);
            if (childVal instanceof DSAKeyValueType) {
                DSAKeyValueType dsaKeyVal = (DSAKeyValueType)childVal;
                String dsaKeyValueTagName = kvJAXB.getName().getLocalPart();
                KeyDataValue dsaKeyValKDV = new KeyDataValue(null, DSAKeyValueType.class.getSimpleName(), dsaKeyValueTagName, null, null, childKDV);
                childKDV.getKeyDataValueList().add(dsaKeyValKDV);
                KeyDataValue gValKDV = new KeyDataValue(null, byte[].class.getSimpleName(), "G", dsaKeyVal.getG(), null, dsaKeyValKDV);
                dsaKeyValKDV.getKeyDataValueList().add(gValKDV);
                KeyDataValue jValKDV = new KeyDataValue(null, byte[].class.getSimpleName(), "J", dsaKeyVal.getJ(), null, dsaKeyValKDV);
                dsaKeyValKDV.getKeyDataValueList().add(jValKDV);
                KeyDataValue pValKDV = new KeyDataValue(null, byte[].class.getSimpleName(), "P", dsaKeyVal.getP(), null, dsaKeyValKDV);
                dsaKeyValKDV.getKeyDataValueList().add(pValKDV);
                KeyDataValue pGenCounterValKDV = new KeyDataValue(null, byte[].class.getSimpleName(), "PgenCounter", dsaKeyVal.getPgenCounter(), null, dsaKeyValKDV);
                dsaKeyValKDV.getKeyDataValueList().add(pGenCounterValKDV);
                KeyDataValue qValKDV = new KeyDataValue(null, byte[].class.getSimpleName(), "Q", dsaKeyVal.getQ(), null, dsaKeyValKDV);
                dsaKeyValKDV.getKeyDataValueList().add(qValKDV);
                KeyDataValue seedValKDV = new KeyDataValue(null, byte[].class.getSimpleName(), "Seed", dsaKeyVal.getSeed(), null, dsaKeyValKDV);
                dsaKeyValKDV.getKeyDataValueList().add(seedValKDV);
                KeyDataValue yValKDV = new KeyDataValue(null, byte[].class.getSimpleName(), "Y", dsaKeyVal.getY(), null, dsaKeyValKDV);
                dsaKeyValKDV.getKeyDataValueList().add(yValKDV);
                continue;
            }
            if (!(childVal instanceof RSAKeyValueType)) continue;
            RSAKeyValueType rsaKeyVal = (RSAKeyValueType)childVal;
            String rsaKeyValueTagName = kvJAXB.getName().getLocalPart();
            KeyDataValue rsaKeyValKDV = new KeyDataValue(null, RSAKeyValueType.class.getSimpleName(), rsaKeyValueTagName, null, null, childKDV);
            childKDV.getKeyDataValueList().add(rsaKeyValKDV);
            KeyDataValue exponentValKDV = new KeyDataValue(null, byte[].class.getSimpleName(), "Exponent", rsaKeyVal.getExponent(), null, rsaKeyValKDV);
            rsaKeyValKDV.getKeyDataValueList().add(exponentValKDV);
            KeyDataValue modulusValKDV = new KeyDataValue(null, byte[].class.getSimpleName(), "Modulus", rsaKeyVal.getModulus(), null, rsaKeyValKDV);
            rsaKeyValKDV.getKeyDataValueList().add(modulusValKDV);
        }
        return modelKeyValueKDV;
    }

    private static KeyDataValue mapRetrievalMethod(String apiKeyInfoContentTagName, KeyInfo modelKeyInfo, RetrievalMethodType retrievalMethodType) {
        KeyDataValue retrievalMethodTypeKDV = new KeyDataValue();
        retrievalMethodTypeKDV.setKeyDataName(apiKeyInfoContentTagName);
        retrievalMethodTypeKDV.setKeyDataType(RetrievalMethodType.class.getSimpleName());
        retrievalMethodTypeKDV.setKeyInfo(modelKeyInfo);
        KeyDataValue uriKDV = new KeyDataValue();
        uriKDV.setKeyDataName("URI");
        uriKDV.setKeyDataType(String.class.getSimpleName());
        uriKDV.setKeyDataValue(retrievalMethodTypeKDV);
        uriKDV.setKeyDataValueString(retrievalMethodType.getURI());
        retrievalMethodTypeKDV.getKeyDataValueList().add(uriKDV);
        KeyDataValue typeKDV = new KeyDataValue();
        typeKDV.setKeyDataName("Type");
        typeKDV.setKeyDataType(String.class.getSimpleName());
        typeKDV.setKeyDataValue(retrievalMethodTypeKDV);
        typeKDV.setKeyDataValueString(retrievalMethodType.getType());
        retrievalMethodTypeKDV.getKeyDataValueList().add(typeKDV);
        TransformsType transformsType = retrievalMethodType.getTransforms();
        if (transformsType != null) {
            List tTypeList = transformsType.getTransform();
            for (TransformType tType : tTypeList) {
                KeyDataValue transformKDV = new KeyDataValue();
                transformKDV.setKeyDataName("Transform");
                transformKDV.setKeyDataType(String.class.getSimpleName());
                transformKDV.setKeyDataValue(retrievalMethodTypeKDV);
                transformKDV.setKeyDataValueString(tType.getAlgorithm());
                for (Object xform : tType.getContent()) {
                    SignatureTransformDataValue stdv = MappingApiToModel.mapSignatureTransformDataValue(xform);
                    KeyDataValue transformContentKDV = new KeyDataValue();
                    transformContentKDV.setKeyDataType(stdv.getContentType());
                    transformContentKDV.setKeyDataValueBytes(stdv.getContentBytes());
                    transformContentKDV.setKeyDataValue(transformKDV);
                    transformKDV.getKeyDataValueList().add(transformContentKDV);
                }
                retrievalMethodTypeKDV.getKeyDataValueList().add(transformKDV);
            }
        }
        return retrievalMethodTypeKDV;
    }

    private static KeyDataValue mapPGPDataType(String apiKeyInfoContentTagName, KeyInfo modelKeyInfo, PGPDataType pgpDataType) {
        KeyDataValue pgpDataTypeKDV = new KeyDataValue();
        pgpDataTypeKDV.setKeyDataName(apiKeyInfoContentTagName);
        pgpDataTypeKDV.setKeyDataType(PGPDataType.class.getSimpleName());
        pgpDataTypeKDV.setKeyInfo(modelKeyInfo);
        List pgpDataValues = pgpDataType.getContent();
        for (Object pgpDataValue : pgpDataValues) {
            if (!(pgpDataValue instanceof JAXBElement)) continue;
            JAXBElement pgpDataJAXB = (JAXBElement)pgpDataValue;
            String tagName = pgpDataJAXB.getName().getLocalPart();
            KeyDataValue keyIDKDV = new KeyDataValue();
            keyIDKDV.setKeyDataName(tagName);
            keyIDKDV.setKeyDataValue(pgpDataTypeKDV);
            if (pgpDataJAXB.getValue() instanceof String) {
                keyIDKDV.setKeyDataValueString((String)pgpDataJAXB.getValue());
            } else {
                keyIDKDV.setKeyDataValueBytes((byte[])pgpDataJAXB.getValue());
            }
            pgpDataTypeKDV.getKeyDataValueList().add(keyIDKDV);
        }
        return pgpDataTypeKDV;
    }

    private static KeyDataValue mapSPKIDataType(String apiKeyInfoContentTagName, KeyInfo modelKeyInfo, SPKIDataType spkiDataType) {
        KeyDataValue spkiDataTypeKDV = new KeyDataValue();
        spkiDataTypeKDV.setKeyDataName(apiKeyInfoContentTagName);
        spkiDataTypeKDV.setKeyDataType(SPKIDataType.class.getSimpleName());
        spkiDataTypeKDV.setKeyInfo(modelKeyInfo);
        List spkiDataValues = spkiDataType.getSPKISexpAndAny();
        for (Object spkiDataValue : spkiDataValues) {
            if (spkiDataValue instanceof JAXBElement) {
                JAXBElement spkiDataJAXB = (JAXBElement)spkiDataValue;
                String tagName = spkiDataJAXB.getName().getLocalPart();
                KeyDataValue keyIDKDV = new KeyDataValue();
                keyIDKDV.setKeyDataName(tagName);
                keyIDKDV.setKeyDataValue(spkiDataTypeKDV);
                if (spkiDataJAXB.getValue() instanceof String) {
                    keyIDKDV.setKeyDataValueString((String)spkiDataJAXB.getValue());
                } else {
                    keyIDKDV.setKeyDataValueBytes((byte[])spkiDataJAXB.getValue());
                }
                spkiDataTypeKDV.getKeyDataValueList().add(keyIDKDV);
                continue;
            }
            throw new RuntimeException("Unrecognized type: " + spkiDataValue.getClass().getCanonicalName());
        }
        return spkiDataTypeKDV;
    }

    private static SignatureTransformDataValue mapSignatureTransformDataValue(Object xform) {
        SignatureTransformDataValue sdv = new SignatureTransformDataValue();
        if (xform instanceof String) {
            sdv.setContentType(String.class.getSimpleName());
            String xformStr = xform.toString();
            try {
                byte[] xformBytes = xformStr.getBytes("UTF-8");
                sdv.setContentBytes(xformBytes);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to encode string due to: " + e.getMessage(), e);
            }
        } else if (xform instanceof Element) {
            sdv.setContentType(Element.class.getCanonicalName());
            Element xformEl = (Element)xform;
            String str = MappingApiToModel.serializeTransformElement(xformEl);
            try {
                sdv.setContentBytes(str.getBytes("UTF-8"));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to encode string due to: " + e.getMessage(), e);
            }
        } else if (xform instanceof byte[]) {
            sdv.setContentType(byte[].class.getSimpleName());
            sdv.setContentBytes((byte[])xform);
        } else if (xform instanceof JAXBElement) {
            sdv.setContentType(Element.class.getCanonicalName());
            JAXBElement xformJAXB = (JAXBElement)xform;
            DOMResult domResult = new DOMResult();
            JAXB.marshal((Object)xformJAXB, (Result)domResult);
            Element xformEl = ((Document)domResult.getNode()).getDocumentElement();
            String str = MappingApiToModel.serializeTransformElement(xformEl);
            try {
                sdv.setContentBytes(str.getBytes("UTF-8"));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to encode string due to: " + e.getMessage(), e);
            }
        } else {
            throw new RuntimeException("Unrecognized type: " + xform.getClass().getCanonicalName());
        }
        return sdv;
    }

    private static String serializeTransformElement(Element xformEl) throws DOMException, LSException {
        Document document = xformEl.getOwnerDocument();
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer serializer = domImplLS.createLSSerializer();
        serializer.getDomConfig().setParameter("canonical-form", false);
        serializer.getDomConfig().setParameter("xml-declaration", false);
        String str = serializer.writeToString(xformEl);
        return str;
    }

    public static org.apache.juddi.model.ChangeRecord mapChangeRecord(ChangeRecord rec) throws UnsupportedEncodingException {
        org.apache.juddi.model.ChangeRecord r = new org.apache.juddi.model.ChangeRecord();
        r.setOriginatingUSN(rec.getChangeID().getOriginatingUSN());
        if (r.getOriginatingUSN() == null) {
            // empty if block
        }
        r.setNodeID(rec.getChangeID().getNodeID());
        if (rec.getChangeRecordNewData() != null) {
            r.setRecordType(ChangeRecord.RecordType.ChangeRecordNewData);
            r.setEntityKey(rec.getChangeRecordNewData().getOperationalInfo().getEntityKey());
            if (rec.getChangeRecordNewData().getOperationalInfo().getEntityKey() == null) {
                throw new UnsupportedEncodingException("entity key is null! make sure it's filled out before saving!");
            }
        } else if (rec.getChangeRecordAcknowledgement() != null) {
            r.setRecordType(ChangeRecord.RecordType.ChangeRecordAcknowledgement);
        } else if (rec.getChangeRecordConditionFailed() != null) {
            r.setRecordType(ChangeRecord.RecordType.ChangeRecordConditionFailed);
        } else if (rec.getChangeRecordCorrection() != null) {
            r.setRecordType(ChangeRecord.RecordType.ChangeRecordCorrection);
        } else if (rec.getChangeRecordDelete() != null) {
            r.setRecordType(ChangeRecord.RecordType.ChangeRecordDelete);
            if (rec.getChangeRecordDelete().getTModelKey() != null) {
                r.setEntityKey(rec.getChangeRecordDelete().getTModelKey());
            }
            if (rec.getChangeRecordDelete().getBindingKey() != null) {
                r.setEntityKey(rec.getChangeRecordDelete().getBindingKey());
            }
            if (rec.getChangeRecordDelete().getBusinessKey() != null) {
                r.setEntityKey(rec.getChangeRecordDelete().getBusinessKey());
            }
            if (rec.getChangeRecordDelete().getServiceKey() != null) {
                r.setEntityKey(rec.getChangeRecordDelete().getServiceKey());
            }
        } else if (rec.getChangeRecordDeleteAssertion() != null) {
            r.setRecordType(ChangeRecord.RecordType.ChangeRecordDeleteAssertion);
        } else if (rec.getChangeRecordHide() != null) {
            r.setRecordType(ChangeRecord.RecordType.ChangeRecordHide);
            r.setEntityKey(rec.getChangeRecordHide().getTModelKey());
        } else if (rec.getChangeRecordNewDataConditional() != null) {
            r.setRecordType(ChangeRecord.RecordType.ChangeRecordNewDataConditional);
        } else if (rec.getChangeRecordNull() != null) {
            r.setRecordType(ChangeRecord.RecordType.ChangeRecordNull);
        } else if (rec.getChangeRecordPublisherAssertion() != null) {
            r.setRecordType(ChangeRecord.RecordType.ChangeRecordPublisherAssertion);
        } else {
            throw new UnsupportedEncodingException("unknown type!");
        }
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)rec, (Writer)sw);
        r.setContents(sw.toString().getBytes("UTF-8"));
        return r;
    }

    public static void mapOperationalInfo(UddiEntity model, OperationalInfo operationalInfo) {
        if (operationalInfo == null || model == null) {
            return;
        }
        if (operationalInfo.getCreated() != null) {
            model.setCreated(operationalInfo.getCreated().toGregorianCalendar().getTime());
        }
        model.setAuthorizedName(operationalInfo.getAuthorizedName());
        if (operationalInfo.getModified() != null) {
            model.setModified(operationalInfo.getModified().toGregorianCalendar().getTime());
        }
        if (operationalInfo.getModifiedIncludingChildren() != null) {
            model.setModifiedIncludingChildren(operationalInfo.getModifiedIncludingChildren().toGregorianCalendar().getTime());
        }
        model.setNodeId(operationalInfo.getNodeID());
    }

    public static void mapOperationalInfoIncludingChildren(org.apache.juddi.model.BusinessEntity model, OperationalInfo operationalInfo) {
        if (operationalInfo == null || model == null) {
            return;
        }
        if (operationalInfo.getCreated() != null) {
            model.setCreated(operationalInfo.getCreated().toGregorianCalendar().getTime());
        }
        model.setAuthorizedName(operationalInfo.getAuthorizedName());
        if (operationalInfo.getModified() != null) {
            model.setModified(operationalInfo.getModified().toGregorianCalendar().getTime());
        }
        if (operationalInfo.getModifiedIncludingChildren() != null) {
            model.setModifiedIncludingChildren(operationalInfo.getModifiedIncludingChildren().toGregorianCalendar().getTime());
        }
        model.setNodeId(operationalInfo.getNodeID());
        for (int i = 0; i < model.getBusinessServices().size(); ++i) {
            MappingApiToModel.mapOperationalInfo(model.getBusinessServices().get(i), operationalInfo);
            for (int k = 0; k < model.getBusinessServices().get(i).getBindingTemplates().size(); ++k) {
                MappingApiToModel.mapOperationalInfo(model.getBusinessServices().get(i).getBindingTemplates().get(k), operationalInfo);
            }
        }
    }

    public static void mapReplicationConfiguration(ReplicationConfiguration replicationConfiguration, org.apache.juddi.model.ReplicationConfiguration model, EntityManager em) throws DispositionReportFaultMessage {
        if (replicationConfiguration == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.replication.configNull"));
        }
        model.setMaximumTimeToGetChanges(replicationConfiguration.getMaximumTimeToGetChanges());
        model.setMaximumTimeToSyncRegistry(replicationConfiguration.getMaximumTimeToSyncRegistry());
        model.setSerialNumber(null);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddkkmmZ");
        model.setTimeOfConfigurationUpdate(sdf.format(new Date()));
        if (replicationConfiguration.getRegistryContact() != null) {
            model.setContact(MappingApiToModel.mapContact(replicationConfiguration.getRegistryContact().getContact(), model));
        }
        MappingApiToModel.mapCommunicationGraph(model, replicationConfiguration.getCommunicationGraph(), em);
        model.setOperator(MappingApiToModel.mapOperators(replicationConfiguration, model));
        if (replicationConfiguration.getSignature() != null) {
            model.setSignatures(MappingApiToModel.mapApiSignaturesToModelSignatures(replicationConfiguration.getSignature()));
        }
    }

    private static Contact mapContact(org.uddi.api_v3.Contact contact, org.apache.juddi.model.ReplicationConfiguration model) throws DispositionReportFaultMessage {
        Contact cmodel = new Contact();
        cmodel.setReplicationConfigId(model);
        cmodel.setAddresses(new ArrayList<Address>());
        MappingApiToModel.mapContactAddresses(contact.getAddress(), cmodel.getAddresses(), cmodel);
        if (cmodel.getAddresses().isEmpty()) {
            cmodel.setAddresses(null);
        }
        return cmodel;
    }

    private static List<Operator> mapOperators(ReplicationConfiguration cfg, org.apache.juddi.model.ReplicationConfiguration modelparent) throws DispositionReportFaultMessage {
        if (cfg == null) {
            return null;
        }
        List api = cfg.getOperator();
        if (api == null) {
            return null;
        }
        ArrayList<Operator> model = new ArrayList<Operator>();
        for (int i = 0; i < api.size(); ++i) {
            int k;
            Operator op = new Operator();
            op.setParent(modelparent);
            op.setSoapReplicationURL(((org.uddi.repl_v3.Operator)api.get(i)).getSoapReplicationURL());
            if (!((org.uddi.repl_v3.Operator)api.get(i)).getContact().isEmpty()) {
                op.setContact(new ArrayList<Contact>());
                for (k = 0; k < ((org.uddi.repl_v3.Operator)api.get(i)).getContact().size(); ++k) {
                    op.getContact().add(MappingApiToModel.mapContact((org.uddi.api_v3.Contact)((org.uddi.repl_v3.Operator)api.get(i)).getContact().get(k), null));
                }
            }
            op.setOperatorNodeID(((org.uddi.repl_v3.Operator)api.get(i)).getOperatorNodeID());
            op.setOperatorStatus(MappingApiToModel.mapOperatorStatus(((org.uddi.repl_v3.Operator)api.get(i)).getOperatorStatus()));
            if (!((org.uddi.repl_v3.Operator)api.get(i)).getKeyInfo().isEmpty()) {
                op.setKeyInfo(new ArrayList<KeyInfo>());
                for (k = 0; k < ((org.uddi.repl_v3.Operator)api.get(i)).getKeyInfo().size(); ++k) {
                    KeyInfo modelKeyInfo = new KeyInfo();
                    modelKeyInfo.setXmlID(((KeyInfoType)((org.uddi.repl_v3.Operator)api.get(i)).getKeyInfo().get(i)).getId());
                    modelKeyInfo.setKeyDataValue(new ArrayList<KeyDataValue>());
                    if (((KeyInfoType)((org.uddi.repl_v3.Operator)api.get(i)).getKeyInfo().get(i)).getContent() != null) {
                        modelKeyInfo.setKeyDataValue(new ArrayList<KeyDataValue>());
                        for (int x = 0; x < ((KeyInfoType)((org.uddi.repl_v3.Operator)api.get(i)).getKeyInfo().get(k)).getContent().size(); ++x) {
                            MappingApiToModel.mapKeyValue((JAXBElement)((KeyInfoType)((org.uddi.repl_v3.Operator)api.get(i)).getKeyInfo().get(k)).getContent().get(x), modelKeyInfo.getKeyDataValue());
                        }
                    }
                    op.getKeyInfo().add(modelKeyInfo);
                }
            }
            model.add(op);
        }
        return model;
    }

    private static OperatorStatusType mapOperatorStatus(org.uddi.repl_v3.OperatorStatusType operatorStatus) {
        switch (operatorStatus) {
            case NEW: {
                return OperatorStatusType.NEW;
            }
            case NORMAL: {
                return OperatorStatusType.NORMAL;
            }
            case RESIGNED: {
                return OperatorStatusType.RESIGNED;
            }
        }
        return null;
    }

    private static void mapCommunicationGraph(org.apache.juddi.model.ReplicationConfiguration model, CommunicationGraph communicationGraph, EntityManager em) throws ValueNotAllowedException {
        if (model == null) {
            return;
        }
        if (communicationGraph.getControlledMessage() != null) {
            model.setControlMessage(new ArrayList<ControlMessage>());
            for (int k = 0; k < communicationGraph.getControlledMessage().size(); ++k) {
                ControlMessage BC = new ControlMessage((String)communicationGraph.getControlledMessage().get(k));
                BC.setReplicationConfiguration(model);
                model.getControlMessage().add(BC);
            }
        }
        for (int i = 0; i < communicationGraph.getNode().size(); ++i) {
            ReplicationConfigurationNode replicationConfigurationNode = new ReplicationConfigurationNode();
            replicationConfigurationNode.setNodeName((String)communicationGraph.getNode().get(i));
            replicationConfigurationNode.setParent(model);
            model.getNode().add(replicationConfigurationNode);
        }
        if (communicationGraph.getEdge() != null && !communicationGraph.getEdge().isEmpty()) {
            ArrayList<Edge> ret = new ArrayList<Edge>();
            for (int i = 0; i < communicationGraph.getEdge().size(); ++i) {
                Edge e = new Edge();
                e.setReplicationConfiguration(model);
                e.setMessageReceiver(((CommunicationGraph.Edge)communicationGraph.getEdge().get(i)).getMessageReceiver());
                e.setMessageSender(((CommunicationGraph.Edge)communicationGraph.getEdge().get(i)).getMessageSender());
                if (((CommunicationGraph.Edge)communicationGraph.getEdge().get(i)).getMessage() != null) {
                    e.setMessage(new ArrayList<ControlMessage>());
                    for (int k = 0; k < ((CommunicationGraph.Edge)communicationGraph.getEdge().get(i)).getMessage().size(); ++k) {
                        ControlMessage controlMessage = new ControlMessage((String)((CommunicationGraph.Edge)communicationGraph.getEdge().get(i)).getMessage().get(k));
                        controlMessage.setReplicationConfiguration(model);
                        controlMessage.setParentEdge(e);
                        e.getMessages().add(controlMessage);
                    }
                }
                if (((CommunicationGraph.Edge)communicationGraph.getEdge().get(i)).getMessageReceiverAlternate() != null) {
                    ArrayList<EdgeReceiverAlternate> eras = new ArrayList<EdgeReceiverAlternate>();
                    for (String s : ((CommunicationGraph.Edge)communicationGraph.getEdge().get(i)).getMessageReceiverAlternate()) {
                        EdgeReceiverAlternate x = new EdgeReceiverAlternate();
                        x.setParent(e);
                        x.setReceiverAlternate(s);
                        eras.add(x);
                    }
                    e.setMessageReceiverAlternate(eras);
                }
                ret.add(e);
            }
            model.setEdge(ret);
        }
    }

    public static void mapOperationalInfoIncludingChildren(BusinessService model, OperationalInfo operationalInfo) {
        if (operationalInfo == null || model == null) {
            return;
        }
        if (operationalInfo.getCreated() != null) {
            model.setCreated(operationalInfo.getCreated().toGregorianCalendar().getTime());
        }
        model.setAuthorizedName(operationalInfo.getAuthorizedName());
        if (operationalInfo.getModified() != null) {
            model.setModified(operationalInfo.getModified().toGregorianCalendar().getTime());
        }
        if (operationalInfo.getModifiedIncludingChildren() != null) {
            model.setModifiedIncludingChildren(operationalInfo.getModifiedIncludingChildren().toGregorianCalendar().getTime());
        }
        model.setNodeId(operationalInfo.getNodeID());
        for (int k = 0; k < model.getBindingTemplates().size(); ++k) {
            MappingApiToModel.mapOperationalInfo(model.getBindingTemplates().get(k), operationalInfo);
        }
    }
}

