/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.mapping;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.jaxb.JAXBMarshaller;
import org.apache.juddi.model.Address;
import org.apache.juddi.model.BindingDescr;
import org.apache.juddi.model.BusinessDescr;
import org.apache.juddi.model.BusinessIdentifier;
import org.apache.juddi.model.BusinessName;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.CanonicalizationMethod;
import org.apache.juddi.model.CategoryBag;
import org.apache.juddi.model.Clerk;
import org.apache.juddi.model.ClientSubscriptionInfo;
import org.apache.juddi.model.Contact;
import org.apache.juddi.model.ContactDescr;
import org.apache.juddi.model.ControlMessage;
import org.apache.juddi.model.DiscoveryUrl;
import org.apache.juddi.model.Edge;
import org.apache.juddi.model.EdgeReceiverAlternate;
import org.apache.juddi.model.Email;
import org.apache.juddi.model.InstanceDetailsDescr;
import org.apache.juddi.model.KeyDataValue;
import org.apache.juddi.model.KeyInfo;
import org.apache.juddi.model.Node;
import org.apache.juddi.model.Operator;
import org.apache.juddi.model.OverviewDoc;
import org.apache.juddi.model.OverviewDocDescr;
import org.apache.juddi.model.PersonName;
import org.apache.juddi.model.Phone;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.Reference;
import org.apache.juddi.model.ReplicationConfigurationNode;
import org.apache.juddi.model.ServiceDescr;
import org.apache.juddi.model.ServiceName;
import org.apache.juddi.model.ServiceProjection;
import org.apache.juddi.model.Signature;
import org.apache.juddi.model.SignatureTransform;
import org.apache.juddi.model.SignatureTransformDataValue;
import org.apache.juddi.model.SignatureValue;
import org.apache.juddi.model.SignedInfo;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.TmodelDescr;
import org.apache.juddi.model.TmodelIdentifier;
import org.apache.juddi.model.TmodelInstanceInfo;
import org.apache.juddi.model.TmodelInstanceInfoDescr;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.subscription.TypeConvertor;
import org.apache.juddi.v3.client.cryptor.XmlUtils;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.AddressLine;
import org.uddi.api_v3.AssertionStatusItem;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.CompletionStatus;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.Direction;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.HostingRedirector;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.KeysOwned;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OperationalInfo;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.RelatedBusinessInfo;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.SharedRelationships;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.repl_v3.ChangeRecord;
import org.uddi.repl_v3.ChangeRecordIDType;
import org.uddi.repl_v3.CommunicationGraph;
import org.uddi.repl_v3.OperatorStatusType;
import org.uddi.repl_v3.ReplicationConfiguration;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionFilter;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.w3._2000._09.xmldsig_.CanonicalizationMethodType;
import org.w3._2000._09.xmldsig_.DSAKeyValueType;
import org.w3._2000._09.xmldsig_.DigestMethodType;
import org.w3._2000._09.xmldsig_.KeyInfoType;
import org.w3._2000._09.xmldsig_.KeyValueType;
import org.w3._2000._09.xmldsig_.PGPDataType;
import org.w3._2000._09.xmldsig_.RSAKeyValueType;
import org.w3._2000._09.xmldsig_.ReferenceType;
import org.w3._2000._09.xmldsig_.RetrievalMethodType;
import org.w3._2000._09.xmldsig_.SPKIDataType;
import org.w3._2000._09.xmldsig_.SignatureMethodType;
import org.w3._2000._09.xmldsig_.SignatureType;
import org.w3._2000._09.xmldsig_.SignatureValueType;
import org.w3._2000._09.xmldsig_.SignedInfoType;
import org.w3._2000._09.xmldsig_.TransformType;
import org.w3._2000._09.xmldsig_.TransformsType;
import org.w3._2000._09.xmldsig_.X509DataType;
import org.w3._2000._09.xmldsig_.X509IssuerSerialType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MappingModelToApi {
    private static Log logger = LogFactory.getLog(MappingModelToApi.class);

    public static void mapPublisher(Publisher modelPublisher, org.apache.juddi.api_v3.Publisher apiPublisher) throws DispositionReportFaultMessage {
        apiPublisher.setAuthorizedName(modelPublisher.getAuthorizedName());
        apiPublisher.setPublisherName(modelPublisher.getPublisherName());
        apiPublisher.setEmailAddress(modelPublisher.getEmailAddress());
        apiPublisher.setIsAdmin(modelPublisher.getIsAdmin());
        apiPublisher.setIsEnabled(modelPublisher.getIsEnabled());
        apiPublisher.setMaxBindingsPerService(modelPublisher.getMaxBindingsPerService());
        apiPublisher.setMaxBusinesses(modelPublisher.getMaxBusinesses());
        apiPublisher.setMaxServicePerBusiness(modelPublisher.getMaxServicesPerBusiness());
        apiPublisher.setMaxTModels(modelPublisher.getMaxTmodels());
        MappingModelToApi.mapSignature(modelPublisher.getSignatures(), apiPublisher.getSignature());
    }

    public static void mapBusinessEntity(org.apache.juddi.model.BusinessEntity modelBusinessEntity, BusinessEntity apiBusinessEntity) throws DispositionReportFaultMessage {
        apiBusinessEntity.setBusinessKey(modelBusinessEntity.getEntityKey());
        MappingModelToApi.mapBusinessNames(modelBusinessEntity.getBusinessNames(), apiBusinessEntity.getName());
        MappingModelToApi.mapBusinessDescriptions(modelBusinessEntity.getBusinessDescrs(), apiBusinessEntity.getDescription());
        MappingModelToApi.mapDiscoveryUrls(modelBusinessEntity.getDiscoveryUrls(), apiBusinessEntity.getDiscoveryURLs(), apiBusinessEntity);
        MappingModelToApi.mapContacts(modelBusinessEntity.getContacts(), apiBusinessEntity.getContacts(), apiBusinessEntity);
        MappingModelToApi.mapBusinessIdentifiers(modelBusinessEntity.getBusinessIdentifiers(), apiBusinessEntity.getIdentifierBag(), apiBusinessEntity);
        apiBusinessEntity.setCategoryBag(MappingModelToApi.mapCategoryBag(modelBusinessEntity.getCategoryBag(), apiBusinessEntity.getCategoryBag()));
        MappingModelToApi.mapBusinessServices(modelBusinessEntity.getBusinessServices(), modelBusinessEntity.getServiceProjections(), apiBusinessEntity.getBusinessServices(), apiBusinessEntity);
        MappingModelToApi.mapSignature(modelBusinessEntity.getSignatures(), apiBusinessEntity.getSignature());
    }

    public static void mapSignature(List<Signature> signatureList, List<SignatureType> apiSignatureList) throws DispositionReportFaultMessage {
        apiSignatureList.clear();
        for (Signature modelSig : signatureList) {
            SignatureType apiSignature = new SignatureType();
            apiSignature.setId(modelSig.getXmlID());
            SignedInfo modelSignedInfo = modelSig.getSignedInfo();
            SignedInfoType apiSignedInfoType = new SignedInfoType();
            apiSignature.setSignedInfo(apiSignedInfoType);
            CanonicalizationMethod modelCanonMethod = modelSignedInfo.getCanonicalizationMethod();
            CanonicalizationMethodType apiCanonMethod = new CanonicalizationMethodType();
            apiCanonMethod.setAlgorithm(modelCanonMethod.getAlgorithm());
            apiSignedInfoType.setCanonicalizationMethod(apiCanonMethod);
            String sigAlg = modelSignedInfo.getSignatureMethod().getAlgorithm();
            SignatureMethodType apiSigMethod = new SignatureMethodType();
            apiSigMethod.setAlgorithm(sigAlg);
            apiSignedInfoType.setSignatureMethod(apiSigMethod);
            List<Reference> modelReferenceList = modelSignedInfo.getReference();
            List apiReferenceList = apiSignedInfoType.getReference();
            for (Reference modelRef : modelReferenceList) {
                ReferenceType apiRef = new ReferenceType();
                String refUri = modelRef.getUri();
                if (refUri == null) {
                    refUri = "";
                }
                apiRef.setURI(refUri);
                List<SignatureTransform> modelSigTransformList = modelRef.getTransforms();
                TransformsType apiTransformsType = apiRef.getTransforms();
                if (apiTransformsType == null) {
                    apiTransformsType = new TransformsType();
                    apiRef.setTransforms(apiTransformsType);
                }
                List apiTransformList = apiTransformsType.getTransform();
                for (SignatureTransform modelSigTransform : modelSigTransformList) {
                    String modelTransformAlgStr = modelSigTransform.getTransform();
                    TransformType apiTransform = new TransformType();
                    apiTransform.setAlgorithm(modelTransformAlgStr);
                    List<SignatureTransformDataValue> sigTransformSDVList = modelSigTransform.getSignatureTransformDataValue();
                    for (SignatureTransformDataValue sigTransformSDV : sigTransformSDVList) {
                        String type = sigTransformSDV.getContentType();
                        byte[] xformBytes = sigTransformSDV.getContentBytes();
                        Object transformObject = MappingModelToApi.convertDataToTransformContent(type, xformBytes);
                        apiTransform.getContent().add(transformObject);
                    }
                    apiTransformList.add(apiTransform);
                }
                String digestMethodStr = modelRef.getDigestMethod();
                byte[] digestValBytes = modelRef.getDigestValue();
                DigestMethodType apiDigestMethod = new DigestMethodType();
                apiDigestMethod.setAlgorithm(digestMethodStr);
                apiRef.setDigestMethod(apiDigestMethod);
                apiRef.setDigestValue(digestValBytes);
                apiReferenceList.add(apiRef);
            }
            SignatureValueType apiSignatureValue = new SignatureValueType();
            SignatureValue modelSigValue = modelSig.getSignatureValue();
            apiSignatureValue.setId(modelSigValue.getXmlID());
            apiSignatureValue.setValue(modelSigValue.getValue());
            apiSignature.setSignatureValue(apiSignatureValue);
            KeyInfoType apiKeyInfo = new KeyInfoType();
            KeyInfo modelKeyInfo = modelSig.getKeyInfo();
            apiKeyInfo.setId(modelKeyInfo.getXmlID());
            List<KeyDataValue> modelKeyDataValueList = modelKeyInfo.getKeyDataValue();
            List apiX509KeyInfoList = apiKeyInfo.getContent();
            MappingModelToApi.mapModelKeyDataValue(modelKeyDataValueList, apiX509KeyInfoList);
            apiSignature.setKeyInfo(apiKeyInfo);
            apiSignatureList.add(apiSignature);
        }
    }

    private static void mapModelKeyDataValue(List<KeyDataValue> modelKeyDataValueList, List<Object> parentKeyDataList) {
        for (KeyDataValue modelKeyDataValue : modelKeyDataValueList) {
            Object contents;
            String tagName = modelKeyDataValue.getKeyDataName();
            String dataType = modelKeyDataValue.getKeyDataType();
            byte[] contentBytes = modelKeyDataValue.getKeyDataValueBytes();
            String contentStr = modelKeyDataValue.getKeyDataValueString();
            Object object = contents = contentBytes != null ? contentBytes : (Object)contentStr;
            if (contents == null) {
                JAXBElement jaxb;
                Object dataJAXB;
                ArrayList<Object> childKeyDataList = new ArrayList<Object>();
                if (dataType.equals(X509DataType.class.getSimpleName())) {
                    X509DataType x509DataType = new X509DataType();
                    MappingModelToApi.mapModelKeyDataValue(modelKeyDataValue.getKeyDataValueList(), childKeyDataList);
                    x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName().addAll(childKeyDataList);
                    dataJAXB = new JAXBElement(new QName("http://www.w3.org/2000/09/xmldsig#", tagName), X509DataType.class, (Object)x509DataType);
                    parentKeyDataList.add(dataJAXB);
                    continue;
                }
                if (dataType.equals(RetrievalMethodType.class.getSimpleName())) {
                    RetrievalMethodType retrievalMethodType = new RetrievalMethodType();
                    TransformsType transformsType = new TransformsType();
                    for (KeyDataValue retrievalMethodKDV : modelKeyDataValue.getKeyDataValueList()) {
                        if (retrievalMethodKDV.getKeyDataName().equals("Transform")) {
                            TransformType tType = new TransformType();
                            tType.setAlgorithm(retrievalMethodKDV.getKeyDataValueString());
                            for (KeyDataValue transformContentKDV : retrievalMethodKDV.getKeyDataValueList()) {
                                String type = transformContentKDV.getKeyDataType();
                                byte[] xformBytes = transformContentKDV.getKeyDataValueBytes();
                                Object transformObject = MappingModelToApi.convertDataToTransformContent(type, xformBytes);
                                tType.getContent().add(transformObject);
                            }
                            transformsType.getTransform().add(tType);
                            continue;
                        }
                        if (retrievalMethodKDV.getKeyDataName().equals("Type")) {
                            retrievalMethodType.setType(retrievalMethodKDV.getKeyDataValueString());
                            continue;
                        }
                        if (retrievalMethodKDV.getKeyDataName().equals("URI")) {
                            retrievalMethodType.setURI(retrievalMethodKDV.getKeyDataValueString());
                            continue;
                        }
                        throw new RuntimeException("Unrecognized key data type: " + retrievalMethodKDV.getKeyDataType());
                    }
                    if (transformsType.getTransform() != null && !transformsType.getTransform().isEmpty()) {
                        retrievalMethodType.setTransforms(transformsType);
                    }
                    JAXBElement dataJAXB2 = new JAXBElement(new QName("http://www.w3.org/2000/09/xmldsig#", tagName), RetrievalMethodType.class, (Object)retrievalMethodType);
                    parentKeyDataList.add(dataJAXB2);
                    continue;
                }
                if (dataType.equals(PGPDataType.class.getSimpleName())) {
                    PGPDataType pgpDataType = new PGPDataType();
                    for (KeyDataValue pgpDataKDV : modelKeyDataValue.getKeyDataValueList()) {
                        String pgpDataTagName = pgpDataKDV.getKeyDataName();
                        Object pgpDataContents = pgpDataKDV.getKeyDataValueBytes() != null ? pgpDataKDV.getKeyDataValueBytes() : (Object)pgpDataKDV.getKeyDataValueString();
                        Class<?> pgpDataClazz = pgpDataContents.getClass();
                        jaxb = new JAXBElement(new QName("http://www.w3.org/2000/09/xmldsig#", pgpDataTagName), pgpDataClazz, pgpDataContents);
                        pgpDataType.getContent().add(jaxb);
                    }
                    dataJAXB = new JAXBElement(new QName("http://www.w3.org/2000/09/xmldsig#", tagName), PGPDataType.class, (Object)pgpDataType);
                    parentKeyDataList.add(dataJAXB);
                    continue;
                }
                if (dataType.equals(SPKIDataType.class.getSimpleName())) {
                    SPKIDataType spkiDataType = new SPKIDataType();
                    for (KeyDataValue spkiDataKDV : modelKeyDataValue.getKeyDataValueList()) {
                        String spkiDataTagName = spkiDataKDV.getKeyDataName();
                        Object spkiDataContents = spkiDataKDV.getKeyDataValueBytes() != null ? spkiDataKDV.getKeyDataValueBytes() : (Object)spkiDataKDV.getKeyDataValueString();
                        Class<?> spkiDataClazz = spkiDataContents.getClass();
                        jaxb = new JAXBElement(new QName("http://www.w3.org/2000/09/xmldsig#", spkiDataTagName), spkiDataClazz, spkiDataContents);
                        spkiDataType.getSPKISexpAndAny().add(jaxb);
                    }
                    dataJAXB = new JAXBElement(new QName("http://www.w3.org/2000/09/xmldsig#", tagName), SPKIDataType.class, (Object)spkiDataType);
                    parentKeyDataList.add(dataJAXB);
                    continue;
                }
                if (dataType.equals(KeyValueType.class.getSimpleName())) {
                    KeyValueType keyValueType = new KeyValueType();
                    for (KeyDataValue keyValueDataKDV : modelKeyDataValue.getKeyDataValueList()) {
                        for (KeyDataValue keyValueDataChildKDV : keyValueDataKDV.getKeyDataValueList()) {
                            JAXBElement jaxb2;
                            String keyDataDataType = keyValueDataChildKDV.getKeyDataType();
                            if (keyDataDataType.equals("DSAKeyValueType")) {
                                DSAKeyValueType dsaKeyValueType = new DSAKeyValueType();
                                for (KeyDataValue dsaKDV : keyValueDataChildKDV.getKeyDataValueList()) {
                                    if ("G".equals(dsaKDV.getKeyDataName())) {
                                        dsaKeyValueType.setG(dsaKDV.getKeyDataValueBytes());
                                        continue;
                                    }
                                    if ("P".equals(dsaKDV.getKeyDataName())) {
                                        dsaKeyValueType.setP(dsaKDV.getKeyDataValueBytes());
                                        continue;
                                    }
                                    if ("Q".equals(dsaKDV.getKeyDataName())) {
                                        dsaKeyValueType.setQ(dsaKDV.getKeyDataValueBytes());
                                        continue;
                                    }
                                    if ("Y".equals(dsaKDV.getKeyDataName())) {
                                        dsaKeyValueType.setY(dsaKDV.getKeyDataValueBytes());
                                        continue;
                                    }
                                    if ("J".equals(dsaKDV.getKeyDataName())) {
                                        dsaKeyValueType.setJ(dsaKDV.getKeyDataValueBytes());
                                        continue;
                                    }
                                    if ("Seed".equals(dsaKDV.getKeyDataName())) {
                                        dsaKeyValueType.setSeed(dsaKDV.getKeyDataValueBytes());
                                        continue;
                                    }
                                    if ("PgenCounter".equals(dsaKDV.getKeyDataName())) {
                                        dsaKeyValueType.setPgenCounter(dsaKDV.getKeyDataValueBytes());
                                        continue;
                                    }
                                    throw new RuntimeException("Unrecognized dsa type: " + dsaKDV.getKeyDataName());
                                }
                                jaxb2 = new JAXBElement(new QName("http://www.w3.org/2000/09/xmldsig#", keyValueDataChildKDV.getKeyDataName()), DSAKeyValueType.class, (Object)dsaKeyValueType);
                                keyValueType.getContent().add(jaxb2);
                                continue;
                            }
                            if (keyDataDataType.equals("RSAKeyValueType")) {
                                RSAKeyValueType rsaKeyValueType = new RSAKeyValueType();
                                for (KeyDataValue rsaKDV : keyValueDataChildKDV.getKeyDataValueList()) {
                                    if ("Exponent".equals(rsaKDV.getKeyDataName())) {
                                        rsaKeyValueType.setExponent(rsaKDV.getKeyDataValueBytes());
                                        continue;
                                    }
                                    if ("Modulus".equals(rsaKDV.getKeyDataName())) {
                                        rsaKeyValueType.setModulus(rsaKDV.getKeyDataValueBytes());
                                        continue;
                                    }
                                    throw new RuntimeException("Unrecognized dsa type: " + rsaKDV.getKeyDataName());
                                }
                                jaxb2 = new JAXBElement(new QName("http://www.w3.org/2000/09/xmldsig#", keyValueDataChildKDV.getKeyDataName()), RSAKeyValueType.class, (Object)rsaKeyValueType);
                                keyValueType.getContent().add(jaxb2);
                                continue;
                            }
                            throw new RuntimeException("Unrecognized element: " + keyDataDataType);
                        }
                    }
                    dataJAXB = new JAXBElement(new QName("http://www.w3.org/2000/09/xmldsig#", tagName), KeyValueType.class, (Object)keyValueType);
                    parentKeyDataList.add(dataJAXB);
                    continue;
                }
                throw new RuntimeException("Unrecognized type: " + dataType);
            }
            if (dataType != null && dataType.equals(X509IssuerSerialType.class.getSimpleName())) {
                X509IssuerSerialType x509IssuerSerialType = new X509IssuerSerialType();
                x509IssuerSerialType.setX509IssuerName(contentStr);
                x509IssuerSerialType.setX509SerialNumber(new BigInteger(contentBytes));
                JAXBElement dataJAXB = new JAXBElement(new QName("http://www.w3.org/2000/09/xmldsig#", tagName), X509IssuerSerialType.class, (Object)x509IssuerSerialType);
                parentKeyDataList.add(dataJAXB);
                continue;
            }
            JAXBElement dataJAXB = new JAXBElement(new QName("http://www.w3.org/2000/09/xmldsig#", tagName), contents.getClass(), contents);
            parentKeyDataList.add(dataJAXB);
        }
    }

    public static void mapBusinessNames(List<BusinessName> modelNameList, List<Name> apiNameList) throws DispositionReportFaultMessage {
        apiNameList.clear();
        for (BusinessName modelName : modelNameList) {
            Name apiName = new Name();
            apiName.setLang(modelName.getLangCode());
            apiName.setValue(modelName.getName());
            apiNameList.add(apiName);
        }
    }

    public static void mapBusinessDescriptions(List<BusinessDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (BusinessDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static void mapDiscoveryUrls(List<DiscoveryUrl> modelDiscUrlList, DiscoveryURLs apiDiscUrls, BusinessEntity apiBusinessEntity) throws DispositionReportFaultMessage {
        if (modelDiscUrlList == null || modelDiscUrlList.size() == 0) {
            return;
        }
        if (apiDiscUrls == null) {
            apiDiscUrls = new DiscoveryURLs();
        }
        List apiDiscUrlList = apiDiscUrls.getDiscoveryURL();
        apiDiscUrlList.clear();
        for (DiscoveryUrl modelDiscUrl : modelDiscUrlList) {
            DiscoveryURL apiDiscUrl = new DiscoveryURL();
            apiDiscUrl.setUseType(modelDiscUrl.getUseType());
            String discoveryURL = modelDiscUrl.getUrl();
            try {
                String baseUrl = AppConfig.getConfiguration().getString("juddi.server.baseurl");
                if (baseUrl == null) {
                    logger.warn((Object)"Token 'juddi.server.baseurl' not found in the juddiv3.xml, defaulting to 'http://localhost:8080/juddiv3'");
                    baseUrl = "http://localhost:8080/juddiv3";
                }
                discoveryURL = discoveryURL.replaceAll("\\$\\{juddi.server.baseurl\\}", baseUrl);
                baseUrl = AppConfig.getConfiguration().getString("juddi.server.baseurlsecure");
                if (baseUrl == null) {
                    logger.warn((Object)"Token 'juddi.server.baseurlsecure' not found in the juddiv3.xml, defaulting to 'juddi.server.baseurlsecure'");
                    baseUrl = "https://localhost:8443/juddiv3";
                }
                discoveryURL = discoveryURL.replaceAll("\\$\\{juddi.server.baseurlsecure\\}", baseUrl);
            }
            catch (ConfigurationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            apiDiscUrl.setValue(discoveryURL);
            apiDiscUrlList.add(apiDiscUrl);
        }
        apiBusinessEntity.setDiscoveryURLs(apiDiscUrls);
    }

    public static void mapContact(Contact modelContact, org.uddi.api_v3.Contact apiContact) throws DispositionReportFaultMessage {
        if (apiContact == null) {
            apiContact = new org.uddi.api_v3.Contact();
        }
        apiContact.setUseType(modelContact.getUseType());
        MappingModelToApi.mapPersonNames(modelContact.getPersonNames(), apiContact.getPersonName());
        MappingModelToApi.mapContactDescriptions(modelContact.getContactDescrs(), apiContact.getDescription());
        MappingModelToApi.mapContactEmails(modelContact.getEmails(), apiContact.getEmail());
        MappingModelToApi.mapContactPhones(modelContact.getPhones(), apiContact.getPhone());
        MappingModelToApi.mapContactAddresses(modelContact.getAddresses(), apiContact.getAddress());
    }

    public static void mapContacts(List<Contact> modelContactList, Contacts apiContacts, BusinessEntity apiBusinessEntity) throws DispositionReportFaultMessage {
        if (modelContactList == null || modelContactList.size() == 0) {
            return;
        }
        if (apiContacts == null) {
            apiContacts = new Contacts();
        }
        List apiContactList = apiContacts.getContact();
        apiContactList.clear();
        for (Contact modelContact : modelContactList) {
            org.uddi.api_v3.Contact apiContact = new org.uddi.api_v3.Contact();
            MappingModelToApi.mapContact(modelContact, apiContact);
            apiContactList.add(apiContact);
        }
        apiBusinessEntity.setContacts(apiContacts);
    }

    public static void mapContactDescriptions(List<ContactDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (ContactDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static void mapPersonNames(List<PersonName> modelPersonNameList, List<org.uddi.api_v3.PersonName> apiPersonNameList) throws DispositionReportFaultMessage {
        apiPersonNameList.clear();
        for (PersonName personName : modelPersonNameList) {
            org.uddi.api_v3.PersonName apiPersonName = new org.uddi.api_v3.PersonName();
            apiPersonName.setLang(personName.getLangCode());
            apiPersonName.setValue(personName.getName());
            apiPersonNameList.add(apiPersonName);
        }
    }

    public static void mapContactEmails(List<Email> modelEmailList, List<org.uddi.api_v3.Email> apiEmailList) throws DispositionReportFaultMessage {
        apiEmailList.clear();
        for (Email modelEmail : modelEmailList) {
            org.uddi.api_v3.Email apiEmail = new org.uddi.api_v3.Email();
            apiEmail.setUseType(modelEmail.getUseType());
            apiEmail.setValue(modelEmail.getEmailAddress());
            apiEmailList.add(apiEmail);
        }
    }

    public static void mapContactPhones(List<Phone> modelPhoneList, List<org.uddi.api_v3.Phone> apiPhoneList) throws DispositionReportFaultMessage {
        apiPhoneList.clear();
        for (Phone modelPhone : modelPhoneList) {
            org.uddi.api_v3.Phone apiPhone = new org.uddi.api_v3.Phone();
            apiPhone.setUseType(modelPhone.getUseType());
            apiPhone.setValue(modelPhone.getPhoneNumber());
            apiPhoneList.add(apiPhone);
        }
    }

    public static void mapContactAddresses(List<Address> modelAddressList, List<org.uddi.api_v3.Address> apiAddressList) throws DispositionReportFaultMessage {
        apiAddressList.clear();
        for (Address modelAddress : modelAddressList) {
            org.uddi.api_v3.Address apiAddress = new org.uddi.api_v3.Address();
            apiAddress.setUseType(modelAddress.getUseType());
            apiAddress.setLang("");
            apiAddress.setSortCode(modelAddress.getSortCode());
            apiAddress.setTModelKey(modelAddress.getTmodelKey());
            MappingModelToApi.mapAddressLines(modelAddress.getAddressLines(), apiAddress.getAddressLine());
            apiAddressList.add(apiAddress);
        }
    }

    public static void mapAddressLines(List<org.apache.juddi.model.AddressLine> modelAddressLineList, List<AddressLine> apiAddressLineList) throws DispositionReportFaultMessage {
        apiAddressLineList.clear();
        for (org.apache.juddi.model.AddressLine modelAddressLine : modelAddressLineList) {
            AddressLine apiAddressLine = new AddressLine();
            apiAddressLine.setKeyName(modelAddressLine.getKeyName());
            apiAddressLine.setKeyValue(modelAddressLine.getKeyValue());
            apiAddressLine.setValue(modelAddressLine.getLine());
            apiAddressLineList.add(apiAddressLine);
        }
    }

    public static void mapBusinessIdentifiers(List<BusinessIdentifier> modelIdentifierList, IdentifierBag apiIdentifierBag, BusinessEntity apiBusinessEntity) throws DispositionReportFaultMessage {
        if (modelIdentifierList == null || modelIdentifierList.size() == 0) {
            return;
        }
        if (apiIdentifierBag == null) {
            apiIdentifierBag = new IdentifierBag();
        }
        List apiKeyedRefList = apiIdentifierBag.getKeyedReference();
        apiKeyedRefList.clear();
        for (BusinessIdentifier modelIdentifier : modelIdentifierList) {
            KeyedReference apiKeyedRef = new KeyedReference();
            apiKeyedRef.setTModelKey(modelIdentifier.getTmodelKeyRef());
            apiKeyedRef.setKeyName(modelIdentifier.getKeyName());
            apiKeyedRef.setKeyValue(modelIdentifier.getKeyValue());
            apiKeyedRefList.add(apiKeyedRef);
        }
        apiBusinessEntity.setIdentifierBag(apiIdentifierBag);
    }

    public static void mapBusinessServices(List<BusinessService> modelBusinessServiceList, List<ServiceProjection> modelServiceProjectionList, BusinessServices apiBusinessServices, BusinessEntity apiBusinessEntity) throws DispositionReportFaultMessage {
        org.uddi.api_v3.BusinessService apiBusinessService;
        if (apiBusinessServices == null) {
            apiBusinessServices = new BusinessServices();
        }
        List apiBusinessServiceList = apiBusinessServices.getBusinessService();
        apiBusinessServiceList.clear();
        if (modelBusinessServiceList != null && modelBusinessServiceList.size() > 0) {
            for (BusinessService modelBusinessService : modelBusinessServiceList) {
                apiBusinessService = new org.uddi.api_v3.BusinessService();
                MappingModelToApi.mapBusinessService(modelBusinessService, apiBusinessService);
                apiBusinessServiceList.add(apiBusinessService);
            }
        }
        if (modelServiceProjectionList != null && modelServiceProjectionList.size() > 0) {
            for (ServiceProjection modelServiceProjection : modelServiceProjectionList) {
                apiBusinessService = new org.uddi.api_v3.BusinessService();
                MappingModelToApi.mapBusinessService(modelServiceProjection.getBusinessService(), apiBusinessService);
                apiBusinessServiceList.add(apiBusinessService);
            }
        }
        if (apiBusinessServiceList.size() > 0) {
            apiBusinessEntity.setBusinessServices(apiBusinessServices);
        }
    }

    public static void mapBusinessService(BusinessService modelBusinessService, org.uddi.api_v3.BusinessService apiBusinessService) throws DispositionReportFaultMessage {
        apiBusinessService.setBusinessKey(modelBusinessService.getBusinessEntity().getEntityKey());
        apiBusinessService.setServiceKey(modelBusinessService.getEntityKey());
        MappingModelToApi.mapServiceNames(modelBusinessService.getServiceNames(), apiBusinessService.getName());
        MappingModelToApi.mapServiceDescriptions(modelBusinessService.getServiceDescrs(), apiBusinessService.getDescription());
        MappingModelToApi.mapBindingTemplates(modelBusinessService.getBindingTemplates(), apiBusinessService.getBindingTemplates(), apiBusinessService);
        apiBusinessService.setCategoryBag(MappingModelToApi.mapCategoryBag(modelBusinessService.getCategoryBag(), apiBusinessService.getCategoryBag()));
        MappingModelToApi.mapSignature(modelBusinessService.getSignatures(), apiBusinessService.getSignature());
    }

    public static void mapServiceNames(List<ServiceName> modelNameList, List<Name> apiNameList) throws DispositionReportFaultMessage {
        apiNameList.clear();
        for (ServiceName modelName : modelNameList) {
            Name apiName = new Name();
            apiName.setLang(modelName.getLangCode());
            apiName.setValue(modelName.getName());
            apiNameList.add(apiName);
        }
    }

    public static void mapServiceDescriptions(List<ServiceDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (ServiceDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static void mapBindingTemplates(List<org.apache.juddi.model.BindingTemplate> modelBindingTemplateList, BindingTemplates apiBindingTemplates, org.uddi.api_v3.BusinessService apiBusinessService) throws DispositionReportFaultMessage {
        if (modelBindingTemplateList == null || modelBindingTemplateList.size() == 0) {
            return;
        }
        if (apiBindingTemplates == null) {
            apiBindingTemplates = new BindingTemplates();
        }
        List apiBindingTemplateList = apiBindingTemplates.getBindingTemplate();
        apiBindingTemplateList.clear();
        for (org.apache.juddi.model.BindingTemplate modelBindingTemplate : modelBindingTemplateList) {
            BindingTemplate apiBindingTemplate = new BindingTemplate();
            MappingModelToApi.mapBindingTemplate(modelBindingTemplate, apiBindingTemplate);
            apiBindingTemplateList.add(apiBindingTemplate);
        }
        apiBusinessService.setBindingTemplates(apiBindingTemplates);
    }

    public static void mapBindingTemplate(org.apache.juddi.model.BindingTemplate modelBindingTemplate, BindingTemplate apiBindingTemplate) throws DispositionReportFaultMessage {
        apiBindingTemplate.setServiceKey(modelBindingTemplate.getBusinessService().getEntityKey());
        apiBindingTemplate.setBindingKey(modelBindingTemplate.getEntityKey());
        AccessPoint apiAccessPoint = new AccessPoint();
        apiAccessPoint.setUseType(modelBindingTemplate.getAccessPointType());
        String accessPointValue = modelBindingTemplate.getAccessPointUrl();
        if (accessPointValue != null) {
            try {
                String baseUrl = AppConfig.getConfiguration().getString("juddi.server.baseurl");
                if (baseUrl == null) {
                    logger.warn((Object)"Token 'juddi.server.baseurl' not found in the juddiv3.xml, defaulting to 'http://localhost:8080/juddiv3'");
                    baseUrl = "http://localhost:8080/juddiv3";
                }
                accessPointValue = accessPointValue.replaceAll("\\$\\{juddi.server.baseurl\\}", baseUrl);
                baseUrl = AppConfig.getConfiguration().getString("juddi.server.baseurlsecure");
                if (baseUrl == null) {
                    logger.warn((Object)"Token 'juddi.server.baseurlsecure' not found in the juddiv3.xml, defaulting to 'juddi.server.baseurlsecure'");
                    baseUrl = "https://localhost:8443/juddiv3";
                }
                accessPointValue = accessPointValue.replaceAll("\\$\\{juddi.server.baseurlsecure\\}", baseUrl);
            }
            catch (ConfigurationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        apiAccessPoint.setValue(accessPointValue);
        apiBindingTemplate.setAccessPoint(apiAccessPoint);
        if (modelBindingTemplate.getHostingRedirector() != null) {
            HostingRedirector apiHost = new HostingRedirector();
            apiHost.setBindingKey(modelBindingTemplate.getHostingRedirector());
            apiBindingTemplate.setHostingRedirector(apiHost);
        }
        MappingModelToApi.mapTModelInstanceDetails(modelBindingTemplate.getTmodelInstanceInfos(), apiBindingTemplate.getTModelInstanceDetails(), apiBindingTemplate);
        MappingModelToApi.mapBindingDescriptions(modelBindingTemplate.getBindingDescrs(), apiBindingTemplate.getDescription());
        apiBindingTemplate.setCategoryBag(MappingModelToApi.mapCategoryBag(modelBindingTemplate.getCategoryBag(), apiBindingTemplate.getCategoryBag()));
        MappingModelToApi.mapSignature(modelBindingTemplate.getSignatures(), apiBindingTemplate.getSignature());
    }

    public static void mapBindingDescriptions(List<BindingDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (BindingDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static org.uddi.api_v3.CategoryBag mapCategoryBag(CategoryBag modelCategoryBag, org.uddi.api_v3.CategoryBag apiCategoryBag) throws DispositionReportFaultMessage {
        if (modelCategoryBag != null) {
            if (apiCategoryBag == null) {
                apiCategoryBag = new org.uddi.api_v3.CategoryBag();
            }
            for (org.apache.juddi.model.KeyedReference modelKeyedReference : modelCategoryBag.getKeyedReferences()) {
                KeyedReference apiKeyedReference = new KeyedReference();
                apiKeyedReference.setTModelKey(modelKeyedReference.getTmodelKeyRef());
                apiKeyedReference.setKeyName(modelKeyedReference.getKeyName());
                apiKeyedReference.setKeyValue(modelKeyedReference.getKeyValue());
                apiCategoryBag.getKeyedReference().add(apiKeyedReference);
            }
            for (org.apache.juddi.model.KeyedReferenceGroup modelKeyedReferenceGroup : modelCategoryBag.getKeyedReferenceGroups()) {
                KeyedReferenceGroup apiKeyedReferenceGroup = new KeyedReferenceGroup();
                MappingModelToApi.mapKeyedReferenceGroup(modelKeyedReferenceGroup, apiKeyedReferenceGroup);
                apiCategoryBag.getKeyedReferenceGroup().add(apiKeyedReferenceGroup);
            }
        }
        return apiCategoryBag;
    }

    public static void mapKeyedReferenceGroup(org.apache.juddi.model.KeyedReferenceGroup modelKeyedReferenceGroup, KeyedReferenceGroup apiKeyedReferenceGroup) throws DispositionReportFaultMessage {
        apiKeyedReferenceGroup.setTModelKey(modelKeyedReferenceGroup.getTmodelKey());
        for (org.apache.juddi.model.KeyedReference modelKeyedReference : modelKeyedReferenceGroup.getKeyedReferences()) {
            KeyedReference apiKeyedReference = new KeyedReference();
            apiKeyedReference.setTModelKey(modelKeyedReference.getTmodelKeyRef());
            apiKeyedReference.setKeyName(modelKeyedReference.getKeyName());
            apiKeyedReference.setKeyValue(modelKeyedReference.getKeyValue());
            apiKeyedReferenceGroup.getKeyedReference().add(apiKeyedReference);
        }
    }

    public static void mapTModelInstanceDetails(List<TmodelInstanceInfo> modelTModelInstInfoList, TModelInstanceDetails apiTModelInstDetails, BindingTemplate apiBindingTemplate) throws DispositionReportFaultMessage {
        if (modelTModelInstInfoList == null || modelTModelInstInfoList.size() == 0) {
            return;
        }
        if (apiTModelInstDetails == null) {
            apiTModelInstDetails = new TModelInstanceDetails();
        }
        List apiTModelInstInfoList = apiTModelInstDetails.getTModelInstanceInfo();
        apiTModelInstInfoList.clear();
        for (TmodelInstanceInfo modelTModelInstInfo : modelTModelInstInfoList) {
            TModelInstanceInfo apiTModelInstInfo = new TModelInstanceInfo();
            apiTModelInstInfo.setTModelKey(modelTModelInstInfo.getTmodelKey());
            MappingModelToApi.mapTModelInstanceInfoDescriptions(modelTModelInstInfo.getTmodelInstanceInfoDescrs(), apiTModelInstInfo.getDescription());
            MappingModelToApi.mapInstanceDetails(modelTModelInstInfo, apiTModelInstInfo.getInstanceDetails(), apiTModelInstInfo);
            apiTModelInstInfoList.add(apiTModelInstInfo);
        }
        apiBindingTemplate.setTModelInstanceDetails(apiTModelInstDetails);
    }

    public static void mapTModelInstanceInfoDescriptions(List<TmodelInstanceInfoDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (TmodelInstanceInfoDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static void mapInstanceDetails(TmodelInstanceInfo modelTModelInstInfo, InstanceDetails apiInstanceDetails, TModelInstanceInfo apiTModelInstInfo) throws DispositionReportFaultMessage {
        if (modelTModelInstInfo == null || modelTModelInstInfo.getInstanceParms() == null && modelTModelInstInfo.getOverviewDocs().size() == 0) {
            return;
        }
        if (apiInstanceDetails == null) {
            apiInstanceDetails = new InstanceDetails();
        }
        apiInstanceDetails.setInstanceParms(modelTModelInstInfo.getInstanceParms());
        List<InstanceDetailsDescr> modelInstDetailsDescrList = modelTModelInstInfo.getInstanceDetailsDescrs();
        for (InstanceDetailsDescr modelInstDetailDescr : modelInstDetailsDescrList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelInstDetailDescr.getLangCode());
            apiDesc.setValue(modelInstDetailDescr.getDescr());
            apiInstanceDetails.getDescription().add(apiDesc);
        }
        MappingModelToApi.mapOverviewDocs(modelTModelInstInfo.getOverviewDocs(), apiInstanceDetails, null);
        apiTModelInstInfo.setInstanceDetails(apiInstanceDetails);
    }

    public static void mapOverviewDocs(List<OverviewDoc> modelOverviewDocs, InstanceDetails apiInstanceDetails, TModel apiTModel) {
        for (OverviewDoc modelOverviewDoc : modelOverviewDocs) {
            org.uddi.api_v3.OverviewDoc apiOverviewDoc = new org.uddi.api_v3.OverviewDoc();
            List<OverviewDocDescr> overviewDocDescrList = modelOverviewDoc.getOverviewDocDescrs();
            for (OverviewDocDescr overviewDocDescr : overviewDocDescrList) {
                Description apiDesc = new Description();
                apiDesc.setLang(overviewDocDescr.getLangCode());
                apiDesc.setValue(overviewDocDescr.getDescr());
                apiOverviewDoc.getDescription().add(apiDesc);
            }
            OverviewURL apiOverviewURL = new OverviewURL();
            apiOverviewURL.setUseType(modelOverviewDoc.getOverviewUrlUseType());
            apiOverviewURL.setValue(modelOverviewDoc.getOverviewUrl());
            apiOverviewDoc.setOverviewURL(apiOverviewURL);
            if (apiInstanceDetails != null) {
                apiInstanceDetails.getOverviewDoc().add(apiOverviewDoc);
                continue;
            }
            apiTModel.getOverviewDoc().add(apiOverviewDoc);
        }
    }

    public static void mapTModel(Tmodel modelTModel, TModel apiTModel) throws DispositionReportFaultMessage {
        apiTModel.setTModelKey(modelTModel.getEntityKey());
        Name apiName = new Name();
        apiName.setValue(modelTModel.getName());
        apiName.setLang(modelTModel.getLangCode());
        apiTModel.setName(apiName);
        apiTModel.setDeleted(Boolean.valueOf(modelTModel.getDeleted()));
        MappingModelToApi.mapTModelDescriptions(modelTModel.getTmodelDescrs(), apiTModel.getDescription());
        MappingModelToApi.mapTModelIdentifiers(modelTModel.getTmodelIdentifiers(), apiTModel.getIdentifierBag(), apiTModel);
        apiTModel.setCategoryBag(MappingModelToApi.mapCategoryBag(modelTModel.getCategoryBag(), apiTModel.getCategoryBag()));
        MappingModelToApi.mapOverviewDocs(modelTModel.getOverviewDocs(), null, apiTModel);
        MappingModelToApi.mapSignature(modelTModel.getSignatures(), apiTModel.getSignature());
    }

    public static void mapTModelDescriptions(List<TmodelDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (TmodelDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static void mapTModelIdentifiers(List<TmodelIdentifier> modelIdentifierList, IdentifierBag apiIdentifierBag, TModel apiTModel) throws DispositionReportFaultMessage {
        if (modelIdentifierList == null || modelIdentifierList.size() == 0) {
            return;
        }
        if (apiIdentifierBag == null) {
            apiIdentifierBag = new IdentifierBag();
        }
        List apiKeyedRefList = apiIdentifierBag.getKeyedReference();
        apiKeyedRefList.clear();
        for (TmodelIdentifier modelIdentifier : modelIdentifierList) {
            KeyedReference apiKeyedRef = new KeyedReference();
            apiKeyedRef.setTModelKey(modelIdentifier.getTmodelKeyRef());
            apiKeyedRef.setKeyName(modelIdentifier.getKeyName());
            apiKeyedRef.setKeyValue(modelIdentifier.getKeyValue());
            apiKeyedRefList.add(apiKeyedRef);
        }
        apiTModel.setIdentifierBag(apiIdentifierBag);
    }

    public static void mapBusinessInfo(org.apache.juddi.model.BusinessEntity modelBusinessEntity, BusinessInfo apiBusinessInfo) throws DispositionReportFaultMessage {
        apiBusinessInfo.setBusinessKey(modelBusinessEntity.getEntityKey());
        MappingModelToApi.mapBusinessNames(modelBusinessEntity.getBusinessNames(), apiBusinessInfo.getName());
        MappingModelToApi.mapBusinessDescriptions(modelBusinessEntity.getBusinessDescrs(), apiBusinessInfo.getDescription());
        MappingModelToApi.mapServiceInfos(modelBusinessEntity.getBusinessServices(), apiBusinessInfo.getServiceInfos(), apiBusinessInfo);
    }

    public static void mapServiceInfos(List<BusinessService> modelBusinessServiceList, ServiceInfos apiServiceInfos, BusinessInfo apiBusinessInfo) throws DispositionReportFaultMessage {
        if (modelBusinessServiceList.size() == 0) {
            return;
        }
        if (apiServiceInfos == null) {
            apiServiceInfos = new ServiceInfos();
        }
        List apiServiceInfoList = apiServiceInfos.getServiceInfo();
        apiServiceInfoList.clear();
        for (BusinessService modelBusinessService : modelBusinessServiceList) {
            ServiceInfo apiServiceInfo = new ServiceInfo();
            MappingModelToApi.mapServiceInfo(modelBusinessService, apiServiceInfo);
            apiServiceInfos.getServiceInfo().add(apiServiceInfo);
        }
        apiBusinessInfo.setServiceInfos(apiServiceInfos);
    }

    public static void mapServiceInfo(BusinessService modelBusinessService, ServiceInfo apiServiceInfo) throws DispositionReportFaultMessage {
        apiServiceInfo.setBusinessKey(modelBusinessService.getBusinessEntity().getEntityKey());
        apiServiceInfo.setServiceKey(modelBusinessService.getEntityKey());
        MappingModelToApi.mapServiceNames(modelBusinessService.getServiceNames(), apiServiceInfo.getName());
    }

    public static void mapTModelInfo(Tmodel modelTModel, TModelInfo apiTModelInfo) throws DispositionReportFaultMessage {
        apiTModelInfo.setTModelKey(modelTModel.getEntityKey());
        Name apiName = new Name();
        apiName.setValue(modelTModel.getName());
        apiName.setLang(modelTModel.getLangCode());
        apiTModelInfo.setName(apiName);
        MappingModelToApi.mapTModelDescriptions(modelTModel.getTmodelDescrs(), apiTModelInfo.getDescription());
    }

    public static void mapAuthToken(org.apache.juddi.model.AuthToken modelAuthToken, AuthToken apiAuthToken) throws DispositionReportFaultMessage {
        apiAuthToken.setAuthInfo(modelAuthToken.getAuthToken());
    }

    public static void mapPublisherAssertion(org.apache.juddi.model.PublisherAssertion modelPublisherAssertion, PublisherAssertion apiPublisherAssertion) throws DispositionReportFaultMessage {
        apiPublisherAssertion.setFromKey(modelPublisherAssertion.getId().getFromKey());
        apiPublisherAssertion.setToKey(modelPublisherAssertion.getId().getToKey());
        KeyedReference keyedRef = new KeyedReference();
        keyedRef.setTModelKey(modelPublisherAssertion.getTmodelKey());
        keyedRef.setKeyName(modelPublisherAssertion.getKeyName());
        keyedRef.setKeyValue(modelPublisherAssertion.getKeyValue());
        if (modelPublisherAssertion.getSignatures() != null && !modelPublisherAssertion.getSignatures().isEmpty()) {
            MappingModelToApi.mapSignature(modelPublisherAssertion.getSignatures(), apiPublisherAssertion.getSignature());
        }
        apiPublisherAssertion.setKeyedReference(keyedRef);
    }

    public static void mapAssertionStatusItem(org.apache.juddi.model.PublisherAssertion modelPublisherAssertion, AssertionStatusItem apiAssertionStatusItem, List<?> businessKeys) throws DispositionReportFaultMessage {
        apiAssertionStatusItem.setFromKey(modelPublisherAssertion.getId().getFromKey());
        apiAssertionStatusItem.setToKey(modelPublisherAssertion.getId().getToKey());
        KeyedReference keyedRef = new KeyedReference();
        keyedRef.setTModelKey(modelPublisherAssertion.getTmodelKey());
        keyedRef.setKeyName(modelPublisherAssertion.getKeyName());
        keyedRef.setKeyValue(modelPublisherAssertion.getKeyValue());
        apiAssertionStatusItem.setKeyedReference(keyedRef);
        if ("true".equalsIgnoreCase(modelPublisherAssertion.getFromCheck()) && "true".equalsIgnoreCase(modelPublisherAssertion.getToCheck())) {
            apiAssertionStatusItem.setCompletionStatus(CompletionStatus.STATUS_COMPLETE);
        } else if (!"true".equalsIgnoreCase(modelPublisherAssertion.getFromCheck()) && "true".equalsIgnoreCase(modelPublisherAssertion.getToCheck())) {
            apiAssertionStatusItem.setCompletionStatus(CompletionStatus.STATUS_FROM_KEY_INCOMPLETE);
        } else if ("true".equalsIgnoreCase(modelPublisherAssertion.getFromCheck()) && !"true".equalsIgnoreCase(modelPublisherAssertion.getToCheck())) {
            apiAssertionStatusItem.setCompletionStatus(CompletionStatus.STATUS_TO_KEY_INCOMPLETE);
        } else if (!"true".equalsIgnoreCase(modelPublisherAssertion.getFromCheck()) && !"true".equalsIgnoreCase(modelPublisherAssertion.getToCheck())) {
            apiAssertionStatusItem.setCompletionStatus(CompletionStatus.STATUS_BOTH_INCOMPLETE);
        }
        KeysOwned keysOwned = new KeysOwned();
        ArrayList<String> businessKeyList = new ArrayList<String>();
        for (Object businessKey : businessKeys) {
            businessKeyList.add(String.valueOf(businessKey));
        }
        Collections.sort(businessKeyList);
        if (Collections.binarySearch(businessKeyList, modelPublisherAssertion.getBusinessEntityByFromKey().getEntityKey()) >= 0) {
            keysOwned.setFromKey(modelPublisherAssertion.getBusinessEntityByFromKey().getEntityKey());
        }
        if (Collections.binarySearch(businessKeyList, modelPublisherAssertion.getBusinessEntityByToKey().getEntityKey()) >= 0) {
            keysOwned.setToKey(modelPublisherAssertion.getBusinessEntityByToKey().getEntityKey());
        }
        if (keysOwned.getFromKey() == null && keysOwned.getToKey() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.invalidKey.KeysOwned"));
        }
        apiAssertionStatusItem.setKeysOwned(keysOwned);
    }

    public static void mapRelatedBusinessInfo(org.apache.juddi.model.PublisherAssertion modelPublisherAssertion, org.apache.juddi.model.BusinessEntity modelRelatedBusiness, Direction direction, RelatedBusinessInfo apiRelatedBusinessInfo) throws DispositionReportFaultMessage {
        apiRelatedBusinessInfo.setBusinessKey(modelRelatedBusiness.getEntityKey());
        MappingModelToApi.mapBusinessNames(modelRelatedBusiness.getBusinessNames(), apiRelatedBusinessInfo.getName());
        MappingModelToApi.mapBusinessDescriptions(modelRelatedBusiness.getBusinessDescrs(), apiRelatedBusinessInfo.getDescription());
        SharedRelationships sharedRelationships = new SharedRelationships();
        sharedRelationships.setDirection(direction);
        KeyedReference keyedRef = new KeyedReference();
        keyedRef.setTModelKey(modelPublisherAssertion.getTmodelKey());
        keyedRef.setKeyName(modelPublisherAssertion.getKeyName());
        keyedRef.setKeyValue(modelPublisherAssertion.getKeyValue());
        sharedRelationships.getKeyedReference().add(keyedRef);
        apiRelatedBusinessInfo.getSharedRelationships().add(sharedRelationships);
    }

    public static void mapOperationalInfo(UddiEntity modelUddiEntity, OperationalInfo apiOperationalInfo) throws DispositionReportFaultMessage {
        apiOperationalInfo.setCreated(TypeConvertor.convertDateToXMLGregorianCalendar(modelUddiEntity.getCreated()));
        apiOperationalInfo.setModified(TypeConvertor.convertDateToXMLGregorianCalendar(modelUddiEntity.getModified()));
        apiOperationalInfo.setModifiedIncludingChildren(TypeConvertor.convertDateToXMLGregorianCalendar(modelUddiEntity.getModifiedIncludingChildren()));
        apiOperationalInfo.setNodeID(modelUddiEntity.getNodeId());
        apiOperationalInfo.setAuthorizedName(modelUddiEntity.getAuthorizedName());
        apiOperationalInfo.setEntityKey(modelUddiEntity.getEntityKey());
    }

    public static void mapSubscription(org.apache.juddi.model.Subscription modelSubscription, Subscription apiSubscription) throws DispositionReportFaultMessage {
        apiSubscription.setSubscriptionKey(modelSubscription.getSubscriptionKey());
        apiSubscription.setBrief(modelSubscription.isBrief());
        apiSubscription.setExpiresAfter(TypeConvertor.convertDateToXMLGregorianCalendar(modelSubscription.getExpiresAfter()));
        apiSubscription.setBindingKey(modelSubscription.getBindingKey());
        apiSubscription.setMaxEntities(modelSubscription.getMaxEntities());
        apiSubscription.setNotificationInterval(TypeConvertor.convertStringToDuration(modelSubscription.getNotificationInterval()));
        try {
            SubscriptionFilter existingFilter = (SubscriptionFilter)JAXBMarshaller.unmarshallFromString((String)modelSubscription.getSubscriptionFilter(), (String)"org.uddi.sub_v3");
            apiSubscription.setSubscriptionFilter(existingFilter);
        }
        catch (JAXBException e) {
            logger.error((Object)"JAXB Exception while marshalling subscription filter", (Throwable)e);
            throw new FatalErrorException(new ErrorMessage("errors.Unspecified"));
        }
    }

    public static void mapClientSubscriptionInfo(ClientSubscriptionInfo modelClientSubscriptionInfo, org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo, EntityManager em) throws DispositionReportFaultMessage {
        apiClientSubscriptionInfo.setSubscriptionKey(modelClientSubscriptionInfo.getSubscriptionKey());
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeInMillis(modelClientSubscriptionInfo.getLastNotified().getTime());
        try {
            apiClientSubscriptionInfo.setLastModified(DatatypeFactory.newInstance().newXMLGregorianCalendar(gcal));
        }
        catch (DatatypeConfigurationException ex) {
            logger.warn((Object)"unable to create DatatypeFactory", (Throwable)ex);
        }
        if (modelClientSubscriptionInfo.getFromClerk() != null) {
            org.apache.juddi.api_v3.Clerk apiFromClerk = new org.apache.juddi.api_v3.Clerk();
            MappingModelToApi.mapClerk(modelClientSubscriptionInfo.getFromClerk(), apiFromClerk, em);
            apiClientSubscriptionInfo.setFromClerk(apiFromClerk);
        }
        if (modelClientSubscriptionInfo.getToClerk() != null) {
            org.apache.juddi.api_v3.Clerk apiToClerk = new org.apache.juddi.api_v3.Clerk();
            MappingModelToApi.mapClerk(modelClientSubscriptionInfo.getToClerk(), apiToClerk, em);
            apiClientSubscriptionInfo.setToClerk(apiToClerk);
        }
    }

    public static void mapClerk(Clerk modelClerk, org.apache.juddi.api_v3.Clerk apiClerk, EntityManager em) throws DispositionReportFaultMessage {
        apiClerk.setName(modelClerk.getClerkName());
        apiClerk.setPassword(modelClerk.getCred());
        apiClerk.setPublisher(modelClerk.getPublisherId());
        if (modelClerk.getNode() != null) {
            org.apache.juddi.api_v3.Node apiNode = new org.apache.juddi.api_v3.Node();
            MappingModelToApi.mapNode((Node)em.find(Node.class, (Object)modelClerk.getNode()), apiNode);
            apiClerk.setNode(apiNode);
        }
    }

    public static void mapNode(Node modelNode, org.apache.juddi.api_v3.Node apiNode) throws DispositionReportFaultMessage {
        apiNode.setCustodyTransferUrl(modelNode.getCustodyTransferUrl());
        apiNode.setFactoryInitial(modelNode.getFactoryInitial());
        apiNode.setFactoryNamingProvider(modelNode.getFactoryNamingProvider());
        apiNode.setFactoryURLPkgs(modelNode.getFactoryURLPkgs());
        apiNode.setInquiryUrl(modelNode.getInquiryUrl());
        apiNode.setJuddiApiUrl(modelNode.getJuddiApiUrl());
        apiNode.setName(modelNode.getName());
        apiNode.setClientName(modelNode.getClientName());
        apiNode.setProxyTransport(modelNode.getProxyTransport());
        apiNode.setPublishUrl(modelNode.getPublishUrl());
        apiNode.setSecurityUrl(modelNode.getSecurityUrl());
        apiNode.setSubscriptionUrl(modelNode.getSubscriptionUrl());
        apiNode.setSubscriptionListenerUrl(modelNode.getSubscriptionListenerUrl());
        apiNode.setReplicationUrl(modelNode.getReplicationUrl());
    }

    private static Object convertDataToTransformContent(String type, byte[] xformBytes) throws RuntimeException {
        Object transformObject;
        if (type.equals(String.class.getSimpleName())) {
            try {
                transformObject = new String(xformBytes, "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException("Error decoding string due to: " + e.getMessage(), e);
            }
        } else if (type.equals(byte[].class.getSimpleName())) {
            transformObject = xformBytes;
        } else if (type.equals(Element.class.getCanonicalName())) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                dbf.setNamespaceAware(true);
                dbf.setXIncludeAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new ByteArrayInputStream(xformBytes));
                transformObject = doc.getDocumentElement();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to parse element due to: " + e.getMessage(), e);
            }
        } else {
            throw new RuntimeException("Unrecognized type: " + type);
        }
        return transformObject;
    }

    public static void mapReplicationConfiguration(org.apache.juddi.model.ReplicationConfiguration find, ReplicationConfiguration item) throws DispositionReportFaultMessage {
        item.setMaximumTimeToGetChanges(find.getMaximumTimeToGetChanges());
        item.setMaximumTimeToSyncRegistry(find.getMaximumTimeToSyncRegistry());
        item.setSerialNumber(find.getSerialNumber().longValue());
        ArrayList<SignatureType> sigs = new ArrayList<SignatureType>();
        MappingModelToApi.mapSignature(find.getSignatures(), sigs);
        item.getSignature().addAll(sigs);
        MappingModelToApi.mapOperator(find.getOperator(), item.getOperator());
        ArrayList<Contact> modelContactList = new ArrayList<Contact>();
        Contacts cs = new Contacts();
        MappingModelToApi.mapContacts(modelContactList, cs, new BusinessEntity());
        item.setRegistryContact(new ReplicationConfiguration.RegistryContact());
        if (!cs.getContact().isEmpty()) {
            item.getRegistryContact().setContact((org.uddi.api_v3.Contact)cs.getContact().get(0));
        } else {
            item.getRegistryContact().setContact(new org.uddi.api_v3.Contact());
            item.getRegistryContact().getContact().getPersonName().add(new org.uddi.api_v3.PersonName("unknown", null));
        }
        item.setTimeOfConfigurationUpdate(find.getTimeOfConfigurationUpdate());
        CommunicationGraph xcom = new CommunicationGraph();
        MappingModelToApi.mapCommunicationGraph(find, xcom);
        item.setCommunicationGraph(xcom);
    }

    private static void mapOperator(List<Operator> model, List<org.uddi.repl_v3.Operator> api) throws DispositionReportFaultMessage {
        for (int i = 0; i < model.size(); ++i) {
            org.uddi.repl_v3.Operator op = new org.uddi.repl_v3.Operator();
            op.setOperatorNodeID(model.get(i).getOperatorNodeID());
            op.setSoapReplicationURL(model.get(i).getSoapReplicationURL());
            switch (model.get(i).getOperatorStatus()) {
                case NEW: {
                    op.setOperatorStatus(OperatorStatusType.NEW);
                    break;
                }
                case NORMAL: {
                    op.setOperatorStatus(OperatorStatusType.NORMAL);
                    break;
                }
                case RESIGNED: {
                    op.setOperatorStatus(OperatorStatusType.RESIGNED);
                }
            }
            Contacts c = new Contacts();
            MappingModelToApi.mapContacts(model.get(i).getContact(), c, new BusinessEntity());
            op.getContact().addAll(c.getContact());
            if (model.get(i).getKeyInfo() != null) {
                for (int x = 0; x < model.get(i).getKeyInfo().size(); ++x) {
                    KeyInfoType apiKeyInfo = new KeyInfoType();
                    KeyInfo modelKeyInfo = model.get(i).getKeyInfo().get(x);
                    apiKeyInfo.setId(modelKeyInfo.getXmlID());
                    List<KeyDataValue> modelKeyDataValueList = modelKeyInfo.getKeyDataValue();
                    List apiX509KeyInfoList = apiKeyInfo.getContent();
                    MappingModelToApi.mapModelKeyDataValue(modelKeyDataValueList, apiX509KeyInfoList);
                    op.getKeyInfo().add(apiKeyInfo);
                }
            }
            api.add(op);
        }
    }

    private static void mapCommunicationGraph(org.apache.juddi.model.ReplicationConfiguration model, CommunicationGraph api) {
        MappingModelToApi.mapEdge(model.getEdge(), api.getEdge());
        MappingModelToApi.mapControlMessages(model.getControlMessage(), api.getControlledMessage());
        MappingModelToApi.mapEdgeNodes(model.getNode(), api.getNode());
    }

    private static void mapEdge(List<Edge> model, List<CommunicationGraph.Edge> api) {
        for (Edge modelEdge : model) {
            CommunicationGraph.Edge apiEdge = new CommunicationGraph.Edge();
            apiEdge.setMessageReceiver(modelEdge.getMessageReceiver());
            apiEdge.setMessageSender(modelEdge.getMessageSender());
            Iterator<ControlMessage> it2 = modelEdge.getMessages().iterator();
            while (it2.hasNext()) {
                apiEdge.getMessage().add(it2.next().getMessage());
            }
            Iterator<EdgeReceiverAlternate> it3 = modelEdge.getMessageReceiverAlternate().iterator();
            while (it3.hasNext()) {
                apiEdge.getMessageReceiverAlternate().add(it3.next().getReceiverAlternate());
            }
            api.add(apiEdge);
        }
    }

    private static void mapControlMessages(List<ControlMessage> model, List<String> api) {
        Iterator<ControlMessage> it = model.iterator();
        while (it.hasNext()) {
            api.add(it.next().getMessage());
        }
    }

    private static void mapEdgeNodes(List<ReplicationConfigurationNode> model, List<String> api) {
        Iterator<ReplicationConfigurationNode> it = model.iterator();
        while (it.hasNext()) {
            api.add(it.next().getNodeName());
        }
    }

    public static ChangeRecord mapChangeRecord(org.apache.juddi.model.ChangeRecord cr) {
        if (cr == null) {
            return null;
        }
        ChangeRecord ret = null;
        StringReader sr = null;
        try {
            sr = new StringReader(new String(cr.getContents(), "UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(MappingModelToApi.class.getName()).log(Level.SEVERE, null, ex);
        }
        ret = (ChangeRecord)XmlUtils.unmarshal((Reader)sr, (Class[])new Class[]{ChangeRecord.class});
        if (cr.getOriginatingUSN() == null || cr.getOriginatingUSN() == -1L) {
            ret.setChangeID(new ChangeRecordIDType(cr.getNodeID(), cr.getId()));
        } else {
            ret.setChangeID(new ChangeRecordIDType(cr.getNodeID(), cr.getOriginatingUSN()));
        }
        return ret;
    }
}

