/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.query.BusinessEntityQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.uddi.api_v3.TModelBag;

public class FindBusinessByTModelKeyQuery
extends BusinessEntityQuery {
    private static final Log log = LogFactory.getLog(FindBusinessByTModelKeyQuery.class);
    public static final String ENTITY_NAME_CHILD = "TmodelInstanceInfo";
    protected static final String entityAliasChild = FindBusinessByTModelKeyQuery.buildAlias("TmodelInstanceInfo");

    public static List<Object> select(EntityManager em, FindQualifiers fq, TModelBag tModels, List<Object> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.isEmpty()) {
            return keysIn;
        }
        if (tModels == null) {
            return keysIn;
        }
        List tmodelKeys = tModels.getTModelKey();
        if (tmodelKeys == null || tmodelKeys.isEmpty()) {
            return keysIn;
        }
        DynamicQuery dynamicQry = new DynamicQuery(selectSQL);
        FindBusinessByTModelKeyQuery.appendConditions(dynamicQry, fq, tmodelKeys);
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        return FindBusinessByTModelKeyQuery.getQueryResult(em, dynamicQry, keysIn, "be.entityKey");
    }

    public static void appendConditions(DynamicQuery qry, FindQualifiers fq, List<String> tmodelKeys) {
        FindBusinessByTModelKeyQuery.appendJoinTables(qry, fq, tmodelKeys);
        qry.AND().pad().openParen().pad();
        int count = 0;
        int tblCount = -1;
        for (String tmodelKey : tmodelKeys) {
            String tmodelKeyTerm = (fq.isOrAllKeys() ? entityAliasChild + "0" : entityAliasChild + ++tblCount) + ".tmodelKey";
            qry.appendGroupedAnd(new DynamicQuery.Parameter(tmodelKeyTerm, tmodelKey, "="));
            if (count + 1 < tmodelKeys.size()) {
                if (fq.isOrAllKeys()) {
                    qry.OR().pad();
                } else {
                    qry.AND().pad();
                }
            }
            ++count;
        }
        qry.closeParen().pad();
    }

    public static void appendJoinTables(DynamicQuery qry, FindQualifiers fq, List<String> tmodelKeys) {
        if (tmodelKeys != null && tmodelKeys.size() > 0) {
            qry.comma().pad().append("BusinessService bs").pad();
            qry.comma().pad().append("BindingTemplate bt").pad();
            StringBuilder thetaJoins = new StringBuilder(200);
            int tblCount = 0;
            for (int count = 0; count < tmodelKeys.size(); ++count) {
                if (count != 0) {
                    if (fq.isOrAllKeys()) continue;
                    qry.comma().pad().append("TmodelInstanceInfo " + entityAliasChild + ++tblCount).pad();
                    thetaJoins.append(entityAliasChild + (tblCount - 1) + "." + "bindingTemplate" + "." + "entityKey" + " = " + entityAliasChild + tblCount + "." + "bindingTemplate" + "." + "entityKey" + " ");
                    thetaJoins.append("and ");
                    continue;
                }
                qry.comma().pad().append("TmodelInstanceInfo " + entityAliasChild + tblCount).pad();
                thetaJoins.append("bt.entityKey = " + entityAliasChild + tblCount + "." + "bindingTemplate" + "." + "entityKey" + " ");
                thetaJoins.append("and ");
            }
            qry.WHERE().pad().openParen().pad();
            qry.append("be.entityKey = bs.businessEntity.entityKey").pad();
            qry.AND().pad().append("bs.entityKey = bt.businessService.entityKey").pad();
            qry.AND().pad();
            String thetaJoinsStr = thetaJoins.toString();
            if (thetaJoinsStr.endsWith("and ")) {
                thetaJoinsStr = thetaJoinsStr.substring(0, thetaJoinsStr.length() - "and ".length());
            }
            qry.append(thetaJoinsStr);
            qry.closeParen().pad();
            if (fq != null && fq.isSignaturePresent()) {
                qry.AND().pad().openParen().pad().append("be.signatures IS NOT EMPTY ").pad().closeParen().pad();
            }
        }
    }
}

