/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.query.EntityQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;

public class FindEntityByPublisherQuery
extends EntityQuery {
    public static final String AUTHORIZED_NAME_FIELD = "authorizedName";
    private final String entityName;
    private final String entityAlias;
    private final String keyName;
    private final String selectSQL;
    private String signaturePresent;

    public FindEntityByPublisherQuery(String entityName, String entityAlias, String keyName, String signaturePresent) {
        this.entityName = entityName;
        this.entityAlias = entityAlias;
        this.keyName = keyName;
        this.signaturePresent = signaturePresent;
        StringBuilder sql = new StringBuilder(200);
        sql.append("select distinct ").append(entityAlias).append(".").append(keyName).append(" from ").append(entityName).append(" ").append(entityAlias).append(" ");
        this.selectSQL = sql.toString();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getSelectSQL() {
        return this.selectSQL;
    }

    public String getSignaturePresent() {
        return this.signaturePresent;
    }

    public void setSignaturePresent(String signaturePresent) {
        this.signaturePresent = signaturePresent;
    }

    public List<?> select(EntityManager em, FindQualifiers fq, UddiEntityPublisher publisher, List<?> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        if (publisher == null) {
            return keysIn;
        }
        DynamicQuery dynamicQry = new DynamicQuery(this.selectSQL);
        this.appendConditions(dynamicQry, fq, publisher);
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        return FindEntityByPublisherQuery.getQueryResult(em, dynamicQry, keysIn, this.entityAlias + "." + this.keyName);
    }

    public void appendConditions(DynamicQuery qry, FindQualifiers fq, UddiEntityPublisher publisher) {
        qry.WHERE().pad();
        if (fq != null && fq.isSignaturePresent()) {
            qry.pad().openParen().pad().append(this.getSignaturePresent()).pad().closeParen().pad().AND();
        }
        qry.appendGroupedAnd(new DynamicQuery.Parameter(this.entityAlias + "." + AUTHORIZED_NAME_FIELD, publisher.getAuthorizedName(), "="));
    }
}

