/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.model.PublisherAssertion;
import org.apache.juddi.query.PublisherAssertionQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.uddi.api_v3.CompletionStatus;

public class FindPublisherAssertionByBusinessQuery
extends PublisherAssertionQuery {
    private static Log log = LogFactory.getLog(FindPublisherAssertionByBusinessQuery.class);

    public static List<PublisherAssertion> select(EntityManager em, List<?> businessKeys, CompletionStatus completionStatus) {
        if (businessKeys == null || businessKeys.isEmpty()) {
            return null;
        }
        DynamicQuery dynamicQry = new DynamicQuery(selectSQL);
        FindPublisherAssertionByBusinessQuery.appendConditions(dynamicQry, businessKeys, completionStatus);
        log.debug((Object)dynamicQry);
        Query qry = dynamicQry.buildJPAQuery(em);
        List result = qry.getResultList();
        return result;
    }

    public static void appendConditions(DynamicQuery qry, List<?> businessKeys, CompletionStatus completionStatus) {
        qry.WHERE().pad().openParen().pad();
        qry.appendInList("pa.businessEntityByFromKey.entityKey", businessKeys);
        qry.pad().OR().pad();
        qry.appendInList("pa.businessEntityByToKey.entityKey", businessKeys);
        qry.closeParen().pad();
        if (completionStatus != null) {
            qry.AND().pad().openParen().pad();
            String fromCheckTerm = "UPPER(pa.fromCheck)";
            String toCheckTerm = "UPPER(pa.toCheck)";
            if (completionStatus == CompletionStatus.STATUS_BOTH_INCOMPLETE) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter(fromCheckTerm, "TRUE", "<>"));
                qry.AND().pad();
                qry.appendGroupedAnd(new DynamicQuery.Parameter(toCheckTerm, "TRUE", "<>"));
            } else if (completionStatus == CompletionStatus.STATUS_COMPLETE) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter(fromCheckTerm, "TRUE", "="));
                qry.AND().pad();
                qry.appendGroupedAnd(new DynamicQuery.Parameter(toCheckTerm, "TRUE", "="));
            } else if (completionStatus == CompletionStatus.STATUS_FROM_KEY_INCOMPLETE) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter(fromCheckTerm, "TRUE", "<>"));
                qry.AND().pad();
                qry.appendGroupedAnd(new DynamicQuery.Parameter(toCheckTerm, "TRUE", "="));
            } else if (completionStatus == CompletionStatus.STATUS_TO_KEY_INCOMPLETE) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter(fromCheckTerm, "TRUE", "="));
                qry.AND().pad();
                qry.appendGroupedAnd(new DynamicQuery.Parameter(toCheckTerm, "TRUE", "<>"));
            }
            qry.closeParen().pad();
        }
    }
}

