/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.query.TModelQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.uddi.api_v3.Name;

public class FindTModelByNameQuery
extends TModelQuery {
    private static Log log = LogFactory.getLog(FindTModelByNameQuery.class);

    public static List<Object> select(EntityManager em, FindQualifiers fq, Name name, List<Object> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.isEmpty()) {
            return keysIn;
        }
        if (name == null) {
            return keysIn;
        }
        DynamicQuery dynamicQry = new DynamicQuery(selectSQL);
        FindTModelByNameQuery.appendConditions(dynamicQry, fq, name);
        dynamicQry.AND().pad().appendGroupedAnd(new DynamicQuery.Parameter("t.deleted", false, "="));
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        return FindTModelByNameQuery.getQueryResult(em, dynamicQry, keysIn, "t.entityKey");
    }

    public static void appendConditions(DynamicQuery qry, FindQualifiers fq, Name name) {
        String namePredicate = "=";
        if (fq != null && fq.isApproximateMatch()) {
            namePredicate = "like";
        }
        qry.WHERE().pad().openParen().pad();
        String nameTerm = "t.name";
        String nameValue = name.getValue();
        if (fq != null && fq.isCaseInsensitiveMatch()) {
            nameTerm = "upper(t.name)";
            nameValue = name.getValue().toUpperCase();
        }
        if (name.getLang() == null || name.getLang().length() == 0) {
            qry.appendGroupedAnd(new DynamicQuery.Parameter(nameTerm, nameValue, namePredicate));
        } else {
            String langValue = name.getLang().endsWith("%") ? name.getLang().toUpperCase() : name.getLang().toUpperCase() + "%";
            qry.appendGroupedAnd(new DynamicQuery.Parameter(nameTerm, nameValue, namePredicate), new DynamicQuery.Parameter("upper(t.langCode)", langValue, "like"));
        }
        qry.closeParen().pad();
        if (fq != null && fq.isSignaturePresent()) {
            qry.AND().pad().openParen().pad().append("t.signatures IS NOT EMPTY ").pad().closeParen().pad();
        }
    }
}

