/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.rmi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.rmi.JUDDIApiService;
import org.apache.juddi.rmi.UDDICustodyTransferService;
import org.apache.juddi.rmi.UDDIInquiryService;
import org.apache.juddi.rmi.UDDIPublicationService;
import org.apache.juddi.rmi.UDDISecurityService;
import org.apache.juddi.rmi.UDDISubscriptionListenerService;
import org.apache.juddi.rmi.UDDISubscriptionService;

public class JNDIRegistration {
    public static final String JUDDI = "/juddiv3";
    public static final String UDDI_SECURITY_SERVICE = "/juddiv3/UDDISecurityService";
    public static final String UDDI_PUBLICATION_SERVICE = "/juddiv3/UDDIPublicationService";
    public static final String UDDI_INQUIRY_SERVICE = "/juddiv3/UDDIInquiryService";
    public static final String UDDI_SUBSCRIPTION_SERVICE = "/juddiv3/UDDISubscriptionService";
    public static final String UDDI_SUBSCRIPTION_LISTENER_SERVICE = "/juddiv3/UDDISubscriptionListenerService";
    public static final String UDDI_CUSTODY_TRANSFER_SERVICE = "/juddiv3/UDDICustodyTransferService";
    public static final String JUDDI_PUBLISHER_SERVICE = "/juddiv3/JUDDIApiService";
    private UDDISecurityService securityService = null;
    private UDDIPublicationService publicationService = null;
    private UDDIInquiryService inquiryService = null;
    private UDDISubscriptionService subscriptionService = null;
    private UDDISubscriptionListenerService subscriptionListenerService = null;
    private UDDICustodyTransferService custodyTransferService = null;
    private JUDDIApiService publisherService = null;
    private Log log = LogFactory.getLog(this.getClass());
    InitialContext context = new InitialContext();
    private static JNDIRegistration registration = null;

    public static JNDIRegistration getInstance() throws NamingException {
        if (registration == null) {
            registration = new JNDIRegistration();
        }
        return registration;
    }

    private JNDIRegistration() throws NamingException {
    }

    public void register(int port) {
        try {
            Context juddiContext = this.context.createSubcontext(JUDDI);
            this.securityService = new UDDISecurityService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting /juddiv3/UDDISecurityService, " + this.securityService.getClass()));
            }
            juddiContext.bind(UDDI_SECURITY_SERVICE, (Object)this.securityService);
            this.publicationService = new UDDIPublicationService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting /juddiv3/UDDIPublicationService, " + this.publicationService.getClass()));
            }
            juddiContext.bind(UDDI_PUBLICATION_SERVICE, (Object)this.publicationService);
            this.inquiryService = new UDDIInquiryService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting /juddiv3/UDDIInquiryService, " + this.inquiryService.getClass()));
            }
            juddiContext.bind(UDDI_INQUIRY_SERVICE, (Object)this.inquiryService);
            this.subscriptionService = new UDDISubscriptionService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting /juddiv3/UDDISubscriptionService, " + this.subscriptionService.getClass()));
            }
            juddiContext.bind(UDDI_SUBSCRIPTION_SERVICE, (Object)this.subscriptionService);
            this.subscriptionListenerService = new UDDISubscriptionListenerService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting /juddiv3/UDDISubscriptionListenerService, " + this.subscriptionListenerService.getClass()));
            }
            juddiContext.bind(UDDI_SUBSCRIPTION_LISTENER_SERVICE, (Object)this.subscriptionListenerService);
            this.custodyTransferService = new UDDICustodyTransferService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting /juddiv3/UDDICustodyTransferService, " + this.custodyTransferService.getClass()));
            }
            juddiContext.bind(UDDI_CUSTODY_TRANSFER_SERVICE, (Object)this.custodyTransferService);
            this.publisherService = new JUDDIApiService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting /juddiv3/JUDDIApiService, " + this.publisherService.getClass()));
            }
            juddiContext.bind(JUDDI_PUBLISHER_SERVICE, (Object)this.publisherService);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void unregister() {
        try {
            this.context.unbind(UDDI_SECURITY_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.securityService = null;
        try {
            this.context.unbind(UDDI_PUBLICATION_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.publicationService = null;
        try {
            this.context.unbind(UDDI_INQUIRY_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.inquiryService = null;
        try {
            this.context.unbind(UDDI_SUBSCRIPTION_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.subscriptionService = null;
        try {
            this.context.unbind(UDDI_SUBSCRIPTION_LISTENER_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.subscriptionListenerService = null;
        try {
            this.context.unbind(UDDI_CUSTODY_TRANSFER_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.custodyTransferService = null;
        try {
            this.context.unbind(JUDDI_PUBLISHER_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.publisherService = null;
        try {
            this.context.unbind(JUDDI);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

