/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.subscription.notify;

import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.ClassUtil;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.TmodelInstanceInfo;
import org.apache.juddi.subscription.notify.Notifier;

public class NotifierFactory {
    Log log = LogFactory.getLog(this.getClass());
    public static final String UDDI_TRANSPORT_KEY = "uddi:uddi.org:transport:";

    public Notifier getNotifier(BindingTemplate bindingTemplate) throws URISyntaxException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        String notifierClassName = null;
        for (TmodelInstanceInfo tModelInstanceInfo : bindingTemplate.getTmodelInstanceInfos()) {
            if (!tModelInstanceInfo.getTmodelKey().startsWith(UDDI_TRANSPORT_KEY)) continue;
            this.log.debug((Object)("Found transport tModelKey " + tModelInstanceInfo.getTmodelKey()));
            String transport = tModelInstanceInfo.getTmodelKey().substring(UDDI_TRANSPORT_KEY.length(), tModelInstanceInfo.getTmodelKey().length());
            transport = transport.replaceAll("-", "_");
            notifierClassName = "org.apache.juddi.subscription.notify." + transport.toUpperCase() + "Notifier";
            break;
        }
        if (notifierClassName == null) {
            this.log.warn((Object)("The bindingTemplate " + bindingTemplate.getEntityKey() + " does not contain a tModel to define its type of transport. Defaulting to http."));
            notifierClassName = "org.apache.juddi.subscription.notify.HTTPNotifier";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Going find and instantiate notifier class: " + notifierClassName));
        }
        Class<?> notifierClass = ClassUtil.forName(notifierClassName, this.getClass());
        Notifier notifier = (Notifier)notifierClass.getConstructor(BindingTemplate.class).newInstance(bindingTemplate);
        return notifier;
    }
}

