/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.auth;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.auth.Authenticator;
import org.apache.juddi.v3.error.AuthenticationException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.UnknownUserException;

public class HTTPContainerAuthenticator
implements Authenticator {
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public String authenticate(String authorizedName, String cred) throws AuthenticationException, FatalErrorException {
        throw new UnknownUserException(new ErrorMessage("errros.UnsupportedAuthenticator"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UddiEntityPublisher identify(String authInfoNotused, String authorizedNameNotused, WebServiceContext ctx) throws AuthenticationException, FatalErrorException {
        int MaxBindingsPerService = -1;
        int MaxServicesPerBusiness = -1;
        int MaxTmodels = -1;
        int MaxBusinesses = -1;
        try {
            MaxBindingsPerService = AppConfig.getConfiguration().getInt("juddi.maxBindingsPerService", -1);
            MaxServicesPerBusiness = AppConfig.getConfiguration().getInt("juddi.maxServicesPerBusiness", -1);
            MaxTmodels = AppConfig.getConfiguration().getInt("juddi.maxTModelsPerPublisher", -1);
            MaxBusinesses = AppConfig.getConfiguration().getInt("juddi.maxBusinessesPerPublisher", -1);
        }
        catch (Exception ex) {
            MaxBindingsPerService = -1;
            MaxServicesPerBusiness = -1;
            MaxTmodels = -1;
            MaxBusinesses = -1;
            this.log.error((Object)"config exception! ", (Throwable)ex);
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            String user = null;
            if (ctx == null) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", "no web service context!"));
            }
            if (ctx.getUserPrincipal() != null) {
                user = ctx.getUserPrincipal().getName();
            }
            if (user == null) {
                MessageContext mc = ctx.getMessageContext();
                HttpServletRequest req = null;
                if (mc != null) {
                    req = (HttpServletRequest)mc.get((Object)"javax.xml.ws.servlet.request");
                }
                if (req != null && req.getUserPrincipal() != null) {
                    user = req.getUserPrincipal().getName();
                }
            }
            if (user == null || user.length() == 0) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher"));
            }
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)user);
            if (publisher == null) {
                this.log.warn((Object)("Publisher \"" + user + "\" was not found in the database, adding the publisher in on the fly."));
                publisher = new Publisher();
                publisher.setAuthorizedName(user);
                publisher.setIsAdmin(false);
                publisher.setIsEnabled(true);
                publisher.setMaxBindingsPerService(MaxBindingsPerService);
                publisher.setMaxBusinesses(MaxBusinesses);
                publisher.setMaxServicesPerBusiness(MaxServicesPerBusiness);
                publisher.setMaxTmodels(MaxTmodels);
                publisher.setPublisherName("Unknown");
                em.persist((Object)publisher);
                tx.commit();
            }
            Publisher publisher2 = publisher;
            return publisher2;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

