/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.ClassUtil;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.auth.Authenticator;
import org.apache.juddi.v3.auth.AuthenticatorFactory;
import org.apache.juddi.v3.auth.JuddiUsers;
import org.apache.juddi.v3.auth.User;
import org.apache.juddi.v3.error.AuthenticationException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.UnknownUserException;

public class XMLDocAuthenticator
implements Authenticator {
    protected static final Log log = LogFactory.getLog(AuthenticatorFactory.class);
    Map<String, User> userTable;

    public XMLDocAuthenticator() throws JAXBException, IOException, ConfigurationException {
        this.readUserFile();
    }

    public XMLDocAuthenticator(boolean b) {
    }

    protected String getFilename() throws ConfigurationException {
        return AppConfig.getConfiguration().getString("juddi.auth.usersfile", "juddi-users.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readUserFile() throws JAXBException, IOException, ConfigurationException {
        this.userTable = new HashMap<String, User>();
        String usersFileName = this.getFilename();
        if (usersFileName == null || usersFileName.length() == 0) {
            throw new ConfigurationException("usersFileName value is null!");
        }
        File file = new File(usersFileName);
        try (InputStream stream = null;){
            if (file.exists()) {
                log.info((Object)("Reading jUDDI Users File: " + usersFileName + "..."));
                stream = new FileInputStream(file);
            } else {
                URL resource = ClassUtil.getResource(usersFileName, this.getClass());
                if (resource != null) {
                    log.info((Object)("Reading jUDDI Users File: " + usersFileName + "...from " + resource.toExternalForm()));
                } else {
                    log.info((Object)("Reading jUDDI Users File: " + usersFileName + "..."));
                }
                stream = ClassUtil.getResource(usersFileName, this.getClass()).openStream();
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{JuddiUsers.class});
            Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
            JAXBElement element = unMarshaller.unmarshal((Source)new StreamSource(stream), JuddiUsers.class);
            JuddiUsers users = (JuddiUsers)element.getValue();
            for (User user : users.getUser()) {
                this.userTable.put(user.getUserid(), user);
                log.debug((Object)("Loading user credentials for user: " + user.getUserid()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authenticate(String userID, String credential) throws AuthenticationException, FatalErrorException {
        if (userID == null) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidUserId"));
        }
        if (credential == null) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidCredentials"));
        }
        if (this.userTable.containsKey(userID)) {
            User user = this.userTable.get(userID);
            if (user.getPassword() == null || !credential.equals(user.getPassword())) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidCredentials"));
            }
        } else {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidUserId", userID));
        }
        int MaxBindingsPerService = -1;
        int MaxServicesPerBusiness = -1;
        int MaxTmodels = -1;
        int MaxBusinesses = -1;
        try {
            MaxBindingsPerService = AppConfig.getConfiguration().getInt("juddi.maxBindingsPerService", -1);
            MaxServicesPerBusiness = AppConfig.getConfiguration().getInt("juddi.maxServicesPerBusiness", -1);
            MaxTmodels = AppConfig.getConfiguration().getInt("juddi.maxTModelsPerPublisher", -1);
            MaxBusinesses = AppConfig.getConfiguration().getInt("juddi.maxBusinessesPerPublisher", -1);
        }
        catch (Exception ex) {
            MaxBindingsPerService = -1;
            MaxServicesPerBusiness = -1;
            MaxTmodels = -1;
            MaxBusinesses = -1;
            log.error((Object)("config exception! " + userID), (Throwable)ex);
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)userID);
            if (publisher == null) {
                log.warn((Object)("Publisher \"" + userID + "\" was not found in the database, adding the publisher in on the fly."));
                publisher = new Publisher();
                publisher.setAuthorizedName(userID);
                publisher.setIsAdmin("false");
                publisher.setIsEnabled("true");
                publisher.setMaxBindingsPerService(MaxBindingsPerService);
                publisher.setMaxBusinesses(MaxBusinesses);
                publisher.setMaxServicesPerBusiness(MaxServicesPerBusiness);
                publisher.setMaxTmodels(MaxTmodels);
                publisher.setPublisherName("Unknown");
                em.persist((Object)publisher);
                tx.commit();
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return userID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UddiEntityPublisher identify(String authInfo, String authorizedName, WebServiceContext ctx) throws AuthenticationException {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)authorizedName);
            if (publisher == null) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
            }
            Publisher publisher2 = publisher;
            return publisher2;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

