/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.juddi.api_v3.Clerk;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.api_v3.SaveClerk;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class ValidateClerk
extends ValidateUDDIApi {
    public ValidateClerk(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateSaveClerk(EntityManager em, SaveClerk body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List clerks = body.getClerk();
        if (clerks == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.saveClerk.NoInput"));
        }
        for (Clerk clerk : body.getClerk()) {
            this.validateClerk(em, clerk);
        }
    }

    public void validateClerk(EntityManager em, Clerk clerk) throws DispositionReportFaultMessage {
        if (clerk == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.clerk.NullInput"));
        }
        String name = clerk.getName();
        if (name == null || name.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.clerk.NoName"));
        }
        String publisherName = clerk.getPublisher();
        if (publisherName == null || publisherName.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.clerk.NoPublisherName"));
        }
        Node node = clerk.getNode();
        if (node == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.clerk.NullNodeInput"));
        }
        String nodeName = node.getName();
        if (nodeName == null || nodeName.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoName"));
        }
    }
}

