/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidCombinationException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.UnsupportedException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidatePublish;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetOperationalInfo;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.TModelBag;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class ValidateInquiry
extends ValidateUDDIApi {
    static Map<String, Boolean> supportedFindqualifiers = null;

    public ValidateInquiry(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateGetBusinessDetail(GetBusinessDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getBusinessKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            ++i;
        }
    }

    public void validateGetServiceDetail(GetServiceDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getServiceKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            ++i;
        }
    }

    public void validateGetBindingDetail(GetBindingDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getBindingKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            ++i;
        }
    }

    public void validateGetTModelDetail(GetTModelDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getTModelKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            ++i;
        }
    }

    public void validateGetOperationalInfo(GetOperationalInfo body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getEntityKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            ++i;
        }
    }

    public void validateFindBusiness(FindBusiness body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getCategoryBag() == null && body.getFindTModel() == null && body.getTModelBag() == null && body.getName().size() == 0 && body.getIdentifierBag() == null && body.getDiscoveryURLs() == null && body.getFindRelatedBusinesses() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.findbusiness.NoInput"));
        }
        this.validateNames(body.getName());
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateTModelBag(body.getTModelBag());
        this.validateFindTModel(body.getFindTModel(), true);
        this.validateFindRelatedBusinesses(body.getFindRelatedBusinesses(), true);
        this.validateDiscoveryUrls(body.getDiscoveryURLs());
        this.validateIdentifierBag(body.getIdentifierBag());
        this.validateCategoryBag(body.getCategoryBag());
    }

    public void validateFindService(FindService body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getCategoryBag() == null && body.getFindTModel() == null && (body.getTModelBag() == null || body.getTModelBag().getTModelKey().size() == 0) && body.getName().size() == 0 && body.getBusinessKey() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.findservice.NoInput"));
        }
        this.validateNames(body.getName());
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateTModelBag(body.getTModelBag());
        this.validateFindTModel(body.getFindTModel(), true);
        this.validateCategoryBag(body.getCategoryBag());
    }

    public void validateFindBinding(FindBinding body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getServiceKey() != null && body.getServiceKey().length() > 0) {
            this.validateServiceExists(body.getServiceKey());
        }
        if ((body.getServiceKey() == null || body.getServiceKey().length() == 0) && body.getCategoryBag() == null && body.getFindTModel() == null && body.getTModelBag() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.findbinding.NoInput"));
        }
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateTModelBag(body.getTModelBag());
        this.validateFindTModel(body.getFindTModel(), true);
        this.validateCategoryBag(body.getCategoryBag());
        this.validateFindingBindingFQ(body.getFindQualifiers());
        this.validateFindQualifiers_AppoximateMatchAndCombinedCatbag(body.getFindQualifiers());
    }

    public void validateFindTModel(FindTModel body, boolean nullAllowed) throws DispositionReportFaultMessage {
        if (body == null) {
            if (nullAllowed) {
                return;
            }
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getCategoryBag() == null && body.getIdentifierBag() == null && body.getName() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.findtmodel.NoInput"));
        }
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateIdentifierBag(body.getIdentifierBag());
        this.validateCategoryBag(body.getCategoryBag());
        this.validateFindQualifiers_AppoximateMatchAndCombinedCatbag(body.getFindQualifiers());
    }

    public void validateFindRelatedBusinesses(FindRelatedBusinesses body, boolean nullAllowed) throws DispositionReportFaultMessage {
        KeyedReference keyedRef;
        if (body == null) {
            if (nullAllowed) {
                return;
            }
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (!(body.getBusinessKey() != null && body.getBusinessKey().length() != 0 || body.getFromKey() != null && body.getFromKey().length() != 0 || body.getToKey() != null && body.getToKey().length() != 0)) {
            throw new FatalErrorException(new ErrorMessage("errors.findrelatedbusiness.NoInput"));
        }
        boolean businessKeyExists = false;
        boolean fromKeyExists = false;
        if (body.getBusinessKey() != null && body.getBusinessKey().length() > 0) {
            businessKeyExists = true;
            body.setBusinessKey(body.getBusinessKey().toLowerCase());
        }
        if (body.getFromKey() != null && body.getFromKey().length() > 0) {
            fromKeyExists = true;
            if (businessKeyExists) {
                throw new FatalErrorException(new ErrorMessage("errors.findrelatedbusiness.MultipleInput"));
            }
            body.setFromKey(body.getFromKey().toLowerCase());
        }
        if (body.getToKey() != null && body.getToKey().length() > 0) {
            if (businessKeyExists || fromKeyExists) {
                throw new FatalErrorException(new ErrorMessage("errors.findrelatedbusiness.MultipleInput"));
            }
            body.setToKey(body.getToKey().toLowerCase());
        }
        if ((keyedRef = body.getKeyedReference()) != null) {
            if (keyedRef.getTModelKey() == null || keyedRef.getTModelKey().length() == 0 || keyedRef.getKeyName() == null || keyedRef.getKeyName().length() == 0 || keyedRef.getKeyValue() == null || keyedRef.getKeyValue().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.findrelatedbusiness.BlankKeyedRef"));
            }
            this.validateKeyedReference(keyedRef);
        }
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateFindRelatedBusinessesFindQualifiers(body.getFindQualifiers());
        this.validateFindQualifiers_AppoximateMatchAndCombinedCatbag(body.getFindQualifiers());
    }

    public void validateNames(List<Name> names) throws DispositionReportFaultMessage {
        if (names != null) {
            for (Name n : names) {
                if (n.getValue() == null || n.getValue().length() == 0) {
                    throw new ValueNotAllowedException(new ErrorMessage("errors.names.NoValue"));
                }
                ValidatePublish.validateLang(n.getLang());
            }
        }
    }

    public void validateTModelBag(TModelBag tmodelBag) throws DispositionReportFaultMessage {
        if (tmodelBag == null) {
            return;
        }
        if (tmodelBag.getTModelKey() == null || tmodelBag.getTModelKey().size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodelbag.NoInput"));
        }
        List keyList = tmodelBag.getTModelKey();
        int i = 0;
        for (String key : keyList) {
            key = key.toLowerCase();
            keyList.set(i, key);
            ++i;
        }
    }

    public void validateDiscoveryUrls(DiscoveryURLs discUrls) throws DispositionReportFaultMessage {
        if (discUrls == null) {
            return;
        }
        List discUrlList = discUrls.getDiscoveryURL();
        if (discUrlList == null || discUrlList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.discurls.NoInput"));
        }
    }

    public void validateCategoryBag(CategoryBag categories) throws DispositionReportFaultMessage {
        if (categories == null) {
            return;
        }
        List elems = categories.getKeyedReference();
        List krgs = categories.getKeyedReferenceGroup();
        if (!(elems != null && elems.size() != 0 || krgs != null && krgs.size() != 0)) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.categorybag.NoInput"));
        }
        for (KeyedReference elem : elems) {
            this.validateKeyedReference(elem);
        }
        for (KeyedReference elem : krgs) {
            this.validateKeyedReferenceGroup((KeyedReferenceGroup)elem);
        }
    }

    public void validateIdentifierBag(IdentifierBag identifiers) throws DispositionReportFaultMessage {
        if (identifiers == null) {
            return;
        }
        List keyedRefList = identifiers.getKeyedReference();
        if (keyedRefList == null || keyedRefList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.identifierbag.NoInput"));
        }
        for (KeyedReference keyedRef : keyedRefList) {
            this.validateKeyedReference(keyedRef);
        }
    }

    public void validateKeyedReferenceGroup(KeyedReferenceGroup krg) throws DispositionReportFaultMessage {
        if (krg.getTModelKey() == null || krg.getTModelKey().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
        }
        krg.setTModelKey(krg.getTModelKey().toLowerCase());
        List keyedRefs = krg.getKeyedReference();
        if (keyedRefs != null && keyedRefs.size() > 0) {
            for (KeyedReference keyedRef : keyedRefs) {
                this.validateKeyedReference(keyedRef);
            }
        }
    }

    public void validateKeyedReference(KeyedReference kr) throws DispositionReportFaultMessage {
        if (kr == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NullInput"));
        }
        if (kr.getTModelKey() == null || kr.getTModelKey().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
        }
        kr.setTModelKey(kr.getTModelKey().toLowerCase());
        if (kr.getKeyValue() == null || kr.getKeyValue().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoKeyValue"));
        }
    }

    private void validateFindQualifiers(FindQualifiers findQualifiers) throws DispositionReportFaultMessage {
        if (findQualifiers == null) {
            return;
        }
        List fqList = findQualifiers.getFindQualifier();
        if (fqList == null || fqList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.findqualifiers.NoInput"));
        }
        Hashtable<String, String> fqTable = new Hashtable<String, String>();
        for (String fq : fqList) {
            String result = fqTable.put(fq.toUpperCase(), fq.toUpperCase());
            if (result != null) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.findqualifiers.DuplicateValue", result));
            }
            this.ValidateSupportedFindQualifier(fq);
            if (fq.equalsIgnoreCase("andAllKeys") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:andallkeys")) {
                if (fqTable.get("orAllKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:orallkeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orAllKeys"));
                }
                if (fqTable.get("orLikeKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:orlikekeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orLikeKeys"));
                }
            } else if (fq.equalsIgnoreCase("orAllKeys") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:orallkeys")) {
                if (fqTable.get("andAllKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:andallkeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "andAllKeys"));
                }
                if (fqTable.get("orLikeKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:orlikekeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orLikeKeys"));
                }
            } else if (fq.equalsIgnoreCase("orLikeKeys") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:orlikekeys")) {
                if (fqTable.get("andAllKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:andallkeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "andAllKeys"));
                }
                if (fqTable.get("orAllKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:orallkeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orAllKeys"));
                }
            }
            if (fq.equalsIgnoreCase("sortByNameAsc") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbynameasc")) {
                if (fqTable.get("sortByNameDesc".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:sortbynamedesc".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByNameDesc"));
                }
            } else if ((fq.equalsIgnoreCase("sortByNameDesc") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbynamedesc")) && (fqTable.get("sortByNameAsc".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:sortbynameasc".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByNameAsc"));
            }
            if (fq.equalsIgnoreCase("sortByDateAsc") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbydateasc")) {
                if (fqTable.get("sortByDateDesc".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:sortbydatedesc".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByDateDesc"));
                }
            } else if ((fq.equalsIgnoreCase("sortByDateDesc") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbydatedesc")) && (fqTable.get("sortByDateAsc".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:sortbydateasc".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByDateAsc"));
            }
            if (fq.equalsIgnoreCase("combineCategoryBags") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:combinecategorybags")) {
                if (fqTable.get("serviceSubset".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:servicesubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "serviceSubset"));
                }
                if (fqTable.get("bindingSubset".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:bindingsubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "bindingSubset"));
                }
            } else if (fq.equalsIgnoreCase("serviceSubset") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:servicesubset")) {
                if (fqTable.get("combineCategoryBags".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:combinecategorybags".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "combineCategoryBags"));
                }
                if (fqTable.get("bindingSubset".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:bindingsubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "bindingSubset"));
                }
            } else if (fq.equalsIgnoreCase("bindingSubset") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:bindingsubset")) {
                if (fqTable.get("serviceSubset".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:servicesubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "serviceSubset"));
                }
                if (fqTable.get("combineCategoryBags".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:combinecategorybags".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "combineCategoryBags"));
                }
            }
            if (fq.equalsIgnoreCase("exactMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:exactmatch")) {
                if (fqTable.get("approximateMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:approximatematch".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "approximateMatch"));
                }
            } else if ((fq.equalsIgnoreCase("approximateMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:approximatematch")) && (fqTable.get("exactMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:exactmatch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "exactMatch"));
            }
            if (fq.equalsIgnoreCase("exactMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:exactmatch")) {
                if (fqTable.get("caseInsensitiveMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:caseinsensitivematch".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseInsensitiveMatch"));
                }
            } else if ((fq.equalsIgnoreCase("caseInsensitiveMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:caseinsensitivematch")) && (fqTable.get("exactMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:exactmatch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "exactMatch"));
            }
            if (fq.equalsIgnoreCase("binarySort") || fq.equalsIgnoreCase("uddi:uddi.org:sortorder:binarysort")) {
                if (fqTable.get("UTS-10".toUpperCase()) != null || fqTable.get("uddi:uddi.org:sortorder:uts-10".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "UTS-10"));
                }
            } else if ((fq.equalsIgnoreCase("UTS-10") || fq.equalsIgnoreCase("uddi:uddi.org:sortorder:uts-10")) && (fqTable.get("binarySort".toUpperCase()) != null || fqTable.get("uddi:uddi.org:sortorder:binarysort".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "binarySort"));
            }
            if (fq.equalsIgnoreCase("diacriticSensitiveMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:diacriticssensitivematch")) {
                if (fqTable.get("diacriticInsensitiveMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:diacriticsinsensitivematch".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "diacriticInsensitiveMatch"));
                }
            } else if ((fq.equalsIgnoreCase("diacriticInsensitiveMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:diacriticsinsensitivematch")) && (fqTable.get("diacriticSensitiveMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:diacriticssensitivematch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "diacriticSensitiveMatch"));
            }
            if (fq.equalsIgnoreCase("exactMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:exactmatch")) {
                if (fqTable.get("diacriticInsensitiveMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:diacriticsinsensitivematch".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "diacriticInsensitiveMatch"));
                }
            } else if ((fq.equalsIgnoreCase("diacriticInsensitiveMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:diacriticsinsensitivematch")) && (fqTable.get("exactMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:exactmatch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "exactMatch"));
            }
            if (fq.equalsIgnoreCase("caseSensitiveSort") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:casesensitivesort")) {
                if (fqTable.get("caseInsensitiveSort".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:caseinsensitivesort".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseInsensitiveSort"));
                }
            } else if ((fq.equalsIgnoreCase("caseInsensitiveSort") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:caseinsensitivesort")) && (fqTable.get("caseSensitiveSort".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:casesensitivesort".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseSensitiveSort"));
            }
            if (fq.equalsIgnoreCase("caseSensitiveMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:casesensitivematch")) {
                if (fqTable.get("caseInsensitiveMatch".toUpperCase()) == null && fqTable.get("uddi:uddi.org:findqualifier:caseinsensitivematch".toUpperCase()) == null) continue;
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseInsensitiveMatch"));
            }
            if (!fq.equalsIgnoreCase("caseInsensitiveMatch") && !fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:caseinsensitivematch") || fqTable.get("caseSensitiveMatch".toUpperCase()) == null && fqTable.get("uddi:uddi.org:findqualifier:casesensitivematch".toUpperCase()) == null) continue;
            throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseSensitiveMatch"));
        }
    }

    private void validateFindingBindingFQ(FindQualifiers findQualifiers) throws InvalidCombinationException {
        if (findQualifiers == null) {
            return;
        }
        for (int i = 0; i < findQualifiers.getFindQualifier().size(); ++i) {
            if (((String)findQualifiers.getFindQualifier().get(i)).equals("binarySort") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:sortorder:binarysort")) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", "binarySort"));
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("caseInsensitiveMatch") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:caseinsensitivematch")) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", "caseInsensitiveMatch"));
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("caseSensitiveMatch") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:casesensitivematch")) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", "caseSensitiveMatch"));
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("caseInsensitiveSort") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:caseinsensitivesort")) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", "caseInsensitiveSort"));
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("caseSensitiveSort") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:casesensitivesort")) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", "uddi:uddi.org:findqualifier:casesensitivesort"));
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("sortByNameAsc") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbynameasc")) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", "sortByNameAsc"));
            }
            if (!((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("sortByNameDesc") && !((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbynamedesc")) continue;
            throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", "sortByNameDesc"));
        }
    }

    private void validateFindRelatedBusinessesFindQualifiers(FindQualifiers findQualifiers) throws InvalidCombinationException {
        if (findQualifiers == null) {
            return;
        }
        for (int i = 0; i < findQualifiers.getFindQualifier().size(); ++i) {
            if (!((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("andAllKeys") && !((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:andallkeys")) continue;
            throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", "andAllKeys"));
        }
    }

    private void validateFindQualifiers_AppoximateMatchAndCombinedCatbag(FindQualifiers findQualifiers) throws InvalidCombinationException {
        if (findQualifiers == null) {
            return;
        }
        boolean containsAPPROXIMATE_MATCH = false;
        boolean containsCOMBINE_CATEGORY_BAGS = false;
        for (int i = 0; i < findQualifiers.getFindQualifier().size(); ++i) {
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("approximateMatch") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:approximatematch")) {
                containsAPPROXIMATE_MATCH = true;
            }
            if (!((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("combineCategoryBags") && !((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:combinecategorybags")) continue;
            containsCOMBINE_CATEGORY_BAGS = true;
        }
        if (containsAPPROXIMATE_MATCH && containsCOMBINE_CATEGORY_BAGS) {
            throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", "combineCategoryBags & uddi:uddi.org:findqualifier:approximatematch"));
        }
    }

    private void ValidateSupportedFindQualifier(String fq) throws UnsupportedException {
        if (supportedFindqualifiers == null || supportedFindqualifiers.isEmpty()) {
            this.InitFindQualifierMap();
        }
        if (supportedFindqualifiers.get(fq.toLowerCase()) == null) {
            throw new UnsupportedException(new ErrorMessage("errors.Unsupported.findQualifier", fq));
        }
    }

    private void InitFindQualifierMap() {
        supportedFindqualifiers = new HashMap<String, Boolean>();
        supportedFindqualifiers.put("andAllKeys".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:andallkeys".toLowerCase(), true);
        supportedFindqualifiers.put("approximateMatch".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:approximatematch".toLowerCase(), true);
        supportedFindqualifiers.put("binarySort".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:sortorder:binarysort".toLowerCase(), true);
        supportedFindqualifiers.put("bindingSubset".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:bindingsubset".toLowerCase(), true);
        supportedFindqualifiers.put("caseInsensitiveMatch".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:caseinsensitivematch".toLowerCase(), true);
        supportedFindqualifiers.put("caseSensitiveMatch".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:casesensitivematch".toLowerCase(), true);
        supportedFindqualifiers.put("caseSensitiveSort".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:casesensitivesort".toLowerCase(), true);
        supportedFindqualifiers.put("combineCategoryBags".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:combinecategorybags".toLowerCase(), true);
        supportedFindqualifiers.put("diacriticInsensitiveMatch".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:diacriticsinsensitivematch".toLowerCase(), true);
        supportedFindqualifiers.put("diacriticSensitiveMatch".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:diacriticssensitivematch".toLowerCase(), true);
        supportedFindqualifiers.put("exactMatch".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:exactmatch".toLowerCase(), true);
        supportedFindqualifiers.put("orAllKeys".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:orallkeys".toLowerCase(), true);
        supportedFindqualifiers.put("orLikeKeys".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:orlikekeys".toLowerCase(), true);
        supportedFindqualifiers.put("serviceSubset".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:servicesubset".toLowerCase(), true);
        supportedFindqualifiers.put("signaturePresent".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:signaturepresent".toLowerCase(), true);
        supportedFindqualifiers.put("sortByDateAsc".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:sortbydateasc".toLowerCase(), true);
        supportedFindqualifiers.put("sortByDateDesc".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:sortbydatedesc".toLowerCase(), true);
        supportedFindqualifiers.put("sortByNameAsc".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:sortbynameasc".toLowerCase(), true);
        supportedFindqualifiers.put("sortByNameDesc".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:sortbynamedesc".toLowerCase(), true);
        supportedFindqualifiers.put("suppressProjectedServices".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:findqualifier:suppressprojectedservices".toLowerCase(), true);
        supportedFindqualifiers.put("UTS-10".toLowerCase(), true);
        supportedFindqualifiers.put("uddi:uddi.org:sortorder:uts-10".toLowerCase(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateServiceExists(String serviceKey) throws InvalidKeyPassedException {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            BusinessService modelBusinessService = null;
            try {
                modelBusinessService = (BusinessService)em.find(BusinessService.class, (Object)serviceKey);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (modelBusinessService == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", serviceKey));
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

