/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.List;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.api_v3.SaveNode;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.client.transport.RMITransport;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class ValidateNode
extends ValidateUDDIApi {
    private static final Logger logger = Logger.getLogger(ValidateNode.class.getCanonicalName());

    public ValidateNode(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateSaveNode(EntityManager em, SaveNode body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List nodes = body.getNode();
        if (nodes == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.saveNodes.NoInput"));
        }
        for (Node clerk : body.getNode()) {
            this.validateNode(clerk);
        }
    }

    public void validateNode(Node node) throws DispositionReportFaultMessage {
        if (node == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NullInput"));
        }
        String name = node.getName();
        if (name == null || name.length() == 0 || name.length() > 255 || node.getClientName() == null || node.getClientName().length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoName"));
        }
        if (node.getDescription() == null || node.getDescription().length() == 0 || node.getDescription().length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoDescription"));
        }
        if (node.getClientName() == null || node.getClientName().length() == 0 || node.getClientName().length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoClientName"));
        }
        if (node.getCustodyTransferUrl() == null || node.getCustodyTransferUrl().length() == 0 || node.getClientName().length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoNCT"));
        }
        if (node.getInquiryUrl() == null || node.getInquiryUrl().length() == 0 || node.getInquiryUrl().length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoIN"));
        }
        if (node.getPublishUrl() == null || node.getPublishUrl().length() == 0 || node.getPublishUrl().length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoPUB"));
        }
        if (node.getSubscriptionListenerUrl() == null || node.getSubscriptionListenerUrl().length() == 0 || node.getSubscriptionListenerUrl().length() > 255) {
            // empty if block
        }
        if (node.getReplicationUrl() == null || node.getReplicationUrl().length() == 0 || node.getReplicationUrl().length() > 255) {
            // empty if block
        }
        if (node.getSubscriptionUrl() == null || node.getSubscriptionUrl().length() == 0 || node.getSubscriptionUrl().length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoSUB"));
        }
        if (node.getSecurityUrl() == null || node.getSecurityUrl().length() == 0 || node.getSecurityUrl().length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoSec"));
        }
        if (node.getProxyTransport() == null || node.getProxyTransport().length() == 0 || node.getProxyTransport().length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoProxy"));
        }
        try {
            Class<?> forName = Class.forName(node.getProxyTransport());
            Object j = forName.newInstance();
            if (!(j instanceof Transport)) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.node.illegalProxyTransport"));
            }
        }
        catch (Exception ex) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.illegalProxyTransport"));
        }
        if (node.getProxyTransport().equalsIgnoreCase(RMITransport.class.getCanonicalName())) {
            if (node.getFactoryInitial() == null || node.getFactoryInitial().length() == 0 || node.getFactoryInitial().length() > 255) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoRMIData"));
            }
            if (node.getFactoryNamingProvider() == null || node.getFactoryNamingProvider().length() == 0 || node.getFactoryNamingProvider().length() > 255) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoRMIData"));
            }
            if (node.getFactoryURLPkgs() == null || node.getFactoryURLPkgs().length() == 0 || node.getFactoryURLPkgs().length() > 255) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoRMIDataF"));
            }
        }
    }
}

