/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.ws.Holder;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.api_v3.DeleteClerk;
import org.apache.juddi.api_v3.DeleteNode;
import org.apache.juddi.api_v3.DeletePublisher;
import org.apache.juddi.api_v3.SavePublisher;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.keygen.KeyGenerator;
import org.apache.juddi.keygen.KeyGeneratorFactory;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.PublisherAssertionId;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.query.FindBusinessByPublisherQuery;
import org.apache.juddi.query.FindTModelByPublisherQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.v3.client.config.TokenResolver;
import org.apache.juddi.v3.client.cryptor.CryptorFactory;
import org.apache.juddi.v3.client.cryptor.DigSigUtil;
import org.apache.juddi.v3.error.AssertionNotFoundException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.InvalidProjectionException;
import org.apache.juddi.v3.error.KeyUnavailableException;
import org.apache.juddi.v3.error.MaxEntitiesExceededException;
import org.apache.juddi.v3.error.UserMismatchException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidateSubscription;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.apache.juddi.validation.ValidateUDDIKey;
import org.apache.juddi.validation.ValidateValuesFromWebService;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.Address;
import org.uddi.api_v3.AddressLine;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Contact;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.Email;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.HostingRedirector;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.Phone;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.repl_v3.CommunicationGraph;
import org.uddi.repl_v3.ReplicationConfiguration;
import org.uddi.sub_v3.Subscription;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class ValidatePublish
extends ValidateUDDIApi {
    private static final Log log = LogFactory.getLog(ValidatePublish.class);
    private DigSigUtil ds = null;

    public ValidatePublish(UddiEntityPublisher publisher, String nodeid) {
        super(publisher, nodeid);
    }

    public ValidatePublish(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateDeleteBusiness(EntityManager em, DeleteBusiness body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getBusinessKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(org.apache.juddi.model.BusinessEntity.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", entityKey));
            }
            if (!this.publisher.isOwner((UddiEntity)obj) && !((Publisher)this.publisher).isAdmin()) {
                throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
            }
            ++i;
        }
    }

    public void validateDeleteService(EntityManager em, DeleteService body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getServiceKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(BusinessService.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", entityKey));
            }
            this.AccessCheck(obj, entityKey);
            ++i;
        }
    }

    public void validateDeleteBinding(EntityManager em, DeleteBinding body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getBindingKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            ValidatePublish.validateKeyLength(entityKey);
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(org.apache.juddi.model.BindingTemplate.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BindingTemplateNotFound", entityKey));
            }
            this.AccessCheck(obj, entityKey);
            ++i;
        }
    }

    public void validateDeleteTModel(EntityManager em, DeleteTModel body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getTModelKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            ValidatePublish.validateKeyLength(entityKey);
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(Tmodel.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", entityKey));
            }
            this.AccessCheck(obj, entityKey);
            ++i;
        }
    }

    private void AccessCheck(Object obj, String entityKey) throws UserMismatchException {
        boolean accessCheck = false;
        if (!((UddiEntity)obj).getNodeId().equals(this.nodeID)) {
            throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidNode", entityKey + " Owning Node: " + ((UddiEntity)obj).getNodeId() + ", this node: " + this.nodeID));
        }
        if (this.publisher.isOwner((UddiEntity)obj) && this.nodeID.equals(((UddiEntity)obj).getNodeId())) {
            accessCheck = true;
        }
        if (((Publisher)this.publisher).isAdmin() && this.nodeID.equals(((UddiEntity)obj).getNodeId())) {
            accessCheck = true;
        }
        if (!accessCheck) {
            throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
        }
    }

    public void validateDeletePublisherAssertions(EntityManager em, DeletePublisherAssertions body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getPublisherAssertion();
        if (entityList == null || entityList.size() == 0) {
            throw new AssertionNotFoundException(new ErrorMessage("errors.pubassertion.NoPubAssertions"));
        }
        for (PublisherAssertion entity : entityList) {
            ValidatePublish.validateKeyLength(entity.getFromKey());
            ValidatePublish.validateKeyLength(entity.getToKey());
            this.validatePublisherAssertion(em, entity);
            PublisherAssertionId pubAssertionId = new PublisherAssertionId(entity.getFromKey(), entity.getToKey());
            Object obj = em.find(org.apache.juddi.model.PublisherAssertion.class, (Object)pubAssertionId);
            if (obj == null) {
                throw new AssertionNotFoundException(new ErrorMessage("errors.pubassertion.AssertionNotFound", entity.getFromKey() + ", " + entity.getToKey()));
            }
            org.apache.juddi.model.PublisherAssertion pubAssertion = (org.apache.juddi.model.PublisherAssertion)obj;
            KeyedReference keyedRef = entity.getKeyedReference();
            if (keyedRef == null) {
                throw new AssertionNotFoundException(new ErrorMessage("errors.pubassertion.AssertionNotFound", entity.getFromKey() + ", " + entity.getToKey()));
            }
            if (!(pubAssertion.getTmodelKey().equalsIgnoreCase(keyedRef.getTModelKey()) && pubAssertion.getKeyName().equalsIgnoreCase(keyedRef.getKeyName()) && pubAssertion.getKeyValue().equalsIgnoreCase(keyedRef.getKeyValue()))) {
                throw new AssertionNotFoundException(new ErrorMessage("errors.pubassertion.AssertionNotFound", entity.getFromKey() + ", " + entity.getToKey()));
            }
            if (this.publisher.isOwner(pubAssertion.getBusinessEntityByToKey()) || this.publisher.isOwner(pubAssertion.getBusinessEntityByFromKey())) continue;
            throw new UserMismatchException(new ErrorMessage("errors.usermismatch.assertion"));
        }
    }

    public void validateSaveBusiness(EntityManager em, SaveBusiness body, Configuration config, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        if (config == null) {
            try {
                config = AppConfig.getConfiguration();
            }
            catch (ConfigurationException ce) {
                log.error((Object)("Could not optain config. " + ce.getMessage()), (Throwable)ce);
            }
        }
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getBusinessEntity();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.savebusiness.NoInput"));
        }
        for (BusinessEntity entity : entityList) {
            this.validateBusinessEntity(em, entity, config, publisher);
        }
        this.validateCheckedTModelsBE(entityList, config);
    }

    public void validateSaveBusinessMax(EntityManager em) throws DispositionReportFaultMessage {
        List<?> businessKeysFound;
        Publisher publisher = (Publisher)em.find(Publisher.class, (Object)this.getPublisher().getAuthorizedName());
        Integer maxBusinesses = publisher.getMaxBusinesses();
        try {
            if (maxBusinesses == null) {
                maxBusinesses = AppConfig.getConfiguration().containsKey("juddi.maxBusinessesPerPublisher") ? AppConfig.getConfiguration().getInteger("juddi.maxBusinessesPerPublisher", Integer.valueOf(-1)) : Integer.valueOf(-1);
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            maxBusinesses = -1;
        }
        if (maxBusinesses > 0 && (businessKeysFound = FindBusinessByPublisherQuery.select(em, null, publisher, null)) != null && businessKeysFound.size() > maxBusinesses) {
            throw new MaxEntitiesExceededException(new ErrorMessage("errors.save.maxBusinessesExceeded"));
        }
    }

    public void validateSaveService(EntityManager em, SaveService body, Configuration config, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        if (config == null) {
            try {
                config = AppConfig.getConfiguration();
            }
            catch (ConfigurationException ce) {
                log.error((Object)("Could not optain config. " + ce.getMessage()), (Throwable)ce);
            }
        }
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getBusinessService();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.saveservice.NoInput"));
        }
        for (org.uddi.api_v3.BusinessService entity : entityList) {
            this.validateBusinessService(em, entity, null, config, publisher);
        }
        this.validateCheckedTModelsBS(entityList, config);
    }

    public void validateSaveServiceMax(EntityManager em, String businessKey) throws DispositionReportFaultMessage {
        org.apache.juddi.model.BusinessEntity modelBusinessEntity;
        Publisher publisher = (Publisher)em.find(Publisher.class, (Object)this.getPublisher().getAuthorizedName());
        Integer maxServices = publisher.getMaxBusinesses();
        try {
            if (maxServices == null) {
                maxServices = AppConfig.getConfiguration().containsKey("juddi.maxServicesPerBusiness") ? AppConfig.getConfiguration().getInteger("juddi.maxServicesPerBusiness", Integer.valueOf(-1)) : Integer.valueOf(-1);
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            maxServices = -1;
        }
        if (maxServices > 0 && (modelBusinessEntity = (org.apache.juddi.model.BusinessEntity)em.find(org.apache.juddi.model.BusinessEntity.class, (Object)businessKey)).getBusinessServices() != null && modelBusinessEntity.getBusinessServices().size() > maxServices) {
            throw new MaxEntitiesExceededException(new ErrorMessage("errors.save.maxServicesExceeded"));
        }
    }

    public void validateSaveBinding(EntityManager em, SaveBinding body, Configuration config, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        if (config == null) {
            try {
                config = AppConfig.getConfiguration();
            }
            catch (ConfigurationException ce) {
                log.error((Object)("Could not optain config. " + ce.getMessage()), (Throwable)ce);
            }
        }
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getBindingTemplate();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.savebinding.NoInput"));
        }
        for (BindingTemplate entity : entityList) {
            this.validateBindingTemplate(em, entity, null, config, publisher);
        }
        this.validateCheckedTModelsBT(entityList, config);
    }

    public void validateSaveBindingMax(EntityManager em, String serviceKey) throws DispositionReportFaultMessage {
        BusinessService modelBusinessService;
        Publisher publisher = (Publisher)em.find(Publisher.class, (Object)this.getPublisher().getAuthorizedName());
        Integer maxBindings = publisher.getMaxBindingsPerService();
        try {
            if (maxBindings == null) {
                maxBindings = AppConfig.getConfiguration().containsKey("juddi.maxBindingsPerService") ? AppConfig.getConfiguration().getInteger("juddi.maxBindingsPerService", Integer.valueOf(-1)) : Integer.valueOf(-1);
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            maxBindings = -1;
        }
        if (maxBindings > 0 && (modelBusinessService = (BusinessService)em.find(BusinessService.class, (Object)serviceKey)).getBindingTemplates() != null && modelBusinessService.getBindingTemplates().size() > maxBindings) {
            throw new MaxEntitiesExceededException(new ErrorMessage("errors.save.maxBindingsExceeded"));
        }
    }

    public void validateSaveTModel(EntityManager em, SaveTModel body, Configuration config, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        if (config == null) {
            try {
                config = AppConfig.getConfiguration();
            }
            catch (ConfigurationException ce) {
                log.error((Object)("Could not optain config. " + ce.getMessage()), (Throwable)ce);
            }
        }
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getTModel();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.savetmodel.NoInput"));
        }
        for (TModel entity : entityList) {
            this.validateTModel(em, entity, config, publisher);
        }
        this.validateCheckedTModelsTM(entityList, config);
    }

    public void validateSaveTModelMax(EntityManager em) throws DispositionReportFaultMessage {
        List<?> tmodelKeysFound;
        Publisher publisher = (Publisher)em.find(Publisher.class, (Object)this.getPublisher().getAuthorizedName());
        Integer maxTModels = publisher.getMaxTmodels();
        try {
            if (maxTModels == null) {
                maxTModels = AppConfig.getConfiguration().containsKey("juddi.maxTModelsPerPublisher") ? AppConfig.getConfiguration().getInteger("juddi.maxTModelsPerPublisher", Integer.valueOf(-1)) : Integer.valueOf(-1);
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            maxTModels = -1;
        }
        if (maxTModels > 0 && (tmodelKeysFound = FindTModelByPublisherQuery.select(em, null, publisher, null, new DynamicQuery.Parameter[0])) != null && tmodelKeysFound.size() > maxTModels) {
            throw new MaxEntitiesExceededException(new ErrorMessage("errors.save.maxTModelsExceeded"));
        }
    }

    public void validateAddPublisherAssertions(EntityManager em, AddPublisherAssertions body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getPublisherAssertion();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.addpublisherassertions.NoInput"));
        }
        for (PublisherAssertion entity : entityList) {
            this.validatePublisherAssertion(em, entity);
        }
    }

    public void validateSetPublisherAssertions(EntityManager em, Holder<List<PublisherAssertion>> body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = (List)body.value;
        if (entityList != null && entityList.size() > 0) {
            for (PublisherAssertion entity : entityList) {
                this.validatePublisherAssertion(em, entity);
            }
        }
    }

    void validateNotSigned(BusinessEntity item) throws ValueNotAllowedException {
        if (item == null) {
            return;
        }
        if (item.getBusinessKey() == null && !item.getSignature().isEmpty()) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.entity.SignedButNoKey", "businessKey"));
        }
        if (item.getBusinessServices() != null && !item.getSignature().isEmpty()) {
            for (int i = 0; i < item.getBusinessServices().getBusinessService().size(); ++i) {
                if (((org.uddi.api_v3.BusinessService)item.getBusinessServices().getBusinessService().get(i)).getBusinessKey() == null || ((org.uddi.api_v3.BusinessService)item.getBusinessServices().getBusinessService().get(i)).getBusinessKey().length() == 0) {
                    throw new ValueNotAllowedException(new ErrorMessage("errors.entity.SignedButNoKey", "business/Service(" + i + ")/businessKey"));
                }
                if (((org.uddi.api_v3.BusinessService)item.getBusinessServices().getBusinessService().get(i)).getServiceKey() == null || ((org.uddi.api_v3.BusinessService)item.getBusinessServices().getBusinessService().get(i)).getServiceKey().length() == 0) {
                    throw new ValueNotAllowedException(new ErrorMessage("errors.entity.SignedButNoKey", "business/Service(" + i + ")/serviceKey"));
                }
                if (((org.uddi.api_v3.BusinessService)item.getBusinessServices().getBusinessService().get(i)).getBindingTemplates() == null) continue;
                for (int k = 0; k < ((org.uddi.api_v3.BusinessService)item.getBusinessServices().getBusinessService().get(i)).getBindingTemplates().getBindingTemplate().size(); ++k) {
                    if (((BindingTemplate)((org.uddi.api_v3.BusinessService)item.getBusinessServices().getBusinessService().get(i)).getBindingTemplates().getBindingTemplate().get(k)).getBindingKey() != null && ((BindingTemplate)((org.uddi.api_v3.BusinessService)item.getBusinessServices().getBusinessService().get(i)).getBindingTemplates().getBindingTemplate().get(k)).getBindingKey().length() != 0) continue;
                    throw new ValueNotAllowedException(new ErrorMessage("errors.entity.SignedButNoKey", "business/Service(" + i + ")/bindingTemplate)" + k + ")/bindingKey"));
                }
            }
        }
    }

    void validateNotSigned(BindingTemplate item) throws ValueNotAllowedException {
        if (item == null) {
            return;
        }
        if (item.getBindingKey() == null && !item.getSignature().isEmpty()) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.entity.SignedButNoKey", "bindingKey"));
        }
        if (item.getServiceKey() == null && !item.getSignature().isEmpty()) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.entity.SignedButNoKey", "serviceKey"));
        }
    }

    void validateNotSigned(TModel item) throws ValueNotAllowedException {
        if (item == null) {
            return;
        }
        if (item.getTModelKey() == null && !item.getSignature().isEmpty()) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.entity.SignedButNoKey", "tModelKey"));
        }
    }

    void validateNotSigned(org.uddi.api_v3.BusinessService item) throws ValueNotAllowedException {
        if (item == null) {
            return;
        }
        if (item.getBusinessKey() == null && !item.getSignature().isEmpty()) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.entity.SignedButNoKey", "businessKey"));
        }
        if (item.getServiceKey() == null && !item.getSignature().isEmpty()) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.entity.SignedButNoKey", "serviceKey"));
        }
        if (item.getBindingTemplates() != null && !item.getSignature().isEmpty()) {
            for (int i = 0; i < item.getBindingTemplates().getBindingTemplate().size(); ++i) {
                if (((BindingTemplate)item.getBindingTemplates().getBindingTemplate().get(i)).getBindingKey() != null && ((BindingTemplate)item.getBindingTemplates().getBindingTemplate().get(i)).getBindingKey().length() != 0) continue;
                throw new ValueNotAllowedException(new ErrorMessage("errors.entity.SignedButNoKey", "businessService/bindingTemplate(" + i + ")/bindingKey"));
            }
        }
    }

    public void validateBusinessEntity(EntityManager em, BusinessEntity businessEntity, Configuration config, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        if (businessEntity == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.businessentity.NullInput"));
        }
        boolean entityExists = false;
        this.validateNotSigned(businessEntity);
        String entityKey = businessEntity.getBusinessKey();
        if (entityKey == null || entityKey.length() == 0) {
            KeyGenerator keyGen = KeyGeneratorFactory.getKeyGenerator();
            entityKey = keyGen.generate(publisher);
            businessEntity.setBusinessKey(entityKey);
        } else {
            entityKey = entityKey.toLowerCase();
            businessEntity.setBusinessKey(entityKey);
            ValidatePublish.validateKeyLength(entityKey);
            Object obj = em.find(org.apache.juddi.model.BusinessEntity.class, (Object)entityKey);
            if (obj != null) {
                entityExists = true;
                this.AccessCheck(obj, entityKey);
            } else {
                ValidateUDDIKey.validateUDDIv3Key(entityKey);
                if (!publisher.isValidPublisherKey(em, entityKey)) {
                    throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
                }
            }
        }
        if (!entityExists && !ValidatePublish.isUniqueKey(em, entityKey)) {
            throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.KeyExists", entityKey));
        }
        this.validateNames(businessEntity.getName());
        this.validateDiscoveryUrls(businessEntity.getDiscoveryURLs());
        this.validateContacts(businessEntity.getContacts(), config);
        this.validateCategoryBag(businessEntity.getCategoryBag(), config, false);
        this.validateIdentifierBag(businessEntity.getIdentifierBag(), config, false);
        this.validateDescriptions(businessEntity.getDescription());
        this.validateBusinessServices(em, businessEntity.getBusinessServices(), businessEntity, config, publisher);
        this.validateSignaturesBusiness(businessEntity, config);
    }

    public void validateBusinessServices(EntityManager em, BusinessServices businessServices, BusinessEntity parent, Configuration config, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        if (businessServices == null) {
            return;
        }
        List businessServiceList = businessServices.getBusinessService();
        if (businessServiceList == null || businessServiceList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.businessservices.NoInput"));
        }
        for (org.uddi.api_v3.BusinessService businessService : businessServiceList) {
            this.validateBusinessService(em, businessService, parent, config, publisher);
        }
    }

    public void validateBusinessService(EntityManager em, org.uddi.api_v3.BusinessService businessService, BusinessEntity parent, Configuration config, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        String parentKey;
        if (businessService == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.businessservice.NullInput"));
        }
        this.validateNotSigned(businessService);
        String entityKey = businessService.getServiceKey();
        if (entityKey != null && entityKey.length() > 0) {
            entityKey = entityKey.toLowerCase();
            ValidatePublish.validateKeyLength(entityKey);
            businessService.setServiceKey(entityKey);
        }
        if ((parentKey = businessService.getBusinessKey()) != null && parentKey.length() > 0) {
            parentKey = parentKey.toLowerCase();
            businessService.setBusinessKey(parentKey);
        }
        boolean isProjection = false;
        if (parent != null) {
            if (parentKey != null && parentKey.length() > 0) {
                if (!parentKey.equalsIgnoreCase(parent.getBusinessKey())) {
                    if (entityKey == null || entityKey.length() == 0) {
                        throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceKeyNotProvidedWithProjection", parentKey + ", " + parent.getBusinessKey()));
                    }
                    isProjection = true;
                }
            } else {
                parentKey = parent.getBusinessKey();
            }
        }
        if (isProjection) {
            Object obj = em.find(BusinessService.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ProjectedServiceNotFound", parentKey + ", " + entityKey));
            }
            BusinessService bs = (BusinessService)obj;
            if (!businessService.getBusinessKey().equalsIgnoreCase(bs.getBusinessEntity().getEntityKey())) {
                throw new InvalidProjectionException(new ErrorMessage("errors.invalidprojection.ParentMismatch", businessService.getBusinessKey() + ", " + bs.getBusinessEntity().getEntityKey()));
            }
            obj = null;
        } else {
            boolean entityExists = false;
            if (entityKey == null || entityKey.length() == 0) {
                KeyGenerator keyGen = KeyGeneratorFactory.getKeyGenerator();
                entityKey = keyGen.generate(publisher);
                businessService.setServiceKey(entityKey);
            } else {
                Object obj = em.find(BusinessService.class, (Object)entityKey);
                if (obj != null) {
                    entityExists = true;
                    BusinessService bs = (BusinessService)obj;
                    if (parentKey == null || parentKey.length() == 0) {
                        parentKey = bs.getBusinessEntity().getEntityKey();
                        businessService.setBusinessKey(parentKey);
                    }
                    this.AccessCheck(obj, entityKey);
                    if (!parentKey.equalsIgnoreCase(bs.getBusinessEntity().getEntityKey())) {
                        if (!publisher.isOwner(bs.getBusinessEntity())) {
                            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.businessservice.ParentMismatch", parentKey + ", " + bs.getBusinessEntity().getEntityKey()));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Services moved from business " + bs.getBusinessEntity() + " to " + businessService.getBusinessKey()));
                        }
                    }
                } else {
                    ValidateUDDIKey.validateUDDIv3Key(entityKey);
                    if (!publisher.isValidPublisherKey(em, entityKey)) {
                        throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
                    }
                }
            }
            if (!(entityExists || parentKey != null && parentKey.length() != 0)) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentBusinessNotFound", parentKey));
            }
            if (parentKey != null && parent == null) {
                Object parentTemp = em.find(org.apache.juddi.model.BusinessEntity.class, (Object)parentKey);
                if (parentTemp == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentBusinessNotFound", parentKey));
                }
                this.AccessCheck(parentTemp, parentKey);
            }
            if (!entityExists && !ValidatePublish.isUniqueKey(em, entityKey)) {
                throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.KeyExists", entityKey));
            }
            this.validateNames(businessService.getName());
            this.validateCategoryBag(businessService.getCategoryBag(), config, false);
            this.validateDescriptions(businessService.getDescription());
            this.validateBindingTemplates(em, businessService.getBindingTemplates(), businessService, config, publisher);
            this.validateSignaturesService(businessService, config);
        }
    }

    public void validateBindingTemplates(EntityManager em, BindingTemplates bindingTemplates, org.uddi.api_v3.BusinessService parent, Configuration config, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        if (bindingTemplates == null) {
            return;
        }
        List bindingTemplateList = bindingTemplates.getBindingTemplate();
        if (bindingTemplateList == null || bindingTemplateList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.bindingtemplates.NoInput"));
        }
        for (BindingTemplate bindingTemplate : bindingTemplateList) {
            this.validateBindingTemplate(em, bindingTemplate, parent, config, publisher);
        }
    }

    public void validateBindingTemplate(EntityManager em, BindingTemplate bindingTemplate, org.uddi.api_v3.BusinessService parent, Configuration config, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        String parentKey;
        if (bindingTemplate == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.bindingtemplate.NullInput"));
        }
        String entityKey = bindingTemplate.getBindingKey();
        if (entityKey != null && entityKey.length() > 0) {
            entityKey = entityKey.toLowerCase();
            bindingTemplate.setBindingKey(entityKey);
            ValidatePublish.validateKeyLength(entityKey);
        }
        if ((parentKey = bindingTemplate.getServiceKey()) != null && parentKey.length() > 0) {
            parentKey = parentKey.toLowerCase();
            bindingTemplate.setServiceKey(parentKey);
        }
        if (parent != null) {
            if (parentKey != null && parentKey.length() > 0) {
                if (!parentKey.equalsIgnoreCase(parent.getServiceKey())) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.bindingtemplate.ParentMismatch", parentKey + ", " + parent.getBusinessKey()));
                }
            } else {
                parentKey = parent.getServiceKey();
            }
        }
        boolean entityExists = false;
        if (entityKey == null || entityKey.length() == 0) {
            this.validateNotSigned(bindingTemplate);
            KeyGenerator keyGen = KeyGeneratorFactory.getKeyGenerator();
            entityKey = keyGen.generate(publisher);
            bindingTemplate.setBindingKey(entityKey);
        } else {
            Object obj = em.find(org.apache.juddi.model.BindingTemplate.class, (Object)entityKey);
            if (obj != null) {
                entityExists = true;
                org.apache.juddi.model.BindingTemplate bt = (org.apache.juddi.model.BindingTemplate)obj;
                if (parentKey == null || parentKey.length() == 0) {
                    parentKey = bt.getBusinessService().getEntityKey();
                    bindingTemplate.setServiceKey(parentKey);
                }
                if (!parentKey.equalsIgnoreCase(bt.getBusinessService().getEntityKey())) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.bindingtemplate.ParentMismatch", parentKey + ", " + bt.getBusinessService().getEntityKey()));
                }
                this.AccessCheck(obj, entityKey);
            } else {
                ValidateUDDIKey.validateUDDIv3Key(entityKey);
                if (!publisher.isValidPublisherKey(em, entityKey)) {
                    throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
                }
            }
        }
        if (!(entityExists || parentKey != null && parentKey.length() != 0)) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentServiceNotFound", parentKey));
        }
        if (parentKey != null && parent == null) {
            Object parentTemp = em.find(BusinessService.class, (Object)parentKey);
            if (parentTemp == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentBusinessNotFound", parentKey));
            }
            if (!(parentTemp instanceof BusinessService)) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentBusinessNotFound", parentKey));
            }
            this.AccessCheck(parentTemp, parentKey);
        }
        if (!entityExists && !ValidatePublish.isUniqueKey(em, entityKey)) {
            throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.KeyExists", entityKey));
        }
        if (bindingTemplate.getAccessPoint() == null && bindingTemplate.getHostingRedirector() == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.bindingtemplate.NoAccessPoint"));
        }
        if (bindingTemplate.getAccessPoint() != null && bindingTemplate.getHostingRedirector() != null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.bindingtemplate.NoAccessPoint"));
        }
        this.validateCategoryBag(bindingTemplate.getCategoryBag(), config, false);
        this.validateTModelInstanceDetails(bindingTemplate.getTModelInstanceDetails(), config, false);
        this.validateAccessPoint(em, bindingTemplate.getAccessPoint(), config);
        this.validateDescriptions(bindingTemplate.getDescription());
        this.validateHostingRedirector(em, bindingTemplate.getHostingRedirector(), config);
        this.validateSignaturesBinding(bindingTemplate, config);
    }

    public void validateTModel(EntityManager em, TModel tModel, Configuration config, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        if (tModel == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodel.NullInput"));
        }
        boolean entityExists = false;
        String entityKey = tModel.getTModelKey();
        if (entityKey == null || entityKey.length() == 0) {
            KeyGenerator keyGen = KeyGeneratorFactory.getKeyGenerator();
            entityKey = keyGen.generate(publisher);
            this.validateNotSigned(tModel);
            tModel.setTModelKey(entityKey);
        } else {
            entityKey = entityKey.toLowerCase();
            tModel.setTModelKey(entityKey);
            Object obj = em.find(Tmodel.class, (Object)entityKey);
            if (obj != null) {
                entityExists = true;
                this.AccessCheck(obj, entityKey);
            } else if (entityKey.toUpperCase().contains("keygenerator".toUpperCase())) {
                ValidateUDDIKey.validateUDDIv3KeyGeneratorTModel(tModel);
                String rootPublisherStr = "root";
                try {
                    rootPublisherStr = AppConfig.getConfiguration().getString("juddi.root.publisher");
                }
                catch (ConfigurationException ce) {
                    log.error((Object)"Could not read the root publisher setting in the configuration.");
                }
                if (publisher.getAuthorizedName().equals(rootPublisherStr)) {
                    throw new FatalErrorException(new ErrorMessage("errors.tmodel.keygenerator.RootKeyGen"));
                }
                if (!publisher.isKeyGeneratorAvailable(em, entityKey)) {
                    throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
                }
            } else {
                ValidateUDDIKey.validateUDDIv3Key(entityKey);
                if (!entityKey.toUpperCase().startsWith("UUID:") && !publisher.isValidPublisherKey(em, entityKey)) {
                    throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
                }
            }
        }
        if (!entityExists && !ValidatePublish.isUniqueKey(em, entityKey)) {
            throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.KeyExists", entityKey));
        }
        ValidatePublish.validateKeyLength(entityKey);
        if (tModel.getName() == null || tModel.getName().getValue() == null || tModel.getName().getValue().equals("")) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodel.NoName"));
        }
        this.validateCategoryBag(tModel.getCategoryBag(), config, false);
        this.validateIdentifierBag(tModel.getIdentifierBag(), config, false);
        this.validateDescriptions(tModel.getDescription());
        this.validateNameLength(tModel.getName().getValue());
        ValidatePublish.validateLang(tModel.getName().getLang());
        List overviewDocList = tModel.getOverviewDoc();
        if (overviewDocList != null) {
            for (OverviewDoc overviewDoc : overviewDocList) {
                this.validateOverviewDoc(overviewDoc);
            }
        }
        this.validateSignaturesTModel(tModel, config);
    }

    public void validatePublisherAssertion(EntityManager em, PublisherAssertion pubAssertion) throws DispositionReportFaultMessage {
        if (pubAssertion == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.pubassertion.NullInput"));
        }
        KeyedReference keyedRef = pubAssertion.getKeyedReference();
        if (keyedRef == null || keyedRef.getTModelKey() == null || keyedRef.getTModelKey().length() == 0 || keyedRef.getKeyName() == null || keyedRef.getKeyName().length() == 0 || keyedRef.getKeyValue() == null || keyedRef.getKeyValue().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.pubassertion.BlankKeyedRef"));
        }
        String fromKey = pubAssertion.getFromKey();
        if (fromKey == null || fromKey.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.pubassertion.BlankFromKey"));
        }
        String toKey = pubAssertion.getToKey();
        if (toKey == null || toKey.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.pubassertion.BlankToKey"));
        }
        if (fromKey.equalsIgnoreCase(toKey)) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.pubassertion.SameBusinessKey"));
        }
        fromKey = fromKey.toLowerCase();
        pubAssertion.setFromKey(fromKey);
        toKey = toKey.toLowerCase();
        pubAssertion.setToKey(toKey);
        ValidatePublish.validateKeyLength(toKey);
        ValidatePublish.validateKeyLength(fromKey);
        Object fromObj = em.find(org.apache.juddi.model.BusinessEntity.class, (Object)fromKey);
        if (fromObj == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", fromKey));
        }
        Object toObj = em.find(org.apache.juddi.model.BusinessEntity.class, (Object)pubAssertion.getToKey());
        if (toObj == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", toKey));
        }
        if (!this.publisher.isOwner((UddiEntity)fromObj) && !this.publisher.isOwner((UddiEntity)toObj)) {
            throw new UserMismatchException(new ErrorMessage("errors.pubassertion.UserMismatch", fromKey + " & " + toKey));
        }
        try {
            this.validateKeyedReference(pubAssertion.getKeyedReference(), AppConfig.getConfiguration(), false);
        }
        catch (ConfigurationException ce) {
            log.error((Object)("Could not optain config. " + ce.getMessage()), (Throwable)ce);
        }
    }

    public void validateNames(List<Name> names) throws DispositionReportFaultMessage {
        if (names == null || names.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.names.NoInput"));
        }
        for (Name n : names) {
            if (n.getValue() == null || n.getValue().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.names.NoValue"));
            }
            this.validateNameLength(n.getValue());
            ValidatePublish.validateLang(n.getLang());
        }
    }

    public void validateContacts(Contacts contacts, Configuration config) throws DispositionReportFaultMessage {
        if (contacts == null) {
            return;
        }
        List contactList = contacts.getContact();
        if (contactList == null || contactList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.contacts.NoInput"));
        }
        for (Contact contact : contactList) {
            this.validateContact(contact, config);
        }
    }

    public void validateContact(Contact contact, Configuration config) throws DispositionReportFaultMessage {
        if (log.isDebugEnabled()) {
            log.debug((Object)"validateContact");
        }
        if (contact == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.contact.NullInput"));
        }
        List pnameList = contact.getPersonName();
        if (pnameList == null || pnameList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.contact.NoPersonName"));
        }
        for (PersonName pn : pnameList) {
            if (pn.getValue() == null || pn.getValue().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.contacts.NoPersonName"));
            }
            this.validateNameLength(pn.getValue());
            ValidatePublish.validateLang(pn.getLang());
        }
        List addressList = contact.getAddress();
        if (addressList != null) {
            for (Address address : addressList) {
                if (address == null) continue;
                this.validateSortCode(address.getSortCode());
                ValidatePublish.validateKeyLength(address.getTModelKey());
                ValidatePublish.validateLang(address.getLang());
                ValidatePublish.validateUseType(address.getUseType());
                boolean checked = true;
                if (address.getTModelKey() != null) {
                    address.setTModelKey(address.getTModelKey().toLowerCase());
                    this.validatedAddressLinesIfKeyDefined(address.getAddressLine());
                    checked = this.verifyTModelKeyExistsAndChecked(address.getTModelKey(), config);
                }
                if (address.getAddressLine() == null || address.getAddressLine().size() == 0) {
                    throw new ValueNotAllowedException(new ErrorMessage("errors.contact.NoAddressLine"));
                }
                if (!checked) continue;
                this.validateAddressLines(address.getAddressLine(), config);
            }
        }
        this.validateEmailAddress(contact.getEmail());
        this.validatePhone(contact.getPhone());
        this.validateDescriptions(contact.getDescription());
        ValidatePublish.validateUseType(contact.getUseType());
    }

    public void validateDiscoveryUrls(DiscoveryURLs discUrls) throws DispositionReportFaultMessage {
        if (discUrls == null) {
            return;
        }
        List discUrlList = discUrls.getDiscoveryURL();
        if (discUrlList == null || discUrlList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.discurls.NoInput"));
        }
        for (DiscoveryURL url : discUrlList) {
            if (url.getValue() == null || url.getValue().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.discurls.NoInput"));
            }
            this.validateDiscoveryUrlLength(url);
        }
    }

    public void validateCategoryBag(CategoryBag categories, Configuration config, boolean isRoot) throws DispositionReportFaultMessage {
        if (categories == null) {
            return;
        }
        List elems = categories.getKeyedReference();
        List groups = categories.getKeyedReferenceGroup();
        if (groups.size() == 0 && elems.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.categorybag.NoInput"));
        }
        for (KeyedReferenceGroup group : groups) {
            this.validateKeyedReferenceGroup(group, config, isRoot);
        }
        for (KeyedReference elem : elems) {
            this.validateKeyedReference(elem, config, isRoot);
        }
    }

    public void validateIdentifierBag(IdentifierBag identifiers, Configuration config, boolean isRoot) throws DispositionReportFaultMessage {
        if (identifiers == null) {
            return;
        }
        List keyedRefList = identifiers.getKeyedReference();
        if (keyedRefList == null || keyedRefList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.identifierbag.NoInput"));
        }
        for (KeyedReference keyedRef : keyedRefList) {
            this.validateKeyedReference(keyedRef, config, isRoot);
        }
    }

    public void validateKeyedReferenceGroup(KeyedReferenceGroup krg, Configuration config, boolean isRoot) throws DispositionReportFaultMessage {
        List keyedRefs;
        boolean checked;
        if (log.isDebugEnabled()) {
            log.debug((Object)"validateKeyedReferenceGroup");
        }
        if (krg.getTModelKey() == null || krg.getTModelKey().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
        }
        String tmodelKey = krg.getTModelKey().toLowerCase();
        krg.setTModelKey(tmodelKey);
        ValidatePublish.validateKeyLength(tmodelKey);
        boolean checkRef = false;
        try {
            checkRef = config.getBoolean("juddi.validation.enforceReferentialIntegrity", false);
        }
        catch (Exception ex) {
            log.warn((Object)"Error caught reading juddi.validation.enforceReferentialIntegrity from config file", (Throwable)ex);
        }
        if (checkRef && !isRoot) {
            this.verifyTModelKeyExists(tmodelKey);
        }
        if ((checked = this.verifyTModelKeyExistsAndChecked(tmodelKey, config)) && (keyedRefs = krg.getKeyedReference()) != null && keyedRefs.size() > 0) {
            for (KeyedReference keyedRef : keyedRefs) {
                this.validateKeyedReference(keyedRef, config, isRoot);
            }
        }
    }

    public void validateKeyedReference(KeyedReference kr, Configuration config, boolean isRoot) throws DispositionReportFaultMessage {
        String tmodelKey;
        if (log.isDebugEnabled()) {
            log.debug((Object)"validateKeyedReference");
        }
        if ((tmodelKey = kr.getTModelKey()) == null || tmodelKey.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
        }
        tmodelKey = tmodelKey.toLowerCase();
        kr.setTModelKey(tmodelKey);
        ValidatePublish.validateKeyLength(tmodelKey);
        if (kr.getKeyValue() == null || kr.getKeyValue().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoKeyValue"));
        }
        this.validateKeyValue(kr.getKeyValue());
        this.validateKeyName(kr.getKeyName());
        boolean checkRef = false;
        try {
            checkRef = config.getBoolean("juddi.validation.enforceReferentialIntegrity", false);
        }
        catch (Exception ex) {
            log.warn((Object)"Error caught reading juddi.validation.enforceReferentialIntegrity from config file", (Throwable)ex);
        }
        if (checkRef && !isRoot) {
            this.verifyTModelKeyExists(tmodelKey);
        }
        String rootPublisherStr = config.getString("juddi.root.publisher");
        if ("uddi:uddi.org:categorization:nodes".equalsIgnoreCase(kr.getTModelKey()) && !rootPublisherStr.equals(this.publisher.getAuthorizedName())) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NodeCategoryTModel", "uddi:uddi.org:categorization:nodes"));
        }
    }

    public void validateTModelInstanceDetails(TModelInstanceDetails tmodelInstDetails, Configuration config, boolean isRoot) throws DispositionReportFaultMessage {
        if (log.isDebugEnabled()) {
            log.debug((Object)"validateTModelInstanceDetails");
        }
        if (tmodelInstDetails == null) {
            return;
        }
        List tmodelInstInfoList = tmodelInstDetails.getTModelInstanceInfo();
        if (tmodelInstInfoList == null || tmodelInstInfoList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodelinstdetails.NoInput"));
        }
        for (TModelInstanceInfo tmodelInstInfo : tmodelInstInfoList) {
            this.validateTModelInstanceInfo(tmodelInstInfo, config, isRoot);
        }
    }

    public void validateTModelInstanceInfo(TModelInstanceInfo tmodelInstInfo, Configuration config, boolean isRoot) throws DispositionReportFaultMessage {
        if (tmodelInstInfo == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodelinstinfo.NullInput"));
        }
        if (tmodelInstInfo.getTModelKey() == null || tmodelInstInfo.getTModelKey().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodelinstinfo.NoTModelKey"));
        }
        tmodelInstInfo.setTModelKey(tmodelInstInfo.getTModelKey().toLowerCase());
        boolean checkRef = false;
        try {
            checkRef = config.getBoolean("juddi.validation.enforceReferentialIntegrity", false);
        }
        catch (Exception ex) {
            log.warn((Object)"Error caught reading juddi.validation.enforceReferentialIntegrity from config file", (Throwable)ex);
        }
        if (checkRef && !isRoot) {
            this.verifyTModelKeyExists(tmodelInstInfo.getTModelKey());
        }
        this.validateInstanceDetails(tmodelInstInfo.getInstanceDetails());
        if (log.isDebugEnabled()) {
            log.debug((Object)"validateTModelInstanceInfo");
        }
        ValidatePublish.validateKeyLength(tmodelInstInfo.getTModelKey());
        this.validateDescriptions(tmodelInstInfo.getDescription());
    }

    public void validateInstanceDetails(InstanceDetails instDetails) throws DispositionReportFaultMessage {
        if (instDetails == null) {
            return;
        }
        List elems = instDetails.getOverviewDoc();
        if (instDetails.getInstanceParms() == null && elems.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.instdetails.NoOverviewOrParms"));
        }
        for (int i = 0; i < elems.size(); ++i) {
            this.validateDescriptions(((OverviewDoc)elems.get(i)).getDescription());
            this.validateOverviewURL(((OverviewDoc)elems.get(i)).getOverviewURL());
        }
        if (instDetails.getInstanceParms() != null && instDetails.getInstanceParms().length() > 8192) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.instdetails.MaxLength", instDetails.getInstanceParms().length() + ""));
        }
    }

    public void validateOverviewDoc(OverviewDoc overviewDoc) throws DispositionReportFaultMessage {
        if (overviewDoc == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.overviewdoc.NullInput"));
        }
        List elems = overviewDoc.getDescription();
        if ((elems == null || elems.size() == 0) && overviewDoc.getOverviewURL() == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.overviewdoc.NoDescOrUrl"));
        }
        for (int i = 0; i < elems.size(); ++i) {
            ValidatePublish.validateLang(((Description)elems.get(i)).getLang());
            this.validateURL(((Description)elems.get(i)).getValue());
        }
    }

    public void validateRegisteredInfo(GetRegisteredInfo body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getInfoSelection() == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.getregisteredinfo.NoInfoSelection"));
        }
    }

    public void validateDeletePublisher(EntityManager em, DeletePublisher body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getPublisherId();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        if (!((Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.deletepublisher.AdminReqd"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String entityKey : entityKeyList) {
            ValidatePublish.validateKeyLength(entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(Publisher.class, (Object)entityKey);
            if (obj != null) continue;
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.PublisherNotFound", entityKey));
        }
    }

    public void validateSaveSubscriptionAdmin(EntityManager em, String publisherOrUsername, List<Subscription> subscriptions) throws DispositionReportFaultMessage {
        if (subscriptions == null || subscriptions.isEmpty()) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (!((Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.deletepublisher.AdminReqd"));
        }
        UddiEntityPublisher user = new UddiEntityPublisher(publisherOrUsername);
        ValidateSubscription vsub = new ValidateSubscription(user);
        for (int i = 0; i < subscriptions.size(); ++i) {
            vsub.validateSubscriptions(em, subscriptions, user);
        }
    }

    public void validateSavePublisher(EntityManager em, SavePublisher body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getPublisher();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.savepublisher.NoInput"));
        }
        if (!((Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.savepublisher.AdminReqd", this.publisher.getAuthorizedName()));
        }
        for (org.apache.juddi.api_v3.Publisher entity : entityList) {
            this.validatePublisher(em, entity);
        }
    }

    public void validatePublisher(EntityManager em, org.apache.juddi.api_v3.Publisher publisher) throws DispositionReportFaultMessage {
        if (publisher == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.publisher.NullInput"));
        }
        String authorizedName = publisher.getAuthorizedName();
        if (authorizedName == null || authorizedName.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.publisher.NoAuthorizedName"));
        }
        String publisherName = publisher.getPublisherName();
        if (publisherName == null || publisherName.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.publisher.NoPublisherName"));
        }
    }

    public void validateAdminDeleteTModel(EntityManager em, DeleteTModel body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getTModelKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        if (!((Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.AdminReqd"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String entityKey : entityKeyList) {
            ValidatePublish.validateKeyLength(entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (inserted) continue;
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
        }
    }

    private static void validateDescription(String value) throws ValueNotAllowedException {
        if (value != null && value.length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.DescriptionTooLong"));
        }
    }

    public static void validateLang(String lang) throws ValueNotAllowedException {
        if (lang != null && lang.length() > 26) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.names.LangTooLong"));
        }
    }

    private static void validateUseType(String useType) throws ValueNotAllowedException {
        if (useType != null && useType.length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.names.UseTypeTooLong"));
        }
    }

    public static void validateKeyLength(String value) throws ValueNotAllowedException {
        if (value != null && value.length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keys.TooLong"));
        }
    }

    private void validateAccessPoint(EntityManager em, AccessPoint value, Configuration config) throws ValueNotAllowedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"validateAccessPoint");
        }
        if (value != null) {
            if (value.getValue().length() > 4096) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.accessPoint.TooLong"));
            }
            ValidatePublish.validateUseType(value.getUseType());
            if (value.getUseType() != null) {
                if (value.getUseType().equalsIgnoreCase(AccessPointType.BINDING_TEMPLATE.toString())) {
                    Object obj = em.find(org.apache.juddi.model.BindingTemplate.class, (Object)value.getValue());
                    if (obj == null) {
                        throw new ValueNotAllowedException(new ErrorMessage("errors.accessPoint.bindingtemplateRedirect.keynotexist"));
                    }
                } else if (value.getUseType().equalsIgnoreCase(AccessPointType.HOSTING_REDIRECTOR.toString())) {
                    try {
                        new URL(value.getValue());
                    }
                    catch (MalformedURLException ex) {
                        throw new ValueNotAllowedException(new ErrorMessage("errors.accessPoint.hostingRedirector.notaurl"));
                    }
                }
            }
        }
    }

    private void validateHostingRedirector(EntityManager em, HostingRedirector hostingRedirector, Configuration config) throws ValueNotAllowedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"validateHostingRedirector");
        }
        if (hostingRedirector == null) {
            return;
        }
        if (hostingRedirector.getBindingKey() == null || hostingRedirector.getBindingKey().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.hostingredirector.noinput"));
        }
        if (hostingRedirector.getBindingKey().length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.hostingredirector.TooLong"));
        }
        boolean checkRef = false;
        try {
            checkRef = config.getBoolean("juddi.validation.enforceReferentialIntegrity", false);
        }
        catch (Exception ex) {
            log.warn((Object)"Error caught reading juddi.validation.enforceReferentialIntegrity from config file", (Throwable)ex);
        }
        if (checkRef) {
            // empty if block
        }
    }

    private void validateNameLength(String value) throws ValueNotAllowedException {
        if (value == null || value.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.names.NoInput"));
        }
        if (value.length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.names.TooLong"));
        }
    }

    private void validateSortCode(String value) throws ValueNotAllowedException {
        if (value != null && value.length() > 10) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.sortCode.TooLong"));
        }
    }

    private void validateAddressLines(List<AddressLine> addressLine, Configuration config) throws ValueNotAllowedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"validateAddressLines");
        }
        if (addressLine != null) {
            for (int i = 0; i < addressLine.size(); ++i) {
                this.validateKeyName(addressLine.get(i).getKeyName());
                this.verifyTModelKeyExistsAndChecked(addressLine.get(i).getKeyName(), config);
                this.validateKeyValue(addressLine.get(i).getKeyValue());
                if (addressLine.get(i).getValue() == null || addressLine.get(i).getValue().length() == 0) {
                    throw new ValueNotAllowedException(new ErrorMessage("errors.addressline.noinput"));
                }
                if (addressLine.get(i).getValue().length() <= 80) continue;
                throw new ValueNotAllowedException(new ErrorMessage("errors.addressline.TooLong"));
            }
        }
    }

    private void validateEmailAddress(List<Email> email) throws ValueNotAllowedException {
        if (email != null) {
            for (int i = 0; i < email.size(); ++i) {
                ValidatePublish.validateUseType(email.get(i).getUseType());
                if (email.get(i).getValue() == null || email.get(i).getValue().length() == 0) {
                    throw new ValueNotAllowedException(new ErrorMessage("errors.email.noinput"));
                }
                if (email.get(i).getValue().length() <= 255) continue;
                throw new ValueNotAllowedException(new ErrorMessage("errors.email.TooLong"));
            }
        }
    }

    private void validatePhone(List<Phone> phone) throws ValueNotAllowedException {
        if (phone != null) {
            for (int i = 0; i < phone.size(); ++i) {
                ValidatePublish.validateUseType(phone.get(i).getUseType());
                if (phone.get(i).getValue() == null || phone.get(i).getValue().length() == 0) {
                    throw new ValueNotAllowedException(new ErrorMessage("errors.phone.noinput"));
                }
                if (phone.get(i).getValue().length() <= 50) continue;
                throw new ValueNotAllowedException(new ErrorMessage("errors.phone.TooLong"));
            }
        }
    }

    private void validateDiscoveryUrlLength(DiscoveryURL url) throws ValueNotAllowedException {
        if (url != null) {
            ValidatePublish.validateUseType(url.getUseType());
            this.validateURL(url.getValue());
        }
    }

    private void validateKeyValue(String value) throws ValueNotAllowedException {
        if (value != null && value.length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyvalue.TooLong"));
        }
    }

    private void validateKeyName(String value) throws ValueNotAllowedException {
        if (value != null && value.length() > 255) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyname.TooLong"));
        }
    }

    private void validateDescriptions(List<Description> description) throws ValueNotAllowedException {
        for (int i = 0; i < description.size(); ++i) {
            if (description.get(i).getValue() == null) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.contact.EmptyDescription"));
            }
            ValidatePublish.validateLang(description.get(i).getLang());
            ValidatePublish.validateDescription(description.get(i).getValue());
        }
    }

    private void validateOverviewURL(OverviewURL overviewURL) throws ValueNotAllowedException {
        if (overviewURL != null) {
            ValidatePublish.validateUseType(overviewURL.getUseType());
            this.validateURL(overviewURL.getValue());
        }
    }

    private void validateURL(String value) throws ValueNotAllowedException {
        if (value != null && value.length() > 4096) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.url.overviewTooLong"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyTModelKeyExistsAndChecked(String tmodelKey, Configuration config) throws ValueNotAllowedException {
        boolean checked = true;
        if (tmodelKey == null || tmodelKey.length() == 0) {
            return false;
        }
        if (tmodelKey.equalsIgnoreCase("uddi:uddi.org:categorization:types")) {
            return false;
        }
        if (tmodelKey.equalsIgnoreCase("uddi:uddi.org:categorization:nodes")) {
            return false;
        }
        if (tmodelKey.equalsIgnoreCase("uddi:uddi.org:v3_inquiry")) {
            return false;
        }
        if (tmodelKey.equalsIgnoreCase("uddi:uddi.org:v3_publication")) {
            return false;
        }
        if (tmodelKey.equalsIgnoreCase("uddi:uddi.org:v3_security")) {
            return false;
        }
        if (tmodelKey.equalsIgnoreCase("uddi:uddi.org:v3_ownership_transfer")) {
            return false;
        }
        if (tmodelKey.equalsIgnoreCase("uddi:uddi.org:v3_subscription")) {
            return false;
        }
        if (tmodelKey.equalsIgnoreCase("uddi:uddi.org:v3_subscriptionlistener")) {
            return false;
        }
        if (config == null) {
            log.warn((Object)new ErrorMessage("errors.tmodel.ReferentialIntegrityNullConfig"));
            return false;
        }
        boolean checkRef = false;
        try {
            checkRef = config.getBoolean("juddi.validation.enforceReferentialIntegrity", false);
        }
        catch (Exception ex) {
            log.warn((Object)"Error caught reading juddi.validation.enforceReferentialIntegrity from config file", (Throwable)ex);
        }
        if (checkRef) {
            EntityManager em;
            if (log.isDebugEnabled()) {
                log.debug((Object)("verifyTModelKeyExists " + tmodelKey));
            }
            if ((em = PersistenceManager.getEntityManager()) == null) {
                log.warn((Object)new ErrorMessage("errors.tmodel.ReferentialIntegrityNullEM"));
            } else {
                Tmodel modelTModel = null;
                EntityTransaction tx = em.getTransaction();
                try {
                    tx.begin();
                    modelTModel = (Tmodel)em.find(Tmodel.class, (Object)tmodelKey);
                    if (modelTModel == null) {
                        checked = false;
                    } else if (modelTModel.getCategoryBag() != null) {
                        for (org.apache.juddi.model.KeyedReference ref : modelTModel.getCategoryBag().getKeyedReferences()) {
                            if (!"uddi-org:types:unchecked".equalsIgnoreCase(ref.getKeyName())) continue;
                            checked = false;
                            break;
                        }
                    }
                    tx.commit();
                }
                finally {
                    if (tx.isActive()) {
                        tx.rollback();
                    }
                    em.close();
                }
                if (modelTModel == null) {
                    throw new ValueNotAllowedException(new ErrorMessage("errors.tmodel.ReferencedKeyDoesNotExist", tmodelKey));
                }
            }
        }
        return checked;
    }

    private boolean verifyTModelKeyChecked(Tmodel modelTModel) {
        boolean checked = true;
        if (modelTModel == null) {
            checked = false;
        } else {
            for (org.apache.juddi.model.KeyedReference ref : modelTModel.getCategoryBag().getKeyedReferences()) {
                if (!"uddi-org:types:unchecked".equalsIgnoreCase(ref.getTmodelKeyRef())) continue;
                checked = false;
                break;
            }
        }
        return checked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TModel verifyTModelKeyExists(String tmodelKey) throws ValueNotAllowedException, DispositionReportFaultMessage {
        TModel api = null;
        EntityManager em = PersistenceManager.getEntityManager();
        boolean found = false;
        if (em == null) {
            log.warn((Object)new ErrorMessage("errors.tmodel.ReferentialIntegrityNullEM"));
        } else {
            Tmodel modelTModel = null;
            EntityTransaction tx = em.getTransaction();
            try {
                tx.begin();
                modelTModel = (Tmodel)em.find(Tmodel.class, (Object)tmodelKey);
                if (modelTModel != null) {
                    found = true;
                    api = new TModel();
                    MappingModelToApi.mapTModel(modelTModel, api);
                }
                tx.commit();
            }
            finally {
                if (tx.isActive()) {
                    tx.rollback();
                }
                em.close();
            }
        }
        if (!found) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodel.ReferencedKeyDoesNotExist", tmodelKey));
        }
        return api;
    }

    private List<String> GetBindingKeysCheckedTModelKeyedReferenceBT(Map<String, TModel> cache, List<BindingTemplate> obj) {
        ArrayList<String> ret = new ArrayList<String>();
        if (obj == null) {
            return ret;
        }
        for (BindingTemplate bt : obj) {
            if (bt.getCategoryBag() == null) continue;
            for (int i = 0; i < bt.getCategoryBag().getKeyedReference().size(); ++i) {
                ret.addAll(this.GetBindingKeysCheckedTModelKeyedReference(cache, (KeyedReference)bt.getCategoryBag().getKeyedReference().get(i)));
            }
        }
        return ret;
    }

    private List<String> GetBindingKeysCheckedTModelKeyedReferenceBS(Map<String, TModel> cache, List<org.uddi.api_v3.BusinessService> obj) {
        ArrayList<String> ret = new ArrayList<String>();
        if (obj == null) {
            return ret;
        }
        for (org.uddi.api_v3.BusinessService bt : obj) {
            if (bt.getCategoryBag() != null) {
                for (int i = 0; i < bt.getCategoryBag().getKeyedReference().size(); ++i) {
                    ret.addAll(this.GetBindingKeysCheckedTModelKeyedReference(cache, (KeyedReference)bt.getCategoryBag().getKeyedReference().get(i)));
                }
            }
            if (bt.getBindingTemplates() == null) continue;
            ret.addAll(this.GetBindingKeysCheckedTModelKeyedReferenceBT(cache, bt.getBindingTemplates().getBindingTemplate()));
        }
        return ret;
    }

    private List<String> GetBindingKeysCheckedTModelKeyedReferenceBE(Map<String, TModel> cache, List<BusinessEntity> obj) {
        ArrayList<String> ret = new ArrayList<String>();
        if (obj == null) {
            return ret;
        }
        for (BusinessEntity bt : obj) {
            int i;
            if (bt.getCategoryBag() != null) {
                for (i = 0; i < bt.getCategoryBag().getKeyedReference().size(); ++i) {
                    ret.addAll(this.GetBindingKeysCheckedTModelKeyedReference(cache, (KeyedReference)bt.getCategoryBag().getKeyedReference().get(i)));
                }
            }
            if (bt.getIdentifierBag() != null) {
                for (i = 0; i < bt.getIdentifierBag().getKeyedReference().size(); ++i) {
                    ret.addAll(this.GetBindingKeysCheckedTModelKeyedReference(cache, (KeyedReference)bt.getIdentifierBag().getKeyedReference().get(i)));
                }
            }
            if (bt.getBusinessServices() == null) continue;
            ret.addAll(this.GetBindingKeysCheckedTModelKeyedReferenceBS(cache, bt.getBusinessServices().getBusinessService()));
        }
        return ret;
    }

    private List<String> GetBindingKeysCheckedTModelKeyedReferenceTM(Map<String, TModel> cache, List<TModel> obj) {
        ArrayList<String> ret = new ArrayList<String>();
        if (obj == null) {
            return ret;
        }
        for (TModel bt : obj) {
            int i;
            if (bt.getCategoryBag() != null) {
                for (i = 0; i < bt.getCategoryBag().getKeyedReference().size(); ++i) {
                    ret.addAll(this.GetBindingKeysCheckedTModelKeyedReference(cache, (KeyedReference)bt.getCategoryBag().getKeyedReference().get(i)));
                }
            }
            if (bt.getIdentifierBag() == null) continue;
            for (i = 0; i < bt.getIdentifierBag().getKeyedReference().size(); ++i) {
                ret.addAll(this.GetBindingKeysCheckedTModelKeyedReference(cache, (KeyedReference)bt.getIdentifierBag().getKeyedReference().get(i)));
            }
        }
        return ret;
    }

    private List<String> GetBindingKeysCheckedTModelKeyedReference(Map<String, TModel> cache, KeyedReference get) {
        ArrayList<String> ret = new ArrayList<String>();
        TModel ref = null;
        log.debug((Object)("looking for is validated by for keyedref " + get.getTModelKey()));
        if (cache.containsKey(get.getTModelKey())) {
            ref = cache.get(get.getTModelKey());
        }
        if (ref == null) {
            try {
                ref = this.verifyTModelKeyExists(get.getTModelKey());
                cache.put(get.getTModelKey(), ref);
            }
            catch (Exception ex) {
                log.error((Object)("unexpected error loading tmodel " + get.getTModelKey()), (Throwable)ex);
            }
        }
        if (ref != null) {
            ret.addAll(this.TModelContains("uddi:uddi.org:categorization:validatedby", ref));
            ret.addAll(this.TModelContains("uuid:25b22e3e-3dfa-3024-b02a-3438b9050b59", ref));
        }
        return ret;
    }

    private List<String> TModelContains(String key, TModel ref) {
        int i;
        if (key == null) {
            return null;
        }
        if (ref == null || ref.getTModelKey() == null) {
            return null;
        }
        log.debug((Object)("looking for key=" + key + " from tModel " + ref.getTModelKey()));
        ArrayList<String> ret = new ArrayList<String>();
        if (ref.getCategoryBag() != null) {
            for (i = 0; i < ref.getCategoryBag().getKeyedReference().size(); ++i) {
                if (!((KeyedReference)ref.getCategoryBag().getKeyedReference().get(i)).getTModelKey().equalsIgnoreCase(key)) continue;
                log.debug((Object)("found reference for key=" + key + " from tModel " + ref.getTModelKey() + " validation endpoint " + ((KeyedReference)ref.getCategoryBag().getKeyedReference().get(i)).getKeyValue()));
                ret.add(((KeyedReference)ref.getCategoryBag().getKeyedReference().get(i)).getKeyValue());
            }
            for (i = 0; i < ref.getCategoryBag().getKeyedReferenceGroup().size(); ++i) {
                for (int k = 0; k < ((KeyedReferenceGroup)ref.getCategoryBag().getKeyedReferenceGroup().get(i)).getKeyedReference().size(); ++k) {
                    if (!((KeyedReference)((KeyedReferenceGroup)ref.getCategoryBag().getKeyedReferenceGroup().get(i)).getKeyedReference().get(k)).getTModelKey().equalsIgnoreCase(key)) continue;
                    log.debug((Object)("found reference for key=" + key + " from tModel " + ref.getTModelKey() + " validation endpoint " + ((KeyedReference)((KeyedReferenceGroup)ref.getCategoryBag().getKeyedReferenceGroup().get(i)).getKeyedReference().get(k)).getKeyValue()));
                    ret.add(((KeyedReference)((KeyedReferenceGroup)ref.getCategoryBag().getKeyedReferenceGroup().get(i)).getKeyedReference().get(k)).getKeyValue());
                }
            }
        }
        if (ref.getIdentifierBag() != null) {
            for (i = 0; i < ref.getIdentifierBag().getKeyedReference().size(); ++i) {
                if (!((KeyedReference)ref.getIdentifierBag().getKeyedReference().get(i)).getTModelKey().equalsIgnoreCase(key)) continue;
                log.debug((Object)("found reference for key=" + key + " from tModel " + ref.getTModelKey() + " validation endpoint " + ((KeyedReference)ref.getIdentifierBag().getKeyedReference().get(i)).getKeyValue()));
                ret.add(((KeyedReference)ref.getIdentifierBag().getKeyedReference().get(i)).getKeyValue());
            }
        }
        return ret;
    }

    private void validatedAddressLinesIfKeyDefined(List<AddressLine> addressLine) throws ValueNotAllowedException {
        StringBuilder err = new StringBuilder();
        for (int i = 0; i < addressLine.size(); ++i) {
            if (addressLine.get(i).getKeyName() == null || addressLine.get(i).getKeyName().trim().length() == 0) {
                err.append("addressLine(").append(i).append(").keyName,");
            }
            if (addressLine.get(i).getKeyValue() == null || addressLine.get(i).getKeyValue().trim().length() == 0) {
                err.append("addressLine(").append(i).append(").keyValue,");
            }
            if (addressLine.get(i).getValue() != null && addressLine.get(i).getValue().trim().length() != 0) continue;
            err.append("addressLine(").append(i).append(").value,");
        }
        if (err.length() > 0) {
            throw new ValueNotAllowedException(new ErrorMessage("E_invalidValueAddressLine", err.toString()));
        }
    }

    private void validateCheckedTModelsBT(List<BindingTemplate> bindingTemplate, Configuration config) throws ValueNotAllowedException {
        boolean checkRef = false;
        try {
            checkRef = config.getBoolean("juddi.validation.enforceReferentialIntegrity", false);
        }
        catch (Exception ex) {
            log.warn((Object)"Error caught reading juddi.validation.enforceReferentialIntegrity from config file", (Throwable)ex);
        }
        if (!checkRef) {
            return;
        }
        HashMap<String, TModel> cache = new HashMap<String, TModel>();
        List<String> bindings = this.GetBindingKeysCheckedTModelKeyedReferenceBT(cache, bindingTemplate);
        if (!bindings.isEmpty()) {
            bindings = new ArrayList<String>(new HashSet<String>(bindings));
            for (int i = 0; i < bindings.size(); ++i) {
                EntityManager em = PersistenceManager.getEntityManager();
                org.apache.juddi.model.BindingTemplate find = (org.apache.juddi.model.BindingTemplate)em.find(org.apache.juddi.model.BindingTemplate.class, (Object)bindings.get(i));
                if (find == null) continue;
                String url = find.getAccessPointUrl();
                if (url == null) {
                    url = find.getHostingRedirector();
                }
                if (url == null) continue;
                ValidateValuesFromWebService.ValidateBinding(this.Rectify(url, config), bindingTemplate);
            }
        }
    }

    private void validateCheckedTModelsBS(List<org.uddi.api_v3.BusinessService> bizlist, Configuration config) throws ValueNotAllowedException {
        boolean checkRef = false;
        try {
            checkRef = config.getBoolean("juddi.validation.enforceReferentialIntegrity", false);
        }
        catch (Exception ex) {
            log.warn((Object)"Error caught reading juddi.validation.enforceReferentialIntegrity from config file", (Throwable)ex);
        }
        if (!checkRef) {
            return;
        }
        HashMap<String, TModel> cache = new HashMap<String, TModel>();
        List<String> bindings = this.GetBindingKeysCheckedTModelKeyedReferenceBS(cache, bizlist);
        if (!bindings.isEmpty()) {
            bindings = new ArrayList<String>(new HashSet<String>(bindings));
            for (int i = 0; i < bindings.size(); ++i) {
                EntityManager em = PersistenceManager.getEntityManager();
                org.apache.juddi.model.BindingTemplate find = (org.apache.juddi.model.BindingTemplate)em.find(org.apache.juddi.model.BindingTemplate.class, (Object)bindings.get(i));
                if (find == null) continue;
                String url = find.getAccessPointUrl();
                if (url == null) {
                    url = find.getHostingRedirector();
                }
                if (url == null) continue;
                ValidateValuesFromWebService.ValidateService(this.Rectify(url, config), bizlist);
            }
        }
    }

    private void validateCheckedTModelsBE(List<BusinessEntity> entity, Configuration config) throws ValueNotAllowedException {
        boolean checkRef = false;
        try {
            checkRef = config.getBoolean("juddi.validation.enforceReferentialIntegrity", false);
        }
        catch (Exception ex) {
            log.warn((Object)"Error caught reading juddi.validation.enforceReferentialIntegrity from config file", (Throwable)ex);
        }
        if (!checkRef) {
            return;
        }
        HashMap<String, TModel> cache = new HashMap<String, TModel>();
        List<String> bindings = this.GetBindingKeysCheckedTModelKeyedReferenceBE(cache, entity);
        if (!bindings.isEmpty()) {
            bindings = new ArrayList<String>(new HashSet<String>(bindings));
            for (int i = 0; i < bindings.size(); ++i) {
                EntityManager em = PersistenceManager.getEntityManager();
                org.apache.juddi.model.BindingTemplate find = (org.apache.juddi.model.BindingTemplate)em.find(org.apache.juddi.model.BindingTemplate.class, (Object)bindings.get(i));
                if (find == null) continue;
                String url = find.getAccessPointUrl();
                if (url == null) {
                    url = find.getHostingRedirector();
                }
                if (url == null) continue;
                ValidateValuesFromWebService.ValidateBusiness(this.Rectify(url, config), entity);
            }
        }
    }

    private void validateCheckedTModelsTM(List<TModel> entity, Configuration config) throws ValueNotAllowedException {
        boolean checkRef = false;
        try {
            checkRef = config.getBoolean("juddi.validation.enforceReferentialIntegrity", false);
        }
        catch (Exception ex) {
            log.warn((Object)"Error caught reading juddi.validation.enforceReferentialIntegrity from config file", (Throwable)ex);
        }
        if (!checkRef) {
            return;
        }
        HashMap<String, TModel> cache = new HashMap<String, TModel>();
        List<String> bindings = this.GetBindingKeysCheckedTModelKeyedReferenceTM(cache, entity);
        if (!bindings.isEmpty()) {
            bindings = new ArrayList<String>(new HashSet<String>(bindings));
            for (int i = 0; i < bindings.size(); ++i) {
                EntityManager em = PersistenceManager.getEntityManager();
                org.apache.juddi.model.BindingTemplate find = (org.apache.juddi.model.BindingTemplate)em.find(org.apache.juddi.model.BindingTemplate.class, (Object)bindings.get(i));
                if (find == null) continue;
                String url = find.getAccessPointUrl();
                if (url == null) {
                    url = find.getHostingRedirector();
                }
                if (url == null) continue;
                log.debug((Object)("attempting vsv from " + url));
                ValidateValuesFromWebService.ValidateTModel(this.Rectify(url, config), entity);
            }
        }
    }

    private String Rectify(String url, Configuration config) {
        Properties p = new Properties();
        p.put("juddi.server.baseurl", config.getString("juddi.server.baseurl", "http://localhost:8080/juddiv3"));
        return TokenResolver.replaceTokens((String)url, (Properties)p);
    }

    public void validateDeleteNode(EntityManager em, DeleteNode nodeID, ReplicationConfiguration cfg) throws DispositionReportFaultMessage {
        if (nodeID == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.deleteClerk.NoInput"));
        }
        if (!((Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.deletepublisher.AdminReqd"));
        }
        if (nodeID.getNodeID() == null || nodeID.getNodeID().trim().equalsIgnoreCase("")) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.deleteNode.NoInput"));
        }
        if (cfg != null && cfg.getCommunicationGraph() != null) {
            for (String node : cfg.getCommunicationGraph().getNode()) {
                if (!node.equals(nodeID.getNodeID())) continue;
                throw new InvalidKeyPassedException(new ErrorMessage("errors.deleteNode.InReplicationConfig", nodeID.getNodeID()));
            }
            for (int i = 0; i < cfg.getCommunicationGraph().getEdge().size(); ++i) {
                if (nodeID.getNodeID().equals(((CommunicationGraph.Edge)cfg.getCommunicationGraph().getEdge().get(i)).getMessageReceiver())) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.deleteNode.InReplicationConfig", nodeID.getNodeID()));
                }
                if (!nodeID.getNodeID().equals(((CommunicationGraph.Edge)cfg.getCommunicationGraph().getEdge().get(i)).getMessageSender())) continue;
                throw new InvalidKeyPassedException(new ErrorMessage("errors.deleteNode.InReplicationConfig", nodeID.getNodeID()));
            }
        }
    }

    public void validateDeleteClerk(EntityManager em, DeleteClerk clerkID) throws DispositionReportFaultMessage {
        if (clerkID == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.deleteClerk.NoInput"));
        }
        if (!((Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.deletepublisher.AdminReqd"));
        }
        if (clerkID.getClerkID() == null || clerkID.getClerkID().trim().equalsIgnoreCase("")) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.deleteClerk.NoInput"));
        }
    }

    public void validateGetAllNodes() throws DispositionReportFaultMessage {
        if (!((Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.deletepublisher.AdminReqd"));
        }
    }

    private synchronized void initDigSig(Configuration config) {
        if (this.ds == null) {
            Properties p = new Properties();
            p.put("trustStorePath", config.getString("juddi.validation.rejectInvalidSignatures.trustStorePath", ""));
            p.put("trustStoreType", config.getString("juddi.validation.rejectInvalidSignatures.trustStoreType", ""));
            String enc = config.getString("juddi.validation.rejectInvalidSignatures.trustStorePassword", "");
            if (config.getBoolean("juddi.validation.rejectInvalidSignatures.trustStorePassword[@isPasswordEncrypted]", false)) {
                log.debug((Object)"trust password is encrypted, decrypting...");
                String prov = config.getString("juddi.validation.rejectInvalidSignatures.trustStorePassword[@cryptoProvider]", "");
                try {
                    p.setProperty("trustStorePassword", CryptorFactory.getCryptor((String)prov).decrypt(enc));
                }
                catch (Exception ex) {
                    log.warn((Object)("unable to decrypt trust store password " + ex.getMessage()));
                    log.debug((Object)("unable to decrypt trust store password " + ex.getMessage()), (Throwable)ex);
                }
            } else if (!"".equals(enc)) {
                log.warn((Object)"Hey, you should consider encrypting your trust store password!");
                p.setProperty("trustStorePassword", enc);
            }
            p.put("checkRevocationCRL", config.getString("juddi.validation.rejectInvalidSignatures.checkRevocationCRL", "true"));
            p.put("checkTrust", config.getString("juddi.validation.rejectInvalidSignatures.checkTrust", "true"));
            p.put("checkTimestamps", config.getString("juddi.validation.rejectInvalidSignatures.checkTimestamps", "true"));
            try {
                this.ds = new DigSigUtil(p);
            }
            catch (CertificateException ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
    }

    private void validateSignaturesBinding(BindingTemplate bindingTemplate, Configuration config) throws FatalErrorException {
        AtomicReference outmsg;
        boolean ok;
        boolean shouldcheck = config.getBoolean("juddi.validation.rejectInvalidSignatures.enable", false);
        this.initDigSig(config);
        if (shouldcheck && !bindingTemplate.getSignature().isEmpty() && this.ds != null && !(ok = this.ds.verifySignedUddiEntity((Object)bindingTemplate, outmsg = new AtomicReference()))) {
            throw new FatalErrorException(new ErrorMessage("errors.digitalsignature.validationfailure", bindingTemplate.getBindingKey() + " " + (String)outmsg.get()));
        }
    }

    private void validateSignaturesService(org.uddi.api_v3.BusinessService businessService, Configuration config) throws FatalErrorException {
        AtomicReference outmsg;
        boolean ok;
        boolean shouldcheck = config.getBoolean("juddi.validation.rejectInvalidSignatures.enable", false);
        this.initDigSig(config);
        if (shouldcheck && !businessService.getSignature().isEmpty() && this.ds != null && !(ok = this.ds.verifySignedUddiEntity((Object)businessService, outmsg = new AtomicReference()))) {
            throw new FatalErrorException(new ErrorMessage("errors.digitalsignature.validationfailure", businessService.getServiceKey() + " " + (String)outmsg.get()));
        }
    }

    private void validateSignaturesTModel(TModel tModel, Configuration config) throws FatalErrorException {
        AtomicReference outmsg;
        boolean ok;
        boolean shouldcheck = config.getBoolean("juddi.validation.rejectInvalidSignatures.enable", false);
        this.initDigSig(config);
        if (shouldcheck && !tModel.getSignature().isEmpty() && this.ds != null && !(ok = this.ds.verifySignedUddiEntity((Object)tModel, outmsg = new AtomicReference()))) {
            throw new FatalErrorException(new ErrorMessage("errors.digitalsignature.validationfailure", tModel.getTModelKey() + " " + (String)outmsg.get()));
        }
    }

    private void validateSignaturesBusiness(BusinessEntity businessEntity, Configuration config) throws FatalErrorException {
        AtomicReference outmsg;
        boolean ok;
        boolean shouldcheck = config.getBoolean("juddi.validation.rejectInvalidSignatures.enable", false);
        this.initDigSig(config);
        if (shouldcheck && !businessEntity.getSignature().isEmpty() && this.ds != null && !(ok = this.ds.verifySignedUddiEntity((Object)businessEntity, outmsg = new AtomicReference()))) {
            throw new FatalErrorException(new ErrorMessage("errors.digitalsignature.validationfailure", businessEntity.getBusinessKey() + " " + (String)outmsg.get()));
        }
    }
}

