/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManager;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.client.cryptor.CryptorFactory;
import org.apache.juddi.v3.client.cryptor.DigSigUtil;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidValueException;
import org.apache.juddi.v3.error.TransferNotAllowedException;
import org.apache.juddi.validation.ValidateCustodyTransfer;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.uddi.custody_v3.TransferEntities;
import org.uddi.repl_v3.ChangeRecordIDType;
import org.uddi.repl_v3.HighWaterMarkVectorType;
import org.uddi.repl_v3.NotifyChangeRecordsAvailable;
import org.uddi.repl_v3.Operator;
import org.uddi.repl_v3.ReplicationConfiguration;
import org.uddi.repl_v3.TransferCustody;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class ValidateReplication
extends ValidateUDDIApi {
    private static final Log log = LogFactory.getLog(ValidateReplication.class);
    private DigSigUtil ds = null;

    public ValidateReplication(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public ValidateReplication(UddiEntityPublisher publisher, String nodeid) {
        super(publisher, nodeid);
    }

    public void validateNotifyChangeRecordsAvailable(NotifyChangeRecordsAvailable body, WebServiceContext ctx) throws DispositionReportFaultMessage {
    }

    public void validateGetChangeRecords(String requestingNode, HighWaterMarkVectorType changesAlreadySeen, BigInteger responseLimitCount, HighWaterMarkVectorType responseLimitVector, ReplicationConfiguration FetchEdges, WebServiceContext ctx) throws DispositionReportFaultMessage {
        if (requestingNode == null || requestingNode.trim().equalsIgnoreCase("")) {
            throw new FatalErrorException(new ErrorMessage("errors.replication.nodeNotSpecified"));
        }
        if (changesAlreadySeen != null) {
            // empty if block
        }
        if (responseLimitCount != null && responseLimitVector != null) {
            throw new FatalErrorException(new ErrorMessage("errors.replication.bothLimitsSpecified"));
        }
        if (responseLimitCount != null && responseLimitCount.longValue() <= 0L) {
            throw new FatalErrorException(new ErrorMessage("errors.replication.negativeLimit", responseLimitCount.toString()));
        }
        if (responseLimitVector != null) {
            for (int i = 0; i < responseLimitVector.getHighWaterMark().size(); ++i) {
                if (((ChangeRecordIDType)responseLimitVector.getHighWaterMark().get(i)).getOriginatingUSN() == null || ((ChangeRecordIDType)responseLimitVector.getHighWaterMark().get(i)).getOriginatingUSN() <= 0L) {
                    throw new FatalErrorException(new ErrorMessage("errors.replication.limitVectorNull"));
                }
                if (((ChangeRecordIDType)responseLimitVector.getHighWaterMark().get(i)).getNodeID() != null && !((ChangeRecordIDType)responseLimitVector.getHighWaterMark().get(i)).getNodeID().trim().equalsIgnoreCase("")) continue;
                throw new FatalErrorException(new ErrorMessage("errors.replication.limitVectorNoNode"));
            }
        }
    }

    private static boolean ContainsNode(String requestingNode, ReplicationConfiguration FetchEdges) {
        if (FetchEdges == null) {
            return false;
        }
        if (FetchEdges.getCommunicationGraph() == null) {
            return false;
        }
        for (int i = 0; i < FetchEdges.getCommunicationGraph().getNode().size(); ++i) {
            if (!((String)FetchEdges.getCommunicationGraph().getNode().get(i)).equalsIgnoreCase(requestingNode)) continue;
            return true;
        }
        return false;
    }

    public void validateSetReplicationNodes(ReplicationConfiguration replicationConfiguration, EntityManager em, String thisnode, Configuration config) throws DispositionReportFaultMessage, ConfigurationException {
        AtomicReference outmsg;
        boolean ok;
        if (replicationConfiguration == null) {
            throw new InvalidValueException(new ErrorMessage("errors.replication.configNull"));
        }
        if (replicationConfiguration.getCommunicationGraph() == null) {
            throw new InvalidValueException(new ErrorMessage("errors.replication.configNull"));
        }
        if (replicationConfiguration.getRegistryContact() == null) {
            throw new InvalidValueException(new ErrorMessage("errors.replication.contactNull"));
        }
        if (replicationConfiguration.getRegistryContact().getContact() == null) {
            throw new InvalidValueException(new ErrorMessage("errors.replication.contactNull"));
        }
        if (replicationConfiguration.getRegistryContact().getContact().getPersonName().get(0) == null) {
            throw new InvalidValueException(new ErrorMessage("errors.replication.contactNull"));
        }
        if (replicationConfiguration.getOperator() == null || replicationConfiguration.getOperator().isEmpty()) {
            throw new InvalidValueException(new ErrorMessage("errors.replication.contactNull", "Operator is null or empty"));
        }
        for (int i = 0; i < replicationConfiguration.getOperator().size(); ++i) {
            if (((Operator)replicationConfiguration.getOperator().get(i)).getSoapReplicationURL() == null || "".equals(((Operator)replicationConfiguration.getOperator().get(i)).getSoapReplicationURL())) {
                throw new InvalidValueException(new ErrorMessage("errors.replication.contactNull", "Replication URL is null or empty"));
            }
            if (!((Operator)replicationConfiguration.getOperator().get(i)).getSoapReplicationURL().toLowerCase().startsWith("http")) {
                throw new InvalidValueException(new ErrorMessage("errors.replication.contactNull", "Replication URL is invalid, only HTTP is supported"));
            }
            if (((Operator)replicationConfiguration.getOperator().get(i)).getOperatorNodeID() != null && !((Operator)replicationConfiguration.getOperator().get(i)).getOperatorNodeID().equalsIgnoreCase("")) continue;
            throw new InvalidValueException(new ErrorMessage("errors.replication.contactNull", "Node ID is not defined"));
        }
        if (replicationConfiguration.getCommunicationGraph() != null) {
            for (String s : replicationConfiguration.getCommunicationGraph().getNode()) {
                if (this.Contains(replicationConfiguration.getOperator(), s)) continue;
                throw new InvalidValueException(new ErrorMessage("errors.replication.configNodeNotFound"));
            }
            for (String s : replicationConfiguration.getCommunicationGraph().getEdge()) {
                if (!this.Contains(replicationConfiguration.getOperator(), s.getMessageReceiver())) {
                    throw new InvalidValueException(new ErrorMessage("errors.replication.configNodeNotFound"));
                }
                if (!this.Contains(replicationConfiguration.getOperator(), s.getMessageSender())) {
                    throw new InvalidValueException(new ErrorMessage("errors.replication.configNodeNotFound"));
                }
                if (s.getMessageReceiver().equalsIgnoreCase(s.getMessageSender())) {
                    throw new InvalidValueException(new ErrorMessage("errors.replication.configNodeLoop"));
                }
                for (String id : s.getMessageReceiverAlternate()) {
                    if (this.Contains(replicationConfiguration.getOperator(), id)) continue;
                    throw new InvalidValueException(new ErrorMessage("errors.replication.configNodeNotFound"));
                }
            }
        }
        boolean shouldcheck = config.getBoolean("juddi.validation.rejectInvalidSignatures.enable", false);
        this.initDigSig(config);
        if (shouldcheck && !replicationConfiguration.getSignature().isEmpty() && this.ds != null && !(ok = this.ds.verifySignedUddiEntity((Object)replicationConfiguration, outmsg = new AtomicReference()))) {
            throw new FatalErrorException(new ErrorMessage("errors.digitalsignature.validationfailure " + (String)outmsg.get()));
        }
    }

    private synchronized void initDigSig(Configuration config) {
        if (this.ds == null) {
            Properties p = new Properties();
            p.put("trustStorePath", config.getString("juddi.validation.rejectInvalidSignatures.trustStorePath", ""));
            p.put("trustStoreType", config.getString("juddi.validation.rejectInvalidSignatures.trustStoreType", ""));
            String enc = config.getString("juddi.validation.rejectInvalidSignatures.trustStorePassword", "");
            if (config.getBoolean("juddi.validation.rejectInvalidSignatures.trustStorePassword[@isPasswordEncrypted]", false)) {
                log.debug((Object)"trust password is encrypted, decrypting...");
                String prov = config.getString("juddi.validation.rejectInvalidSignatures.trustStorePassword[@cryptoProvider]", "");
                try {
                    p.setProperty("trustStorePassword", CryptorFactory.getCryptor((String)prov).decrypt(enc));
                }
                catch (Exception ex) {
                    log.warn((Object)("unable to decrypt trust store password " + ex.getMessage()));
                    log.debug((Object)("unable to decrypt trust store password " + ex.getMessage()), (Throwable)ex);
                }
            } else if (!"".equals(enc)) {
                log.warn((Object)"Hey, you should consider encrypting your trust store password!");
                p.setProperty("trustStorePassword", enc);
            }
            p.put("checkRevocationCRL", config.getString("juddi.validation.rejectInvalidSignatures.checkRevocationCRL", "true"));
            p.put("checkTrust", config.getString("juddi.validation.rejectInvalidSignatures.checkTrust", "true"));
            p.put("checkTimestamps", config.getString("juddi.validation.rejectInvalidSignatures.checkTimestamps", "true"));
            try {
                this.ds = new DigSigUtil(p);
            }
            catch (CertificateException ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
    }

    private boolean Contains(List<Operator> operator, String s) {
        if (operator == null) {
            return false;
        }
        for (Operator o : operator) {
            if (!o.getOperatorNodeID().equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public void validateTransfer(EntityManager em, TransferCustody body) throws DispositionReportFaultMessage {
        String transferTokenId;
        if (body == null) {
            throw new TransferNotAllowedException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getTransferToken() == null) {
            throw new TransferNotAllowedException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getKeyBag() == null) {
            throw new TransferNotAllowedException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getTransferOperationalInfo() == null) {
            throw new TransferNotAllowedException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getTransferOperationalInfo().getNodeID() == null) {
            throw new TransferNotAllowedException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getTransferOperationalInfo().getAuthorizedName() == null) {
            throw new TransferNotAllowedException(new ErrorMessage("errors.NullInput"));
        }
        TransferEntities x = new TransferEntities();
        x.setKeyBag(body.getKeyBag());
        x.setTransferToken(body.getTransferToken());
        try {
            transferTokenId = new String(body.getTransferToken().getOpaqueToken(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidValueException(new ErrorMessage("errors.stringEncoding"));
        }
        new ValidateCustodyTransfer(null).validateTransferLocalEntities(em, transferTokenId, body.getKeyBag().getKey());
    }
}

