/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.model.Subscription;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.UnsupportedException;
import org.uddi.v3_service.DispositionReportFaultMessage;

public abstract class ValidateUDDIApi {
    protected UddiEntityPublisher publisher;
    protected String nodeID = null;

    public ValidateUDDIApi(UddiEntityPublisher publisher, String nodeid) {
        this.publisher = publisher;
        this.nodeID = nodeid;
    }

    public ValidateUDDIApi(UddiEntityPublisher publisher) {
        this.publisher = publisher;
        try {
            this.nodeID = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ex) {
            Logger.getLogger(ValidateUDDIApi.class.getName()).log(Level.SEVERE, "unable to get the current node id, this may cause access control problems and must be fixed. set juddi.nodeId in juddiv3.xml", ex);
        }
    }

    public UddiEntityPublisher getPublisher() {
        return this.publisher;
    }

    public void setPublisher(UddiEntityPublisher publisher) {
        this.publisher = publisher;
    }

    public static void unsupportedAPICall() throws DispositionReportFaultMessage {
        throw new UnsupportedException(new ErrorMessage("errors.Unsupported"));
    }

    public static boolean isUniqueKey(EntityManager em, String entityKey) {
        Object obj = em.find(UddiEntity.class, (Object)entityKey);
        if (obj != null) {
            return false;
        }
        obj = em.find(Subscription.class, (Object)entityKey);
        return obj == null;
    }
}

