/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.ValidValues;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.uddi.api_v3.TModel;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class ValidateValueSetValidation
extends ValidateUDDIApi {
    private static Log log = LogFactory.getLog(ValidateValueSetValidation.class);

    public ValidateValueSetValidation(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateSetAllValidValues(List<ValidValues> values) throws ValueNotAllowedException {
        if (values == null || values.isEmpty()) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.NullInput"));
        }
        for (int i = 0; i < values.size(); ++i) {
            String key = values.get(i).getTModekKey();
            if (key == null || key.trim().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.NullInput", "tModel key"));
            }
            Tmodel tm = ValidateValueSetValidation.GetTModel_MODEL_IfExists(values.get(i).getTModekKey());
            if (tm == null) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.invalidkey.TModelNotFound", key));
            }
            if (this.publisher.isOwner(tm)) continue;
            throw new ValueNotAllowedException(new ErrorMessage("errors.usermismatch.InvalidOwner", key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TModel GetTModel_API_IfExists(String tmodelKey) throws ValueNotAllowedException {
        EntityManager em = PersistenceManager.getEntityManager();
        TModel apitmodel = null;
        if (em == null) {
            log.warn((Object)new ErrorMessage("errors.tmodel.ReferentialIntegrityNullEM"));
            return null;
        }
        EntityTransaction tx = em.getTransaction();
        try {
            Tmodel modelTModel = null;
            tx.begin();
            modelTModel = (Tmodel)em.find(Tmodel.class, (Object)tmodelKey);
            if (modelTModel != null) {
                apitmodel = new TModel();
                try {
                    MappingModelToApi.mapTModel(modelTModel, apitmodel);
                }
                catch (DispositionReportFaultMessage ex) {
                    log.warn((Object)ex);
                    apitmodel = null;
                }
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return apitmodel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tmodel GetTModel_MODEL_IfExists(String tmodelKey) throws ValueNotAllowedException {
        EntityManager em = PersistenceManager.getEntityManager();
        Tmodel model = null;
        if (em == null) {
            log.warn((Object)new ErrorMessage("errors.tmodel.ReferentialIntegrityNullEM"));
            return null;
        }
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            model = (Tmodel)em.find(Tmodel.class, (Object)tmodelKey);
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return model;
    }
}

