/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.List;
import javax.xml.ws.BindingProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.UDDIValueSetValidationImpl;
import org.apache.juddi.v3.client.UDDIService;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.TModel;
import org.uddi.v3_service.UDDIValueSetValidationPortType;
import org.uddi.vs_v3.ValidateValues;

public class ValidateValuesFromWebService {
    private static final Log log = LogFactory.getLog(ValidateValuesFromWebService.class);

    private static UDDIValueSetValidationPortType getPort(String url) throws ValueNotAllowedException {
        UDDIService svc = new UDDIService();
        UDDIValueSetValidationPortType vsv = svc.getUDDIValueSetValidationPort();
        if (url == null || url.trim().length() == 0) {
            log.error((Object)"VSV Validation Failed: Calling Url is null");
            ValueNotAllowedException x = new ValueNotAllowedException(new ErrorMessage("errors.valuesetvalidation.invalidurl"));
            throw x;
        }
        if (url.startsWith("http://localhost:8080/juddiv3") || url.startsWith("https://localhost:8443/juddiv3")) {
            vsv = new UDDIValueSetValidationImpl();
        } else if (url.startsWith("classpath:/")) {
            try {
                String clz = url.substring(11);
                Class<?> forName = Class.forName(clz);
                vsv = (UDDIValueSetValidationPortType)forName.newInstance();
            }
            catch (Exception ex) {
                log.error((Object)("VSV Validation Failed: Cannot locate class from url " + url), (Throwable)ex);
            }
        } else if (url.toLowerCase().startsWith("http")) {
            log.info((Object)"Calling External VSV Service");
            ((BindingProvider)vsv).getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        } else {
            log.warn((Object)("Unable to figure out how to use the URL " + url + " as a Value Set Validation Service transport mechanism."));
            ValueNotAllowedException x = new ValueNotAllowedException(new ErrorMessage("errors.valuesetvalidation.invalidurl", url));
            throw x;
        }
        return vsv;
    }

    public static void ValidateTModel(String url, List<TModel> obj) throws ValueNotAllowedException {
        UDDIValueSetValidationPortType vsv = ValidateValuesFromWebService.getPort(url);
        ValidateValues req = new ValidateValues();
        req.getTModel().addAll(obj);
        try {
            vsv.validateValues(req);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            ValueNotAllowedException x = new ValueNotAllowedException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", ex.getMessage()));
            throw x;
        }
    }

    public static void ValidateBinding(String url, List<BindingTemplate> obj) throws ValueNotAllowedException {
        UDDIValueSetValidationPortType vsv = ValidateValuesFromWebService.getPort(url);
        ValidateValues req = new ValidateValues();
        req.getBindingTemplate().addAll(obj);
        try {
            vsv.validateValues(req);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            ValueNotAllowedException x = new ValueNotAllowedException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", ex.getMessage()));
            throw x;
        }
    }

    public static void ValidateService(String url, List<BusinessService> obj) throws ValueNotAllowedException {
        UDDIValueSetValidationPortType vsv = ValidateValuesFromWebService.getPort(url);
        ValidateValues req = new ValidateValues();
        req.getBusinessService().addAll(obj);
        try {
            vsv.validateValues(req);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            ValueNotAllowedException x = new ValueNotAllowedException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", ex.getMessage()));
            throw x;
        }
    }

    public static void ValidateBusiness(String url, List<BusinessEntity> obj) throws ValueNotAllowedException {
        UDDIValueSetValidationPortType vsv = ValidateValuesFromWebService.getPort(url);
        ValidateValues req = new ValidateValues();
        req.getBusinessEntity().addAll(obj);
        try {
            vsv.validateValues(req);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            ValueNotAllowedException x = new ValueNotAllowedException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", ex.getMessage()));
            throw x;
        }
    }

    public static void ValidatePubAss(String url, PublisherAssertion obj) throws ValueNotAllowedException {
        UDDIValueSetValidationPortType vsv = ValidateValuesFromWebService.getPort(url);
        ValidateValues req = new ValidateValues();
        req.getPublisherAssertion().add(obj);
        try {
            vsv.validateValues(req);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            ValueNotAllowedException x = new ValueNotAllowedException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", ex.getMessage()));
            throw x;
        }
    }
}

