/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation.vsv;

import java.util.ArrayList;
import java.util.List;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.InvalidValueException;
import org.apache.juddi.validation.vsv.ValueSetValidator;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.v3_service.DispositionReportFaultMessage;

public abstract class AbstractSimpleValidator
implements ValueSetValidator {
    public abstract String getMyKey();

    @Override
    public void validateValuesBindingTemplate(List<BindingTemplate> items, String xpath) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getCategoryBag() != null) {
                this.validatedValuesKeyRef(items.get(i).getCategoryBag().getKeyedReference(), xpath + "bindingTemplate(" + i + ").categoryBag.");
                this.validatedValuesKeyRefGrp(items.get(i).getCategoryBag().getKeyedReferenceGroup(), xpath + "bindingTemplate(" + i + ").categoryBag.");
            }
            if (items.get(i).getTModelInstanceDetails() == null) continue;
            this.validateTmodelInstanceDetails(items.get(i).getTModelInstanceDetails().getTModelInstanceInfo(), xpath + "bindingTemplate(" + i + ").tModelInstanceDetails.");
        }
    }

    @Override
    public void validateValuesBusinessEntity(List<BusinessEntity> items) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getCategoryBag() != null) {
                this.validatedValuesKeyRef(items.get(i).getCategoryBag().getKeyedReference(), "businessEntity(" + i + ").categoryBag.");
                this.validatedValuesKeyRefGrp(items.get(i).getCategoryBag().getKeyedReferenceGroup(), "businessEntity(" + i + ").categoryBagGroup.");
            }
            if (items.get(i).getIdentifierBag() != null) {
                this.validatedValuesKeyRef(items.get(i).getIdentifierBag().getKeyedReference(), "businessEntity(" + i + ").identifierBag.");
            }
            if (items.get(i).getBusinessServices() == null) continue;
            this.validateValuesBusinessService(items.get(i).getBusinessServices().getBusinessService(), "businessEntity(" + i + ").");
        }
    }

    @Override
    public void validateValuesBusinessService(List<BusinessService> items, String xpath) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getCategoryBag() != null) {
                this.validatedValuesKeyRef(items.get(i).getCategoryBag().getKeyedReference(), xpath + "businessService(" + i + ").categoryBag.");
                this.validatedValuesKeyRefGrp(items.get(i).getCategoryBag().getKeyedReferenceGroup(), xpath + "businessService(" + i + ").categoryBag.");
            }
            if (items.get(i).getBindingTemplates() == null) continue;
            this.validateValuesBindingTemplate(items.get(i).getBindingTemplates().getBindingTemplate(), xpath + xpath + "businessService(" + i + ").");
        }
    }

    @Override
    public void validateValuesPublisherAssertion(List<PublisherAssertion> items) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getKeyedReference() == null) continue;
            ArrayList<KeyedReference> temp = new ArrayList<KeyedReference>();
            temp.add(items.get(i).getKeyedReference());
            this.validatedValuesKeyRef(temp, "publisherAssertion(" + i + ").");
        }
    }

    private void validatedValuesKeyRef(List<KeyedReference> items, String xpath) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        StringBuilder err = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            List<String> validValues;
            if (!items.get(i).getTModelKey().equalsIgnoreCase(this.getMyKey()) || (validValues = this.getValidValues()) == null) continue;
            boolean localfound = false;
            for (int k = 0; k < validValues.size(); ++k) {
                if (!validValues.get(k).equals(items.get(i).getKeyValue())) continue;
                localfound = true;
            }
            if (localfound) continue;
            err.append(xpath).append("keyedReference(").append(i).append(")=").append(items.get(i).getKeyValue()).append(" ");
        }
        if (err.length() > 0) {
            throw new InvalidValueException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", err.toString() + this.getPrintableValidValues()));
        }
    }

    private void validatedValuesKeyRefGrp(List<KeyedReferenceGroup> items, String xpath) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            this.validatedValuesKeyRef(items.get(i).getKeyedReference(), xpath + "keyReferenceGroup(" + i + ").");
        }
    }

    @Override
    public void validateTmodelInstanceDetails(List<TModelInstanceInfo> tModelInstanceInfo, String xpath) throws DispositionReportFaultMessage {
    }

    @Override
    public abstract List<String> getValidValues();

    @Override
    public void validateValuesTModel(List<TModel> items) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getCategoryBag() != null) {
                this.validatedValuesKeyRef(items.get(i).getCategoryBag().getKeyedReference(), "tModel(" + i + ").categoryBag.");
                this.validatedValuesKeyRefGrp(items.get(i).getCategoryBag().getKeyedReferenceGroup(), "tModel(" + i + ").categoryBag.");
            }
            if (items.get(i).getIdentifierBag() == null) continue;
            this.validatedValuesKeyRef(items.get(i).getIdentifierBag().getKeyedReference(), "tModel(" + i + ").identifierBag.");
        }
    }

    public static void validateKeyNotPresentKeyRef(List<KeyedReference> items, String key, String itemtype) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            AbstractSimpleValidator.validateKeyNotPresentKeyRef(items.get(i), key, itemtype);
        }
    }

    public static void validateKeyNotPresentKeyRef(KeyedReference item, String key, String itemtype) throws DispositionReportFaultMessage {
        if (item == null) {
            return;
        }
        if (key.equalsIgnoreCase(item.getTModelKey())) {
            throw new InvalidValueException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", "key " + key + " not allowed on " + itemtype));
        }
    }

    public static void validateKeyNotPresentKeyRefGrp(List<KeyedReferenceGroup> items, String key, String itemtype) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (key.equalsIgnoreCase(items.get(i).getTModelKey())) {
                throw new InvalidValueException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", "key " + key + " not allowed on " + itemtype));
            }
            AbstractSimpleValidator.validateKeyNotPresentKeyRef(items.get(i).getKeyedReference(), key, itemtype);
        }
    }

    private String getPrintableValidValues() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Valid Values:[");
        List<String> validValues = this.getValidValues();
        for (int i = 0; i < validValues.size(); ++i) {
            sb.append(validValues.get(i));
            if (i + 1 >= validValues.size()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

