/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.cli;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.runtime.Connect;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.runtime.distributed.DistributedHerder;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.apache.kafka.connect.storage.KafkaOffsetBackingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
public class ConnectDistributed {
    private static final Logger log = LoggerFactory.getLogger(ConnectDistributed.class);

    public static void main(String[] args) throws Exception {
        String workerPropsFile;
        if (args.length < 1) {
            log.info("Usage: ConnectDistributed worker.properties");
            System.exit(1);
        }
        Map workerProps = !(workerPropsFile = args[0]).isEmpty() ? Utils.propsToStringMap((Properties)Utils.loadProps((String)workerPropsFile)) : Collections.emptyMap();
        DistributedConfig config = new DistributedConfig(workerProps);
        Worker worker = new Worker(config, new KafkaOffsetBackingStore());
        RestServer rest = new RestServer(config);
        DistributedHerder herder = new DistributedHerder(config, worker, rest.advertisedUrl());
        Connect connect = new Connect(worker, herder, rest);
        connect.start();
        connect.awaitStop();
    }
}

