/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.distributed.NotLeaderException;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.CreateConnectorRequest;
import org.apache.kafka.connect.runtime.rest.entities.TaskInfo;
import org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.apache.kafka.connect.util.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/connectors")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectorsResource {
    private static final Logger log = LoggerFactory.getLogger(ConnectorsResource.class);
    private static final long REQUEST_TIMEOUT_MS = 90000L;
    private final Herder herder;
    @Context
    private ServletContext context;

    public ConnectorsResource(Herder herder) {
        this.herder = herder;
    }

    @GET
    @Path(value="/")
    public Collection<String> listConnectors() throws Throwable {
        FutureCallback<Collection<String>> cb = new FutureCallback<Collection<String>>();
        this.herder.connectors(cb);
        return this.completeOrForwardRequest(cb, "/connectors", "GET", null, new TypeReference<Collection<String>>(){});
    }

    @POST
    @Path(value="/")
    public Response createConnector(CreateConnectorRequest createRequest) throws Throwable {
        String name = createRequest.name();
        Map<String, String> configs = createRequest.config();
        if (!configs.containsKey("name")) {
            configs.put("name", name);
        }
        FutureCallback<Herder.Created<ConnectorInfo>> cb = new FutureCallback<Herder.Created<ConnectorInfo>>();
        this.herder.putConnectorConfig(name, configs, false, cb);
        Herder.Created<ConnectorInfo> info = this.completeOrForwardRequest(cb, "/connectors", "POST", createRequest, new TypeReference<ConnectorInfo>(){}, new CreatedConnectorInfoTranslator());
        return Response.created((URI)URI.create("/connectors/" + name)).entity((Object)info.result()).build();
    }

    @GET
    @Path(value="/{connector}")
    public ConnectorInfo getConnector(@PathParam(value="connector") String connector) throws Throwable {
        FutureCallback<ConnectorInfo> cb = new FutureCallback<ConnectorInfo>();
        this.herder.connectorInfo(connector, cb);
        return this.completeOrForwardRequest(cb, "/connectors/" + connector, "GET", null, new TypeReference<ConnectorInfo>(){});
    }

    @GET
    @Path(value="/{connector}/config")
    public Map<String, String> getConnectorConfig(@PathParam(value="connector") String connector) throws Throwable {
        FutureCallback<Map<String, String>> cb = new FutureCallback<Map<String, String>>();
        this.herder.connectorConfig(connector, cb);
        return this.completeOrForwardRequest(cb, "/connectors/" + connector + "/config", "GET", null, new TypeReference<Map<String, String>>(){});
    }

    @PUT
    @Path(value="/{connector}/config")
    public Response putConnectorConfig(@PathParam(value="connector") String connector, Map<String, String> connectorConfig) throws Throwable {
        FutureCallback<Herder.Created<ConnectorInfo>> cb = new FutureCallback<Herder.Created<ConnectorInfo>>();
        this.herder.putConnectorConfig(connector, connectorConfig, true, cb);
        Herder.Created<ConnectorInfo> createdInfo = this.completeOrForwardRequest(cb, "/connectors/" + connector + "/config", "PUT", connectorConfig, new TypeReference<ConnectorInfo>(){}, new CreatedConnectorInfoTranslator());
        Response.ResponseBuilder response = createdInfo.created() ? Response.created((URI)URI.create("/connectors/" + connector)) : Response.ok();
        return response.entity((Object)createdInfo.result()).build();
    }

    @GET
    @Path(value="/{connector}/tasks")
    public List<TaskInfo> getTaskConfigs(@PathParam(value="connector") String connector) throws Throwable {
        FutureCallback<List<TaskInfo>> cb = new FutureCallback<List<TaskInfo>>();
        this.herder.taskConfigs(connector, cb);
        return this.completeOrForwardRequest(cb, "/connectors/" + connector + "/tasks", "GET", null, new TypeReference<List<TaskInfo>>(){});
    }

    @POST
    @Path(value="/{connector}/tasks")
    public void putTaskConfigs(@PathParam(value="connector") String connector, List<Map<String, String>> taskConfigs) throws Throwable {
        FutureCallback<Void> cb = new FutureCallback<Void>();
        this.herder.putTaskConfigs(connector, taskConfigs, cb);
        this.completeOrForwardRequest(cb, "/connectors/" + connector + "/tasks", "POST", taskConfigs);
    }

    @DELETE
    @Path(value="/{connector}")
    public void destroyConnector(@PathParam(value="connector") String connector) throws Throwable {
        FutureCallback<Herder.Created<ConnectorInfo>> cb = new FutureCallback<Herder.Created<ConnectorInfo>>();
        this.herder.putConnectorConfig(connector, null, true, cb);
        this.completeOrForwardRequest(cb, "/connectors/" + connector, "DELETE", null);
    }

    private <T, U> T completeOrForwardRequest(FutureCallback<T> cb, String path, String method, Object body, TypeReference<U> resultType, Translator<T, U> translator) throws Throwable {
        try {
            return cb.get(90000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NotLeaderException) {
                NotLeaderException notLeaderError = (NotLeaderException)((Object)e.getCause());
                String forwardUrl = RestServer.urlJoin(notLeaderError.leaderUrl(), path);
                log.debug("Forwarding request to leader: {} {} {}", new Object[]{forwardUrl, method, body});
                return translator.translate(RestServer.httpRequest(forwardUrl, method, body, resultType));
            }
            throw e.getCause();
        }
        catch (TimeoutException e) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request timed out");
        }
        catch (InterruptedException e) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request interrupted");
        }
    }

    private <T> T completeOrForwardRequest(FutureCallback<T> cb, String path, String method, Object body, TypeReference<T> resultType) throws Throwable {
        return this.completeOrForwardRequest(cb, path, method, body, resultType, new IdentityTranslator());
    }

    private <T> T completeOrForwardRequest(FutureCallback<T> cb, String path, String method, Object body) throws Throwable {
        return this.completeOrForwardRequest(cb, path, method, body, null, new IdentityTranslator());
    }

    private class CreatedConnectorInfoTranslator
    implements Translator<Herder.Created<ConnectorInfo>, ConnectorInfo> {
        private CreatedConnectorInfoTranslator() {
        }

        @Override
        public Herder.Created<ConnectorInfo> translate(RestServer.HttpResponse<ConnectorInfo> response) {
            boolean created = response.status() == 201;
            return new Herder.Created<ConnectorInfo>(created, response.body());
        }
    }

    private class IdentityTranslator<T>
    implements Translator<T, T> {
        private IdentityTranslator() {
        }

        @Override
        public T translate(RestServer.HttpResponse<T> response) {
            return response.body();
        }
    }

    private static interface Translator<T, U> {
        public T translate(RestServer.HttpResponse<U> var1);
    }
}

