/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.transforms.Transformation;

public class ConnectorConfig
extends AbstractConfig {
    protected static final String COMMON_GROUP = "Common";
    protected static final String TRANSFORMS_GROUP = "Transforms";
    public static final String NAME_CONFIG = "name";
    private static final String NAME_DOC = "Globally unique name to use for this connector.";
    private static final String NAME_DISPLAY = "Connector name";
    public static final String CONNECTOR_CLASS_CONFIG = "connector.class";
    private static final String CONNECTOR_CLASS_DOC = "Name or alias of the class for this connector. Must be a subclass of org.apache.kafka.connect.connector.Connector. If the connector is org.apache.kafka.connect.file.FileStreamSinkConnector, you can either specify this full name,  or use \"FileStreamSink\" or \"FileStreamSinkConnector\" to make the configuration a bit shorter";
    private static final String CONNECTOR_CLASS_DISPLAY = "Connector class";
    public static final String KEY_CONVERTER_CLASS_CONFIG = "key.converter";
    public static final String KEY_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the keys in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String KEY_CONVERTER_CLASS_DISPLAY = "Key converter class";
    public static final String VALUE_CONVERTER_CLASS_CONFIG = "value.converter";
    public static final String VALUE_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String VALUE_CONVERTER_CLASS_DISPLAY = "Value converter class";
    public static final String HEADER_CONVERTER_CLASS_CONFIG = "header.converter";
    public static final String HEADER_CONVERTER_CLASS_DOC = "HeaderConverter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the header values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro. By default, the SimpleHeaderConverter is used to serialize header values to strings and deserialize them by inferring the schemas.";
    public static final String HEADER_CONVERTER_CLASS_DISPLAY = "Header converter class";
    public static final String HEADER_CONVERTER_CLASS_DEFAULT = null;
    public static final String TASKS_MAX_CONFIG = "tasks.max";
    private static final String TASKS_MAX_DOC = "Maximum number of tasks to use for this connector.";
    public static final int TASKS_MAX_DEFAULT = 1;
    private static final int TASKS_MIN_CONFIG = 1;
    private static final String TASK_MAX_DISPLAY = "Tasks max";
    public static final String TRANSFORMS_CONFIG = "transforms";
    private static final String TRANSFORMS_DOC = "Aliases for the transformations to be applied to records.";
    private static final String TRANSFORMS_DISPLAY = "Transforms";
    private final EnrichedConnectorConfig enrichedConfig;

    public static ConfigDef configDef() {
        int orderInGroup = 0;
        return new ConfigDef().define(NAME_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.NonEmptyStringWithoutControlChars.nonEmptyStringWithoutControlChars(), ConfigDef.Importance.HIGH, NAME_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.MEDIUM, NAME_DISPLAY).define(CONNECTOR_CLASS_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, CONNECTOR_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.LONG, CONNECTOR_CLASS_DISPLAY).define(TASKS_MAX_CONFIG, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, TASKS_MAX_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, TASK_MAX_DISPLAY).define(KEY_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, KEY_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, KEY_CONVERTER_CLASS_DISPLAY).define(VALUE_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, VALUE_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, VALUE_CONVERTER_CLASS_DISPLAY).define(HEADER_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)HEADER_CONVERTER_CLASS_DEFAULT, ConfigDef.Importance.LOW, HEADER_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, HEADER_CONVERTER_CLASS_DISPLAY).define(TRANSFORMS_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{new ConfigDef.NonNullValidator(), new ConfigDef.Validator(){

            public void ensureValid(String name, Object value) {
                List transformAliases = (List)value;
                if (transformAliases.size() > new HashSet(transformAliases).size()) {
                    throw new ConfigException(name, value, "Duplicate alias provided.");
                }
            }
        }}), ConfigDef.Importance.LOW, TRANSFORMS_DOC, "Transforms", ++orderInGroup, ConfigDef.Width.LONG, "Transforms");
    }

    public ConnectorConfig(Plugins plugins) {
        this(plugins, new HashMap<String, String>());
    }

    public ConnectorConfig(Plugins plugins, Map<String, String> props) {
        this(plugins, ConnectorConfig.configDef(), props);
    }

    public ConnectorConfig(Plugins plugins, ConfigDef configDef, Map<String, String> props) {
        super(configDef, props);
        this.enrichedConfig = new EnrichedConnectorConfig(ConnectorConfig.enrich(plugins, configDef, props, true), props);
    }

    public Object get(String key) {
        return this.enrichedConfig.get(key);
    }

    public <R extends ConnectRecord<R>> List<Transformation<R>> transformations() {
        List transformAliases = this.getList(TRANSFORMS_CONFIG);
        ArrayList<Transformation<R>> transformations = new ArrayList<Transformation<R>>(transformAliases.size());
        for (String alias : transformAliases) {
            Transformation transformation;
            String prefix = "transforms." + alias + ".";
            try {
                transformation = this.getClass(prefix + "type").asSubclass(Transformation.class).newInstance();
            }
            catch (Exception e) {
                throw new ConnectException((Throwable)e);
            }
            transformation.configure(this.originalsWithPrefix(prefix));
            transformations.add(transformation);
        }
        return transformations;
    }

    public static ConfigDef enrich(Plugins plugins, ConfigDef baseConfigDef, Map<String, String> props, boolean requireFullConfig) {
        Object transformAliases = ConfigDef.parseType((String)TRANSFORMS_CONFIG, (Object)props.get(TRANSFORMS_CONFIG), (ConfigDef.Type)ConfigDef.Type.LIST);
        if (!(transformAliases instanceof List)) {
            return baseConfigDef;
        }
        ConfigDef newDef = new ConfigDef(baseConfigDef);
        LinkedHashSet uniqueTransformAliases = new LinkedHashSet((List)transformAliases);
        for (Object o : uniqueTransformAliases) {
            ConfigDef transformationConfigDef;
            if (!(o instanceof String)) {
                throw new ConfigException("Item in transforms property is not of type String");
            }
            String alias = (String)o;
            String prefix = "transforms." + alias + ".";
            String group = "Transforms: " + alias;
            int orderInGroup = 0;
            final String transformationTypeConfig = prefix + "type";
            ConfigDef.Validator typeValidator = new ConfigDef.Validator(){

                public void ensureValid(String name, Object value) {
                    ConnectorConfig.getConfigDefFromTransformation(transformationTypeConfig, (Class)value);
                }
            };
            newDef.define(transformationTypeConfig, ConfigDef.Type.CLASS, ConfigDef.NO_DEFAULT_VALUE, typeValidator, ConfigDef.Importance.HIGH, "Class for the '" + alias + "' transformation.", group, orderInGroup++, ConfigDef.Width.LONG, "Transformation type for " + alias, Collections.emptyList(), (ConfigDef.Recommender)new TransformationClassRecommender(plugins));
            try {
                String className = props.get(transformationTypeConfig);
                Class cls = (Class)ConfigDef.parseType((String)transformationTypeConfig, (Object)className, (ConfigDef.Type)ConfigDef.Type.CLASS);
                transformationConfigDef = ConnectorConfig.getConfigDefFromTransformation(transformationTypeConfig, cls);
            }
            catch (ConfigException e) {
                if (!requireFullConfig) continue;
                throw e;
            }
            newDef.embed(prefix, group, orderInGroup, transformationConfigDef);
        }
        return newDef;
    }

    static ConfigDef getConfigDefFromTransformation(String key, Class<?> transformationCls) {
        if (transformationCls == null || !Transformation.class.isAssignableFrom(transformationCls)) {
            throw new ConfigException(key, (Object)String.valueOf(transformationCls), "Not a Transformation");
        }
        try {
            return transformationCls.asSubclass(Transformation.class).newInstance().config();
        }
        catch (Exception e) {
            throw new ConfigException(key, (Object)String.valueOf(transformationCls), "Error getting config definition from Transformation: " + e.getMessage());
        }
    }

    static final class TransformationClassRecommender
    implements ConfigDef.Recommender {
        private final Plugins plugins;

        TransformationClassRecommender(Plugins plugins) {
            this.plugins = plugins;
        }

        public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
            ArrayList<Class<Transformation>> transformationPlugins = new ArrayList<Class<Transformation>>();
            for (PluginDesc<Transformation> plugin : this.plugins.transformations()) {
                transformationPlugins.add(plugin.pluginClass());
            }
            return Collections.unmodifiableList(transformationPlugins);
        }

        public boolean visible(String name, Map<String, Object> parsedConfig) {
            return true;
        }
    }

    private static class EnrichedConnectorConfig
    extends AbstractConfig {
        EnrichedConnectorConfig(ConfigDef configDef, Map<String, String> props) {
            super(configDef, props);
        }

        public Object get(String key) {
            return super.get(key);
        }
    }
}

