/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoader;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.transforms.Transformation;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(DelegatingClassLoader.class);
    private static final String CLASSPATH_NAME = "classpath";
    private final Map<String, SortedMap<PluginDesc<?>, ClassLoader>> pluginLoaders;
    private final Map<String, String> aliases;
    private final SortedSet<PluginDesc<Connector>> connectors;
    private final SortedSet<PluginDesc<Converter>> converters;
    private final SortedSet<PluginDesc<HeaderConverter>> headerConverters;
    private final SortedSet<PluginDesc<Transformation>> transformations;
    private final List<String> pluginPaths;
    private final Map<Path, PluginClassLoader> activePaths;

    public DelegatingClassLoader(List<String> pluginPaths, ClassLoader parent) {
        super(new URL[0], parent);
        this.pluginPaths = pluginPaths;
        this.pluginLoaders = new HashMap();
        this.aliases = new HashMap<String, String>();
        this.activePaths = new HashMap<Path, PluginClassLoader>();
        this.connectors = new TreeSet<PluginDesc<Connector>>();
        this.converters = new TreeSet<PluginDesc<Converter>>();
        this.headerConverters = new TreeSet<PluginDesc<HeaderConverter>>();
        this.transformations = new TreeSet<PluginDesc<Transformation>>();
    }

    public DelegatingClassLoader(List<String> pluginPaths) {
        this(pluginPaths, ClassLoader.getSystemClassLoader());
    }

    public Set<PluginDesc<Connector>> connectors() {
        return this.connectors;
    }

    public Set<PluginDesc<Converter>> converters() {
        return this.converters;
    }

    public Set<PluginDesc<HeaderConverter>> headerConverters() {
        return this.headerConverters;
    }

    public Set<PluginDesc<Transformation>> transformations() {
        return this.transformations;
    }

    public ClassLoader connectorLoader(Connector connector) {
        return this.connectorLoader(connector.getClass().getName());
    }

    public ClassLoader connectorLoader(String connectorClassOrAlias) {
        log.debug("Getting plugin class loader for connector: '{}'", (Object)connectorClassOrAlias);
        String fullName = this.aliases.containsKey(connectorClassOrAlias) ? this.aliases.get(connectorClassOrAlias) : connectorClassOrAlias;
        SortedMap<PluginDesc<?>, ClassLoader> inner = this.pluginLoaders.get(fullName);
        if (inner == null) {
            log.error("Plugin class loader for connector: '{}' was not found. Returning: {}", (Object)connectorClassOrAlias, (Object)this);
            return this;
        }
        return (ClassLoader)inner.get(inner.lastKey());
    }

    private static PluginClassLoader newPluginClassLoader(final URL pluginLocation, final URL[] urls, final ClassLoader parent) {
        return (PluginClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new PluginClassLoader(pluginLocation, urls, parent);
            }
        });
    }

    private <T> void addPlugins(Collection<PluginDesc<T>> plugins, ClassLoader loader) {
        for (PluginDesc<T> plugin : plugins) {
            String pluginClassName = plugin.className();
            SortedMap<PluginDesc<?>, ClassLoader> inner = this.pluginLoaders.get(pluginClassName);
            if (inner == null) {
                inner = new TreeMap();
                this.pluginLoaders.put(pluginClassName, inner);
                log.info("Added plugin '{}'", (Object)pluginClassName);
            }
            inner.put(plugin, loader);
        }
    }

    protected void initLoaders() {
        for (String configPath : this.pluginPaths) {
            this.initPluginLoader(configPath);
        }
        this.initPluginLoader(CLASSPATH_NAME);
        this.addAllAliases();
    }

    private void initPluginLoader(String path) {
        try {
            if (CLASSPATH_NAME.equals(path)) {
                this.scanUrlsAndAddPlugins(this.getParent(), ClasspathHelper.forJavaClassPath().toArray(new URL[0]), null);
            } else {
                Path pluginPath = Paths.get(path, new String[0]).toAbsolutePath();
                path = pluginPath.toString();
                if (Files.isDirectory(pluginPath, new LinkOption[0])) {
                    for (Path pluginLocation : PluginUtils.pluginLocations(pluginPath)) {
                        this.registerPlugin(pluginLocation);
                    }
                } else if (PluginUtils.isArchive(pluginPath)) {
                    this.registerPlugin(pluginPath);
                }
            }
        }
        catch (MalformedURLException | InvalidPathException e) {
            log.error("Invalid path in plugin path: {}. Ignoring.", (Object)path, (Object)e);
        }
        catch (IOException e) {
            log.error("Could not get listing for plugin path: {}. Ignoring.", (Object)path, (Object)e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Could not instantiate plugins in: {}. Ignoring: {}", (Object)path, (Object)e);
        }
    }

    private void registerPlugin(Path pluginLocation) throws InstantiationException, IllegalAccessException, IOException {
        log.info("Loading plugin from: {}", (Object)pluginLocation);
        ArrayList<URL> pluginUrls = new ArrayList<URL>();
        for (Path path : PluginUtils.pluginUrls(pluginLocation)) {
            pluginUrls.add(path.toUri().toURL());
        }
        Object[] urls = pluginUrls.toArray(new URL[0]);
        if (log.isDebugEnabled()) {
            log.debug("Loading plugin urls: {}", (Object)Arrays.toString(urls));
        }
        PluginClassLoader loader = DelegatingClassLoader.newPluginClassLoader(pluginLocation.toUri().toURL(), (URL[])urls, this);
        this.scanUrlsAndAddPlugins(loader, (URL[])urls, pluginLocation);
    }

    private void scanUrlsAndAddPlugins(ClassLoader loader, URL[] urls, Path pluginLocation) throws InstantiationException, IllegalAccessException {
        PluginScanResult plugins = this.scanPluginPath(loader, urls);
        log.info("Registered loader: {}", (Object)loader);
        if (!plugins.isEmpty()) {
            if (loader instanceof PluginClassLoader) {
                this.activePaths.put(pluginLocation, (PluginClassLoader)loader);
            }
            this.addPlugins(plugins.connectors(), loader);
            this.connectors.addAll(plugins.connectors());
            this.addPlugins(plugins.converters(), loader);
            this.converters.addAll(plugins.converters());
            this.addPlugins(plugins.headerConverters(), loader);
            this.headerConverters.addAll(plugins.headerConverters());
            this.addPlugins(plugins.transformations(), loader);
            this.transformations.addAll(plugins.transformations());
        }
        this.loadJdbcDrivers(loader);
    }

    private void loadJdbcDrivers(final ClassLoader loader) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ServiceLoader<Driver> loadedDrivers = ServiceLoader.load(Driver.class, loader);
                Iterator<Driver> driversIterator = loadedDrivers.iterator();
                try {
                    while (driversIterator.hasNext()) {
                        Driver driver = driversIterator.next();
                        log.debug("Registered java.sql.Driver: {} to java.sql.DriverManager", (Object)driver);
                    }
                }
                catch (Throwable t) {
                    log.debug("Ignoring java.sql.Driver classes listed in resources but not present in class loader's classpath: ", t);
                }
                return null;
            }
        });
    }

    private PluginScanResult scanPluginPath(ClassLoader loader, URL[] urls) throws InstantiationException, IllegalAccessException {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.setClassLoaders(new ClassLoader[]{loader});
        builder.addUrls(urls);
        builder.setScanners(new Scanner[]{new SubTypesScanner()});
        builder.useParallelExecutor();
        InternalReflections reflections = new InternalReflections((Configuration)builder);
        return new PluginScanResult(this.getPluginDesc(reflections, Connector.class, loader), this.getPluginDesc(reflections, Converter.class, loader), this.getPluginDesc(reflections, HeaderConverter.class, loader), this.getPluginDesc(reflections, Transformation.class, loader));
    }

    private <T> Collection<PluginDesc<T>> getPluginDesc(Reflections reflections, Class<T> klass, ClassLoader loader) throws InstantiationException, IllegalAccessException {
        Set plugins = reflections.getSubTypesOf(klass);
        ArrayList<PluginDesc<T>> result = new ArrayList<PluginDesc<T>>();
        for (Class plugin : plugins) {
            if (!PluginUtils.isConcrete(plugin)) continue;
            if (Connector.class.isAssignableFrom(plugin)) {
                result.add(new PluginDesc(plugin, ((Connector)plugin.newInstance()).version(), loader));
                continue;
            }
            result.add(new PluginDesc(plugin, "undefined", loader));
        }
        return result;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!PluginUtils.shouldLoadInIsolation(name)) {
            return super.loadClass(name, resolve);
        }
        String fullName = this.aliases.containsKey(name) ? this.aliases.get(name) : name;
        SortedMap<PluginDesc<?>, ClassLoader> inner = this.pluginLoaders.get(fullName);
        if (inner != null) {
            ClassLoader pluginLoader = (ClassLoader)inner.get(inner.lastKey());
            log.trace("Retrieving loaded class '{}' from '{}'", (Object)fullName, (Object)pluginLoader);
            return pluginLoader instanceof PluginClassLoader ? ((PluginClassLoader)pluginLoader).loadClass(fullName, resolve) : super.loadClass(fullName, resolve);
        }
        return super.loadClass(fullName, resolve);
    }

    private void addAllAliases() {
        this.addAliases(this.connectors);
        this.addAliases(this.converters);
        this.addAliases(this.headerConverters);
        this.addAliases(this.transformations);
    }

    private <S> void addAliases(Collection<PluginDesc<S>> plugins) {
        for (PluginDesc pluginDesc : plugins) {
            if (!PluginUtils.isAliasUnique(pluginDesc, plugins)) continue;
            String simple = PluginUtils.simpleName(pluginDesc);
            String pruned = PluginUtils.prunedName(pluginDesc);
            this.aliases.put(simple, pluginDesc.className());
            if (simple.equals(pruned)) {
                log.info("Added alias '{}' to plugin '{}'", (Object)simple, (Object)pluginDesc.className());
                continue;
            }
            this.aliases.put(pruned, pluginDesc.className());
            log.info("Added aliases '{}' and '{}' to plugin '{}'", new Object[]{simple, pruned, pluginDesc.className()});
        }
    }

    private static class InternalReflections
    extends Reflections {
        public InternalReflections(Configuration configuration) {
            super(configuration);
        }

        protected void scan(URL url) {
            block2: {
                try {
                    super.scan(url);
                }
                catch (ReflectionsException e) {
                    Logger log = Reflections.log;
                    if (log == null || !log.isWarnEnabled()) break block2;
                    log.warn("could not create Vfs.Dir from url. ignoring the exception and continuing", (Throwable)e);
                }
            }
        }
    }
}

