/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.Herder;

public class HerderProvider {
    private final CountDownLatch initialized = new CountDownLatch(1);
    volatile Herder herder = null;

    public HerderProvider() {
    }

    public HerderProvider(Herder herder) {
        this.herder = herder;
        this.initialized.countDown();
    }

    public Herder get() {
        try {
            if (!this.initialized.await(1L, TimeUnit.MINUTES)) {
                throw new ConnectException("Timed out waiting for herder to be initialized.");
            }
        }
        catch (InterruptedException e) {
            throw new ConnectException("Interrupted while waiting for herder to be initialized.", (Throwable)e);
        }
        return this.herder;
    }

    public void setHerder(Herder herder) {
        this.herder = herder;
        this.initialized.countDown();
    }
}

