/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.reflections.vfs.Vfs;

public class ReflectionsUtil {
    private static final String FILE_PROTOCOL = "file";
    private static final List<String> ENDINGS = Arrays.asList(".mar", ".jnilib", "*");

    public static void registerUrlTypes() {
        LinkedList<EmptyUrlType> urlTypes = new LinkedList<EmptyUrlType>();
        urlTypes.add(new EmptyUrlType(ENDINGS));
        urlTypes.addAll(Arrays.asList(Vfs.DefaultUrlTypes.values()));
        Vfs.setDefaultURLTypes(urlTypes);
    }

    private static class EmptyUrlType
    implements Vfs.UrlType {
        private final List<String> endings;

        private EmptyUrlType(List<String> endings) {
            this.endings = endings;
        }

        public boolean matches(URL url) {
            String protocol = url.getProtocol();
            String externalForm = url.toExternalForm();
            if (!protocol.equals(ReflectionsUtil.FILE_PROTOCOL)) {
                return false;
            }
            for (String ending : this.endings) {
                if (!externalForm.endsWith(ending)) continue;
                return true;
            }
            return false;
        }

        public Vfs.Dir createDir(URL url) throws Exception {
            return EmptyUrlType.emptyVfsDir(url);
        }

        private static Vfs.Dir emptyVfsDir(final URL url) {
            return new Vfs.Dir(){

                public String getPath() {
                    return url.toExternalForm();
                }

                public Iterable<Vfs.File> getFiles() {
                    return Collections.emptyList();
                }

                public void close() {
                }
            };
        }
    }
}

