/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.Scope;
import java.util.Objects;

public class ConfluentConnectClusterId {
    private final String id;
    private final Scope scope;

    public ConfluentConnectClusterId(String kafkaClusterId, String connectClusterId) {
        this("", ConfluentConnectClusterId.scope(kafkaClusterId, connectClusterId));
    }

    public ConfluentConnectClusterId(@JsonProperty(value="id") String id, @JsonProperty(value="scope") Scope scope) {
        this.id = Objects.requireNonNull(id, "id may not be null");
        this.scope = Objects.requireNonNull(scope, "scope may not be null");
    }

    @JsonProperty
    public String id() {
        return this.id;
    }

    @JsonProperty
    public Scope scope() {
        return this.scope;
    }

    private static Scope scope(String kafkaClusterId, String connectClusterId) {
        return new Scope.Builder(new String[0]).withKafkaCluster(kafkaClusterId).withCluster("connect-cluster", connectClusterId).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfluentConnectClusterId that = (ConfluentConnectClusterId)o;
        return this.id.equals(that.id) && this.scope.equals((Object)that.scope);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.scope);
    }

    public String toString() {
        return "ConfluentClusterId{id='" + this.id + '\'' + ", scope=" + this.scope + '}';
    }
}

