/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.FutureCallback;
import org.apache.kafka.connect.util.TopicAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBasedLog<K, V> {
    private static final Logger log = LoggerFactory.getLogger(KafkaBasedLog.class);
    private static final long MAX_SLEEP_MS = TimeUnit.SECONDS.toMillis(1L);
    private Time time;
    private final long createTopicTimeoutNs;
    private final String topic;
    private int partitionCount;
    private final Map<String, Object> producerConfigs;
    private final Map<String, Object> consumerConfigs;
    private final Callback<ConsumerRecord<K, V>> consumedCallback;
    private final Supplier<TopicAdmin> topicAdminSupplier;
    private Consumer<K, V> consumer;
    private Producer<K, V> producer;
    private TopicAdmin admin;
    private Thread thread;
    private boolean stopRequested;
    private Queue<Callback<Void>> readLogEndOffsetCallbacks;
    private java.util.function.Consumer<TopicAdmin> initializer;

    @Deprecated
    public KafkaBasedLog(String topic, Map<String, Object> producerConfigs, Map<String, Object> consumerConfigs, Callback<ConsumerRecord<K, V>> consumedCallback, Time time, Runnable initializer, long createTopicTimeoutMs) {
        this(topic, producerConfigs, consumerConfigs, () -> null, consumedCallback, time, initializer != null ? admin -> initializer.run() : null, createTopicTimeoutMs);
    }

    public KafkaBasedLog(String topic, Map<String, Object> producerConfigs, Map<String, Object> consumerConfigs, Supplier<TopicAdmin> topicAdminSupplier, Callback<ConsumerRecord<K, V>> consumedCallback, Time time, java.util.function.Consumer<TopicAdmin> initializer, long createTopicTimeoutMs) {
        this.topic = topic;
        this.producerConfigs = producerConfigs;
        this.consumerConfigs = consumerConfigs;
        this.topicAdminSupplier = Objects.requireNonNull(topicAdminSupplier);
        this.consumedCallback = consumedCallback;
        this.stopRequested = false;
        this.readLogEndOffsetCallbacks = new ArrayDeque<Callback<Void>>();
        this.time = time;
        this.createTopicTimeoutNs = TimeUnit.MILLISECONDS.toNanos(createTopicTimeoutMs);
        this.initializer = initializer != null ? initializer : admin -> {};
    }

    public KafkaBasedLog(String topic, Map<String, Object> producerConfigs, Map<String, Object> consumerConfigs, Callback<ConsumerRecord<K, V>> consumedCallback, Time time, Runnable initializer) {
        this(topic, producerConfigs, consumerConfigs, consumedCallback, time, initializer, TimeUnit.SECONDS.toMillis(30L));
    }

    public KafkaBasedLog(String topic, Map<String, Object> producerConfigs, Map<String, Object> consumerConfigs, Supplier<TopicAdmin> topicAdminSupplier, Callback<ConsumerRecord<K, V>> consumedCallback, Time time, java.util.function.Consumer<TopicAdmin> initializer) {
        this(topic, producerConfigs, consumerConfigs, topicAdminSupplier, consumedCallback, time, initializer, TimeUnit.SECONDS.toMillis(30L));
    }

    public void start() {
        log.info("Starting KafkaBasedLog with topic " + this.topic);
        this.admin = this.topicAdminSupplier.get();
        this.initializer.accept(this.admin);
        this.producer = this.createProducer();
        this.consumer = this.createConsumer();
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        List partitionInfos = this.consumer.partitionsFor(this.topic);
        long started = this.time.nanoseconds();
        long sleepMs = 100L;
        while (partitionInfos == null && this.time.nanoseconds() - started < this.createTopicTimeoutNs) {
            this.time.sleep(sleepMs);
            sleepMs = Math.min(2L * sleepMs, MAX_SLEEP_MS);
            partitionInfos = this.consumer.partitionsFor(this.topic);
        }
        if (partitionInfos == null) {
            throw new ConnectException("Could not look up partition metadata for offset backing store topic in allotted period. This could indicate a connectivity issue, unavailable topic partitions, or if this is your first use of the topic it may have taken too long to create.");
        }
        for (PartitionInfo partition : partitionInfos) {
            partitions.add(new TopicPartition(partition.topic(), partition.partition()));
        }
        this.partitionCount = partitions.size();
        this.consumer.assign(partitions);
        this.consumer.seekToBeginning(partitions);
        this.readToLogEnd();
        this.thread = new WorkThread();
        this.thread.start();
        log.info("Finished reading KafkaBasedLog for topic " + this.topic);
        log.info("Started KafkaBasedLog for topic " + this.topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        log.info("Stopping KafkaBasedLog for topic " + this.topic);
        KafkaBasedLog kafkaBasedLog = this;
        synchronized (kafkaBasedLog) {
            this.stopRequested = true;
        }
        if (this.consumer != null) {
            this.consumer.wakeup();
        }
        try {
            if (this.thread != null) {
                this.thread.join();
            }
        }
        catch (InterruptedException e) {
            throw new ConnectException("Failed to stop KafkaBasedLog. Exiting without cleanly shutting down it's producer and consumer.", (Throwable)e);
        }
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (KafkaException e) {
                log.error("Failed to stop KafkaBasedLog producer", (Throwable)e);
            }
        }
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (KafkaException e) {
                log.error("Failed to stop KafkaBasedLog consumer", (Throwable)e);
            }
        }
        this.admin = null;
        log.info("Stopped KafkaBasedLog for topic " + this.topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readToEnd(Callback<Void> callback) {
        log.trace("Starting read to end log for topic {}", (Object)this.topic);
        if (this.producer != null) {
            this.producer.flush();
        }
        KafkaBasedLog kafkaBasedLog = this;
        synchronized (kafkaBasedLog) {
            this.readLogEndOffsetCallbacks.add(callback);
        }
        this.consumer.wakeup();
    }

    public void flush() {
        if (this.producer == null) {
            throw new IllegalStateException("Producer accessed but was never created");
        }
        this.producer.flush();
    }

    public Future<Void> readToEnd() {
        FutureCallback<Void> future = new FutureCallback<Void>(null);
        this.readToEnd(future);
        return future;
    }

    public void send(K key, V value) {
        this.send(key, value, null);
    }

    public void send(K key, V value, org.apache.kafka.clients.producer.Callback callback) {
        if (this.producer == null) {
            throw new IllegalStateException("Producer accessed but was never created");
        }
        this.producer.send(new ProducerRecord(this.topic, key, value), callback);
    }

    public int partitionCount() {
        return this.partitionCount;
    }

    public long createTopicTimeoutMs() {
        return TimeUnit.NANOSECONDS.toMillis(this.createTopicTimeoutNs);
    }

    private Producer<K, V> createProducer() {
        if (this.producerConfigs == null) {
            return null;
        }
        this.producerConfigs.put("acks", "all");
        this.producerConfigs.put("max.in.flight.requests.per.connection", 1);
        return new KafkaProducer(this.producerConfigs);
    }

    private Consumer<K, V> createConsumer() {
        this.consumerConfigs.put("auto.offset.reset", "earliest");
        this.consumerConfigs.put("enable.auto.commit", false);
        return new KafkaConsumer(this.consumerConfigs);
    }

    private void poll(long timeoutMs) {
        try {
            ConsumerRecords records = this.consumer.poll(Duration.ofMillis(timeoutMs));
            for (ConsumerRecord record : records) {
                this.consumedCallback.onCompletion(null, record);
            }
        }
        catch (WakeupException e) {
            throw e;
        }
        catch (KafkaException e) {
            log.error("Error polling: " + (Object)((Object)e));
        }
    }

    private void readToLogEnd() {
        Set assignment = this.consumer.assignment();
        Map<TopicPartition, Long> endOffsets = this.readEndOffsets(assignment);
        log.trace("Reading to end of log offsets {}", endOffsets);
        block0: while (!endOffsets.isEmpty()) {
            Iterator<Map.Entry<TopicPartition, Long>> it = endOffsets.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<TopicPartition, Long> entry = it.next();
                TopicPartition topicPartition = entry.getKey();
                long endOffset = entry.getValue();
                long lastConsumedOffset = this.consumer.position(topicPartition);
                if (lastConsumedOffset >= endOffset) {
                    log.trace("Read to end offset {} for {}", (Object)endOffset, (Object)topicPartition);
                    it.remove();
                    continue;
                }
                log.trace("Behind end offset {} for {}; last-read offset is {}", new Object[]{endOffset, topicPartition, lastConsumedOffset});
                this.poll(Integer.MAX_VALUE);
                continue block0;
            }
        }
    }

    Map<TopicPartition, Long> readEndOffsets(Set<TopicPartition> assignment) {
        log.trace("Reading to end of offset log");
        if (this.admin != null) {
            try {
                return this.admin.endOffsets(assignment);
            }
            catch (UnsupportedVersionException e) {
                log.debug("Reading to end of log offsets with consumer since admin client is unsupported: {}", (Object)e.getMessage());
                this.admin = null;
            }
        }
        return this.consumer.endOffsets(assignment);
    }

    private class WorkThread
    extends Thread {
        public WorkThread() {
            super("KafkaBasedLog Work Thread - " + KafkaBasedLog.this.topic);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                log.trace("{} started execution", (Object)this);
                while (true) {
                    int numCallbacks;
                    KafkaBasedLog kafkaBasedLog = KafkaBasedLog.this;
                    synchronized (kafkaBasedLog) {
                        if (KafkaBasedLog.this.stopRequested) {
                            break;
                        }
                        numCallbacks = KafkaBasedLog.this.readLogEndOffsetCallbacks.size();
                    }
                    if (numCallbacks > 0) {
                        try {
                            KafkaBasedLog.this.readToLogEnd();
                            log.trace("Finished read to end log for topic {}", (Object)KafkaBasedLog.this.topic);
                        }
                        catch (TimeoutException e) {
                            log.warn("Timeout while reading log to end for topic '{}'. Retrying automatically. This may occur when brokers are unavailable or unreachable. Reason: {}", (Object)KafkaBasedLog.this.topic, (Object)e.getMessage());
                            continue;
                        }
                        catch (org.apache.kafka.common.errors.RetriableException | RetriableException e) {
                            log.warn("Retriable error while reading log to end for topic '{}'. Retrying automatically. Reason: {}", (Object)KafkaBasedLog.this.topic, (Object)e.getMessage());
                            continue;
                        }
                        catch (WakeupException e) {
                            continue;
                        }
                    }
                    KafkaBasedLog e = KafkaBasedLog.this;
                    synchronized (e) {
                        for (int i = 0; i < numCallbacks; ++i) {
                            Callback cb = (Callback)KafkaBasedLog.this.readLogEndOffsetCallbacks.poll();
                            cb.onCompletion(null, null);
                        }
                    }
                    try {
                        KafkaBasedLog.this.poll(Integer.MAX_VALUE);
                    }
                    catch (WakeupException e2) {}
                }
            }
            catch (Throwable t) {
                log.error("Unexpected exception in {}", (Object)this, (Object)t);
            }
        }
    }
}

