/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.connect.runtime.AbstractStatus;

public class ConnectMetricsRegistry {
    public static final String CONNECTOR_TAG_NAME = "connector";
    public static final String TASK_TAG_NAME = "task";
    public static final String CONNECTOR_GROUP_NAME = "connector-metrics";
    public static final String TASK_GROUP_NAME = "connector-task-metrics";
    public static final String SOURCE_TASK_GROUP_NAME = "source-task-metrics";
    public static final String SINK_TASK_GROUP_NAME = "sink-task-metrics";
    public static final String WORKER_GROUP_NAME = "connect-worker-metrics";
    public static final String WORKER_REBALANCE_GROUP_NAME = "connect-worker-rebalance-metrics";
    public static final String TASK_ERROR_HANDLING_GROUP_NAME = "task-error-metrics";
    private final List<MetricNameTemplate> allTemplates = new ArrayList<MetricNameTemplate>();
    public final MetricNameTemplate connectorStatus;
    public final MetricNameTemplate connectorType;
    public final MetricNameTemplate connectorClass;
    public final MetricNameTemplate connectorVersion;
    public final MetricNameTemplate connectorTotalTaskCount;
    public final MetricNameTemplate legacyConnectorTotalTaskCount;
    public final MetricNameTemplate connectorRunningTaskCount;
    public final MetricNameTemplate connectorPausedTaskCount;
    public final MetricNameTemplate connectorFailedTaskCount;
    public final MetricNameTemplate connectorUnassignedTaskCount;
    public final MetricNameTemplate connectorDestroyedTaskCount;
    public final MetricNameTemplate connectorRestartingTaskCount;
    public final MetricNameTemplate taskStatus;
    public final MetricNameTemplate taskRunningRatio;
    public final MetricNameTemplate taskPauseRatio;
    public final MetricNameTemplate taskCommitTimeMax;
    public final MetricNameTemplate taskCommitTimeAvg;
    public final MetricNameTemplate taskBatchSizeMax;
    public final MetricNameTemplate taskBatchSizeAvg;
    public final MetricNameTemplate taskCommitFailurePercentage;
    public final MetricNameTemplate taskCommitSuccessPercentage;
    public final MetricNameTemplate sourceRecordPollRate;
    public final MetricNameTemplate sourceRecordPollTotal;
    public final MetricNameTemplate sourceRecordWriteRate;
    public final MetricNameTemplate sourceRecordWriteTotal;
    public final MetricNameTemplate sourceRecordPollBatchTimeMax;
    public final MetricNameTemplate sourceRecordPollBatchTimeAvg;
    public final MetricNameTemplate sourceRecordActiveCount;
    public final MetricNameTemplate sourceRecordActiveCountMax;
    public final MetricNameTemplate sourceRecordActiveCountAvg;
    public final MetricNameTemplate sinkRecordReadRate;
    public final MetricNameTemplate sinkRecordReadTotal;
    public final MetricNameTemplate sinkRecordSendRate;
    public final MetricNameTemplate sinkRecordSendTotal;
    public final MetricNameTemplate sinkRecordLagMax;
    public final MetricNameTemplate sinkRecordPartitionCount;
    public final MetricNameTemplate sinkRecordOffsetCommitSeqNum;
    public final MetricNameTemplate sinkRecordOffsetCommitCompletionRate;
    public final MetricNameTemplate sinkRecordOffsetCommitCompletionTotal;
    public final MetricNameTemplate sinkRecordOffsetCommitSkipRate;
    public final MetricNameTemplate sinkRecordOffsetCommitSkipTotal;
    public final MetricNameTemplate sinkRecordPutBatchTimeMax;
    public final MetricNameTemplate sinkRecordPutBatchTimeAvg;
    public final MetricNameTemplate sinkRecordActiveCount;
    public final MetricNameTemplate sinkRecordActiveCountMax;
    public final MetricNameTemplate sinkRecordActiveCountAvg;
    public final MetricNameTemplate connectorCount;
    public final MetricNameTemplate taskCount;
    public final MetricNameTemplate connectorStartupAttemptsTotal;
    public final MetricNameTemplate connectorStartupSuccessTotal;
    public final MetricNameTemplate connectorStartupSuccessPercentage;
    public final MetricNameTemplate connectorStartupFailureTotal;
    public final MetricNameTemplate connectorStartupFailurePercentage;
    public final MetricNameTemplate taskStartupAttemptsTotal;
    public final MetricNameTemplate taskStartupSuccessTotal;
    public final MetricNameTemplate taskStartupSuccessPercentage;
    public final MetricNameTemplate taskStartupFailureTotal;
    public final MetricNameTemplate taskStartupFailurePercentage;
    public final MetricNameTemplate connectProtocol;
    public final MetricNameTemplate leaderName;
    public final MetricNameTemplate epoch;
    public final MetricNameTemplate rebalanceCompletedTotal;
    public final MetricNameTemplate rebalanceMode;
    public final MetricNameTemplate rebalanceTimeMax;
    public final MetricNameTemplate rebalanceTimeAvg;
    public final MetricNameTemplate rebalanceTimeSinceLast;
    public final MetricNameTemplate recordProcessingFailures;
    public final MetricNameTemplate recordProcessingErrors;
    public final MetricNameTemplate recordsSkipped;
    public final MetricNameTemplate retries;
    public final MetricNameTemplate errorsLogged;
    public final MetricNameTemplate dlqProduceRequests;
    public final MetricNameTemplate dlqProduceFailures;
    public final MetricNameTemplate lastErrorTimestamp;
    public Map<MetricNameTemplate, AbstractStatus.State> connectorStatusMetrics;

    public ConnectMetricsRegistry() {
        this(new LinkedHashSet<String>());
    }

    public ConnectMetricsRegistry(Set<String> tags) {
        LinkedHashSet<String> connectorTags = new LinkedHashSet<String>(tags);
        connectorTags.add(CONNECTOR_TAG_NAME);
        this.connectorStatus = this.createTemplate("status", CONNECTOR_GROUP_NAME, "The status of the connector. One of 'unassigned', 'running', 'paused', 'failed', or 'destroyed'.", connectorTags);
        this.connectorType = this.createTemplate("connector-type", CONNECTOR_GROUP_NAME, "The type of the connector. One of 'source' or 'sink'.", connectorTags);
        this.connectorClass = this.createTemplate("connector-class", CONNECTOR_GROUP_NAME, "The name of the connector class.", connectorTags);
        this.connectorVersion = this.createTemplate("connector-version", CONNECTOR_GROUP_NAME, "The version of the connector class, as reported by the connector.", connectorTags);
        this.legacyConnectorTotalTaskCount = this.createTemplate("connector-total-task-count", CONNECTOR_GROUP_NAME, "The number of tasks of the connector.", connectorTags);
        LinkedHashSet<String> workerTaskTags = new LinkedHashSet<String>(tags);
        workerTaskTags.add(CONNECTOR_TAG_NAME);
        workerTaskTags.add(TASK_TAG_NAME);
        this.taskStatus = this.createTemplate("status", TASK_GROUP_NAME, "The status of the connector task. One of 'unassigned', 'running', 'paused', 'failed', or 'destroyed'.", workerTaskTags);
        this.taskRunningRatio = this.createTemplate("running-ratio", TASK_GROUP_NAME, "The fraction of time this task has spent in the running state.", workerTaskTags);
        this.taskPauseRatio = this.createTemplate("pause-ratio", TASK_GROUP_NAME, "The fraction of time this task has spent in the pause state.", workerTaskTags);
        this.taskCommitTimeMax = this.createTemplate("offset-commit-max-time-ms", TASK_GROUP_NAME, "The maximum time in milliseconds taken by this task to commit offsets.", workerTaskTags);
        this.taskCommitTimeAvg = this.createTemplate("offset-commit-avg-time-ms", TASK_GROUP_NAME, "The average time in milliseconds taken by this task to commit offsets.", workerTaskTags);
        this.taskBatchSizeMax = this.createTemplate("batch-size-max", TASK_GROUP_NAME, "The maximum size of the batches processed by the connector.", workerTaskTags);
        this.taskBatchSizeAvg = this.createTemplate("batch-size-avg", TASK_GROUP_NAME, "The average size of the batches processed by the connector.", workerTaskTags);
        this.taskCommitFailurePercentage = this.createTemplate("offset-commit-failure-percentage", TASK_GROUP_NAME, "The average percentage of this task's offset commit attempts that failed.", workerTaskTags);
        this.taskCommitSuccessPercentage = this.createTemplate("offset-commit-success-percentage", TASK_GROUP_NAME, "The average percentage of this task's offset commit attempts that succeeded.", workerTaskTags);
        LinkedHashSet<String> sourceTaskTags = new LinkedHashSet<String>(tags);
        sourceTaskTags.add(CONNECTOR_TAG_NAME);
        sourceTaskTags.add(TASK_TAG_NAME);
        this.sourceRecordPollRate = this.createTemplate("source-record-poll-rate", SOURCE_TASK_GROUP_NAME, "The average per-second number of records produced/polled (before transformation) by this task belonging to the named source connector in this worker.", sourceTaskTags);
        this.sourceRecordPollTotal = this.createTemplate("source-record-poll-total", SOURCE_TASK_GROUP_NAME, "The total number of records produced/polled (before transformation) by this task belonging to the named source connector in this worker.", sourceTaskTags);
        this.sourceRecordWriteRate = this.createTemplate("source-record-write-rate", SOURCE_TASK_GROUP_NAME, "The average per-second number of records output from the transformations and written to Kafka for this task belonging to the named source connector in this worker. This is after transformations are applied and excludes any records filtered out by the transformations.", sourceTaskTags);
        this.sourceRecordWriteTotal = this.createTemplate("source-record-write-total", SOURCE_TASK_GROUP_NAME, "The number of records output from the transformations and written to Kafka for this task belonging to the named source connector in this worker, since the task was last restarted.", sourceTaskTags);
        this.sourceRecordPollBatchTimeMax = this.createTemplate("poll-batch-max-time-ms", SOURCE_TASK_GROUP_NAME, "The maximum time in milliseconds taken by this task to poll for a batch of source records.", sourceTaskTags);
        this.sourceRecordPollBatchTimeAvg = this.createTemplate("poll-batch-avg-time-ms", SOURCE_TASK_GROUP_NAME, "The average time in milliseconds taken by this task to poll for a batch of source records.", sourceTaskTags);
        this.sourceRecordActiveCount = this.createTemplate("source-record-active-count", SOURCE_TASK_GROUP_NAME, "The number of records that have been produced by this task but not yet completely written to Kafka.", sourceTaskTags);
        this.sourceRecordActiveCountMax = this.createTemplate("source-record-active-count-max", SOURCE_TASK_GROUP_NAME, "The maximum number of records that have been produced by this task but not yet completely written to Kafka.", sourceTaskTags);
        this.sourceRecordActiveCountAvg = this.createTemplate("source-record-active-count-avg", SOURCE_TASK_GROUP_NAME, "The average number of records that have been produced by this task but not yet completely written to Kafka.", sourceTaskTags);
        LinkedHashSet<String> sinkTaskTags = new LinkedHashSet<String>(tags);
        sinkTaskTags.add(CONNECTOR_TAG_NAME);
        sinkTaskTags.add(TASK_TAG_NAME);
        this.sinkRecordReadRate = this.createTemplate("sink-record-read-rate", SINK_TASK_GROUP_NAME, "The average per-second number of records read from Kafka for this task belonging to the named sink connector in this worker. This is before transformations are applied.", sinkTaskTags);
        this.sinkRecordReadTotal = this.createTemplate("sink-record-read-total", SINK_TASK_GROUP_NAME, "The total number of records read from Kafka by this task belonging to the named sink connector in this worker, since the task was last restarted.", sinkTaskTags);
        this.sinkRecordSendRate = this.createTemplate("sink-record-send-rate", SINK_TASK_GROUP_NAME, "The average per-second number of records output from the transformations and sent/put to this task belonging to the named sink connector in this worker. This is after transformations are applied and excludes any records filtered out by the transformations.", sinkTaskTags);
        this.sinkRecordSendTotal = this.createTemplate("sink-record-send-total", SINK_TASK_GROUP_NAME, "The total number of records output from the transformations and sent/put to this task belonging to the named sink connector in this worker, since the task was last restarted.", sinkTaskTags);
        this.sinkRecordLagMax = this.createTemplate("sink-record-lag-max", SINK_TASK_GROUP_NAME, "The maximum lag in terms of number of records that the sink task is behind the consumer's position for any topic partitions.", sinkTaskTags);
        this.sinkRecordPartitionCount = this.createTemplate("partition-count", SINK_TASK_GROUP_NAME, "The number of topic partitions assigned to this task belonging to the named sink connector in this worker.", sinkTaskTags);
        this.sinkRecordOffsetCommitSeqNum = this.createTemplate("offset-commit-seq-no", SINK_TASK_GROUP_NAME, "The current sequence number for offset commits.", sinkTaskTags);
        this.sinkRecordOffsetCommitCompletionRate = this.createTemplate("offset-commit-completion-rate", SINK_TASK_GROUP_NAME, "The average per-second number of offset commit completions that were completed successfully.", sinkTaskTags);
        this.sinkRecordOffsetCommitCompletionTotal = this.createTemplate("offset-commit-completion-total", SINK_TASK_GROUP_NAME, "The total number of offset commit completions that were completed successfully.", sinkTaskTags);
        this.sinkRecordOffsetCommitSkipRate = this.createTemplate("offset-commit-skip-rate", SINK_TASK_GROUP_NAME, "The average per-second number of offset commit completions that were received too late and skipped/ignored.", sinkTaskTags);
        this.sinkRecordOffsetCommitSkipTotal = this.createTemplate("offset-commit-skip-total", SINK_TASK_GROUP_NAME, "The total number of offset commit completions that were received too late and skipped/ignored.", sinkTaskTags);
        this.sinkRecordPutBatchTimeMax = this.createTemplate("put-batch-max-time-ms", SINK_TASK_GROUP_NAME, "The maximum time taken by this task to put a batch of sinks records.", sinkTaskTags);
        this.sinkRecordPutBatchTimeAvg = this.createTemplate("put-batch-avg-time-ms", SINK_TASK_GROUP_NAME, "The average time taken by this task to put a batch of sinks records.", sinkTaskTags);
        this.sinkRecordActiveCount = this.createTemplate("sink-record-active-count", SINK_TASK_GROUP_NAME, "The number of records that have been read from Kafka but not yet completely committed/flushed/acknowledged by the sink task.", sinkTaskTags);
        this.sinkRecordActiveCountMax = this.createTemplate("sink-record-active-count-max", SINK_TASK_GROUP_NAME, "The maximum number of records that have been read from Kafka but not yet completely committed/flushed/acknowledged by the sink task.", sinkTaskTags);
        this.sinkRecordActiveCountAvg = this.createTemplate("sink-record-active-count-avg", SINK_TASK_GROUP_NAME, "The average number of records that have been read from Kafka but not yet completely committed/flushed/acknowledged by the sink task.", sinkTaskTags);
        LinkedHashSet<String> workerTags = new LinkedHashSet<String>(tags);
        this.connectorCount = this.createTemplate("connector-count", WORKER_GROUP_NAME, "The number of connectors run in this worker.", workerTags);
        this.taskCount = this.createTemplate("task-count", WORKER_GROUP_NAME, "The number of tasks run in this worker.", workerTags);
        this.connectorStartupAttemptsTotal = this.createTemplate("connector-startup-attempts-total", WORKER_GROUP_NAME, "The total number of connector startups that this worker has attempted.", workerTags);
        this.connectorStartupSuccessTotal = this.createTemplate("connector-startup-success-total", WORKER_GROUP_NAME, "The total number of connector starts that succeeded.", workerTags);
        this.connectorStartupSuccessPercentage = this.createTemplate("connector-startup-success-percentage", WORKER_GROUP_NAME, "The average percentage of this worker's connectors starts that succeeded.", workerTags);
        this.connectorStartupFailureTotal = this.createTemplate("connector-startup-failure-total", WORKER_GROUP_NAME, "The total number of connector starts that failed.", workerTags);
        this.connectorStartupFailurePercentage = this.createTemplate("connector-startup-failure-percentage", WORKER_GROUP_NAME, "The average percentage of this worker's connectors starts that failed.", workerTags);
        this.taskStartupAttemptsTotal = this.createTemplate("task-startup-attempts-total", WORKER_GROUP_NAME, "The total number of task startups that this worker has attempted.", workerTags);
        this.taskStartupSuccessTotal = this.createTemplate("task-startup-success-total", WORKER_GROUP_NAME, "The total number of task starts that succeeded.", workerTags);
        this.taskStartupSuccessPercentage = this.createTemplate("task-startup-success-percentage", WORKER_GROUP_NAME, "The average percentage of this worker's tasks starts that succeeded.", workerTags);
        this.taskStartupFailureTotal = this.createTemplate("task-startup-failure-total", WORKER_GROUP_NAME, "The total number of task starts that failed.", workerTags);
        this.taskStartupFailurePercentage = this.createTemplate("task-startup-failure-percentage", WORKER_GROUP_NAME, "The average percentage of this worker's tasks starts that failed.", workerTags);
        LinkedHashSet<String> workerConnectorTags = new LinkedHashSet<String>(tags);
        workerConnectorTags.add(CONNECTOR_TAG_NAME);
        this.connectorTotalTaskCount = this.createTemplate("connector-total-task-count", WORKER_GROUP_NAME, "The number of tasks of the connector on the worker.", workerConnectorTags);
        this.connectorRunningTaskCount = this.createTemplate("connector-running-task-count", WORKER_GROUP_NAME, "The number of running tasks of the connector on the worker.", workerConnectorTags);
        this.connectorPausedTaskCount = this.createTemplate("connector-paused-task-count", WORKER_GROUP_NAME, "The number of paused tasks of the connector on the worker.", workerConnectorTags);
        this.connectorFailedTaskCount = this.createTemplate("connector-failed-task-count", WORKER_GROUP_NAME, "The number of failed tasks of the connector on the worker.", workerConnectorTags);
        this.connectorUnassignedTaskCount = this.createTemplate("connector-unassigned-task-count", WORKER_GROUP_NAME, "The number of unassigned tasks of the connector on the worker.", workerConnectorTags);
        this.connectorDestroyedTaskCount = this.createTemplate("connector-destroyed-task-count", WORKER_GROUP_NAME, "The number of destroyed tasks of the connector on the worker.", workerConnectorTags);
        this.connectorRestartingTaskCount = this.createTemplate("connector-restarting-task-count", WORKER_GROUP_NAME, "The number of restarting tasks of the connector on the worker.", workerConnectorTags);
        this.connectorStatusMetrics = new HashMap<MetricNameTemplate, AbstractStatus.State>();
        this.connectorStatusMetrics.put(this.connectorRunningTaskCount, AbstractStatus.State.RUNNING);
        this.connectorStatusMetrics.put(this.connectorPausedTaskCount, AbstractStatus.State.PAUSED);
        this.connectorStatusMetrics.put(this.connectorFailedTaskCount, AbstractStatus.State.FAILED);
        this.connectorStatusMetrics.put(this.connectorUnassignedTaskCount, AbstractStatus.State.UNASSIGNED);
        this.connectorStatusMetrics.put(this.connectorDestroyedTaskCount, AbstractStatus.State.DESTROYED);
        this.connectorStatusMetrics.put(this.connectorRestartingTaskCount, AbstractStatus.State.RESTARTING);
        this.connectorStatusMetrics = Collections.unmodifiableMap(this.connectorStatusMetrics);
        LinkedHashSet<String> rebalanceTags = new LinkedHashSet<String>(tags);
        this.connectProtocol = this.createTemplate("connect-protocol", WORKER_REBALANCE_GROUP_NAME, "The Connect protocol used by this cluster", rebalanceTags);
        this.leaderName = this.createTemplate("leader-name", WORKER_REBALANCE_GROUP_NAME, "The name of the group leader.", rebalanceTags);
        this.epoch = this.createTemplate("epoch", WORKER_REBALANCE_GROUP_NAME, "The epoch or generation number of this worker.", rebalanceTags);
        this.rebalanceCompletedTotal = this.createTemplate("completed-rebalances-total", WORKER_REBALANCE_GROUP_NAME, "The total number of rebalances completed by this worker.", rebalanceTags);
        this.rebalanceMode = this.createTemplate("rebalancing", WORKER_REBALANCE_GROUP_NAME, "Whether this worker is currently rebalancing.", rebalanceTags);
        this.rebalanceTimeMax = this.createTemplate("rebalance-max-time-ms", WORKER_REBALANCE_GROUP_NAME, "The maximum time in milliseconds spent by this worker to rebalance.", rebalanceTags);
        this.rebalanceTimeAvg = this.createTemplate("rebalance-avg-time-ms", WORKER_REBALANCE_GROUP_NAME, "The average time in milliseconds spent by this worker to rebalance.", rebalanceTags);
        this.rebalanceTimeSinceLast = this.createTemplate("time-since-last-rebalance-ms", WORKER_REBALANCE_GROUP_NAME, "The time in milliseconds since this worker completed the most recent rebalance.", rebalanceTags);
        LinkedHashSet<String> taskErrorHandlingTags = new LinkedHashSet<String>(tags);
        taskErrorHandlingTags.add(CONNECTOR_TAG_NAME);
        taskErrorHandlingTags.add(TASK_TAG_NAME);
        this.recordProcessingFailures = this.createTemplate("total-record-failures", TASK_ERROR_HANDLING_GROUP_NAME, "The number of record processing failures in this task.", taskErrorHandlingTags);
        this.recordProcessingErrors = this.createTemplate("total-record-errors", TASK_ERROR_HANDLING_GROUP_NAME, "The number of record processing errors in this task. ", taskErrorHandlingTags);
        this.recordsSkipped = this.createTemplate("total-records-skipped", TASK_ERROR_HANDLING_GROUP_NAME, "The number of records skipped due to errors.", taskErrorHandlingTags);
        this.retries = this.createTemplate("total-retries", TASK_ERROR_HANDLING_GROUP_NAME, "The number of operations retried.", taskErrorHandlingTags);
        this.errorsLogged = this.createTemplate("total-errors-logged", TASK_ERROR_HANDLING_GROUP_NAME, "The number of errors that were logged.", taskErrorHandlingTags);
        this.dlqProduceRequests = this.createTemplate("deadletterqueue-produce-requests", TASK_ERROR_HANDLING_GROUP_NAME, "The number of attempted writes to the dead letter queue.", taskErrorHandlingTags);
        this.dlqProduceFailures = this.createTemplate("deadletterqueue-produce-failures", TASK_ERROR_HANDLING_GROUP_NAME, "The number of failed writes to the dead letter queue.", taskErrorHandlingTags);
        this.lastErrorTimestamp = this.createTemplate("last-error-timestamp", TASK_ERROR_HANDLING_GROUP_NAME, "The epoch timestamp when this task last encountered an error.", taskErrorHandlingTags);
    }

    private MetricNameTemplate createTemplate(String name, String group, String doc, Set<String> tags) {
        MetricNameTemplate template = new MetricNameTemplate(name, group, doc, tags);
        this.allTemplates.add(template);
        return template;
    }

    public List<MetricNameTemplate> getAllTemplates() {
        return Collections.unmodifiableList(this.allTemplates);
    }

    public String connectorTagName() {
        return CONNECTOR_TAG_NAME;
    }

    public String taskTagName() {
        return TASK_TAG_NAME;
    }

    public String connectorGroupName() {
        return CONNECTOR_GROUP_NAME;
    }

    public String taskGroupName() {
        return TASK_GROUP_NAME;
    }

    public String sinkTaskGroupName() {
        return SINK_TASK_GROUP_NAME;
    }

    public String sourceTaskGroupName() {
        return SOURCE_TASK_GROUP_NAME;
    }

    public String workerGroupName() {
        return WORKER_GROUP_NAME;
    }

    public String workerRebalanceGroupName() {
        return WORKER_REBALANCE_GROUP_NAME;
    }

    public String taskErrorHandlingGroupName() {
        return TASK_ERROR_HANDLING_GROUP_NAME;
    }
}

