/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.errors;

import java.util.concurrent.Future;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.connect.runtime.errors.RetryWithToleranceOperator;
import org.apache.kafka.connect.runtime.errors.WorkerErrantRecordReporter;
import org.apache.kafka.connect.runtime.tracing.TraceRecord;
import org.apache.kafka.connect.runtime.tracing.Tracer;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;

@Confluent
public class TraceWorkerErrantRecordReporter
extends WorkerErrantRecordReporter {
    private final Tracer tracer;

    public TraceWorkerErrantRecordReporter(RetryWithToleranceOperator retryWithToleranceOperator, Converter keyConverter, Converter valueConverter, HeaderConverter headerConverter, Tracer tracer) {
        super(retryWithToleranceOperator, keyConverter, valueConverter, headerConverter);
        this.tracer = tracer;
    }

    @Override
    public Future<Void> report(SinkRecord record, Throwable error) {
        TraceRecord traceRecord = this.tracer.traceRecordBuilder().createSinkRecordError(record, error);
        this.tracer.writeTraceRecord(traceRecord, null);
        return super.report(record, error);
    }
}

