/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.FileWatchService;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.runtime.DynamicWorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicWorkerConfigManager {
    private static final Logger log = LoggerFactory.getLogger(DynamicWorkerConfigManager.class);
    private static final String DYNAMIC_WORKER_CONFIG_FILE = "/mnt/config/shared/dynamic-worker-config.properties";
    public static final String DYNAMIC_WORKER_CONFIG_FILE_PROPERTY = "dynamic.worker.config.file";
    private static volatile DynamicWorkerConfigManager instance;
    private static FileWatchService fileWatchService;
    private DynamicWorkerConfig config = DynamicWorkerConfig.DEFAULT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicWorkerConfigManager getInstance() {
        DynamicWorkerConfigManager result = instance;
        if (result != null) {
            return result;
        }
        Class<DynamicWorkerConfigManager> clazz = DynamicWorkerConfigManager.class;
        synchronized (DynamicWorkerConfigManager.class) {
            if (instance == null) {
                fileWatchService = new FileWatchService();
                String configFileName = System.getProperty(DYNAMIC_WORKER_CONFIG_FILE_PROPERTY, DYNAMIC_WORKER_CONFIG_FILE);
                instance = DynamicWorkerConfigManager.createDynamicWorkerConfigManager(configFileName, fileWatchService, true, true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    static DynamicWorkerConfigManager createDynamicWorkerConfigManager(String configFileName, FileWatchService fileWatchService, boolean enableAutoReloadConfig, boolean useDefaultOnLoadError) {
        DynamicWorkerConfigManager instance = new DynamicWorkerConfigManager();
        if (new File(configFileName).exists()) {
            instance.reloadConfig(configFileName, useDefaultOnLoadError);
            if (enableAutoReloadConfig) {
                fileWatchService.add(instance.getFileWatchListener(configFileName));
            }
        } else {
            log.debug("Dynamic worker config file not found at {}", (Object)configFileName);
        }
        return instance;
    }

    private FileWatchService.Listener getFileWatchListener(String configFileName) {
        return new DynamicWorkerConfigFileListener(configFileName, this);
    }

    void reloadConfig(String fileName, boolean useDefaultOnLoadError) {
        DynamicWorkerConfig dynamicWorkerConfig;
        block3: {
            dynamicWorkerConfig = null;
            try {
                log.debug("reloading dynamic worker config from {}", (Object)fileName);
                Map properties = Utils.propsToStringMap((Properties)Utils.loadProps((String)fileName));
                DynamicWorkerConfig.validateProperties(properties);
                dynamicWorkerConfig = new DynamicWorkerConfig(properties);
            }
            catch (Exception e) {
                log.error("Unable to update dynamic config", (Throwable)e);
                if (!useDefaultOnLoadError) break block3;
                log.info("Using default dynamic worker config due to load error");
                dynamicWorkerConfig = DynamicWorkerConfig.DEFAULT;
            }
        }
        if (dynamicWorkerConfig != null) {
            log.info("updating dynamic worker config : {}", (Object)dynamicWorkerConfig);
            this.config = dynamicWorkerConfig;
        }
    }

    public Integer getMaxTasksPerWorker() {
        return this.config.getInt("confluent.max.tasks.per.worker");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ?> copyValues() {
        Map values;
        DynamicWorkerConfigManager dynamicWorkerConfigManager = this;
        synchronized (dynamicWorkerConfigManager) {
            values = this.config.values();
        }
        return values;
    }

    public static void main(String[] args) {
        DynamicWorkerConfigManager dynamicWorkerConfigManager = DynamicWorkerConfigManager.getInstance();
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    System.out.println(dynamicWorkerConfigManager.getMaxTasksPerWorker());
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        });
        System.out.println("Press any key to stop");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Exit.exit((int)0);
    }

    static class DynamicWorkerConfigFileListener
    implements FileWatchService.Listener {
        private final String fileName;
        private final DynamicWorkerConfigManager dynamicWorkerConfigManager;

        public DynamicWorkerConfigFileListener(String configFileName, DynamicWorkerConfigManager dynamicWorkerConfigManager) {
            this.fileName = configFileName;
            this.dynamicWorkerConfigManager = dynamicWorkerConfigManager;
        }

        public File file() {
            return new File(this.fileName);
        }

        public void onInit() {
            log.info("Dynamic worker config file listener initialized");
        }

        public void onUpdate() {
            log.info("Dynamic worker config file updated");
            this.dynamicWorkerConfigManager.reloadConfig(this.fileName, false);
        }
    }
}

