/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.licensing;

import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.LicenseManager;
import io.confluent.license.kafka.BrokerDetector;
import io.confluent.license.kafka.BrokerType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectWorkerLicenseManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectWorkerLicenseManager.class);
    public static final String DEFAULT_TOPIC_NAME = "_confluent-command";
    private final Supplier<LicenseManager> licenseManagerSupplier;
    private final String license;
    private final Map<String, Object> detectorConsumerProperties;

    public static Builder create() {
        return new Builder();
    }

    protected ConnectWorkerLicenseManager(String license, Map<String, Object> detectorConsumerProperties, Supplier<LicenseManager> licenseManagerSupplier) {
        assert (licenseManagerSupplier != null);
        this.licenseManagerSupplier = licenseManagerSupplier;
        this.license = license;
        this.detectorConsumerProperties = detectorConsumerProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOrValidateWorkerLicense() throws ConnectException {
        LicenseManager licenseManager = null;
        try {
            LOG.trace("Creating new license manager");
            licenseManager = this.licenseManagerSupplier.get();
            LOG.info("Validating Confluent License");
            List<Object> licenses = new ArrayList<License>();
            try {
                List validLicenses = licenseManager.registerOrValidateMultiLicense(this.license, true);
                licenses.addAll(validLicenses);
                if (this.containsCPLicense(licenses)) {
                    return;
                }
            }
            catch (InvalidLicenseException e) {
                LOG.trace("No valid license found.", (Throwable)e);
            }
            BrokerType brokerType = this.getBrokerType();
            if (BrokerType.CONFLUENT_CLOUD.equals((Object)brokerType)) {
                LOG.debug("Detected Confluent Cloud Kafka broker, checking for required license");
                if (this.containsCPForCCLicense(licenses)) {
                    LOG.trace("Successfully registered license for Confluent Cloud");
                    return;
                }
            }
            LOG.trace("Checking if TRIAL/FREE_TIER license can be registered");
            licenses = licenseManager.registerOrValidateMultiLicense(this.license, false);
            if (this.containsCPLicense(licenses)) {
                LOG.info("Successfully registered license for Confluent Platform");
                return;
            }
            try {
                throw new ConnectException("Your license for Customer-Managed Confluent Platform for Confluent Cloud may be used solely to access and use the Cloud Service. When operating under this specific license, Confluent does not provide support for any self-managed (Confluent Platform) components utilised exclusively for Confluent Platform broker use cases. To be eligible for support, you must ensure you are connecting to a Confluent Cloud broker or are utilising a valid Enterprise license for a Confluent Platform subscription.");
            }
            catch (InvalidLicenseException e) {
                LOG.warn("No valid license found. Please install a valid license.", (Throwable)e);
            }
            catch (ConnectException e) {
                throw e;
            }
            catch (Throwable t) {
                LOG.warn("Unexpected exception while validating license on connect worker node. Connector will proceed to start up.", t);
            }
        }
        finally {
            if (licenseManager != null) {
                licenseManager.stop();
                LOG.trace("Stopped license manager");
            }
        }
    }

    private boolean containsCPLicense(List<License> licenses) {
        for (License l : licenses) {
            if (!License.DeploymentScope.CP.equals((Object)l.deploymentScope())) continue;
            return true;
        }
        return false;
    }

    private boolean containsCPForCCLicense(List<License> licenses) {
        for (License l : licenses) {
            if (!License.DeploymentScope.CP_FOR_CC.equals((Object)l.deploymentScope())) continue;
            return true;
        }
        return false;
    }

    private BrokerType getBrokerType() {
        BrokerDetector brokerDetector = BrokerDetector.create();
        try {
            LOG.trace("Detecting broker type");
            Properties detectorConsumerProperties = new Properties();
            if (this.detectorConsumerProperties != null) {
                LOG.trace("Using provided detector consumer properties.");
                detectorConsumerProperties.putAll(this.detectorConsumerProperties);
            } else {
                LOG.trace("Using empty detector consumer properties");
            }
            return brokerDetector.determineBrokerType(detectorConsumerProperties);
        }
        catch (Exception e) {
            throw new ConnectException("Error detecting broker type", (Throwable)e);
        }
    }

    public static class Builder {
        protected String topicName;
        protected Map<String, Object> producerProps;
        protected Map<String, Object> consumerProps;
        protected Map<String, Object> adminProps;
        protected Map<String, Object> detectorConsumerProps;
        protected String defaultClientId;
        protected String license;

        protected Builder() {
        }

        public Builder useLicense(String license) {
            this.license = license;
            return this;
        }

        public Builder useTopicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public Builder useProducerConfig(Map<String, Object> configuration) {
            Map<String, Object> originals = Map.copyOf(configuration);
            this.producerProps = new HashMap<String, Object>(originals);
            if (this.producerProps != null && this.producerProps.remove("replication.factor") != null) {
                LOG.debug("Removed {} property from the license manager producer configuration", (Object)"replication.factor");
            }
            return this;
        }

        public Builder useConsumerConfig(Map<String, Object> configuration) {
            Map<String, Object> originals = Map.copyOf(configuration);
            this.consumerProps = new HashMap<String, Object>(originals);
            if (this.consumerProps != null && this.consumerProps.remove("replication.factor") != null) {
                LOG.debug("Removed {} property from the license manager consumer configuration", (Object)"replication.factor");
            }
            return this;
        }

        public Builder useBrokerDetectorConsumerConfig(Map<String, Object> configuration) {
            Map<String, Object> originals = Map.copyOf(configuration);
            this.detectorConsumerProps = new HashMap<String, Object>(originals);
            if (this.detectorConsumerProps != null && this.detectorConsumerProps.remove("replication.factor") != null) {
                LOG.debug("Removed {} property from the license manager broker detector consumer configuration", (Object)"replication.factor");
            }
            return this;
        }

        public Builder useAdminConfig(Map<String, Object> configuration) {
            this.adminProps = configuration;
            return this;
        }

        public Builder useDefaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
            return this;
        }

        protected void addDefaultClientId(Map<String, Object> props) {
            if (this.defaultClientId != null && props != null && !props.containsKey("client.id")) {
                props.put("client.id", this.defaultClientId);
            }
        }

        protected String topicName() {
            return this.topicName == null || this.topicName.trim().isEmpty() ? ConnectWorkerLicenseManager.DEFAULT_TOPIC_NAME : this.topicName;
        }

        protected String license() {
            return this.license;
        }

        protected Map<String, Object> producerConfig() {
            return this.producerProps;
        }

        protected Map<String, Object> consumerConfig() {
            return this.consumerProps;
        }

        protected Map<String, Object> detectorConsumerConfig() {
            return this.detectorConsumerProps;
        }

        protected Map<String, Object> consumerOrProducerConfig() {
            return this.consumerProps != null ? this.consumerProps : this.producerProps;
        }

        protected Map<String, Object> adminConfig() {
            return this.adminProps;
        }

        protected Map<String, Object> adminOrProducerConfig() {
            return this.adminProps != null ? this.adminProps : this.producerProps;
        }

        public ConnectWorkerLicenseManager build() {
            if (this.producerProps == null || this.producerProps.isEmpty()) {
                throw new IllegalStateException("Producer properties for license cannot be null or empty");
            }
            this.addDefaultClientId(this.consumerProps);
            this.addDefaultClientId(this.adminProps);
            this.addDefaultClientId(this.producerProps);
            this.addDefaultClientId(this.detectorConsumerProps);
            return new ConnectWorkerLicenseManager(this.license(), this.detectorConsumerConfig(), () -> {
                LOG.debug("Topic name for license manager: '{}'", (Object)this.topicName());
                return new LicenseManager(this.topicName(), this.producerConfig(), this.consumerOrProducerConfig(), this.adminOrProducerConfig());
            });
        }
    }
}

