/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.HeaderGenerator;
import org.apache.kafka.message.MessageGenerator;
import org.apache.kafka.message.MessageSpec;
import org.apache.kafka.message.MessageSpecType;
import org.apache.kafka.message.TypeClassGenerator;

public class MetadataJsonConvertersGenerator
implements TypeClassGenerator {
    private final HeaderGenerator headerGenerator;
    private final CodeBuffer buffer;
    private final TreeMap<Short, MessageSpec> apis;

    public MetadataJsonConvertersGenerator(String packageName) {
        this.headerGenerator = new HeaderGenerator(packageName);
        this.apis = new TreeMap();
        this.buffer = new CodeBuffer();
    }

    @Override
    public String outputName() {
        return "MetadataJsonConverters.java";
    }

    @Override
    public void registerMessageType(MessageSpec spec) {
        short id;
        MessageSpec prevSpec;
        if (spec.type() == MessageSpecType.METADATA && (prevSpec = this.apis.put(id = spec.apiKey().get().shortValue(), spec)) != null) {
            throw new RuntimeException("Duplicate metadata record entry for type " + id + ". Original claimant: " + prevSpec.name() + ". New claimant: " + spec.name());
        }
    }

    @Override
    public void generateAndWrite(BufferedWriter writer) throws IOException {
        this.buffer.printf("public class MetadataJsonConverters {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.generateWriteJson();
        this.buffer.printf("%n", new Object[0]);
        this.generateReadJson();
        this.buffer.printf("%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.headerGenerator.generate();
        this.headerGenerator.buffer().write(writer);
        this.buffer.write(writer);
    }

    private void generateWriteJson() {
        this.headerGenerator.addImport("com.fasterxml.jackson.databind.JsonNode");
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.ApiMessage");
        this.buffer.printf("public static JsonNode writeJson(ApiMessage apiMessage, short apiVersion) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("switch (apiMessage.apiKey()) {%n", new Object[0]);
        this.buffer.incrementIndent();
        for (Map.Entry<Short, MessageSpec> entry : this.apis.entrySet()) {
            String apiMessageClassName = MessageGenerator.capitalizeFirst(entry.getValue().name());
            this.buffer.printf("case %d:%n", entry.getKey());
            this.buffer.incrementIndent();
            this.buffer.printf("return %sJsonConverter.write((%s) apiMessage, apiVersion);%n", apiMessageClassName, apiMessageClassName);
            this.buffer.decrementIndent();
        }
        this.buffer.printf("default:%n", new Object[0]);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
        this.buffer.printf("throw new UnsupportedVersionException(\"Unknown metadata id \" + apiMessage.apiKey());%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateReadJson() {
        this.headerGenerator.addImport("com.fasterxml.jackson.databind.JsonNode");
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.ApiMessage");
        this.buffer.printf("public static ApiMessage readJson(JsonNode json, short apiKey, short apiVersion) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("switch (apiKey) {%n", new Object[0]);
        this.buffer.incrementIndent();
        for (Map.Entry<Short, MessageSpec> entry : this.apis.entrySet()) {
            String apiMessageClassName = MessageGenerator.capitalizeFirst(entry.getValue().name());
            this.buffer.printf("case %d:%n", entry.getKey());
            this.buffer.incrementIndent();
            this.buffer.printf("return %sJsonConverter.read(json, apiVersion);%n", apiMessageClassName);
            this.buffer.decrementIndent();
        }
        this.buffer.printf("default:%n", new Object[0]);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
        this.buffer.printf("throw new UnsupportedVersionException(\"Unknown metadata id \" + apiKey);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }
}

