/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceRequest;
import org.junit.Assert;
import org.junit.Test;

public class ProduceRequestTest {
    private final SimpleRecord simpleRecord = new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());

    @Test
    public void shouldBeFlaggedAsTransactionalWhenTransactionalRecords() throws Exception {
        MemoryRecords memoryRecords = MemoryRecords.withTransactionalRecords((long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)1, (int)1, (int)1, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord});
        ProduceRequest request = (ProduceRequest)new ProduceRequest.Builder(2, -1, 10, Collections.singletonMap(new TopicPartition("topic", 1), memoryRecords)).build();
        Assert.assertTrue((boolean)request.hasTransactionalRecords());
    }

    @Test
    public void shouldNotBeFlaggedAsTransactionalWhenNoRecords() throws Exception {
        ProduceRequest request = this.createNonIdempotentNonTransactionalRecords();
        Assert.assertFalse((boolean)request.hasTransactionalRecords());
    }

    @Test
    public void shouldNotBeFlaggedAsIdempotentWhenRecordsNotIdempotent() throws Exception {
        ProduceRequest request = this.createNonIdempotentNonTransactionalRecords();
        Assert.assertFalse((boolean)request.hasTransactionalRecords());
    }

    @Test
    public void shouldBeFlaggedAsIdempotentWhenIdempotentRecords() throws Exception {
        MemoryRecords memoryRecords = MemoryRecords.withIdempotentRecords((long)1L, (CompressionType)CompressionType.NONE, (long)1L, (short)1, (int)1, (int)1, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord});
        ProduceRequest request = (ProduceRequest)new ProduceRequest.Builder(2, -1, 10, Collections.singletonMap(new TopicPartition("topic", 1), memoryRecords)).build();
        Assert.assertTrue((boolean)request.hasIdempotentRecords());
    }

    @Test
    public void testMixedTransactionalData() {
        long producerId = 15L;
        int producerEpoch = 5;
        int sequence = 10;
        String transactionalId = "txnlId";
        MemoryRecords nonTxnRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("foo".getBytes())});
        MemoryRecords txnRecords = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)15L, (short)5, (int)10, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("bar".getBytes())});
        LinkedHashMap<TopicPartition, MemoryRecords> recordsByPartition = new LinkedHashMap<TopicPartition, MemoryRecords>();
        recordsByPartition.put(new TopicPartition("foo", 0), txnRecords);
        recordsByPartition.put(new TopicPartition("foo", 1), nonTxnRecords);
        ProduceRequest.Builder builder = new ProduceRequest.Builder(2, -1, 5000, recordsByPartition, "txnlId");
        ProduceRequest request = (ProduceRequest)builder.build();
        Assert.assertTrue((boolean)request.hasTransactionalRecords());
        Assert.assertTrue((boolean)request.hasIdempotentRecords());
    }

    @Test
    public void testMixedIdempotentData() {
        long producerId = 15L;
        int producerEpoch = 5;
        int sequence = 10;
        MemoryRecords nonTxnRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("foo".getBytes())});
        MemoryRecords txnRecords = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)15L, (short)5, (int)10, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("bar".getBytes())});
        LinkedHashMap<TopicPartition, MemoryRecords> recordsByPartition = new LinkedHashMap<TopicPartition, MemoryRecords>();
        recordsByPartition.put(new TopicPartition("foo", 0), txnRecords);
        recordsByPartition.put(new TopicPartition("foo", 1), nonTxnRecords);
        ProduceRequest.Builder builder = new ProduceRequest.Builder(2, -1, 5000, recordsByPartition, null);
        ProduceRequest request = (ProduceRequest)builder.build();
        Assert.assertFalse((boolean)request.hasTransactionalRecords());
        Assert.assertTrue((boolean)request.hasIdempotentRecords());
    }

    private ProduceRequest createNonIdempotentNonTransactionalRecords() {
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord});
        return (ProduceRequest)new ProduceRequest.Builder(2, -1, 10, Collections.singletonMap(new TopicPartition("topic", 1), memoryRecords)).build();
    }
}

