/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.utils.Base64;
import org.junit.Assert;
import org.junit.Test;

public class Base64Test {
    @Test
    public void testBase64UrlEncodeDecode() {
        Base64Test.confirmInversesForAllThreePaddingCases(Base64.urlEncoderNoPadding(), Base64.urlDecoder());
    }

    @Test
    public void testBase64EncodeDecode() {
        Base64Test.confirmInversesForAllThreePaddingCases(Base64.encoder(), Base64.decoder());
    }

    private static void confirmInversesForAllThreePaddingCases(Base64.Encoder encoder, Base64.Decoder decoder) {
        for (String text : new String[]{"", "a", "ab", "abc"}) {
            Assert.assertEquals((Object)text, (Object)new String(decoder.decode(encoder.encodeToString(text.getBytes(StandardCharsets.UTF_8))), StandardCharsets.UTF_8));
        }
    }
}

