/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class OffsetsForLeaderEpochRequest
extends AbstractRequest {
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String LEADER_EPOCH = "leader_epoch";
    private static final Schema OFFSET_FOR_LEADER_EPOCH_REQUEST_PARTITION_V0 = new Schema(CommonFields.PARTITION_ID, new Field("leader_epoch", Type.INT32, "The epoch"));
    private static final Schema OFFSET_FOR_LEADER_EPOCH_REQUEST_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(OFFSET_FOR_LEADER_EPOCH_REQUEST_PARTITION_V0)));
    private static final Schema OFFSET_FOR_LEADER_EPOCH_REQUEST_V0 = new Schema(new Field("topics", new ArrayOf(OFFSET_FOR_LEADER_EPOCH_REQUEST_TOPIC_V0), "An array of topics to get epochs for"));
    private Map<TopicPartition, Integer> epochsByPartition;

    public static Schema[] schemaVersions() {
        return new Schema[]{OFFSET_FOR_LEADER_EPOCH_REQUEST_V0};
    }

    public Map<TopicPartition, Integer> epochsByTopicPartition() {
        return this.epochsByPartition;
    }

    public OffsetsForLeaderEpochRequest(Map<TopicPartition, Integer> epochsByPartition, short version) {
        super(version);
        this.epochsByPartition = epochsByPartition;
    }

    public OffsetsForLeaderEpochRequest(Struct struct, short version) {
        super(version);
        this.epochsByPartition = new HashMap<TopicPartition, Integer>();
        for (Object topicAndEpochsObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicAndEpochs = (Struct)topicAndEpochsObj;
            String topic = topicAndEpochs.get(CommonFields.TOPIC_NAME);
            for (Object partitionAndEpochObj : topicAndEpochs.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionAndEpoch = (Struct)partitionAndEpochObj;
                int partitionId = partitionAndEpoch.get(CommonFields.PARTITION_ID);
                int epoch = partitionAndEpoch.getInt(LEADER_EPOCH);
                TopicPartition tp = new TopicPartition(topic, partitionId);
                this.epochsByPartition.put(tp, epoch);
            }
        }
    }

    public static OffsetsForLeaderEpochRequest parse(ByteBuffer buffer, short versionId) {
        return new OffsetsForLeaderEpochRequest(ApiKeys.OFFSET_FOR_LEADER_EPOCH.parseRequest(versionId, buffer), versionId);
    }

    @Override
    protected Struct toStruct() {
        Struct requestStruct = new Struct(ApiKeys.OFFSET_FOR_LEADER_EPOCH.requestSchema(this.version()));
        Map<String, Map<Integer, Integer>> topicsToPartitionEpochs = CollectionUtils.groupDataByTopic(this.epochsByPartition);
        ArrayList<Struct> topics = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, Integer>> topicToEpochs : topicsToPartitionEpochs.entrySet()) {
            Struct topicsStruct = requestStruct.instance(TOPICS_KEY_NAME);
            topicsStruct.set(CommonFields.TOPIC_NAME, topicToEpochs.getKey());
            ArrayList<Struct> partitions = new ArrayList<Struct>();
            for (Map.Entry<Integer, Integer> partitionEpoch : topicToEpochs.getValue().entrySet()) {
                Struct partitionStruct = topicsStruct.instance(PARTITIONS_KEY_NAME);
                partitionStruct.set(CommonFields.PARTITION_ID, partitionEpoch.getKey());
                partitionStruct.set(LEADER_EPOCH, (Object)partitionEpoch.getValue());
                partitions.add(partitionStruct);
            }
            topicsStruct.set(PARTITIONS_KEY_NAME, (Object)partitions.toArray());
            topics.add(topicsStruct);
        }
        requestStruct.set(TOPICS_KEY_NAME, (Object)topics.toArray());
        return requestStruct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<TopicPartition, EpochEndOffset> errorResponse = new HashMap<TopicPartition, EpochEndOffset>();
        for (TopicPartition tp : this.epochsByPartition.keySet()) {
            errorResponse.put(tp, new EpochEndOffset(error, -1L));
        }
        return new OffsetsForLeaderEpochResponse(errorResponse);
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetsForLeaderEpochRequest> {
        private Map<TopicPartition, Integer> epochsByPartition = new HashMap<TopicPartition, Integer>();

        public Builder() {
            super(ApiKeys.OFFSET_FOR_LEADER_EPOCH);
        }

        public Builder(Map<TopicPartition, Integer> epochsByPartition) {
            super(ApiKeys.OFFSET_FOR_LEADER_EPOCH);
            this.epochsByPartition = epochsByPartition;
        }

        public Builder add(TopicPartition topicPartition, Integer epoch) {
            this.epochsByPartition.put(topicPartition, epoch);
            return this;
        }

        @Override
        public OffsetsForLeaderEpochRequest build(short version) {
            return new OffsetsForLeaderEpochRequest(this.epochsByPartition, version);
        }

        public static OffsetsForLeaderEpochRequest parse(ByteBuffer buffer, short version) {
            return new OffsetsForLeaderEpochRequest(ApiKeys.OFFSET_FOR_LEADER_EPOCH.parseRequest(version, buffer), version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=OffsetForLeaderEpochRequest, ").append("epochsByTopic=").append(this.epochsByPartition).append(")");
            return bld.toString();
        }
    }
}

