/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class ListGroupsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private List<ListedGroup> groups;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("groups", (Type)new ArrayOf((Type)ListedGroup.SCHEMA_0), "Each group in the response.")});
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public ListGroupsResponseData(Readable readable, short version) {
        this.groups = new ArrayList<ListedGroup>();
        this.read(readable, version);
    }

    public ListGroupsResponseData(Struct struct, short version) {
        this.groups = new ArrayList<ListedGroup>();
        this.fromStruct(struct, version);
    }

    public ListGroupsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.groups = new ArrayList<ListedGroup>();
    }

    public short apiKey() {
        return 16;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 1 ? readable.readInt() : 0;
        this.errorCode = readable.readShort();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.groups = null;
        } else {
            this.groups.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.groups.add(new ListedGroup(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        if (version >= 1) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeShort(this.errorCode);
        writable.writeInt(this.groups.size());
        for (ListedGroup element : this.groups) {
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        this.errorCode = struct.getShort("error_code");
        Object[] nestedObjects = struct.getArray("groups");
        this.groups = new ArrayList<ListedGroup>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.groups.add(new ListedGroup((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set("error_code", (Object)this.errorCode);
        Struct[] nestedObjects = new Struct[this.groups.size()];
        int i = 0;
        for (ListedGroup element : this.groups) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("groups", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        if (version >= 1) {
            size += 4;
        }
        size += 2;
        size += 4;
        for (ListedGroup element : this.groups) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListGroupsResponseData)) {
            return false;
        }
        ListGroupsResponseData other = (ListGroupsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return !(this.groups == null ? other.groups != null : !this.groups.equals(other.groups));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.groups == null ? 0 : this.groups.hashCode());
        return hashCode;
    }

    public String toString() {
        return "ListGroupsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", groups=" + MessageUtil.deepToString(this.groups.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<ListedGroup> groups() {
        return this.groups;
    }

    public ListGroupsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ListGroupsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ListGroupsResponseData setGroups(List<ListedGroup> v) {
        this.groups = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("groups", (Type)new ArrayOf((Type)ListedGroup.SCHEMA_0), "Each group in the response.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class ListedGroup
    implements Message {
        private String groupId;
        private String protocolType;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public ListedGroup(Readable readable, short version) {
            this.read(readable, version);
        }

        public ListedGroup(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public ListedGroup() {
            this.groupId = "";
            this.protocolType = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable readable, short version) {
            this.groupId = readable.readNullableString();
            this.protocolType = readable.readNullableString();
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.groupId);
            writable.writeString(this.protocolType);
        }

        public void fromStruct(Struct struct, short version) {
            this.groupId = struct.getString("group_id");
            this.protocolType = struct.getString("protocol_type");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("group_id", (Object)this.groupId);
            struct.set("protocol_type", (Object)this.protocolType);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.groupId);
            size += 2;
            return size += MessageUtil.serializedUtf8Length((CharSequence)this.protocolType);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListedGroup)) {
                return false;
            }
            ListedGroup other = (ListedGroup)obj;
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            return !(this.protocolType == null ? other.protocolType != null : !this.protocolType.equals(other.protocolType));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
            hashCode = 31 * hashCode + (this.protocolType == null ? 0 : this.protocolType.hashCode());
            return hashCode;
        }

        public String toString() {
            return "ListedGroup(groupId='" + this.groupId + "', protocolType='" + this.protocolType + "')";
        }

        public String groupId() {
            return this.groupId;
        }

        public String protocolType() {
            return this.protocolType;
        }

        public ListedGroup setGroupId(String v) {
            this.groupId = v;
            return this;
        }

        public ListedGroup setProtocolType(String v) {
            this.protocolType = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("group_id", (Type)Type.STRING, "The group ID."), new Field("protocol_type", (Type)Type.STRING, "The group protocol type.")}));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

