/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiSet;
import org.apache.kafka.common.utils.ImplicitLinkedHashSet;

public class DeleteGroupsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private DeletableGroupResultSet results;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public DeleteGroupsResponseData(Readable readable, short version) {
        this.results = new DeletableGroupResultSet(0);
        this.read(readable, version);
    }

    public DeleteGroupsResponseData(Struct struct, short version) {
        this.results = new DeletableGroupResultSet(0);
        this.fromStruct(struct, version);
    }

    public DeleteGroupsResponseData() {
        this.throttleTimeMs = 0;
        this.results = new DeletableGroupResultSet(0);
    }

    public short apiKey() {
        return 42;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.results.clear(0);
        } else {
            this.results.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.results.add(new DeletableGroupResult(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.results.size());
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            DeletableGroupResult element = (DeletableGroupResult)iterator.next();
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("results");
        this.results = new DeletableGroupResultSet(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.results.add(new DeletableGroupResult((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.results.size()];
        int i = 0;
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            DeletableGroupResult element = (DeletableGroupResult)iterator.next();
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("results", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            DeletableGroupResult element = (DeletableGroupResult)iterator.next();
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteGroupsResponseData)) {
            return false;
        }
        DeleteGroupsResponseData other = (DeleteGroupsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals((Object)other.results));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DeleteGroupsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString((Iterator)this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public DeletableGroupResultSet results() {
        return this.results;
    }

    public DeleteGroupsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DeleteGroupsResponseData setResults(DeletableGroupResultSet v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", (Type)new ArrayOf((Type)DeletableGroupResult.SCHEMA_0), "The deletion results")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class DeletableGroupResultSet
    extends ImplicitLinkedHashMultiSet<DeletableGroupResult> {
        public DeletableGroupResultSet() {
        }

        public DeletableGroupResultSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public DeletableGroupResultSet(Iterator<DeletableGroupResult> iterator) {
            super(iterator);
        }

        public DeletableGroupResult find(String groupId) {
            DeletableGroupResult key = new DeletableGroupResult();
            key.setGroupId(groupId);
            return (DeletableGroupResult)this.find(key);
        }

        public List<DeletableGroupResult> findAll(String groupId) {
            DeletableGroupResult key = new DeletableGroupResult();
            key.setGroupId(groupId);
            return this.findAll(key);
        }
    }

    public static class DeletableGroupResult
    implements Message,
    ImplicitLinkedHashSet.Element {
        private String groupId;
        private short errorCode;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DeletableGroupResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public DeletableGroupResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public DeletableGroupResult() {
            this.groupId = "";
            this.errorCode = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.groupId = readable.readNullableString();
            this.errorCode = readable.readShort();
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.groupId);
            writable.writeShort(this.errorCode);
        }

        public void fromStruct(Struct struct, short version) {
            this.groupId = struct.getString("group_id");
            this.errorCode = struct.getShort("error_code");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("group_id", (Object)this.groupId);
            struct.set("error_code", (Object)this.errorCode);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.groupId);
            return size += 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeletableGroupResult)) {
                return false;
            }
            DeletableGroupResult other = (DeletableGroupResult)obj;
            return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DeletableGroupResult(groupId='" + this.groupId + "', errorCode=" + this.errorCode + ")";
        }

        public String groupId() {
            return this.groupId;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public DeletableGroupResult setGroupId(String v) {
            this.groupId = v;
            return this;
        }

        public DeletableGroupResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("group_id", (Type)Type.STRING, "The group id"), new Field("error_code", (Type)Type.INT16, "The deletion error, or 0 if the deletion succeeded.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

