/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiSet;
import org.apache.kafka.common.utils.ImplicitLinkedHashSet;

public class JoinGroupRequestData
implements ApiMessage {
    private String groupId;
    private int sessionTimeoutMs;
    private int rebalanceTimeoutMs;
    private String memberId;
    private String protocolType;
    private JoinGroupRequestProtocolSet protocols;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("group_id", (Type)Type.STRING, "The group identifier."), new Field("session_timeout_ms", (Type)Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in milliseconds."), new Field("member_id", (Type)Type.STRING, "The member id assigned by the group coordinator."), new Field("protocol_type", (Type)Type.STRING, "The unique name the for class of protocols implemented by the group we want to join."), new Field("protocols", (Type)new ArrayOf((Type)JoinGroupRequestProtocol.SCHEMA_0), "The list of protocols that the member supports.")});
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;

    public JoinGroupRequestData(Readable readable, short version) {
        this.protocols = new JoinGroupRequestProtocolSet(0);
        this.read(readable, version);
    }

    public JoinGroupRequestData(Struct struct, short version) {
        this.protocols = new JoinGroupRequestProtocolSet(0);
        this.fromStruct(struct, version);
    }

    public JoinGroupRequestData() {
        this.groupId = "";
        this.sessionTimeoutMs = 0;
        this.rebalanceTimeoutMs = -1;
        this.memberId = "";
        this.protocolType = "";
        this.protocols = new JoinGroupRequestProtocolSet(0);
    }

    public short apiKey() {
        return 11;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 4;
    }

    public void read(Readable readable, short version) {
        this.groupId = readable.readNullableString();
        this.sessionTimeoutMs = readable.readInt();
        this.rebalanceTimeoutMs = version >= 1 ? readable.readInt() : -1;
        this.memberId = readable.readNullableString();
        this.protocolType = readable.readNullableString();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.protocols.clear(0);
        } else {
            this.protocols.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.protocols.add(new JoinGroupRequestProtocol(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        writable.writeString(this.groupId);
        writable.writeInt(this.sessionTimeoutMs);
        if (version >= 1) {
            writable.writeInt(this.rebalanceTimeoutMs);
        }
        writable.writeString(this.memberId);
        writable.writeString(this.protocolType);
        writable.writeInt(this.protocols.size());
        Iterator iterator = this.protocols.iterator();
        while (iterator.hasNext()) {
            JoinGroupRequestProtocol element = (JoinGroupRequestProtocol)iterator.next();
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        this.groupId = struct.getString("group_id");
        this.sessionTimeoutMs = struct.getInt("session_timeout_ms");
        this.rebalanceTimeoutMs = version >= 1 ? struct.getInt("rebalance_timeout_ms") : -1;
        this.memberId = struct.getString("member_id");
        this.protocolType = struct.getString("protocol_type");
        Object[] nestedObjects = struct.getArray("protocols");
        this.protocols = new JoinGroupRequestProtocolSet(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.protocols.add(new JoinGroupRequestProtocol((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("group_id", (Object)this.groupId);
        struct.set("session_timeout_ms", (Object)this.sessionTimeoutMs);
        if (version >= 1) {
            struct.set("rebalance_timeout_ms", (Object)this.rebalanceTimeoutMs);
        }
        struct.set("member_id", (Object)this.memberId);
        struct.set("protocol_type", (Object)this.protocolType);
        Struct[] nestedObjects = new Struct[this.protocols.size()];
        int i = 0;
        Iterator iterator = this.protocols.iterator();
        while (iterator.hasNext()) {
            JoinGroupRequestProtocol element = (JoinGroupRequestProtocol)iterator.next();
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("protocols", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 2;
        size += MessageUtil.serializedUtf8Length((CharSequence)this.groupId);
        size += 4;
        if (version >= 1) {
            size += 4;
        }
        size += 2;
        size += MessageUtil.serializedUtf8Length((CharSequence)this.memberId);
        size += 2;
        size += MessageUtil.serializedUtf8Length((CharSequence)this.protocolType);
        size += 4;
        Iterator iterator = this.protocols.iterator();
        while (iterator.hasNext()) {
            JoinGroupRequestProtocol element = (JoinGroupRequestProtocol)iterator.next();
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JoinGroupRequestData)) {
            return false;
        }
        JoinGroupRequestData other = (JoinGroupRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.sessionTimeoutMs != other.sessionTimeoutMs) {
            return false;
        }
        if (this.rebalanceTimeoutMs != other.rebalanceTimeoutMs) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.protocolType == null ? other.protocolType != null : !this.protocolType.equals(other.protocolType)) {
            return false;
        }
        return !(this.protocols == null ? other.protocols != null : !this.protocols.equals((Object)other.protocols));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + this.sessionTimeoutMs;
        hashCode = 31 * hashCode + this.rebalanceTimeoutMs;
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + (this.protocolType == null ? 0 : this.protocolType.hashCode());
        hashCode = 31 * hashCode + (this.protocols == null ? 0 : this.protocols.hashCode());
        return hashCode;
    }

    public String toString() {
        return "JoinGroupRequestData(groupId='" + this.groupId + "', sessionTimeoutMs=" + this.sessionTimeoutMs + ", rebalanceTimeoutMs=" + this.rebalanceTimeoutMs + ", memberId='" + this.memberId + "', protocolType='" + this.protocolType + "', protocols=" + MessageUtil.deepToString((Iterator)this.protocols.iterator()) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public String memberId() {
        return this.memberId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public JoinGroupRequestProtocolSet protocols() {
        return this.protocols;
    }

    public JoinGroupRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public JoinGroupRequestData setSessionTimeoutMs(int v) {
        this.sessionTimeoutMs = v;
        return this;
    }

    public JoinGroupRequestData setRebalanceTimeoutMs(int v) {
        this.rebalanceTimeoutMs = v;
        return this;
    }

    public JoinGroupRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public JoinGroupRequestData setProtocolType(String v) {
        this.protocolType = v;
        return this;
    }

    public JoinGroupRequestData setProtocols(JoinGroupRequestProtocolSet v) {
        this.protocols = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("group_id", (Type)Type.STRING, "The group identifier."), new Field("session_timeout_ms", (Type)Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in milliseconds."), new Field("rebalance_timeout_ms", (Type)Type.INT32, "The maximum time in milliseconds that the coordinator will wait for each member to rejoin when rebalancing the group."), new Field("member_id", (Type)Type.STRING, "The member id assigned by the group coordinator."), new Field("protocol_type", (Type)Type.STRING, "The unique name the for class of protocols implemented by the group we want to join."), new Field("protocols", (Type)new ArrayOf((Type)JoinGroupRequestProtocol.SCHEMA_0), "The list of protocols that the member supports.")})));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }

    public static class JoinGroupRequestProtocolSet
    extends ImplicitLinkedHashMultiSet<JoinGroupRequestProtocol> {
        public JoinGroupRequestProtocolSet() {
        }

        public JoinGroupRequestProtocolSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public JoinGroupRequestProtocolSet(Iterator<JoinGroupRequestProtocol> iterator) {
            super(iterator);
        }

        public JoinGroupRequestProtocol find(String name) {
            JoinGroupRequestProtocol key = new JoinGroupRequestProtocol();
            key.setName(name);
            return (JoinGroupRequestProtocol)this.find(key);
        }

        public List<JoinGroupRequestProtocol> findAll(String name) {
            JoinGroupRequestProtocol key = new JoinGroupRequestProtocol();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class JoinGroupRequestProtocol
    implements Message,
    ImplicitLinkedHashSet.Element {
        private String name;
        private byte[] metadata;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;

        public JoinGroupRequestProtocol(Readable readable, short version) {
            this.read(readable, version);
        }

        public JoinGroupRequestProtocol(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public JoinGroupRequestProtocol() {
            this.name = "";
            this.metadata = Bytes.EMPTY;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 4;
        }

        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            this.metadata = readable.readNullableBytes();
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeBytes(this.metadata);
        }

        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            this.metadata = struct.getByteArray("metadata");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            struct.setByteArray("metadata", this.metadata);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.name);
            size += 4;
            return size += this.metadata.length;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JoinGroupRequestProtocol)) {
                return false;
            }
            JoinGroupRequestProtocol other = (JoinGroupRequestProtocol)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "JoinGroupRequestProtocol(name='" + this.name + "', metadata=" + Arrays.toString(this.metadata) + ")";
        }

        public String name() {
            return this.name;
        }

        public byte[] metadata() {
            return this.metadata;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public JoinGroupRequestProtocol setName(String v) {
            this.name = v;
            return this;
        }

        public JoinGroupRequestProtocol setMetadata(byte[] v) {
            this.metadata = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The protocol name."), new Field("metadata", (Type)Type.BYTES, "The protocol metadata.")}))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }
}

