/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConfigTest {
    private static final ConfigEntry E1 = new ConfigEntry("a", "b");
    private static final ConfigEntry E2 = new ConfigEntry("c", "d");
    private Config config;

    @BeforeEach
    public void setUp() {
        this.config = new Config(Arrays.asList(E1, E2));
    }

    @Test
    public void shouldGetEntry() {
        Assertions.assertEquals((Object)E1, (Object)this.config.get("a"));
        Assertions.assertEquals((Object)E2, (Object)this.config.get("c"));
    }

    @Test
    public void shouldReturnNullOnGetUnknownEntry() {
        Assertions.assertNull((Object)this.config.get("unknown"));
    }

    @Test
    public void shouldGetAllEntries() {
        Assertions.assertEquals((int)2, (int)this.config.entries().size());
        Assertions.assertTrue((boolean)this.config.entries().contains(E1));
        Assertions.assertTrue((boolean)this.config.entries().contains(E2));
    }

    @Test
    public void shouldImplementEqualsProperly() {
        Assertions.assertEquals((Object)this.config, (Object)this.config);
        Assertions.assertEquals((Object)this.config, (Object)new Config(this.config.entries()));
        Assertions.assertNotEquals((Object)new Config(Arrays.asList(E1)), (Object)this.config);
        Assertions.assertNotEquals((Object)this.config, (Object)"this");
    }

    @Test
    public void shouldImplementHashCodeProperly() {
        Assertions.assertEquals((int)this.config.hashCode(), (int)this.config.hashCode());
        Assertions.assertEquals((int)this.config.hashCode(), (int)new Config(this.config.entries()).hashCode());
        Assertions.assertNotEquals((int)new Config(Arrays.asList(E1)).hashCode(), (int)this.config.hashCode());
    }

    @Test
    public void shouldImplementToStringProperly() {
        Assertions.assertTrue((boolean)this.config.toString().contains(E1.toString()));
        Assertions.assertTrue((boolean)this.config.toString().contains(E2.toString()));
    }

    public static ConfigEntry newConfigEntry(String name, String value, ConfigEntry.ConfigSource source, boolean isSensitive, boolean isReadOnly, List<ConfigEntry.ConfigSynonym> synonyms) {
        return new ConfigEntry(name, value, source, isSensitive, isReadOnly, synonyms, ConfigEntry.ConfigType.UNKNOWN, null);
    }
}

