/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProducerConfigTest {
    private final Serializer<byte[]> keySerializer = new ByteArraySerializer();
    private final Serializer<String> valueSerializer = new StringSerializer();
    private final String keySerializerClassName = this.keySerializer.getClass().getName();
    private final String valueSerializerClassName = this.valueSerializer.getClass().getName();
    private final Object keySerializerClass = this.keySerializer.getClass();
    private final Object valueSerializerClass = this.valueSerializer.getClass();

    @Test
    public void testSerializerToPropertyConfig() {
        Properties properties = new Properties();
        properties.setProperty("key.serializer", this.keySerializerClassName);
        properties.setProperty("value.serializer", this.valueSerializerClassName);
        Properties newProperties = ProducerConfig.addSerializerToConfig((Properties)properties, null, null);
        Assertions.assertEquals((Object)newProperties.get("key.serializer"), (Object)this.keySerializerClassName);
        Assertions.assertEquals((Object)newProperties.get("value.serializer"), (Object)this.valueSerializerClassName);
        properties.clear();
        properties.setProperty("value.serializer", this.valueSerializerClassName);
        newProperties = ProducerConfig.addSerializerToConfig((Properties)properties, this.keySerializer, null);
        Assertions.assertEquals((Object)newProperties.get("key.serializer"), (Object)this.keySerializerClassName);
        Assertions.assertEquals((Object)newProperties.get("value.serializer"), (Object)this.valueSerializerClassName);
        properties.clear();
        properties.setProperty("key.serializer", this.keySerializerClassName);
        newProperties = ProducerConfig.addSerializerToConfig((Properties)properties, null, this.valueSerializer);
        Assertions.assertEquals((Object)newProperties.get("key.serializer"), (Object)this.keySerializerClassName);
        Assertions.assertEquals((Object)newProperties.get("value.serializer"), (Object)this.valueSerializerClassName);
        properties.clear();
        newProperties = ProducerConfig.addSerializerToConfig((Properties)properties, this.keySerializer, this.valueSerializer);
        Assertions.assertEquals((Object)newProperties.get("key.serializer"), (Object)this.keySerializerClassName);
        Assertions.assertEquals((Object)newProperties.get("value.serializer"), (Object)this.valueSerializerClassName);
    }

    @Test
    public void testAppendSerializerToConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.serializer", this.keySerializerClass);
        configs.put("value.serializer", this.valueSerializerClass);
        Map newConfigs = ProducerConfig.appendSerializerToConfig(configs, null, null);
        Assertions.assertEquals(newConfigs.get("key.serializer"), (Object)this.keySerializerClass);
        Assertions.assertEquals(newConfigs.get("value.serializer"), (Object)this.valueSerializerClass);
        configs.clear();
        configs.put("value.serializer", this.valueSerializerClass);
        newConfigs = ProducerConfig.appendSerializerToConfig(configs, this.keySerializer, null);
        Assertions.assertEquals(newConfigs.get("key.serializer"), (Object)this.keySerializerClass);
        Assertions.assertEquals(newConfigs.get("value.serializer"), (Object)this.valueSerializerClass);
        configs.clear();
        configs.put("key.serializer", this.keySerializerClass);
        newConfigs = ProducerConfig.appendSerializerToConfig(configs, null, this.valueSerializer);
        Assertions.assertEquals(newConfigs.get("key.serializer"), (Object)this.keySerializerClass);
        Assertions.assertEquals(newConfigs.get("value.serializer"), (Object)this.valueSerializerClass);
        configs.clear();
        newConfigs = ProducerConfig.appendSerializerToConfig(configs, this.keySerializer, this.valueSerializer);
        Assertions.assertEquals(newConfigs.get("key.serializer"), (Object)this.keySerializerClass);
        Assertions.assertEquals(newConfigs.get("value.serializer"), (Object)this.valueSerializerClass);
    }
}

