/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.ResponseHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProduceResponseTest {
    @Test
    public void produceResponseV5Test() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        TopicPartition tp0 = new TopicPartition("test", 0);
        responseData.put(tp0, new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        ProduceResponse v5Response = new ProduceResponse(responseData, 10);
        short version = 5;
        ByteBuffer buffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)v5Response, version, 0);
        ResponseHeader.parse((ByteBuffer)buffer, (short)ApiKeys.PRODUCE.responseHeaderVersion(version));
        ProduceResponse v5FromBytes = (ProduceResponse)AbstractResponse.parseResponse((ApiKeys)ApiKeys.PRODUCE, (ByteBuffer)buffer, (short)version);
        Assertions.assertEquals((int)1, (int)v5FromBytes.responses().size());
        Assertions.assertTrue((boolean)v5FromBytes.responses().containsKey(tp0));
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)v5FromBytes.responses().get(tp0);
        Assertions.assertEquals((long)100L, (long)partitionResponse.logStartOffset);
        Assertions.assertEquals((long)10000L, (long)partitionResponse.baseOffset);
        Assertions.assertEquals((int)10, (int)v5FromBytes.throttleTimeMs());
        Assertions.assertEquals(responseData, (Object)v5Response.responses());
    }

    @Test
    public void produceResponseVersionTest() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        ProduceResponse v0Response = new ProduceResponse(responseData);
        ProduceResponse v1Response = new ProduceResponse(responseData, 10);
        ProduceResponse v2Response = new ProduceResponse(responseData, 10);
        Assertions.assertEquals((int)0, (int)v0Response.throttleTimeMs(), (String)"Throttle time must be zero");
        Assertions.assertEquals((int)10, (int)v1Response.throttleTimeMs(), (String)"Throttle time must be 10");
        Assertions.assertEquals((int)10, (int)v2Response.throttleTimeMs(), (String)"Throttle time must be 10");
        Assertions.assertEquals(responseData, (Object)v0Response.responses(), (String)"Response data does not match");
        Assertions.assertEquals(responseData, (Object)v1Response.responses(), (String)"Response data does not match");
        Assertions.assertEquals(responseData, (Object)v2Response.responses(), (String)"Response data does not match");
    }

    @Test
    public void produceResponseRecordErrorsTest() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        TopicPartition tp = new TopicPartition("test", 0);
        ProduceResponse.PartitionResponse partResponse = new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L, Collections.singletonList(new ProduceResponse.RecordError(3, "Record error")), "Produce failed");
        responseData.put(tp, partResponse);
        for (short ver = 0; ver <= ApiKeys.PRODUCE.latestVersion(); ver = (short)(ver + 1)) {
            ProduceResponse response = new ProduceResponse(responseData);
            ProduceResponse.PartitionResponse deserialized = (ProduceResponse.PartitionResponse)ProduceResponse.parse((ByteBuffer)response.serialize(ver), (short)ver).responses().get(tp);
            if (ver >= 8) {
                Assertions.assertEquals((int)1, (int)deserialized.recordErrors.size());
                Assertions.assertEquals((int)3, (int)((ProduceResponse.RecordError)deserialized.recordErrors.get((int)0)).batchIndex);
                Assertions.assertEquals((Object)"Record error", (Object)((ProduceResponse.RecordError)deserialized.recordErrors.get((int)0)).message);
                Assertions.assertEquals((Object)"Produce failed", (Object)deserialized.errorMessage);
                continue;
            }
            Assertions.assertEquals((int)0, (int)deserialized.recordErrors.size());
            Assertions.assertNull((Object)deserialized.errorMessage);
        }
    }
}

