/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AddPartitionsToTxnResponseTest {
    protected final int throttleTimeMs = 10;
    protected final String topicOne = "topic1";
    protected final int partitionOne = 1;
    protected final Errors errorOne = Errors.COORDINATOR_NOT_AVAILABLE;
    protected final Errors errorTwo = Errors.NOT_COORDINATOR;
    protected final String topicTwo = "topic2";
    protected final int partitionTwo = 2;
    protected TopicPartition tp1 = new TopicPartition("topic1", 1);
    protected TopicPartition tp2 = new TopicPartition("topic2", 2);
    protected Map<Errors, Integer> expectedErrorCounts;
    protected Map<TopicPartition, Errors> errorsMap;

    @BeforeEach
    public void setUp() {
        this.expectedErrorCounts = new HashMap<Errors, Integer>();
        this.expectedErrorCounts.put(this.errorOne, 1);
        this.expectedErrorCounts.put(this.errorTwo, 1);
        this.errorsMap = new HashMap<TopicPartition, Errors>();
        this.errorsMap.put(this.tp1, this.errorOne);
        this.errorsMap.put(this.tp2, this.errorTwo);
    }

    @Test
    public void testConstructorWithErrorResponse() {
        AddPartitionsToTxnResponse response = new AddPartitionsToTxnResponse(10, this.errorsMap);
        Assertions.assertEquals(this.expectedErrorCounts, (Object)response.errorCounts());
        Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
    }

    @Test
    public void testParse() {
        AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection topicCollection = new AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection();
        AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResult topicResult = new AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResult();
        topicResult.setName("topic1");
        topicResult.results().add(new AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResult().setErrorCode(this.errorOne.code()).setPartitionIndex(1));
        topicResult.results().add(new AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResult().setErrorCode(this.errorTwo.code()).setPartitionIndex(2));
        topicCollection.add(topicResult);
        AddPartitionsToTxnResponseData data = new AddPartitionsToTxnResponseData().setResults(topicCollection).setThrottleTimeMs(10);
        AddPartitionsToTxnResponse response = new AddPartitionsToTxnResponse(data);
        Iterator iterator = ApiKeys.ADD_PARTITIONS_TO_TXN.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            AddPartitionsToTxnResponse parsedResponse = AddPartitionsToTxnResponse.parse((ByteBuffer)response.serialize(version), (short)version);
            Assertions.assertEquals(this.expectedErrorCounts, (Object)parsedResponse.errorCounts());
            Assertions.assertEquals((int)10, (int)parsedResponse.throttleTimeMs());
            Assertions.assertEquals((Object)(version >= 1 ? 1 : 0), (Object)parsedResponse.shouldClientThrottle(version));
        }
    }
}

