/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.ListConsumerGroupOffsetsHandler;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListConsumerGroupOffsetsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final String groupId = "group-id";
    private final TopicPartition t0p0 = new TopicPartition("t0", 0);
    private final TopicPartition t0p1 = new TopicPartition("t0", 1);
    private final TopicPartition t1p0 = new TopicPartition("t1", 0);
    private final TopicPartition t1p1 = new TopicPartition("t1", 1);
    private final List<TopicPartition> tps = Arrays.asList(this.t0p0, this.t0p1, this.t1p0, this.t1p1);

    @Test
    public void testBuildRequest() {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler("group-id", this.tps, this.logContext);
        OffsetFetchRequest request = (OffsetFetchRequest)handler.buildBatchedRequest(1, Collections.singleton(CoordinatorKey.byGroupId((String)"group-id"))).build();
        Assertions.assertEquals((Object)"group-id", (Object)request.data().groups().get(0).groupId());
        Assertions.assertEquals((int)2, (int)request.data().groups().get(0).topics().size());
        Assertions.assertEquals((int)2, (int)request.data().groups().get(0).topics().get(0).partitionIndexes().size());
        Assertions.assertEquals((int)2, (int)request.data().groups().get(0).topics().get(1).partitionIndexes().size());
    }

    @Test
    public void testSuccessfulHandleResponse() {
        HashMap<TopicPartition, OffsetAndMetadata> expected = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.assertCompleted(this.handleWithError(Errors.NONE), expected);
    }

    @Test
    public void testSuccessfulHandleResponseWithOnePartitionError() {
        Map<TopicPartition, OffsetAndMetadata> expectedResult = Collections.singletonMap(this.t0p0, new OffsetAndMetadata(10L));
        this.assertCompleted(this.handleWithPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION), expectedResult);
        this.assertCompleted(this.handleWithPartitionError(Errors.TOPIC_AUTHORIZATION_FAILED), expectedResult);
        this.assertCompleted(this.handleWithPartitionError(Errors.UNSTABLE_OFFSET_COMMIT), expectedResult);
    }

    @Test
    public void testUnmappedHandleResponse() {
        this.assertUnmapped(this.handleWithError(Errors.COORDINATOR_NOT_AVAILABLE));
        this.assertUnmapped(this.handleWithError(Errors.NOT_COORDINATOR));
    }

    @Test
    public void testRetriableHandleResponse() {
        this.assertRetriable(this.handleWithError(Errors.COORDINATOR_LOAD_IN_PROGRESS));
    }

    @Test
    public void testFailedHandleResponse() {
        this.assertFailed(GroupAuthorizationException.class, this.handleWithError(Errors.GROUP_AUTHORIZATION_FAILED));
        this.assertFailed(GroupIdNotFoundException.class, this.handleWithError(Errors.GROUP_ID_NOT_FOUND));
        this.assertFailed(InvalidGroupIdException.class, this.handleWithError(Errors.INVALID_GROUP_ID));
    }

    private OffsetFetchResponse buildResponse(Errors error) {
        HashMap responseData = new HashMap();
        OffsetFetchResponse response = new OffsetFetchResponse(error, responseData);
        return response;
    }

    private OffsetFetchResponse buildResponseWithPartitionError(Errors error) {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseData.put(this.t0p0, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", Errors.NONE));
        responseData.put(this.t0p1, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", error));
        OffsetFetchResponse response = new OffsetFetchResponse(Errors.NONE, responseData);
        return response;
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleWithPartitionError(Errors error) {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler("group-id", this.tps, this.logContext);
        OffsetFetchResponse response = this.buildResponseWithPartitionError(error);
        return handler.handleResponse(new Node(1, "host", 1234), Collections.singleton(CoordinatorKey.byGroupId((String)"group-id")), (AbstractResponse)response);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleWithError(Errors error) {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler("group-id", this.tps, this.logContext);
        OffsetFetchResponse response = this.buildResponse(error);
        return handler.handleResponse(new Node(1, "host", 1234), Collections.singleton(CoordinatorKey.byGroupId((String)"group-id")), (AbstractResponse)response);
    }

    private void assertUnmapped(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.singletonList(CoordinatorKey.byGroupId((String)"group-id")), (Object)result.unmappedKeys);
    }

    private void assertRetriable(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
    }

    private void assertCompleted(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result, Map<TopicPartition, OffsetAndMetadata> expected) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id");
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
        Assertions.assertEquals(expected, result.completedKeys.get(CoordinatorKey.byGroupId((String)"group-id")));
    }

    private void assertFailed(Class<? extends Throwable> expectedExceptionType, AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id");
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.failedKeys.keySet());
        Assertions.assertTrue((boolean)expectedExceptionType.isInstance(result.failedKeys.get(key)));
    }
}

