/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.feature;

import java.util.Map;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FinalizedVersionRangeTest {
    @Test
    public void testFromToMap() {
        FinalizedVersionRange versionRange = new FinalizedVersionRange(1, 2);
        Assertions.assertEquals((int)1, (int)versionRange.min());
        Assertions.assertEquals((int)2, (int)versionRange.max());
        Map versionRangeMap = versionRange.toMap();
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version_level", (Object)versionRange.min()), Utils.mkEntry((Object)"max_version_level", (Object)versionRange.max())}), (Object)versionRangeMap);
        FinalizedVersionRange newVersionRange = FinalizedVersionRange.fromMap((Map)versionRangeMap);
        Assertions.assertEquals((int)1, (int)newVersionRange.min());
        Assertions.assertEquals((int)2, (int)newVersionRange.max());
        Assertions.assertEquals((Object)versionRange, (Object)newVersionRange);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"FinalizedVersionRange[min_version_level:1, max_version_level:1]", (Object)new FinalizedVersionRange(1, 1).toString());
        Assertions.assertEquals((Object)"FinalizedVersionRange[min_version_level:1, max_version_level:2]", (Object)new FinalizedVersionRange(1, 2).toString());
    }

    @Test
    public void testIsCompatibleWith() {
        Assertions.assertFalse((boolean)new FinalizedVersionRange(1, 1).isIncompatibleWith(new SupportedVersionRange(1, 1)));
        Assertions.assertFalse((boolean)new FinalizedVersionRange(2, 3).isIncompatibleWith(new SupportedVersionRange(1, 4)));
        Assertions.assertFalse((boolean)new FinalizedVersionRange(1, 4).isIncompatibleWith(new SupportedVersionRange(1, 4)));
        Assertions.assertTrue((boolean)new FinalizedVersionRange(1, 4).isIncompatibleWith(new SupportedVersionRange(2, 3)));
        Assertions.assertTrue((boolean)new FinalizedVersionRange(1, 4).isIncompatibleWith(new SupportedVersionRange(2, 4)));
        Assertions.assertTrue((boolean)new FinalizedVersionRange(2, 4).isIncompatibleWith(new SupportedVersionRange(2, 3)));
    }

    @Test
    public void testMinMax() {
        FinalizedVersionRange versionRange = new FinalizedVersionRange(1, 2);
        Assertions.assertEquals((int)1, (int)versionRange.min());
        Assertions.assertEquals((int)2, (int)versionRange.max());
    }
}

