/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.utils.CollectionUtils;
import org.apache.kafka.common.utils.Utils;

public class ListOffsetResponse
extends AbstractResponse {
    public static final long UNKNOWN_TIMESTAMP = -1L;
    public static final long UNKNOWN_OFFSET = -1L;
    private static final Field.ComplexArray TOPICS = new Field.ComplexArray("responses", "The listed offsets by topic");
    private static final Field.ComplexArray PARTITIONS = new Field.ComplexArray("partition_responses", "The listed offsets by partition");
    @Deprecated
    private static final Field.Array OFFSETS = new Field.Array("offsets'", Type.INT64, "A list of offsets.");
    private static final Field.Int64 TIMESTAMP = new Field.Int64("timestamp", "The timestamp associated with the returned offset");
    private static final Field.Int64 OFFSET = new Field.Int64("offset", "The offset found");
    private static final Field PARTITIONS_V0 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, OFFSETS);
    private static final Field TOPICS_V0 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V0);
    private static final Schema LIST_OFFSET_RESPONSE_V0 = new Schema(TOPICS_V0);
    private static final Field PARTITIONS_V1 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, TIMESTAMP, OFFSET);
    private static final Field TOPICS_V1 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V1);
    private static final Schema LIST_OFFSET_RESPONSE_V1 = new Schema(TOPICS_V1);
    private static final Schema LIST_OFFSET_RESPONSE_V2;
    private static final Schema LIST_OFFSET_RESPONSE_V3;
    private static final Field PARTITIONS_V4;
    private static final Field TOPICS_V4;
    private static final Schema LIST_OFFSET_RESPONSE_V4;
    private static final Schema LIST_OFFSET_RESPONSE_V5;
    private final int throttleTimeMs;
    private final Map<TopicPartition, PartitionData> responseData;

    public static Schema[] schemaVersions() {
        return new Schema[]{LIST_OFFSET_RESPONSE_V0, LIST_OFFSET_RESPONSE_V1, LIST_OFFSET_RESPONSE_V2, LIST_OFFSET_RESPONSE_V3, LIST_OFFSET_RESPONSE_V4, LIST_OFFSET_RESPONSE_V5};
    }

    public ListOffsetResponse(Map<TopicPartition, PartitionData> responseData) {
        this(0, responseData);
    }

    public ListOffsetResponse(int throttleTimeMs, Map<TopicPartition, PartitionData> responseData) {
        this.throttleTimeMs = throttleTimeMs;
        this.responseData = responseData;
    }

    public ListOffsetResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.responseData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.get(TOPICS)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicResponse.get(PARTITIONS)) {
                PartitionData partitionData;
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.get(CommonFields.PARTITION_ID);
                Errors error = Errors.forCode(partitionResponse.get(CommonFields.ERROR_CODE));
                if (partitionResponse.hasField(OFFSETS)) {
                    Object[] offsets = partitionResponse.get(OFFSETS);
                    ArrayList<Long> offsetsList = new ArrayList<Long>();
                    for (Object offset : offsets) {
                        offsetsList.add((Long)offset);
                    }
                    partitionData = new PartitionData(error, offsetsList);
                } else {
                    long timestamp = partitionResponse.get(TIMESTAMP);
                    long offset = partitionResponse.get(OFFSET);
                    Optional<Integer> leaderEpoch = RequestUtils.getLeaderEpoch(partitionResponse, CommonFields.LEADER_EPOCH);
                    partitionData = new PartitionData(error, timestamp, offset, leaderEpoch);
                }
                this.responseData.put(new TopicPartition(topic, partition), partitionData);
            }
        }
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<TopicPartition, PartitionData> responseData() {
        return this.responseData;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (PartitionData response : this.responseData.values()) {
            this.updateErrorCounts(errorCounts, response.error);
        }
        return errorCounts;
    }

    public static ListOffsetResponse parse(ByteBuffer buffer, short version) {
        return new ListOffsetResponse(ApiKeys.LIST_OFFSETS.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.LIST_OFFSETS.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupPartitionDataByTopic(this.responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = struct.instance(TOPICS);
            topicData.set(CommonFields.TOPIC_NAME, topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                PartitionData offsetPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS);
                partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionData.set(CommonFields.ERROR_CODE, offsetPartitionData.error.code());
                if (version == 0) {
                    partitionData.set(OFFSETS, offsetPartitionData.offsets.toArray());
                } else {
                    partitionData.set(TIMESTAMP, offsetPartitionData.timestamp);
                    partitionData.set(OFFSET, offsetPartitionData.offset);
                    RequestUtils.setLeaderEpochIfExists(partitionData, CommonFields.LEADER_EPOCH, offsetPartitionData.leaderEpoch);
                }
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS, partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(TOPICS, topicArray.toArray());
        return struct;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("(type=ListOffsetResponse").append(", throttleTimeMs=").append(this.throttleTimeMs).append(", responseData=").append(this.responseData).append(")");
        return bld.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 3;
    }

    static {
        LIST_OFFSET_RESPONSE_V3 = LIST_OFFSET_RESPONSE_V2 = new Schema(CommonFields.THROTTLE_TIME_MS, TOPICS_V1);
        PARTITIONS_V4 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, TIMESTAMP, OFFSET, CommonFields.LEADER_EPOCH);
        TOPICS_V4 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V4);
        LIST_OFFSET_RESPONSE_V5 = LIST_OFFSET_RESPONSE_V4 = new Schema(CommonFields.THROTTLE_TIME_MS, TOPICS_V4);
    }

    public static final class PartitionData {
        public final Errors error;
        @Deprecated
        public final List<Long> offsets;
        public final Long timestamp;
        public final Long offset;
        public final Optional<Integer> leaderEpoch;

        @Deprecated
        public PartitionData(Errors error, List<Long> offsets) {
            this.error = error;
            this.offsets = offsets;
            this.timestamp = null;
            this.offset = null;
            this.leaderEpoch = Optional.empty();
        }

        public PartitionData(Errors error, long timestamp, long offset, Optional<Integer> leaderEpoch) {
            this.error = error;
            this.timestamp = timestamp;
            this.offset = offset;
            this.offsets = null;
            this.leaderEpoch = leaderEpoch;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("PartitionData(").append("errorCode: ").append(this.error.code());
            if (this.offsets == null) {
                bld.append(", timestamp: ").append(this.timestamp).append(", offset: ").append(this.offset).append(", leaderEpoch: ").append(this.leaderEpoch);
            } else {
                bld.append(", offsets: ").append("[").append(Utils.join(this.offsets, ",")).append("]");
            }
            bld.append(")");
            return bld.toString();
        }
    }
}

