/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class TierListOffsetRequestData
implements ApiMessage {
    private int replicaId;
    private List<TierListOffsetTopic> topics;
    public static final Schema SCHEMA_0 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the requestor."), new Field("topics", new ArrayOf(TierListOffsetTopic.SCHEMA_0), "Each topic in the request."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public TierListOffsetRequestData(Readable readable, short version) {
        this.topics = new ArrayList<TierListOffsetTopic>();
        this.read(readable, version);
    }

    public TierListOffsetRequestData(Struct struct, short version) {
        this.topics = new ArrayList<TierListOffsetTopic>();
        this.fromStruct(struct, version);
    }

    public TierListOffsetRequestData() {
        this.replicaId = 0;
        this.topics = new ArrayList<TierListOffsetTopic>();
    }

    @Override
    public short apiKey() {
        return Short.MAX_VALUE;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable readable, short version) {
        this.replicaId = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics = null;
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new TierListOffsetTopic(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.replicaId);
        writable.writeInt(this.topics.size());
        for (TierListOffsetTopic element : this.topics) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.replicaId = struct.getInt("replica_id");
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<TierListOffsetTopic>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new TierListOffsetTopic((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("replica_id", (Object)this.replicaId);
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (TierListOffsetTopic element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        for (TierListOffsetTopic element : this.topics) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TierListOffsetRequestData)) {
            return false;
        }
        TierListOffsetRequestData other = (TierListOffsetRequestData)obj;
        if (this.replicaId != other.replicaId) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.replicaId;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "TierListOffsetRequestData(replicaId=" + this.replicaId + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int replicaId() {
        return this.replicaId;
    }

    public List<TierListOffsetTopic> topics() {
        return this.topics;
    }

    public TierListOffsetRequestData setReplicaId(int v) {
        this.replicaId = v;
        return this;
    }

    public TierListOffsetRequestData setTopics(List<TierListOffsetTopic> v) {
        this.topics = v;
        return this;
    }

    public static class TierListOffsetPartition
    implements Message {
        private int partitionIndex;
        private int currentLeaderEpoch;
        private byte offsetType;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("current_leader_epoch", Type.INT32, "The current leader epoch."), new Field("offset_type", Type.INT8, "The offset type to lookup."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public TierListOffsetPartition(Readable readable, short version) {
            this.read(readable, version);
        }

        public TierListOffsetPartition(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public TierListOffsetPartition() {
            this.partitionIndex = 0;
            this.currentLeaderEpoch = 0;
            this.offsetType = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.currentLeaderEpoch = readable.readInt();
            this.offsetType = readable.readByte();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeInt(this.currentLeaderEpoch);
            writable.writeByte(this.offsetType);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.currentLeaderEpoch = struct.getInt("current_leader_epoch");
            this.offsetType = struct.getByte("offset_type");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("current_leader_epoch", (Object)this.currentLeaderEpoch);
            struct.set("offset_type", (Object)this.offsetType);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 4;
            return ++size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TierListOffsetPartition)) {
                return false;
            }
            TierListOffsetPartition other = (TierListOffsetPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.currentLeaderEpoch != other.currentLeaderEpoch) {
                return false;
            }
            return this.offsetType == other.offsetType;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.currentLeaderEpoch;
            hashCode = 31 * hashCode + this.offsetType;
            return hashCode;
        }

        public String toString() {
            return "TierListOffsetPartition(partitionIndex=" + this.partitionIndex + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", offsetType=" + this.offsetType + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int currentLeaderEpoch() {
            return this.currentLeaderEpoch;
        }

        public byte offsetType() {
            return this.offsetType;
        }

        public TierListOffsetPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public TierListOffsetPartition setCurrentLeaderEpoch(int v) {
            this.currentLeaderEpoch = v;
            return this;
        }

        public TierListOffsetPartition setOffsetType(byte v) {
            this.offsetType = v;
            return this;
        }
    }

    public static class TierListOffsetTopic
    implements Message {
        private String name;
        private List<TierListOffsetPartition> partitions;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(TierListOffsetPartition.SCHEMA_0), "Each partition in the request."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public TierListOffsetTopic(Readable readable, short version) {
            this.partitions = new ArrayList<TierListOffsetPartition>();
            this.read(readable, version);
        }

        public TierListOffsetTopic(Struct struct, short version) {
            this.partitions = new ArrayList<TierListOffsetPartition>();
            this.fromStruct(struct, version);
        }

        public TierListOffsetTopic() {
            this.name = "";
            this.partitions = new ArrayList<TierListOffsetPartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions = null;
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new TierListOffsetPartition(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (TierListOffsetPartition element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<TierListOffsetPartition>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new TierListOffsetPartition((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (TierListOffsetPartition element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (TierListOffsetPartition element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TierListOffsetTopic)) {
                return false;
            }
            TierListOffsetTopic other = (TierListOffsetTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "TierListOffsetTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<TierListOffsetPartition> partitions() {
            return this.partitions;
        }

        public TierListOffsetTopic setName(String v) {
            this.name = v;
            return this;
        }

        public TierListOffsetTopic setPartitions(List<TierListOffsetPartition> v) {
            this.partitions = v;
            return this;
        }
    }
}

